# ------------------------------------------------------------------------------
# Installation script for IPSDK library python wrapping to Avizo software
# 
# Avizo is a trademark of VSG, Visualization Sciences Group.
# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------
# function allowing to update ipsdk module
# ------------------------------------------------------------------------------

def updateIPSDKForAvizo(ipsdkBaseModule):
    "function allowing to update ipsdk module"
    
    try:
        import _hx_core
    except:
        return
        
    # update of ipsdk base module
    import sys
    thisModule = sys.modules[__name__]
    ipsdkBaseModule.__dict__["fromAvizo"] = thisModule.__dict__["fromAvizo"]
    ipsdkBaseModule.__dict__["toAvizo"] = thisModule.__dict__["toAvizo"]
        
# ------------------------------------------------------------------------------
# function allowing to import an image from Avizo to IPSDK
# ------------------------------------------------------------------------------

def fromAvizo(avizoImageName):
    "function allowing to import an image from Avizo to IPSDK"
    
    import _hx_core
    import PyIPSDK
    PyIPSDK.setContiguousStyle(False)
    
    avizoImage = _hx_core.hx_project.get(avizoImageName)
    avizoNumpyArray = avizoImage.get_array()
    if avizoImage._cpp_classname == "HxUniformScalarField3":
        return PyIPSDK.fromArray(avizoImage.get_array())
    if avizoImage._cpp_classname == "HxUniformLabelField3":
        if avizoNumpyArray.itemsize == 1:
            return PyIPSDK.fromBinaryArray(avizoImage.get_array())
        else:
            return PyIPSDK.fromLabelArray(avizoImage.get_array())
        
    return None
    
# ------------------------------------------------------------------------------
# function allowing to export an image from IPSDK to Avizo
# ------------------------------------------------------------------------------

def toAvizo(ipsdkImage, avizoImageName = ""):
    "function allowing to export an image from IPSDK to Avizo"
    
    import _hx_core
    import PyIPSDK
    PyIPSDK.setContiguousStyle(False)
        
    # create label, binary or grey scale image
    if (ipsdkImage.getBufferType()==PyIPSDK.eImageBufferType.eIBT_Binary or
        ipsdkImage.getBufferType()==PyIPSDK.eImageBufferType.eIBT_Label16 or
        ipsdkImage.getBufferType()==PyIPSDK.eImageBufferType.eIBT_Label32):
        avizoImage = _hx_core.hx_project.create("HxUniformLabelField3")
    else:
        avizoImage = _hx_core.hx_project.create("HxUniformScalarField3")
    if avizoImageName != "":
        avizoImage.name = avizoImageName
    avizoImage.bounding_box = ((0, 0, 0), (ipsdkImage.getSizeX()-1, ipsdkImage.getSizeY()-1, ipsdkImage.getSizeZ()-1))
    avizoImage.set_array(ipsdkImage.array)
    
    