#!/usr/bin/env python
# coding: utf-8
import sys
import os
from importlib import import_module

# retrieve ProjectInfo data
def getProjectInfoData():
    
    # retrieve project version file path
    curScriptDir = os.path.dirname(os.path.abspath(__file__))
    projectRootDir = os.path.dirname(curScriptDir)
    projectRootBinPath = os.path.join(projectRootDir, "Output")
    if os.path.exists(projectRootBinPath) == False:
        projectRootBinPath = os.path.join(projectRootDir, "bin")
    versionInfoPath = os.path.join(projectRootBinPath, "python")
    
    # import getProjectInfo function
    sys.path.insert(0, versionInfoPath)
    from ProjectVersion import getProjectInfo
    sys.path.remove(versionInfoPath)
    
    return getProjectInfo()
    
# retrieve PyIPSDKUtils module
def getPyIPSDKUtilsModule():
    
    # add ipsdk python directory to path
    ipsdkPythonPath = os.path.join(getProjectInfoData()["IPSDKInstallPath"], "python")
    if not ipsdkPythonPath in sys.path:
        sys.path.insert(1, ipsdkPythonPath)
        
    # import PyIPSDKUtils
    pyIPSDKUtils = import_module("PyIPSDKUtils")
    
    return pyIPSDKUtils
        
# start unit tests associated to current project
def startUnitTest(moduleName, bDebugMode):
    
    # add root python directory and product directory to path
    curScriptDir = os.path.dirname(os.path.abspath(__file__))
    if not curScriptDir in sys.path:
        sys.path.insert(1, curScriptDir)
    if not os.path.join(curScriptDir, "PyUserLib") in sys.path:
        sys.path.insert(1, os.path.join(curScriptDir, "PyUserLib"))
    
    # setup project root directory environment variable
    projectRootDir = os.path.dirname(curScriptDir)
    os.environ["IPSDK_PYTHON_PROJECT_ROOT_PATH"] = projectRootDir
    
    # retrieve PyIPSDKUtil module
    pyIPSDKUtils = getPyIPSDKUtilsModule()
    
    # run tests
    pyIPSDKUtils.startUnitTest(moduleName, bDebugMode)
    
# initialization of project
def initProject():
    
    # add root python directory and product directory to path
    curScriptDir = os.path.dirname(os.path.abspath(__file__))
    if not curScriptDir in sys.path:
        sys.path.insert(1, curScriptDir)
    if not os.path.join(curScriptDir, "PyUserLib") in sys.path:
        sys.path.insert(1, os.path.join(curScriptDir, "PyUserLib"))
    ipsdkPythonPath = os.path.join(getProjectInfoData()["IPSDKInstallPath"], "python")
    if not ipsdkPythonPath in sys.path:
        sys.path.insert(1, ipsdkPythonPath)
    
    # setup project root directory environment variable
    projectRootDir = os.path.dirname(curScriptDir)
    os.environ["IPSDK_PYTHON_PROJECT_ROOT_PATH"] = projectRootDir
    
    # retrieve PyIPSDKUtil module
    pyIPSDKUtils = getPyIPSDKUtilsModule()
    
    # retrieve current python version
    pythonMajorVersion = sys.version_info.major
    pythonMinorVersion = sys.version_info.minor
    pythonVersionSubDir = "Python" + str(pythonMajorVersion) + "_" + str(pythonMinorVersion)
    
    # add of project binary directory to path if needed
    projectBinaryDir = pyIPSDKUtils.getProjectBinDir()
    if not projectBinaryDir in sys.path:
        sys.path.insert(1, projectBinaryDir)
    if os.name == "nt":
        os.environ["PATH"] = os.environ["PATH"] + ";"  + projectBinaryDir
    projectPythonBinaryDir = os.path.join(projectBinaryDir, pythonVersionSubDir)
    if not projectPythonBinaryDir in sys.path:
        sys.path.insert(1, projectPythonBinaryDir)
