import os
import sys

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLColor as colorIP
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho


import numpy as np
import joblib
import random
import math
import xml.etree.ElementTree as xmlet

# import DatabaseFunction as Dfct
# import XMLtoInfoSet as xml2IS

try:
    from PyQt5.QtWidgets import QApplication
    app = QApplication(sys.argv)
    screen = app.screens()[0]
    physicalSize = screen.physicalSize()
    availableSize = screen.size()

    pixelSizeRef = 0.248
    pixelSize = ((physicalSize.width()/availableSize.width())+(physicalSize.height()/availableSize.height()))/2

    ratioScreen = pixelSizeRef/pixelSize
except:
    ratioScreen = 1

dictConversion = {}

# eWatershedSeparationMode
dictConversion['eSAT_Default'] = {}
dictConversion['eSAT_Default']['UserName'] = 'Default'
dictConversion['eSAT_Default']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Default'

dictConversion['eSAT_Smooth'] = {}
dictConversion['eSAT_Smooth']['UserName'] = 'Smooth'
dictConversion['eSAT_Smooth']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Smooth'

# eWatershedSeparationMode
dictConversion['eWSM_Split_Binary'] = {}
dictConversion['eWSM_Split_Binary']['UserName'] = 'Split binary'
dictConversion['eWSM_Split_Binary']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Split'

dictConversion['eWSM_Split_Label'] = {}
dictConversion['eWSM_Split_Label']['UserName'] = 'Split label'
dictConversion['eWSM_Split_Label']['IPSDK'] = "Split_Label"

dictConversion['eWSM_Lines'] = {}
dictConversion['eWSM_Lines']['UserName'] = 'Lines'
dictConversion['eWSM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Lines'

dictConversion['eWSM_Basins'] = {}
dictConversion['eWSM_Basins']['UserName'] = 'Basins'
dictConversion['eWSM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Basins'

# eWatershedOutputMode
dictConversion['eWOM_Lines'] = {}
dictConversion['eWOM_Lines']['UserName'] = 'Lines'
dictConversion['eWOM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Lines'

dictConversion['eWOM_Basins'] = {}
dictConversion['eWOM_Basins']['UserName'] = 'Bassins'
dictConversion['eWOM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Basins'

# eShapeGreyscaleType
dictConversion['eSGT_Dark'] = {}
dictConversion['eSGT_Dark']['UserName'] = 'Dark'
dictConversion['eSGT_Dark']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Dark'

dictConversion['eSGT_Light'] = {}
dictConversion['eSGT_Light']['UserName'] = 'Light'
dictConversion['eSGT_Light']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Light'


# eNeighborhood2dType
dictConversion['eN2T_8Connexity'] = {}
dictConversion['eN2T_8Connexity']['UserName'] = 'Connexity 8'
dictConversion['eN2T_8Connexity']['IPSDK'] = 'PyIPSDK.eNeighborhood2dType.eN2T_8Connexity'

dictConversion['eN2T_4Connexity'] = {}
dictConversion['eN2T_4Connexity']['UserName'] = 'Connexity 4'
dictConversion['eN2T_4Connexity']['IPSDK'] = "PyIPSDK.eNeighborhood2dType.eN2T_4Connexity"

# eNeighborhood3dType
dictConversion['eN3T_6Connexity'] = {'UserName': 'Connexity 6', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_6Connexity'}
dictConversion['eN3T_18Connexity'] = {'UserName': 'Connexity 18', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_18Connexity'}
dictConversion['eN3T_26Connexity'] = {'UserName': 'Connexity 26', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_26Connexity'}

# eProcessingOptimizationPolicy
dictConversion['ePOP_MinimizeMemory'] = {}
dictConversion['ePOP_MinimizeMemory']['UserName'] = 'Minimiser Mémoire'
dictConversion['ePOP_MinimizeMemory']['IPSDK'] = 'PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory'

dictConversion['ePOP_MaximizeSpeed'] = {}
dictConversion['ePOP_MaximizeSpeed']['UserName'] = 'Maximiser Vitesse'
dictConversion['ePOP_MaximizeSpeed']['IPSDK'] = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"

# eZoomInterpolationMethod
dictConversion['eZIM_NearestNeighbour'] = {}
dictConversion['eZIM_NearestNeighbour']['UserName'] = 'Nearest Neighbour'
dictConversion['eZIM_NearestNeighbour']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour'

dictConversion['eZIM_Linear'] = {}
dictConversion['eZIM_Linear']['UserName'] = 'Linear'
dictConversion['eZIM_Linear']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Linear'

dictConversion['eZIM_Cubic'] = {}
dictConversion['eZIM_Cubic']['UserName'] = 'Cubic'
dictConversion['eZIM_Cubic']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Cubic'

dictConversion['eZIM_VolumeWeightedMean'] = {}
dictConversion['eZIM_VolumeWeightedMean']['UserName'] = 'Volume Weighted Mean'
dictConversion['eZIM_VolumeWeightedMean']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean'

# eImageBufferType
dictConversion['eIBT_None'] = {}
dictConversion['eIBT_None']['UserName'] = 'Empty buffer type'
dictConversion['eIBT_None']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_None'

dictConversion['eIBT_Int8'] = {}
dictConversion['eIBT_Int8']['UserName'] = 'Int 8'
dictConversion['eIBT_Int8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int8'

dictConversion['eIBT_UInt8'] = {}
dictConversion['eIBT_UInt8']['UserName'] = 'UInt 8'
dictConversion['eIBT_UInt8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt8'

dictConversion['eIBT_Int16'] = {}
dictConversion['eIBT_Int16']['UserName'] = 'Int 16'
dictConversion['eIBT_Int16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int16'

dictConversion['eIBT_UInt16'] = {}
dictConversion['eIBT_UInt16']['UserName'] = 'UInt 16'
dictConversion['eIBT_UInt16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt16'

dictConversion['eIBT_Int32'] = {}
dictConversion['eIBT_Int32']['UserName'] = 'Int 32'
dictConversion['eIBT_Int32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int32'

dictConversion['eIBT_UInt32'] = {}
dictConversion['eIBT_UInt32']['UserName'] = 'Uint 32'
dictConversion['eIBT_UInt32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt32'

dictConversion['eIBT_Real32'] = {}
dictConversion['eIBT_Real32']['UserName'] = 'Float 32'
dictConversion['eIBT_Real32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Real32'

dictConversion['eIBT_Binary'] = {}
dictConversion['eIBT_Binary']['UserName'] = 'Binary'
dictConversion['eIBT_Binary']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Binary'

dictConversion['eIBT_Label8'] = {}
dictConversion['eIBT_Label8']['UserName'] = 'Label on 8 bits'
dictConversion['eIBT_Label8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label8'

dictConversion['eIBT_Label16'] = {}
dictConversion['eIBT_Label16']['UserName'] = 'Label on 16 bits'
dictConversion['eIBT_Label16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label16'

dictConversion['eIBT_Label32'] = {}
dictConversion['eIBT_Label32']['UserName'] = 'Label on 32 bits'
dictConversion['eIBT_Label32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label32'

# eFrequencyBandPassFilterType
dictConversion['eFBPFT_Gaussian'] = {}
dictConversion['eFBPFT_Gaussian']['UserName'] = 'Gaussian'
dictConversion['eFBPFT_Gaussian']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_Gaussian'

dictConversion['eFBPFT_LogGabor'] = {}
dictConversion['eFBPFT_LogGabor']['UserName'] = 'Log Gabor'
dictConversion['eFBPFT_LogGabor']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_LogGabor'

# eProjStatType
dictConversion['ePST_Max'] = {}
dictConversion['ePST_Max']['UserName'] = 'Max'
dictConversion['ePST_Max']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Max'

dictConversion['ePST_Mean'] = {}
dictConversion['ePST_Mean']['UserName'] = 'Mean'
dictConversion['ePST_Mean']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Mean'

dictConversion['ePST_Median'] = {}
dictConversion['ePST_Median']['UserName'] = 'Median'
dictConversion['ePST_Median']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Median'

dictConversion['ePST_Min'] = {}
dictConversion['ePST_Min']['UserName'] = 'Min'
dictConversion['ePST_Min']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Min'

dictConversion['ePST_StdDev'] = {}
dictConversion['ePST_StdDev']['UserName'] = 'Standard Deviation'
dictConversion['ePST_StdDev']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_StdDev'

dictConversion['ePST_Sum'] = {}
dictConversion['ePST_Sum']['UserName'] = 'Sum'
dictConversion['ePST_Sum']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Sum'

dictConversion['ePST_Variance'] = {}
dictConversion['ePST_Variance']['UserName'] = 'Variance'
dictConversion['ePST_Variance']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Variance'

# eSobelKernelType
dictConversion['eSKT_ScharrHalfKnlSz1'] = {}
dictConversion['eSKT_ScharrHalfKnlSz1']['UserName'] = 'Scharr 3'
dictConversion['eSKT_ScharrHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz1'] = {}
dictConversion['eSKT_SobelHalfKnlSz1']['UserName'] = 'Sobel 3'
dictConversion['eSKT_SobelHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz2'] = {}
dictConversion['eSKT_SobelHalfKnlSz2']['UserName'] = 'Sobel 5'
dictConversion['eSKT_SobelHalfKnlSz2']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2'

dictConversion['eSKT_SobelHalfKnlSz3'] = {}
dictConversion['eSKT_SobelHalfKnlSz3']['UserName'] = 'Sobel 7'
dictConversion['eSKT_SobelHalfKnlSz3']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3'

# eLocalExtremumType
dictConversion['eLET_Max'] = {}
dictConversion['eLET_Max']['UserName'] = 'Maximum'
dictConversion['eLET_Max']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Max'

dictConversion['eLET_Min'] = {}
dictConversion['eLET_Min']['UserName'] = 'Minimum'
dictConversion['eLET_Min']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Min'

dictConversion['eLET_StrictMax'] = {}
dictConversion['eLET_StrictMax']['UserName'] = 'Maximum without plateau'
dictConversion['eLET_StrictMax']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMax'

dictConversion['eLET_StrictMin'] = {}
dictConversion['eLET_StrictMin']['UserName'] = 'Minimum without plateau'
dictConversion['eLET_StrictMin']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMin'

#Fourier Transform
dictConversion['eDFTC_Cartesian'] = {}
dictConversion['eDFTC_Cartesian']['UserName'] = 'Cartesian'
dictConversion['eDFTC_Cartesian']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Cartesian'

dictConversion['eDFTC_Polar'] = {}
dictConversion['eDFTC_Polar']['UserName'] = 'Polar'
dictConversion['eDFTC_Polar']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Polar'

dictConversion['eDFTQP_Centered'] = {}
dictConversion['eDFTQP_Centered']['UserName'] = 'Centered'
dictConversion['eDFTQP_Centered']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered'

dictConversion['eDFTQP_Native'] = {}
dictConversion['eDFTQP_Native']['UserName'] = 'Native'
dictConversion['eDFTQP_Native']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native'

# Statistical match
dictConversion['eMinMax'] = {}
dictConversion['eMinMax']['UserName'] = 'Min and Max'
dictConversion['eMinMax']['IPSDK'] = 'PyIPSDK.eMinMax'

dictConversion['eMeanStdDev'] = {}
dictConversion['eMeanStdDev']['UserName'] = 'Mean and Standard deviation'
dictConversion['eMeanStdDev']['IPSDK'] = 'PyIPSDK.eMeanStdDev'

dictConversion['eHistogram'] = {}
dictConversion['eHistogram']['UserName'] = 'Histogram'
dictConversion['eHistogram']['IPSDK'] = 'PyIPSDK.eHistogram'

# eColorGeometryType
dictConversion['eCGT_Grey'] = {'UserName': 'Grey', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Grey'}
dictConversion['eCGT_Rgb'] = {'UserName': 'RGB', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgb'}
dictConversion['eCGT_Rgba'] = {'UserName': 'RGBa', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgba'}
dictConversion['eCGT_XYZ'] = {'UserName': 'XYZ', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_XYZ'}
dictConversion['eCGT_YPbPr'] = {'UserName': 'YPbPr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YPbPr'}
dictConversion['eCGT_YCbCr'] = {'UserName': 'YCbCr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YCbCr'}
dictConversion['eCGT_CieLab'] = {'UserName': 'CieLab', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLab'}
dictConversion['eCGT_CieLuv'] = {'UserName': 'CieLuv', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLuv'}
dictConversion['eCGT_HLS'] = {'UserName': 'HLS', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HLS'}
dictConversion['eCGT_HSV'] = {'UserName': 'HSV', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HSV'}

dictConversion['eRSP_Min'] = {}
dictConversion['eRSP_Min']['UserName'] = 'Min'
dictConversion['eRSP_Min']['IPSDK'] = 'shapeanalysis.eRSP_Min'

dictConversion['eRSP_Max'] = {}
dictConversion['eRSP_Max']['UserName'] = 'Max'
dictConversion['eRSP_Max']['IPSDK'] = 'shapeanalysis.eRSP_Max'

dictConversion['eSCP_SegCenter'] = {}
dictConversion['eSCP_SegCenter']['UserName'] = 'Center'
dictConversion['eSCP_SegCenter']['IPSDK'] = 'PyIPSDK.eSCP_SegCenter'

dictConversion['eSCP_SegEnds'] = {}
dictConversion['eSCP_SegEnds']['UserName'] = 'End'
dictConversion['eSCP_SegEnds']['IPSDK'] = 'PyIPSDK.eSCP_SegEnds'

dictConversion['eSCP_SegClosestPoint'] = {}
dictConversion['eSCP_SegClosestPoint']['UserName'] = 'Closest Point'
dictConversion['eSCP_SegClosestPoint']['IPSDK'] = 'PyIPSDK.eSCP_SegClosestPoint'

dictConversion['eSHP_Ignored'] = {}
dictConversion['eSHP_Ignored']['UserName'] = 'Ignored'
dictConversion['eSHP_Ignored']['IPSDK'] = 'PyIPSDK.eSHP_Ignored'

dictConversion['eSHP_ExtractedButNotAnalyzed'] = {}
dictConversion['eSHP_ExtractedButNotAnalyzed']['UserName'] = 'Extracted but not analysed'
dictConversion['eSHP_ExtractedButNotAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedButNotAnalyzed'

dictConversion['eSHP_ExtractedAndAnalyzed'] = {}
dictConversion['eSHP_ExtractedAndAnalyzed']['UserName'] = 'Extracted and analysed'
dictConversion['eSHP_ExtractedAndAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedAndAnalyzed'

dictConversion['eSEC_Leaf'] = {}
dictConversion['eSEC_Leaf']['UserName'] = 'Leaf'
dictConversion['eSEC_Leaf']['IPSDK'] = 'PyIPSDK.eSEC_Leaf'

dictConversion['eSEC_Branch'] = {}
dictConversion['eSEC_Branch']['UserName'] = 'Branch'
dictConversion['eSEC_Branch']['IPSDK'] = 'PyIPSDK.eSEC_Branch'

dictConversion['eSEC_All'] = {}
dictConversion['eSEC_All']['UserName'] = 'All'
dictConversion['eSEC_All']['IPSDK'] = 'PyIPSDK.eSEC_All'

dictConversion['eSVC_Internal'] = {}
dictConversion['eSVC_Internal']['UserName'] = 'Internal'
dictConversion['eSVC_Internal']['IPSDK'] = 'PyIPSDK.eSVC_Internal'

dictConversion['eSVC_Junction'] = {}
dictConversion['eSVC_Junction']['UserName'] = 'Junction'
dictConversion['eSVC_Junction']['IPSDK'] = 'PyIPSDK.eSVC_Junction'

dictConversion['eSVC_Slab'] = {}
dictConversion['eSVC_Slab']['UserName'] = 'Slab'
dictConversion['eSVC_Slab']['IPSDK'] = 'PyIPSDK.eSVC_Slab'

dictConversion['eSVC_EndPoint'] = {}
dictConversion['eSVC_EndPoint']['UserName'] = 'End Point'
dictConversion['eSVC_EndPoint']['IPSDK'] = 'PyIPSDK.eSVC_EndPoint'

dictConversion['eSVC_All'] = {}
dictConversion['eSVC_All']['UserName'] = 'All'
dictConversion['eSVC_All']['IPSDK'] = 'PyIPSDK.eSVC_All'

#######################
# Info Set Parameters #
#######################

dictConversion['ProcessHoles'] = {}
dictConversion['ProcessHoles']['UserName'] = 'Process Holes'
dictConversion['ProcessHoles']['IPSDK'] = 'shapeanalysis.createHolesBasicPolicyMsrParams'

dictConversion['NbOrientations'] = {}
dictConversion['NbOrientations']['UserName'] = 'Number of orientation?'
dictConversion['NbOrientations']['IPSDK'] = 'shapeanalysis.createAspectRatioMsrParams'

dictConversion['Orientation2D'] = {}
dictConversion['Orientation2D']['UserName'] = 'Orientation'
dictConversion['Orientation2D']['IPSDK'] = 'shapeanalysis.createFeretDiameter2dMsrParams'

dictConversion['Orientation3D'] = {}
dictConversion['Orientation3D']['UserName'] = ['Phi','Theta']
dictConversion['Orientation3D']['IPSDK'] = 'shapeanalysis.createFeretDiameter3dMsrParams'

dictConversion['OutlineSlopeAngularity2dMsrParams'] = {}
dictConversion['OutlineSlopeAngularity2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['OutlineSlopeAngularity2dMsrParams']['IPSDK'] = 'shapeanalysis.createOutlineSlopeAngularity2dMsrParams'

dictConversion['MaxFeretDiameterMsrParams'] = {}
dictConversion['MaxFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretDiameterMsrParams'

dictConversion['MaxFeretOrientation2dMsrParams'] = {}
dictConversion['MaxFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientation2dMsrParams'

dictConversion['MeanFeretDiameterMsrParams'] = {}
dictConversion['MeanFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MeanFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMeanFeretDiameterMsrParams'

dictConversion['MinFeretDiameterMsrParams'] = {}
dictConversion['MinFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretDiameterMsrParams'

dictConversion['MinFeretOrientation2dMsrParams'] = {}
dictConversion['MinFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientation2dMsrParams'

dictConversion['MaxFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MaxFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationPhi3dMsrParams'

dictConversion['MaxFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MaxFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationTheta3dMsrParams'

dictConversion['MinFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MinFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationPhi3dMsrParams'

dictConversion['MinFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MinFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationTheta3dMsrParams'

for extremum in ["Min","Max"]:
    for num in ["0","1"]:
        for letter in ["X","Y","Z"]:
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams'] = {}
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['UserName'] = 'Number of orientation'
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['IPSDK'] = 'shapeanalysis.create'+extremum+'FeretPt'+num+letter+'MsrParams'


dictConversion['OrientedExtentMsrParams'] = {}
dictConversion['OrientedExtentMsrParams']['UserName'] = ['Process Holes','Number of orientation']
dictConversion['OrientedExtentMsrParams']['IPSDK'] = 'shapeanalysis.createOrientedExtentMsrParams'

dictConversion['RelativeSizeMsrParams'] = {}
dictConversion['RelativeSizeMsrParams']['UserName'] = ['Process Holes','Size Policy']
dictConversion['RelativeSizeMsrParams']['IPSDK'] = 'shapeanalysis.createRelativeSizeMsrParams'

dictConversion['Roughness2dMsrParams'] = {}
dictConversion['Roughness2dMsrParams']['UserName'] = ['Process Holes','Max Distance']
dictConversion['Roughness2dMsrParams']['IPSDK'] = 'shapeanalysis.createRoughness2dMsrParams'

dictConversion['LengthOfContact2dMsrParams'] = {}
dictConversion['LengthOfContact2dMsrParams']['UserName'] = ['Contact distance','Segment contact Policy','Process Holes']
dictConversion['LengthOfContact2dMsrParams']['IPSDK'] = 'shapeanalysis.createLengthOfContact2dMsrParams'

dictConversion['NeighborsDistanceMsrParams'] = {}
dictConversion['NeighborsDistanceMsrParams']['UserName'] = ['Max distance','Process Holes']
dictConversion['NeighborsDistanceMsrParams']['IPSDK'] = 'shapeanalysis.createNeighborsDistanceMsrParams'

dictConversion['SurfaceOfContact3dMsrParams'] = {}
dictConversion['SurfaceOfContact3dMsrParams']['UserName'] = ['Contact distance','Process Holes']
dictConversion['SurfaceOfContact3dMsrParams']['IPSDK'] = 'shapeanalysis.createSurfaceOfContact3dMsrParams'

dictConversion['OBBCenterXMsrParams'] = {}
dictConversion['OBBCenterXMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterXMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterXMsrParams'

dictConversion['OBBCenterYMsrParams'] = {}
dictConversion['OBBCenterYMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterYMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterYMsrParams'

dictConversion['OBBCenterZMsrParams'] = {}
dictConversion['OBBCenterZMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterZMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterZMsrParams'

dictConversion['OBBWidthMsrParams'] = {}
dictConversion['OBBWidthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBWidthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBWidthMsrParams'

dictConversion['OBBLengthMsrParams'] = {}
dictConversion['OBBLengthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBLengthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBLengthMsrParams'

dictConversion['OBBHeightMsrParams'] = {}
dictConversion['OBBHeightMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBHeightMsrParams']['IPSDK'] = 'shapeanalysis.createOBBHeightMsrParams'

dictConversion['OBBOrientation2dMsrParams'] = {}
dictConversion['OBBOrientation2dMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientation2dMsrParams'

dictConversion['OBBOrientationAlphaMsrParams'] = {}
dictConversion['OBBOrientationAlphaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationAlphaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationAlphaMsrParams'

dictConversion['OBBOrientationBetaMsrParams'] = {}
dictConversion['OBBOrientationBetaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationBetaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationBetaMsrParams'

dictConversion['OBBOrientationChiMsrParams'] = {}
dictConversion['OBBOrientationChiMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationChiMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationChiMsrParams'

dictConversion['Skeleton2dDiameterLengthMsrParams'] = {}
dictConversion['Skeleton2dDiameterLengthMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterLengthMsrParams'

dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams'] = {}
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterMeanCurvatureMsrParams'

dictConversion['Skeleton2dDiameterTortuosityMsrParams'] = {}
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterTortuosityMsrParams'

dictConversion['Skeleton2dLengthMsrParams'] = {}
dictConversion['Skeleton2dLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dLengthMsrParams'

dictConversion['Skeleton2dMaxThicknessMsrParams'] = {}
dictConversion['Skeleton2dMaxThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMaxThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMaxThicknessMsrParams'

dictConversion['Skeleton2dMeanEdgeLengthMsrParams'] = {}
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanEdgeLengthMsrParams'

dictConversion['Skeleton2dMeanThicknessMsrParams'] = {}
dictConversion['Skeleton2dMeanThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMeanThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanThicknessMsrParams'

dictConversion['Skeleton2dMinThicknessMsrParams'] = {}
dictConversion['Skeleton2dMinThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMinThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMinThicknessMsrParams'

dictConversion['Skeleton2dNbVertexMsrParams'] = {}
dictConversion['Skeleton2dNbVertexMsrParams']['UserName'] = ['Holes Policy','Vertex Catagory']
dictConversion['Skeleton2dNbVertexMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dNbVertexMsrParams'

dictConversion['HistogramMostPopulatedGLMsrParams'] = {}
dictConversion['HistogramMostPopulatedGLMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramMostPopulatedGLMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramMostPopulatedGLMsrParamsBinWidth'

dictConversion['HistogramPopulationMaxMsrParams'] = {}
dictConversion['HistogramPopulationMaxMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramPopulationMaxMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramPopulationMaxMsrParamsBinWidth'

dictConversion['HistogramQuantileMsrParams'] = {}
dictConversion['HistogramQuantileMsrParams']['UserName'] = ['Bin','Min','Max','Quantile']
dictConversion['HistogramQuantileMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramQuantileMsrParamsBinWidth'

def SubElement(element,text):

    toReturn=None
    for child in element:
        if child.tag==text:
            toReturn=child
    if toReturn is None:
        toReturn = xmlet.SubElement(element, text)
    return toReturn

def childIterator(xmlNode, tag):
    for child in xmlNode:
        if child.tag == tag:
            yield child
        else:
            for subChild in childIterator(child, tag):
                yield subChild

def convertTextToAscii(text):

    newText = ''
    if text != None:
        for char in text:
            newText += str(ord(char)) + '.'

        if newText != '':
            newText = newText[:-1]

    return newText

def convertTextFromAscii(text):

    newText = ''
    if text != '' and text != None:
        textSplit = text.split('.')
        for number in textSplit:
            char = chr(int(number))
            newText += char

    return newText

def childText(element,tag):

    text=None
    if element != None:
        for child in element:
            if child.tag==tag:
                text=child.text
                try:
                    if child.get('ASCII') == str(True):
                        text = convertTextFromAscii(text)
                except:
                    pass
    return text

def numberCalibration(value,numberMeaningful=3):

    if float(value) > 0:
        value = float(value) + 0.000001
    elif float(value) < 0:
        value = float(value) - 0.000001
    else:
        value = float(value)

    textValue = str(value)

    if "e-" in textValue:
        try:
            nbZeros = int(textValue.split("e-")[1])
            mainNumber = textValue.split("e-")[0]
            if mainNumber[0] == "-":
                outValue = "-0."
                mainNumber = mainNumber[1:]
            else:
                outValue = "0."
            for i in range(nbZeros-1):
                outValue += "0"

            for i in range(4):
                try:
                    if mainNumber[i] != ".":
                        outValue+=mainNumber[i]
                except:
                    pass

            while len(outValue)>numberMeaningful and outValue[len(outValue)-1]=="0":
                outValue = outValue[:-1]

        except:
            outValue = "0"

    else:

        numberAdded = 0
        firstValue = False
        hasPoint = False
        newValue = ""
        for caracter in textValue:
            if caracter not in ["0",".","-"]:
                firstValue = True
                numberAdded+=1
            else:
                if caracter == "0" and firstValue:
                    numberAdded+=1
            if caracter == ".":
                hasPoint = True
            if caracter != "." or numberAdded < numberMeaningful:
                newValue+=caracter
            if numberAdded >= numberMeaningful and hasPoint:
                break

        if hasPoint:
            hasValue = False
            outValue = ""
            hasPoint = "." in newValue
            for i in range(len(newValue)-1,-1,-1):
                if newValue[i] not in ["0","."] or hasValue or hasPoint == False:
                    outValue = newValue[i] + outValue
                    hasValue = True
                if newValue[i] == ".":
                    hasValue = True
        else:
            outValue = newValue

    return outValue

class RangeSlider(qt.QGroupBox):

    signalValueChanged = QtCore.pyqtSignal(float, float)

    def __init__(self,fontSize = None):
        qt.QGroupBox.__init__(self)

        self.fontSize = fontSize
        self.type = PyIPSDK.eIBT_UInt8
        self.isFixedMin = True
        self.isFixedMax = True
        self.currentIndex = 0

        self.labelSize = 50*ratioScreen
        self.marginLabelSize = 6*ratioScreen
        self.handleSize = 4*ratioScreen
        self.minValue = 0
        self.maxValue = 255
        self.currentValueMin = int(self.maxValue/2)
        self.currentValueMax = self.maxValue
        self.allowConnect = True

        self.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.groupLabelValue = GroupValueLabel(labelSize=self.labelSize,fontSize = fontSize)
        self.groupLabelValue.setFixedHeight(self.height()*33/100)

        self.groupSlider = GroupSlider(parent=self,labelSize=self.labelSize,handleSize=self.handleSize,minValue=self.minValue,maxValue=self.maxValue,fontSize = fontSize)
        self.groupSlider.setFixedHeight(self.height()*67/100)

        self.layout = qt.QGridLayout()
        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.groupSlider.setContentsMargins(0, 0, 0, 0)
        self.groupLabelValue.setContentsMargins(0, 0, 0, 0)
        self.setContentsMargins(0,0,0,0)
        self.layout.setVerticalSpacing(0)

        self.layout.addWidget(self.groupLabelValue,0,0)
        self.layout.addWidget(self.groupSlider,1,0)

        self.groupSlider.signalValueChanged.connect(self.changeLabelsInterface)
        self.groupSlider.signalMouseClicked.connect(self.applyClick)

    def applyClick(self,ratio):

        value = self.minValue + ratio*(self.maxValue - self.minValue)
        if value <= (self.currentValueMin + self.currentValueMax)/2:
            self.isFixedMin = False
            self.setValueMin(value)
        if value > (self.currentValueMin + self.currentValueMax)/2:
            self.isFixedMax = False
            self.setValueMax(value)

    def setMinMaxValues(self,minValue,maxValue):

        if minValue != self.minValue or maxValue != self.maxValue:
            self.minValue = float(numberCalibration(minValue,3))
            self.maxValue = float(numberCalibration(maxValue,3))
            self.groupSlider.labelMin.setText(numberCalibration(minValue,3))
            self.groupSlider.labelMax.setText(numberCalibration(maxValue,3))

    def changeLabelsInterface(self):

        if self.allowConnect:
            if self.currentIndex == 1:
                self.isFixedMin = False
            elif self.currentIndex == 2:
                self.isFixedMax = False
            self.changeLabels()

    def changeLabels(self):

        if self.allowConnect:
            start = self.groupSlider.groupBoxMiddle.pos().x() - self.groupSlider.handleSize - 2
            end = start + self.groupSlider.groupBoxMiddle.width() + 2

            maxSize = self.width() - 2 * (self.labelSize + self.handleSize) - 2 * self.marginLabelSize + 2*ratioScreen

            # maxSize = max(maxSize,end)

            minValue = start * (self.maxValue-self.minValue) / maxSize + self.minValue
            minValue = max(minValue,self.minValue)
            maxValue = end * (self.maxValue-self.minValue) / maxSize + self.minValue
            maxValue = min(maxValue,self.maxValue)
            minValue = min(minValue,self.maxValue)
            maxValue = max(maxValue,self.minValue)

            if self.type != PyIPSDK.eIBT_Real32:
                minValue = round(minValue)
                maxValue = round(maxValue)

            if self.isFixedMin:
                minValue = self.currentValueMin
            if self.isFixedMax:
                maxValue = self.currentValueMax

            self.groupLabelValue.labelMinValue.setText(numberCalibration(minValue,3))
            self.groupLabelValue.labelMaxValue.setText(numberCalibration(maxValue,3))

            self.currentValueMin = minValue
            self.currentValueMax = maxValue

            self.groupLabelValue.layout.setStretch(0, start + (self.marginLabelSize + self.handleSize))
            self.groupLabelValue.layout.setStretch(2, end -start)
            self.groupLabelValue.layout.setStretch(4,maxSize-end + (self.marginLabelSize + self.handleSize))

            self.signalValueChanged.emit(minValue,maxValue)

    def setValues(self,minValue=None,maxValue=None):

        self.allowConnect = False
        maxSize = self.width() - 2 * (self.labelSize + self.handleSize) - 2 * self.marginLabelSize + 2*ratioScreen
        denominator = (self.maxValue - self.minValue)
        if denominator == 0:
            denominator = 1

        if minValue is not None:
            minValue = max(minValue, self.minValue)
            self.groupSlider.splitter.moveSplitter(0, 1)
            if abs(minValue-self.minValue)>0.0001:
                start = (minValue - self.minValue) * maxSize / denominator
                self.groupSlider.splitter.moveSplitter(start, 1)
        if maxValue is not None:
            maxValue = min(maxValue, self.maxValue)
            self.groupSlider.splitter.moveSplitter(maxSize + self.handleSize + 4*ratioScreen, 2)
            if abs(maxValue-self.maxValue)>0.0001:
                end = (maxValue - self.minValue) * maxSize / denominator
                self.groupSlider.splitter.moveSplitter(end + self.handleSize, 2)

        self.allowConnect = True

        self.changeLabels()

    def setValueMin(self,minValue):

        self.setValues(minValue=minValue)

    def setValueMax(self,maxValue):

        self.setValues(maxValue=maxValue)

    def resizeEvent(self,event):

        self.groupLabelValue.setFixedHeight(self.height() * 33 / 100)
        self.groupSlider.setFixedHeight(self.height() * 67 / 100)

class GroupSlider(qt.QWidget):

    signalValueChanged = QtCore.pyqtSignal()
    signalMouseClicked = QtCore.pyqtSignal(float)

    def __init__(self,parent=None,labelSize = 30*ratioScreen,handleSize = 3, minValue = 0, maxValue = 255,fontSize = None):
        qt.QWidget.__init__(self)

        self.parent = parent
        self.labelSize = labelSize
        self.handleSize = handleSize
        self.minValue = minValue
        self.maxValue = maxValue

        self.groupBoxStart = qt.QWidget()
        self.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')

        self.groupBoxMiddle = qt.QWidget()
        self.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')

        self.groupBoxEnd = qt.QWidget()
        self.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')

        image = np.zeros((1000, 1000, 3))
        image = np.asarray(image, dtype=np.uint8)
        self.labelBackground = LabelImage(image=image)
        #self.labelBackground = wgt.LabelImage(str(vrb.folderButtons)+"threshold.jpg")
        #self.groupBoxBackground.setStyleSheet('QWidget {background-image: url("'+str(vrb.folderButtons)+'threshold.jpg");}')

        self.splitter = qt.QSplitter()
        self.splitter.setStyleSheet('QSplitter::handle:vertical {height: '+ str(self.handleSize) + 'px;} QSplitter::handle {background-color: darkblue;}') # QSplitter::handle:pressed {background-color: rgb(0, 100, 0);}')

        self.splitter.addWidget(self.groupBoxStart)
        self.splitter.addWidget(self.groupBoxMiddle)
        self.splitter.addWidget(self.groupBoxEnd)

        font = QtGui.QFont()
        if fontSize is not None:
            font.setPointSize(fontSize)
        font.setBold(True)

        self.labelMin = qt.QLabel(str(self.minValue))
        self.labelMin.setFixedWidth(labelSize)
        self.labelMin.setAlignment(QtCore.Qt.AlignCenter)
        self.labelMin.setFont(font)

        self.labelMax = qt.QLabel(str(self.maxValue))
        self.labelMax.setFixedWidth(labelSize)
        self.labelMax.setAlignment(QtCore.Qt.AlignCenter)
        self.labelMax.setFont(font)

        self.layout = qt.QGridLayout()

        self.layout.setContentsMargins(0,0,0,0)
        self.setContentsMargins(0,0,0,0)

        self.layout.addWidget(self.labelMin,0,0)

        # self.stackedGroupBox = qt.QGroupBox()
        # #self.stackedLayout = qt.QStackedLayout()
        # self.stackedLayout = qt.QGridLayout()
        # self.stackedLayout.addWidget(self.labelBackground,0,0)
        # self.stackedLayout.addWidget(self.splitter,0,0)
        # #self.stackedLayout.setStackingMode(qt.QStackedLayout.StackAll)
        # self.stackedGroupBox.setLayout(self.stackedLayout)

        self.layout.addWidget(self.labelBackground, 0, 1)
        self.layout.addWidget(self.splitter, 0, 1)
        #self.layout.addWidget(self.stackedGroupBox,0,1)

        self.layout.addWidget(self.labelMax,0,2)

        self.setLayout(self.layout)

        self.splitter.splitterMoved.connect(self.handleMoveSplitter)

    def applyExclusive(self,exclusive):

        if exclusive:
            self.groupBoxStart.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
            self.groupBoxMiddle.setStyleSheet('QWidget {background-color: transparent;}')
            self.groupBoxEnd.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
        else:
            self.groupBoxStart.setStyleSheet('QWidget {background-color: transparent;}')
            self.groupBoxMiddle.setStyleSheet('QWidget {background-color: rgba(255, 255, 255,128);}')
            self.groupBoxEnd.setStyleSheet('QWidget {background-color: transparent;}')

    def handleMoveSplitter(self, xpos, index):

        if index == 1:
            self.groupBoxEnd.setMinimumWidth(self.groupBoxEnd.width())
            self.groupBoxStart.setMinimumWidth(0)
        if index == 2:
            self.groupBoxStart.setMinimumWidth(self.groupBoxStart.width())
            self.groupBoxEnd.setMinimumWidth(0)

        self.parent.currentIndex = index

        self.signalValueChanged.emit()

    def mousePressEvent(self,event):

        posX = event.pos().x()-self.splitter.pos().x()
        ratio = posX/self.splitter.width()
        if ratio >= 0 and ratio <= 1:
            self.signalMouseClicked.emit(ratio)

    def getHistogram(self,histogram,color = [255,0,0],image = None, output = False, contour = False):

        newHistogram = []
        for i in range(len(histogram)):
            newHistogram.append(math.sqrt(histogram[i]))

        if len(newHistogram)>=2:
            maxValue = max(newHistogram)
            index = newHistogram.index(maxValue)
            newHistogram[index] = 0
            maxValue2 = max(newHistogram)
            newHistogram[index] = min(3*maxValue2,maxValue)

        sizeX, sizeY = 1000, 1000
        if image is None:
            image = np.zeros((sizeY, sizeX, 3))
            image = np.asarray(image, dtype=np.uint8)

        maxFreq = max(newHistogram)
        maxFreq = max(1,maxFreq)
        step = sizeX/len(newHistogram)

        for i in range(len(newHistogram)):
            for c in range(len(color)):
                if color[c]!=0:
                    if contour == False:
                        image[sizeY-int((newHistogram[i]/maxFreq)*sizeY):sizeY,int(step*i):int(step*(i+1)),c] = color[c]
                    else:
                        image[sizeY - int((newHistogram[i] / maxFreq) * sizeY)-5:sizeY - int((newHistogram[i] / maxFreq) * sizeY)+5, int(step * i):int(step * (i + 1)), c] = color[c]
                        try:
                            image[min(sizeY - int((newHistogram[i] / maxFreq) * sizeY),sizeY - int((newHistogram[i+1] / maxFreq) * sizeY)):
                                  max(sizeY - int((newHistogram[i] / maxFreq) * sizeY),sizeY - int((newHistogram[i+1] / maxFreq) * sizeY)), int(step * (i + 1))-1:int(step * (i + 1))+1, c] = color[c]
                        except:
                            pass

        if output == False:
            self.labelBackground.image = image
            self.labelBackground.resizeEvent(None)
        else:
            return image

    def getColorHistogram(self,image,contour=False):

        histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(0, 255, 1)
        colors = [[255,0,0],[0,255,0],[0,0,255]]
        outImage = None

        for c in range(3):

            plan = PyIPSDK.extractPlan(0,c,0,image)
            plan = util.copyImg(plan)
            histogramMsr2dResult = glbmsr.histogramMsr2d(plan, histogramMsrParams)
            outImage = self.getHistogram(histogramMsr2dResult.frequencies, contour=contour, color=colors[c],image=outImage,output=True)

        vector = outImage[:,:,2] == 255
        outImage[vector, 0] = 0
        outImage[vector, 1] = 0
        vector = outImage[:, :, 1] == 255
        outImage[vector, 0] = 0

        self.labelBackground.image = outImage
        self.labelBackground.resizeEvent(None)


class GroupValueLabel(qt.QWidget):

    def __init__(self, labelSize = 30,fontSize = None):
        qt.QWidget.__init__(self)

        self.labelSize = labelSize

        self.layout = qt.QHBoxLayout()

        font = QtGui.QFont()
        if fontSize is not None:
            font.setPointSize(fontSize)
        font.setBold(True)

        self.labelMinValue = qt.QLabel('0')
        self.labelMinValue.setFixedWidth(self.labelSize)
        self.labelMinValue.setAlignment(QtCore.Qt.AlignRight)
        self.labelMinValue.setFont(font)

        self.labelMaxValue = qt.QLabel('255')
        self.labelMaxValue.setFixedWidth(self.labelSize)
        self.labelMaxValue.setAlignment(QtCore.Qt.AlignLeft)
        self.labelMaxValue.setFont(font)

        self.layout.addStretch()
        self.layout.addWidget(self.labelMinValue)
        self.layout.addStretch()
        self.layout.addWidget(self.labelMaxValue)
        self.layout.addStretch()

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.setContentsMargins(0, 0, 0, 0)

class LabelImage(qt.QLabel):

    def __init__(self, filename=None, image=None):
        qt.QLabel.__init__(self)

        self.filename = filename
        self.image = image
        self.smooth = True

    def resizeEvent(self, event):

        if self.image is None:
            if self.filename != None:
                pixmap = QtGui.QPixmap(self.filename)
                if self.smooth:
                    self.setPixmap(pixmap.scaled(self.width(), self.height(), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation))
                else:
                    self.setPixmap(pixmap.scaled(self.width(), self.height()))
        else:
            if self.image.shape[2] == 1:
                qimg = QtGui.QImage(self.image, self.image.shape[1], self.image.shape[0], self.image.shape[1], QtGui.QImage.Format_Grayscale8)
            if self.image.shape[2] == 3:
                qimg = QtGui.QImage(self.image, self.image.shape[1], self.image.shape[0], 3 * self.image.shape[1], QtGui.QImage.Format_RGB888)
            pixmap = QtGui.QPixmap.fromImage(qimg)
            if self.smooth:
                self.setPixmap(pixmap.scaled(self.width(), self.height(), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation))
            else:
                self.setPixmap(pixmap.scaled(self.width(), self.height()))

class SimpleHorizontalSliderLabel(qt.QGroupBox):

    SignalSliderEvent = QtCore.pyqtSignal()

    def __init__(self,**kwargs):

        qt.QGroupBox.__init__(self)

        if 'label' in kwargs:
            label=kwargs.pop('label')
        else:
            label=''
        if 'minimum' in kwargs:
            self.minimum=kwargs.pop('minimum')
        else:
            self.minimum=0
        if 'maximum' in kwargs:
            self.maximum=kwargs.pop('maximum')
        else:
            self.maximum=255
        if 'defaultValue' in kwargs:
            defaultValue=kwargs.pop('defaultValue')
            if defaultValue<self.minimum:
                defaultValue=self.minimum
            if defaultValue>self.maximum:
                defaultValue = self.maximum
        else:
            defaultValue=self.minimum
        if "ratio" in kwargs:
            self.ratio = kwargs.pop('ratio')
        else:
            self.ratio = 1

        self.title=qt.QLabel(label)
        self.title.setAlignment(QtCore.Qt.AlignCenter)
        self.slider = qt.QSlider(QtCore.Qt.Horizontal)
        self.slider.setRange(self.minimum,self.maximum)
        self.slider.setValue(defaultValue)
        if defaultValue == int(defaultValue) and self.ratio == 1:
            self.lineEditSliderValue = qt.QLabel(str(int (defaultValue)))
        else:
            self.lineEditSliderValue = qt.QLabel(str(defaultValue/self.ratio))

        self.layout = qt.QGridLayout()
        self.setLayout(self.layout)
        self.layout.setContentsMargins(0,0,0,0)
        self.layout.setSizeConstraint(1)

        self.layout.addWidget(self.title, 0, 0)
        self.layout.addWidget(self.slider, 0, 1)
        self.layout.addWidget(self.lineEditSliderValue, 0, 2)

        self.slider.valueChanged.connect(self.changeLineEdit)

    def resizeEvent(self, event):

        self.title.setFixedSize(100*ratioScreen,self.size().height()*90/100)
        self.slider.setFixedSize(max(0,self.size().width() -150*ratioScreen), self.size().height() * 90 / 100)
        self.lineEditSliderValue.setFixedSize(30*ratioScreen, self.size().height() * 90 / 100)

    def changeLineEdit(self):

        value = int(self.slider.value()*100/self.ratio)/100
        if value == int(value):
            value = int(value)
        self.lineEditSliderValue.setText(str(value))

class ImageViewer(qt.QGraphicsView):

    signalZoomFactorChanged = pyqtSignal()
    signalMouseMoved = pyqtSignal(float, float)
    signalNewImage = pyqtSignal(list)
    signalEmitMouse = pyqtSignal(dict)
    signalEmitKey = pyqtSignal(int)

    def __init__(self, scene, widgetImage = None,parent=None):
        qt.QGraphicsView.__init__(self)

        self.widgetImage = widgetImage
        self.parent = parent
        self.index = None

        self.allowResize = True

        self.ctrlPressed = False

        self.currentButtonPressed = None

        self.setMouseTracking(True)
        self.setAcceptDrops(True)

        self.image = None
        self.imageOverlay = None
        self.zoomFactor = 1
        self.mousePressed = False
        self.minZoomFactor = 1
        self.maxZoomFactor = 100
        self.currentZoom = 1

        self.realStartPointX = 0
        self.realStartPointY = 0
        self.refPosX = None
        self.refPosY = None
        self.roiImage = None

        self.minimumSize = 2000

        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

        self.scene = scene
        self.setScene(scene)

        self.setContentsMargins(0, 0, 0, 0)

    def resizeEvent(self, event):

        if self.image != None and self.allowResize:
            self.correctRealStartPoint()
            self.getRoiImage()

    #3 fonctions pour gérer le drag and drop
    def dragEnterEvent(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dragMoveEvent(self, event):

        if event.mimeData().hasUrls:
            event.accept()
        else:
            event.ignore()

    def dropEvent(self, event):

        if event.mimeData().hasUrls:
            urls = event.mimeData().urls()
            self.signalNewImage.emit(urls)

    def wheelEvent(self, event, params=None):

        # Zoom avec la molette
        if params == None:
            realPointX, realPointY = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
            steps = event.angleDelta().y() / 120.0
        else:
            realPointX, realPointY = self.scenePointToRealPoint(params[0], params[1])
            steps = params[2]

        roiSizeXBefore, roiSizeYBefore = self.getRoiSize()
        if steps > 0:
            self.zoomFactor *= (1 + steps * 0.3)
            self.zoomFactor = min(self.zoomFactor, self.maxZoomFactor)
        if steps < 0:
            self.zoomFactor /= (1 - steps * 0.3)
            self.zoomFactor = max(self.zoomFactor, self.minZoomFactor)

        roiSizeX, roiSizeY = self.getRoiSize()

        self.realStartPointX = realPointX - ((roiSizeX) * (realPointX - self.realStartPointX) / roiSizeXBefore)
        self.realStartPointY = realPointY - ((roiSizeY) * (realPointY - self.realStartPointY) / roiSizeYBefore)
        self.correctRealStartPoint()

        self.getRoiImage()

    # Gestion des signaux de la souris
    def mousePressEvent(self, event):

        self.currentButtonPressed = event.button()

        self.viewport().setCursor(Qt.ClosedHandCursor)

        self.mousePressed = True
        self.refPosX = event.pos().x()
        self.refPosY = event.pos().y()

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "MousePressed"

        self.signalEmitMouse.emit(ddict)

    def mouseReleaseEvent(self, event):

        self.currentButtonPressed = None

        self.mousePressed = False
        self.viewport().setCursor(Qt.ArrowCursor)
        self.refPosX = None
        self.refPosY = None

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "Release"

        self.signalEmitMouse.emit(ddict)

    def mouseMoveEvent(self, event):

        if self.mousePressed and self.currentButtonPressed == 1 :

            if self.refPosX != None and self.refPosY != None:
                roiSizeX, roiSizeY = self.getRoiSize()
                usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

                deltaX = event.pos().x() - self.refPosX
                deltaY = event.pos().y() - self.refPosY

                deltaX = deltaX * round(roiSizeX) / usefulSizeX
                deltaY = deltaY * round(roiSizeY) / usefulSizeY

                self.realStartPointX = self.realStartPointX - deltaX
                self.realStartPointY = self.realStartPointY - deltaY

                self.correctRealStartPoint()
                self.getRoiImage()

            self.refPosX = event.pos().x()
            self.refPosY = event.pos().y()

        realPointX, realPointY = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        self.signalMouseMoved.emit(realPointX, realPointY)

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "Move"

        self.signalEmitMouse.emit(ddict)

    def mouseDoubleClickEvent(self, event):

        ddict = {}
        ddict["Position"] = self.scenePointToRealPoint(event.pos().x(), event.pos().y())
        ddict["Button"] = event.button()
        ddict["Event"] = "DoubleClick"

        self.signalEmitMouse.emit(ddict)

    # Gestion des touches du clavier
    def keyPressEvent(self, event):

        key = event.key()
        roiSizeX, roiSizeY = self.getRoiSize()

        # Ctrl
        if key == 16777249:
            self.ctrlPressed = True

        # Ctrl + c
        if key == 67:
            if self.ctrlPressed:

                pixmap = QtGui.QImage(self.scene.width(), self.scene.height(), QtGui.QImage.Format_ARGB32_Premultiplied)
                painter = QtGui.QPainter()
                painter.begin(pixmap)
                painter.setRenderHint(QtGui.QPainter.Antialiasing, True)
                self.scene.render(painter)
                painter.end()

                if self.parent != None:
                    self.parent.clipboard.setImage(pixmap)

        # 4 flèches directionnelles
        if key == 16777234:
            self.realStartPointX -= roiSizeX * 10 / 100
            self.getRoiImage()

        if key == 16777235:
            self.realStartPointY -= roiSizeY * 10 / 100
            self.getRoiImage()

        if key == 16777236:
            self.realStartPointX += roiSizeX * 10 / 100
            self.getRoiImage()

        if key == 16777237:
            self.realStartPointY += roiSizeY * 10 / 100
            self.getRoiImage()

        self.signalEmitKey.emit(key)

    def keyReleaseEvent(self, event):

        key = event.key()

        if key == 16777249:
            self.ctrlPressed = False

    def scenePointToRealPoint(self, pointX, pointY):

        # Passage des coordonnées dans la scène aux coordonnées réelles dans l'image

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()
        uselessSizeX, uselessSizeY = self.getUselessSize()

        realPointX = round(self.realStartPointX) + (pointX * round(roiSizeX) / usefulSizeX) - uselessSizeX
        realPointY = round(self.realStartPointY) + (pointY * round(roiSizeY) / usefulSizeY) - uselessSizeY

        if self.image != None:
            realPointX = max(0, realPointX)
            realPointX = min(realPointX, self.image[0].getSizeX())
            realPointY = max(0, realPointY)
            realPointY = min(realPointY, self.image[0].getSizeY())

        return realPointX, realPointY

    def realPointToScene(self, pointX, pointY):

        # Passage des coordonnées réelles aux coordonnées dans la scène

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

        scenePointX = (pointX - self.realStartPointX) * usefulSizeX / round(roiSizeX)
        scenePointY = (pointY - self.realStartPointY) * usefulSizeY / round(roiSizeY)

        return scenePointX, scenePointY

    def correctRealStartPoint(self):

        # Correction pour ne pas sortir de l'image

        roiSizeX, roiSizeY = self.getRoiSize()

        self.realStartPointX = max(0, self.realStartPointX)
        self.realStartPointY = max(0, self.realStartPointY)

        if self.image != None:
            self.realStartPointX = min(self.image[0].getSizeX() - round(roiSizeX), self.realStartPointX)
            self.realStartPointY = min(self.image[0].getSizeY() - round(roiSizeY), self.realStartPointY)

    def getRoiSize(self):

        # Calcul de la ROI à récupérer dans l'image

        if self.image != None:

            maxRatio = max(self.image[0].getSizeX() / self.width(), self.image[0].getSizeY() / self.height())
            ratioSizeX = maxRatio / (self.image[0].getSizeX() / self.width())
            ratioSizeY = maxRatio / (self.image[0].getSizeY() / self.height())

            roiSizeX = min(self.image[0].getSizeX(), (self.image[0].getSizeX() * ratioSizeX / self.zoomFactor))
            roiSizeY = min(self.image[0].getSizeY(), (self.image[0].getSizeY() * ratioSizeY / self.zoomFactor))
        else:
            roiSizeX = 1
            roiSizeY = 1

        return roiSizeX, roiSizeY

    def getUsefulSizeScene(self):

        # Calcul de la taille utile dans la QGraphicScene

        roiSizeX, roiSizeY = self.getRoiSize()
        maxConversionFactor = min(self.width() / roiSizeX, self.height() / roiSizeY)
        conversionFactorX = (self.width() / roiSizeX) / maxConversionFactor
        conversionFactorY = (self.height() / roiSizeY) / maxConversionFactor

        usefulSizeX = self.width() / conversionFactorX
        usefulSizeY = self.height() / conversionFactorY

        return usefulSizeX, usefulSizeY

    def getUselessSize(self):

        # Calcul de la taille inutile dans la QGraphicScene

        roiSizeX, roiSizeY = self.getRoiSize()
        usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

        uselessSizeX = ((self.width() - usefulSizeX) / 2)
        uselessSizeY = ((self.height() - usefulSizeY) / 2)
        uselessSizeX = uselessSizeX * round(roiSizeX) / usefulSizeX
        uselessSizeY = uselessSizeY * round(roiSizeY) / usefulSizeY

        return uselessSizeX, uselessSizeY

    def getRoiImage(self, changeRoiImage=True):

        #Récupéreration de la ROI à visualiser dans l'image
        #Intéraction avec le widget parent (overlay, contraste...)
        #Passage à une QImage

        if self.image != None:
            self.correctRealStartPoint()
            roiSizeX, roiSizeY = self.getRoiSize()
            usefulSizeX, usefulSizeY = self.getUsefulSizeScene()

            ratio = min(roiSizeX/usefulSizeX,roiSizeY,usefulSizeY)
            zoomLvl = int(np.log(ratio)/np.log(2))
            zoomLvl = max(0,zoomLvl)
            zoomLvl = min(zoomLvl,self.image["maxZoom"])
            factorResize = 2**zoomLvl

            newRoiSizeX = min(roiSizeX/factorResize,self.image[zoomLvl].getSizeX())
            newRoiSizeY = min(roiSizeY/factorResize,self.image[zoomLvl].getSizeY())

            newRealStartPointX = min(self.image[zoomLvl].getSizeX() - round(newRoiSizeX), self.realStartPointX/factorResize)
            newRealStartPointY = min(self.image[zoomLvl].getSizeY() - round(newRoiSizeY), self.realStartPointY/factorResize)

            if changeRoiImage or self.roiImage is None or self.roiImageOverlay is None:

                roiImage = util.getROI2dImg(self.image[zoomLvl], round(newRealStartPointX), round(newRealStartPointY), round(newRoiSizeX), round(newRoiSizeY))
                interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
                if roiImage.getBufferType() not in bufferList:
                    #interp = PyIPSDK.eZoomInterpolationMethod.eZIM_Linear
                    interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
                roiImage = gtrans.zoom2dImg(roiImage, usefulSizeX / round(newRoiSizeX), usefulSizeY / round(newRoiSizeY), interp)
                self.roiImage = roiImage

                if self.imageOverlay != None:
                    roiImageOverlay = util.getROI2dImg(self.imageOverlay[zoomLvl], round(newRealStartPointX), round(newRealStartPointY), round(newRoiSizeX), round(newRoiSizeY))
                    interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
                    if roiImageOverlay.getBufferType() not in bufferList:
                        #interp = PyIPSDK.eZoomInterpolationMethod.eZIM_Linear
                        interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
                    roiImageOverlay = gtrans.zoom2dImg(roiImageOverlay, usefulSizeX / round(newRoiSizeX), usefulSizeY / round(newRoiSizeY), interp)
                else:
                    roiImageOverlay = None
                self.roiImageOverlay = roiImageOverlay

            if self.widgetImage != None:
                #try:
                roiImageToAdd = self.widgetImage.transformImage(self.roiImage, self.roiImageOverlay)
                # except:
                #     roiImageToAdd = util.copyImg(self.roiImage)
            else:
                roiImageToAdd = util.copyImg(self.roiImage)

            if roiImageToAdd.getSizeC() == 1:
                imgFormat = QtGui.QImage.Format_Grayscale8
                qimg = QtGui.QImage(roiImageToAdd.array, roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY(), roiImageToAdd.getSizeX(), imgFormat)

            if roiImageToAdd.getSizeC() == 3:
                imgFormat = QtGui.QImage.Format_RGB888
                qimg = QtGui.QImage(roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY(), imgFormat)
                for v in range(roiImageToAdd.getSizeY()):
                    ptr = qimg.scanLine(v)
                    ptr.setsize(qimg.bytesPerLine())
                    lineArr = np.asarray(ptr)
                    for c in range(3):
                        lineArr[c::3][:roiImageToAdd.getSizeX()] = roiImageToAdd.array[c][v][0:roiImageToAdd.getSizeX()]

            imageToAdd = QtGui.QPixmap.fromImage(qimg)

            self.scene.clear()
            self.scene.clearSelection()
            self.scene.clearFocus()

            self.scene.setSceneRect(0, 0, roiImageToAdd.getSizeX(), roiImageToAdd.getSizeY())
            self.scene.addPixmap(imageToAdd)

            self.signalZoomFactorChanged.emit()

    def changeZoneImage(self, pointX, pointY):

        #Déplacement de l'image dans une zone centrée en pointX, pointY

        roiSizeX, roiSizeY = self.getRoiSize()

        self.realStartPointX = round(pointX - roiSizeX / 2)
        self.realStartPointY = round(pointY - roiSizeY / 2)

        self.correctRealStartPoint()
        self.getRoiImage()

    def resetZoom(self):

        # Retour à l'image en full résolution
        self.realStartPointX = 0
        self.realStartPointY = 0
        self.zoomFactor = 1
        self.getRoiImage()

    def setImage(self, image):

        # Application d'une nouvelle image IPSDK
        self.image = image
        self.correctRealStartPoint()
        self.getRoiImage()

    def setImageOverlay(self,imageOverlay):
        # Application d'une nouvelle image overlay IPSDK
        self.imageOverlay = imageOverlay
        self.getRoiImage()
        #self.getRoiImage(changeRoiImage=False)

class WidgetInfo(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.labelTypeSize = qt.QLabel()
        self.labelZoom = qt.QLabel()
        self.labelPosition = qt.QLabel()

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.labelTypeSize, 0, 0)
        self.layout.addWidget(self.labelZoom, 0, 1)
        self.layout.addWidget(self.labelPosition, 0, 2)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)

    def resizeEvent(self, event):

        self.labelTypeSize.setFixedSize(self.width() * 25 / 100, self.height() * 100 / 100)
        self.labelZoom.setFixedSize(self.width() * 13 / 100, self.height() * 100 / 100)
        self.labelPosition.setFixedSize(self.width() * 52 / 100, self.height() * 100 / 100)

class SlidersAxis(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.sliderX = SimpleHorizontalSliderLabel(label = "x = ", minimum=0, maximum=1, defaultValue=0,ratio=1)
        self.sliderX.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderX.setVisible(False)
        self.sliderY = SimpleHorizontalSliderLabel(label = "y = ", minimum=0, maximum=1, defaultValue=0,ratio=1)
        self.sliderY.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderY.setVisible(False)
        self.sliderZ = SimpleHorizontalSliderLabel(label = "z = ", minimum=0, maximum=1, defaultValue=0,ratio=1)
        self.sliderZ.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.radioButtonX = qt.QRadioButton("X")
        self.radioButtonX.setFixedWidth(40)
        self.radioButtonY = qt.QRadioButton("Y")
        self.radioButtonY.setFixedWidth(40)
        self.radioButtonZ = qt.QRadioButton("Z")
        self.radioButtonZ.setFixedWidth(40)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.sliderX,0,0)
        self.layout.addWidget(self.sliderY,0,0)
        self.layout.addWidget(self.sliderZ,0,0)
        self.layout.addWidget(self.radioButtonX,0,1)
        self.layout.addWidget(self.radioButtonY,0,2)
        self.layout.addWidget(self.radioButtonZ,0,3)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)

        self.radioButtonZ.setChecked(True)

        self.radioButtonX.clicked.connect(self.radioButtonPressed)
        self.radioButtonY.clicked.connect(self.radioButtonPressed)
        self.radioButtonZ.clicked.connect(self.radioButtonPressed)

    def radioButtonPressed(self):

        if self.radioButtonX.isChecked():
            self.sliderX.setVisible(True)
            self.sliderY.setVisible(False)
            self.sliderZ.setVisible(False)
        if self.radioButtonY.isChecked():
            self.sliderX.setVisible(False)
            self.sliderY.setVisible(True)
            self.sliderZ.setVisible(False)
        if self.radioButtonZ.isChecked():
            self.sliderX.setVisible(False)
            self.sliderY.setVisible(False)
            self.sliderZ.setVisible(True)

class ThresholdWidget(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.rangeSlider = RangeSlider()
        self.radioButtonFull = qt.QRadioButton("Full")
        self.radioButtonFull.setFixedWidth(90)
        self.radioButtonFull.setChecked(True)
        self.radioButtonBorder = qt.QRadioButton("Border")
        self.radioButtonBorder.setFixedWidth(90)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.rangeSlider,0,0,3,1)
        self.layout.addWidget(self.radioButtonFull,0,1)
        self.layout.addWidget(self.radioButtonBorder,1,1)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self, event):

        self.rangeSlider.setFixedSize(self.width() - 110*ratioScreen,self.height()*100/100)

class ImageViewerWithScrollBar(qt.QWidget):
    def __init__(self,scene,widgetImage = None, parent = None):
        qt.QWidget.__init__(self)

        pageStep = 250
        self.scrollBarChanging = False
        self.imageViewerChanging = False

        self.imageViewer = ImageViewer(scene,widgetImage = widgetImage,parent = parent)

        self.HScrollBar = qt.QScrollBar()
        self.HScrollBar.setOrientation(QtCore.Qt.Horizontal)
        self.HScrollBar.setPageStep(pageStep)
        self.HScrollBar.setRange(0, 0)
        self.HScrollBar.setEnabled(False)

        self.VScrollBar = qt.QScrollBar()
        self.VScrollBar.setOrientation(QtCore.Qt.Vertical)
        self.VScrollBar.setPageStep(pageStep)
        self.VScrollBar.setRange(0, 0)
        self.VScrollBar.setEnabled(False)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.imageViewer, 0, 0, QtCore.Qt.AlignLeft |QtCore.Qt.AlignTop)
        self.layout.addWidget(self.HScrollBar, 1, 0,QtCore.Qt.AlignTop)
        self.layout.addWidget(self.VScrollBar, 0, 1,QtCore.Qt.AlignLeft)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.setSpacing(0)
        self.layout.setSizeConstraint(1)

        self.imageViewer.signalZoomFactorChanged.connect(self.changeScrollBars)
        self.HScrollBar.valueChanged.connect(self.changeImageViewer)
        self.VScrollBar.valueChanged.connect(self.changeImageViewer)

    def resizeEvent(self,event):

        self.HScrollBar.setFixedSize(self.width()-18*ratioScreen,18*ratioScreen)
        self.VScrollBar.setFixedSize(18*ratioScreen,self.height()-18*ratioScreen)
        self.imageViewer.setFixedSize(self.width()-18*ratioScreen,self.height()-18*ratioScreen)

    def changeScrollBars(self):

        if self.imageViewerChanging == False:

            self.scrollBarChanging = True

            if self.imageViewer.image is not None:

                roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
                nbStepX = (self.imageViewer.image[0].getSizeX() - roiSizeX)/(roiSizeX/20)
                if int(nbStepX) == 0:
                    self.HScrollBar.setEnabled(False)
                else:
                    self.HScrollBar.setEnabled(True)
                self.HScrollBar.setRange(0,nbStepX)
                if nbStepX > 0:
                    valueX = int(self.imageViewer.realStartPointX*nbStepX/(self.imageViewer.image[0].getSizeX()-roiSizeX))
                    self.HScrollBar.setValue(valueX)

                nbStepY = (self.imageViewer.image[0].getSizeY() - roiSizeY)/(roiSizeY/20)
                if int(nbStepY) == 0:
                    self.VScrollBar.setEnabled(False)
                else:
                    self.VScrollBar.setEnabled(True)
                self.VScrollBar.setRange(0,nbStepY)
                if nbStepY > 0:
                    valueY = int(self.imageViewer.realStartPointY*nbStepY/(self.imageViewer.image[0].getSizeY()-roiSizeY))
                    self.VScrollBar.setValue(valueY)

            self.scrollBarChanging = False

    def changeImageViewer(self):

        if self.scrollBarChanging == False:

            self.imageViewerChanging = True

            if self.imageViewer.image is not None:

                roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
                nbStepX = self.HScrollBar.maximum()
                if nbStepX != 0:
                    self.imageViewer.realStartPointX = self.HScrollBar.value()*(self.imageViewer.image[0].getSizeX()-roiSizeX)/nbStepX
                nbStepY = self.VScrollBar.maximum()
                if nbStepY != 0:
                    self.imageViewer.realStartPointY = self.VScrollBar.value()*(self.imageViewer.image[0].getSizeY()-roiSizeY)/nbStepY

                self.imageViewer.getRoiImage()

            self.imageViewerChanging = False

class GroupConfirmWidget(qt.QGroupBox):

    def __init__(self):
        qt.QGroupBox.__init__(self)

        self.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.pushButtonApply = qt.QPushButton("Validate")
        self.pushButtonCancel = qt.QPushButton("Cancel")

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.pushButtonApply, 0, 0, QtCore.Qt.AlignRight)
        self.layout.addWidget(self.pushButtonCancel, 0, 1)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(10*ratioScreen, 0, 10*ratioScreen, 0)
        self.layout.setSpacing(10*ratioScreen)
        self.layout.setSizeConstraint(1)

    def resizeEvent(self,event):

        self.pushButtonApply.setFixedSize(80*ratioScreen,self.height())
        self.pushButtonCancel.setFixedSize(80*ratioScreen,self.height())

class InteractiveThresholdResult:

    thresholdMin = 0
    thresholdMax = 0
    thresholdedImg = None
    bValidated = False

class WidgetImage(qt.QDialog):

    def __init__(self,parent = None):
        qt.QDialog.__init__(self)

        self.parent = parent

        self.dictPos = {}
        self.dictPos["Binary"] = 0
        self.dictPos["Label"] = 1
        self.dictPos["Other"] = 0

        self.image = None
        self.mode = "classic"
        self.imageVisualization = None

        self.imageOverlay = None
        self.imageVisualizationOverlay = None

        self.scene = qt.QGraphicsScene()
        self.imageViewerWithScrollArea = ImageViewerWithScrollBar(self.scene,widgetImage = self,parent=parent)
        self.imageViewer = self.imageViewerWithScrollArea.imageViewer
        #self.imageViewer = ImageViewer(self.scene,widgetImage = self,parent=parent)

        self.widgetInfo = WidgetInfo()

        self.sliderAxis = SlidersAxis()
        self.sliderAxis.setVisible(False)

        self.sliderOpacity = SimpleHorizontalSliderLabel(label="Overlay opacity = ", minimum=0, maximum=100, defaultValue=0, ratio=100)
        self.sliderOpacity.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.sliderOpacity.slider.setValue(50)
        self.sliderOpacity.setVisible(False)

        self.thresholWidget = ThresholdWidget()
        self.rangeSlider = self.thresholWidget.rangeSlider
        self.thresholWidget.setVisible(False)

        self.groupConfirmWidget = GroupConfirmWidget()
        self.results = InteractiveThresholdResult

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.imageViewerWithScrollArea,0,0)
        self.layout.addWidget(self.widgetInfo,1,0)
        self.layout.addWidget(self.sliderAxis, 2, 0)
        self.layout.addWidget(self.sliderOpacity, 3, 0)
        self.layout.addWidget(self.thresholWidget, 3, 0)
        self.layout.addWidget(self.groupConfirmWidget,4,0,Qt.AlignRight)

        self.setLayout(self.layout)

        self.layout.setContentsMargins(0,0,0,5)
        self.layout.setHorizontalSpacing(0)
        self.layout.setSizeConstraint(1)

        self.sliderAxis.radioButtonX.clicked.connect(self.axisChanged)
        self.sliderAxis.radioButtonY.clicked.connect(self.axisChanged)
        self.sliderAxis.radioButtonZ.clicked.connect(self.axisChanged)
        self.sliderAxis.sliderX.slider.valueChanged.connect(self.updateImageViewers)
        self.sliderAxis.sliderY.slider.valueChanged.connect(self.updateImageViewers)
        self.sliderAxis.sliderZ.slider.valueChanged.connect(self.updateImageViewers)

        self.sliderOpacity.slider.valueChanged.connect(self.actualizeScene)
        self.rangeSlider.signalValueChanged.connect(self.actualizeScene)
        self.thresholWidget.radioButtonFull.clicked.connect(self.actualizeScene)
        self.thresholWidget.radioButtonBorder.clicked.connect(self.actualizeScene)

        self.imageViewer.signalZoomFactorChanged.connect(self.changeInfoZoom)
        self.imageViewer.signalMouseMoved.connect(self.changeLabelPosition)

        self.groupConfirmWidget.pushButtonApply.clicked.connect(self.validateResults)
        self.groupConfirmWidget.pushButtonCancel.clicked.connect(self.close)

    def resizeEvent(self, event):

        minValue = self.rangeSlider.currentValueMin
        maxValue = self.rangeSlider.currentValueMax
        self.rangeSlider.setValues(minValue, maxValue)

        heightWidgets = 0
        heightWidgetInfo = 20*ratioScreen
        self.widgetInfo.setFixedSize(self.width() * 100 / 100, heightWidgetInfo)
        heightWidgets += heightWidgetInfo
        if self.sliderAxis.isVisible():
            heightSliderAxis = 15*ratioScreen
            self.sliderAxis.setFixedSize(self.width() * 100 / 100, heightSliderAxis)
            heightWidgets += heightSliderAxis
        if self.mode == "overlay":
            heightSliderOpacity = 15*ratioScreen
            self.sliderOpacity.setFixedSize(self.width() * 100 / 100, heightSliderOpacity)
            heightWidgets += heightSliderOpacity
        if self.mode == "threshold":
            heightSliderThreshold = 53*ratioScreen
            self.thresholWidget.setFixedSize(self.width() * 100 / 100, heightSliderThreshold)
            heightWidgets += heightSliderThreshold
            heightConfirmWidget = 30*ratioScreen
            self.groupConfirmWidget.setFixedSize(self.width() * 50 / 100, heightConfirmWidget)
            heightWidgets += heightConfirmWidget
        self.imageViewerWithScrollArea.setFixedSize(self.width() * 100 / 100 , max(1, self.height() * 100 / 100 - 19*ratioScreen - heightWidgets))

    def actualizeScene(self):

        self.imageViewer.getRoiImage(changeRoiImage=False)

    def setImage(self,image):

        self.image = image
        if self.image != None:
            getMinMaxValue(self.image)
            getLutArray(self.image)
            self.setImageViewer()
            self.infoTypeSize()
            self.changeInfoZoom()
        else:
            self.image = None
            self.imageViewer.setImage(None)

    def changeRangeSlider(self):

        if self.image != None:

            valueMin = self.image.valueMin
            valueMax = self.image.valueMax
            if valueMin == round(valueMin):
                valueMin = round(valueMin)
            if valueMax == round(valueMax):
                valueMax = round(valueMax)

            self.rangeSlider.setMinMaxValues(valueMin,valueMax)
            self.rangeSlider.setValues(self.rangeSlider.currentValueMin,self.rangeSlider.currentValueMax)

            image = self.image
            if image.getSizeC() != 1:
                image = colorIP.lightnessImg(image)

            histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(valueMin,valueMax,max(1, int((valueMax - valueMin) / 1000)))
            try:
                if image.getSizeZ() == 1:
                    histogramMsr2dResult = glbmsr.histogramMsr2d(image, histogramMsrParams)
                else:
                    histogramMsr2dResult = glbmsr.histogramMsr3d(image, histogramMsrParams)
                frequencies = histogramMsr2dResult.frequencies
                self.thresholWidget.rangeSlider.groupSlider.getHistogram(frequencies)
            except:
                pass

    def setImageOverlay(self,imageOverlay,changeSlider=True):

        self.imageOverlay = imageOverlay
        if self.imageOverlay is not None:
            getMinMaxValue(self.imageOverlay)
            getLutArray(self.imageOverlay)

        if changeSlider:
            self.changeRangeSlider()
        self.setImageViewerOverlay()
        self.imageViewer.getRoiImage()

    def updateImageViewers(self):

        self.setImageViewer()
        self.setImageViewerOverlay()

    def setImageViewer(self):

        self.imageViewer.allowResize = False
        self.imageVisualization = None
        if self.image is not None:
            if self.image.getSizeZ() > 1:
                self.imageVisualization = self.getImageVisualization(self.image)
            else:
                self.sliderAxis.setVisible(False)
                self.imageVisualization = self.image

            self.imageVisualization = getMultiResolutionImage(self.imageVisualization)

        self.imageViewer.setImage(self.imageVisualization)
        self.imageViewer.allowResize = True

    def setImageViewerOverlay(self):

        self.imageVisualizationOverlay = None
        if self.imageOverlay is not None:
            if self.imageOverlay.getSizeZ() > 1:
                self.imageVisualizationOverlay = self.getImageVisualization(self.imageOverlay)
            else:
                self.imageVisualizationOverlay = self.imageOverlay

            self.imageVisualizationOverlay = getMultiResolutionImage(self.imageVisualizationOverlay)

        self.imageViewer.setImageOverlay(self.imageVisualizationOverlay)

    def changeMode(self,mode):

        self.mode = mode
        if mode == "classic":
            self.sliderOpacity.setVisible(False)
            self.thresholWidget.setVisible(False)
            self.groupConfirmWidget.setVisible(False)
        elif mode == "overlay":
            self.sliderOpacity.setVisible(True)
            self.thresholWidget.setVisible(False)
            self.groupConfirmWidget.setVisible(False)
        elif mode == "threshold":
            self.sliderOpacity.setVisible(False)
            self.thresholWidget.setVisible(True)
            self.groupConfirmWidget.setVisible(True)

        if self.image is not None:
            self.changeRangeSlider()
        self.resizeEvent(None)
        self.imageViewer.getRoiImage(changeRoiImage=False)

    def changeInfoZoom(self):

        if self.imageViewer.image != None:
            roiSizeX, roiSizeY = self.imageViewer.getRoiSize()
            usefulSizeX, usefulSizeY = self.imageViewer.getUsefulSizeScene()

            ratio = (roiSizeX/usefulSizeX + roiSizeY/usefulSizeY) / 2
            zoom = 1 / ratio
            self.imageViewer.currentZoom = zoom
            zoom = round(zoom*10000)/100

            self.widgetInfo.labelZoom.setText("Zoom : " + str(zoom) + " %")

    def changeLabelPosition(self,posX,posY):

        if self.image is not None and self.imageVisualization is not None:

            posX = int(posX)
            posY = int(posY)

            if posX >= 0 and posX < self.imageVisualization[0].getSizeX() and posY >= 0 and posY < self.imageVisualization[0].getSizeY():

                if self.image.getSizeZ() == 1:
                    text = "x=" + str(int(posX)) + ", y=" + str(int(posY))
                else:
                    if self.sliderAxis.radioButtonX.isChecked():
                        text = "x=" + str(self.sliderAxis.sliderX.slider.value()) + ", y=" + str(int(posX)) + ", z=" + str(int(posY))
                    if self.sliderAxis.radioButtonY.isChecked():
                        text = "x=" + str(int(posX)) + ", y=" + str(self.sliderAxis.sliderY.slider.value()) + ", z=" + str(int(posY))
                    if self.sliderAxis.radioButtonZ.isChecked():
                        text = "x=" + str(int(posX)) + ", y=" + str(int(posY)) + ", z=" + str(self.sliderAxis.sliderZ.slider.value())

                if self.imageVisualization[0].getBufferType() in [PyIPSDK.eImageBufferType.eIBT_Label8, PyIPSDK.eImageBufferType.eIBT_Label16 ,PyIPSDK.eImageBufferType.eIBT_Label32]:
                    text += ", " + "label" + " = "
                else:
                    text += ", " + "value" + " = "

                try:
                    if self.imageVisualization[0].getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
                        if self.imageVisualization[0].array[posY][posX] == 0:
                            text += "False"
                        else:
                            text += "True"
                    else:
                        if self.imageVisualization[0].getSizeC() == 1:
                            if self.imageVisualization[0].getSizeX() == self.imageVisualization[0].array.shape[1] and self.imageVisualization[0].getSizeY() == self.imageVisualization[0].array.shape[0]:
                                text += str(self.imageVisualization[0].array[posY][posX])
                            else:
                                text += str(self.imageVisualization[0].array[0][posY][posX])
                        if self.imageVisualization[0].getSizeC() == 3:
                            text += "( " + str(self.imageVisualization[0].array[0][posY][posX]) + ", " + str(self.imageVisualization[0].array[1][posY][posX]) + ", " + str(self.imageVisualization[0].array[2][posY][posX]) + " )"
                except Exception as e:
                    print(e)
                
                if self.mode == "overlay":
                    try:
                        text += " overlay = "
                        if self.imageVisualizationOverlay[0].getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
                            if self.imageVisualizationOverlay[0].array[posY][posX] == 0:
                                text += "False"
                            else:
                                text += "True"
                        else:
                            if self.imageVisualizationOverlay[0].getSizeC() == 1:
                                if self.imageVisualizationOverlay[0].getSizeX() == self.imageVisualizationOverlay[0].array.shape[1] and self.imageVisualizationOverlay[0].getSizeY() == self.imageVisualizationOverlay[0].array.shape[0]:
                                    text += str(self.imageVisualizationOverlay[0].array[posY][posX])
                                else:
                                    text += str(self.imageVisualizationOverlay[0].array[0][posY][posX])
                            if self.imageVisualizationOverlay[0].getSizeC() == 3:
                                text += "( " + str(self.imageVisualizationOverlay[0].array[0][posY][posX]) + ", " + str(self.imageVisualizationOverlay[0].array[1][posY][posX]) + ", " + str(self.imageVisualizationOverlay[0].array[2][posY][posX]) + " )"
                    except:
                        pass
            else:
                text = ""

            self.widgetInfo.labelPosition.setText(text)

    def infoTypeSize(self):

        text = ""
        if self.image.getSizeZ() == 1:
            text += "2D "
        else:
            text += "3D "
        if self.image.getSizeT() > 1:
            text += "Sequence "
        if self.image.getSizeC() == 1:
            text += "Grey "
        else:
            text += "Color "
        text += str(self.image.getSizeX()) + " x " + str(self.image.getSizeY())
        if self.image.getSizeZ() > 1:
            text += " x "+str(self.image.getSizeZ())
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Binary:
            text += " Binary"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int8:
            text += " Int8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt8:
            text += " UInt8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int16:
            text += " Int16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt16:
            text += " UInt16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Int32:
            text += " Int32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_UInt32:
            text += " UInt32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label8:
            text += " Label8"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label16:
            text += " Label16"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Label32:
            text += " Label32"
        if self.image.getBufferType() == PyIPSDK.eImageBufferType.eIBT_Real32:
            text += " Real32"

        self.widgetInfo.labelTypeSize.setText(text)

    def axisChanged(self):

        self.imageViewer.resetZoom()
        self.setImageViewer()

    def getImageVisualization(self,image):

        self.sliderAxis.setVisible(True)
        self.sliderAxis.sliderX.slider.setMaximum(image.getSizeX()-1)
        self.sliderAxis.sliderY.slider.setMaximum(image.getSizeY()-1)
        self.sliderAxis.sliderZ.slider.setMaximum(image.getSizeZ()-1)
        self.resizeEvent(None)

        if self.sliderAxis.radioButtonX.isChecked():
            value = self.sliderAxis.sliderX.slider.value()
            if image.getSizeC() == 1:
                planArray = np.ascontiguousarray(image.array[:, :, value])
                geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())
            else:
                planArray = np.ascontiguousarray(image.array[:, :, :, value])
                geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeY(), image.getSizeZ())

        if self.sliderAxis.radioButtonY.isChecked():
            value = self.sliderAxis.sliderY.slider.value()
            if image.getSizeC() == 1:
                planArray = np.ascontiguousarray(image.array[:, value, :])
                geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())
            else:
                planArray = np.ascontiguousarray(image.array[:, :, value,:])
                geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeX(), image.getSizeZ())

        if self.sliderAxis.radioButtonZ.isChecked():
            value = self.sliderAxis.sliderZ.slider.value()
            if image.getSizeC() == 1:
                planArray = np.ascontiguousarray(image.array[value, :, :])
                geometry = PyIPSDK.geometry2d(image.getBufferType(), image.getSizeX(), image.getSizeY())
            else:
                planArray = np.ascontiguousarray(image.array[:, value, :, :])
                geometry = PyIPSDK.geometryRgb2d(image.getBufferType(), image.getSizeX(), image.getSizeY())

        imageVisualization = PyIPSDK.fromArray(planArray, geometry)

        return imageVisualization

    def transformImage(self,image,imageOverlay):

        try:

            if self.mode in ["classic","overlay"]:
                outImage = imageToDisplay(image, self.image)
                if self.mode == "overlay":
                    outImageOverlay = imageToDisplay(imageOverlay,self.imageOverlay)
                    if self.imageOverlay.getBufferType() in bufferList:
                        refImage = imageOverlay
                    else:
                        refImage = None
                    outImage = customBlending(outImageOverlay,outImage,self.sliderOpacity.slider.value() / 100,refImage=refImage)
            if self.mode == "threshold":

                if self.imageOverlay is None:
                    if self.image.valueMax - self.image.valueMin != 0:
                        outImage = util.convertImg(image, PyIPSDK.eIBT_Real32)
                        outImage = arithm.addScalarImg(outImage, -self.image.valueMin)
                        outImage = arithm.multiplyScalarImg(outImage, 255 / (self.image.valueMax - self.image.valueMin))
                    else:
                        outImage = util.copyImg(image)
                else:
                    if self.imageOverlay.valueMax - self.imageOverlay.valueMin != 0:
                        outImage = util.convertImg(imageOverlay, PyIPSDK.eIBT_Real32)
                        outImage = arithm.addScalarImg(outImage, -self.imageOverlay.valueMin)
                        outImage = arithm.multiplyScalarImg(outImage, 255 / (self.imageOverlay.valueMax - self.imageOverlay.valueMin))
                    else:
                        outImage = util.copyImg(imageOverlay)
                outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)

                imageThreshold = util.copyImg(image)
                if imageThreshold.getSizeC() == 3:
                    imageThreshold = colorIP.lightnessImg(imageThreshold)
                imageThreshold = bin.thresholdImg(imageThreshold, self.rangeSlider.currentValueMin, self.rangeSlider.currentValueMax)
                if self.thresholWidget.radioButtonBorder.isChecked():
                    inSE = PyIPSDK.circularSEXYInfo(2)
                    maskErode = morpho.erode2dImg(imageThreshold, inSE)
                    imageThreshold = arithm.subtractImgImg(imageThreshold, maskErode)
                    imageThreshold = util.convertImg(imageThreshold, PyIPSDK.eIBT_Binary)
                imageOverlay = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, imageThreshold.getSizeX(), imageThreshold.getSizeY())
                redPlan = util.convertImg(imageThreshold, PyIPSDK.eIBT_UInt8)
                redPlan = arithm.multiplyScalarImg(redPlan,200)
                redPlan = util.convertImg(redPlan, PyIPSDK.eIBT_UInt8)
                redPlanOverlay = PyIPSDK.extractPlan(0, 0, 0, imageOverlay)
                util.copyImg(redPlan,redPlanOverlay)

                outImage = customBlending(imageOverlay, outImage,1, refImage=imageThreshold)

        except:
            outImage = image

        return outImage

    def validateResults(self):

        self.results.bValidated = True
        self.close()

    def closeEvent(self,event):

        if self.mode == "threshold":
            self.results.thresholdMin = self.rangeSlider.currentValueMin
            self.results.thresholdMax = self.rangeSlider.currentValueMax
            self.results.thresholdedImg = bin.thresholdImg(self.image,self.results.thresholdMin,self.results.thresholdMax)

bufferList = [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32,PyIPSDK.eIBT_Binary]

def getLutArray(image):

    random.seed(2)
    if image.getSizeC() != 1:
        image = colorIP.lightnessImg(image)
    image.lut = {}
    if image.getSizeZ() == 1:
        nbLabels = glbmsr.statsMsr2d(image).max
    else:
        nbLabels = glbmsr.statsMsr3d(image).max
    lutArray = []
    lutArray.append([0])
    lutArray.append([0])
    lutArray.append([0])
    for c in range(3):
        for i in range(1, int(nbLabels) + 1):
            lutArray[c].append(random.randint(50, 200))

        image.lut[c] = PyIPSDK.createIntensityLUT(0, 1, lutArray[c])

def customBlending(imageOverlay, image,value,refImage = None):
    #Return image if the label image is 0 and the blending of both images otherwise.
    if image.getSizeC() == 1 and imageOverlay.getSizeC() == 1:
        if refImage is not None:
            outImage = arithm.formula2dImg("if (I3 == 0, I2, I1*" + str(value) + " + I2*" + str(1-value) + ")", InOptImg1=imageOverlay,InOptImg2=image,InOptImg3=refImage)
        else:
            outImage = arithm.blendImgImg(imageOverlay, image, value)

    else:
        outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())

        if image.getSizeC() == 1 and imageOverlay.getSizeC() == 3:
            image = greyToColor(image)
        if image.getSizeC() == 3 and imageOverlay.getSizeC() == 1:
            imageOverlay = greyToColor(imageOverlay)

        if refImage is not None:
            refImage = util.convertImg(refImage, PyIPSDK.eIBT_UInt8)
        for c in range(0, 3):
            planOverlay = PyIPSDK.extractPlan(0, c, 0, imageOverlay)
            plan = PyIPSDK.extractPlan(0, c, 0, image)
            if refImage is not None:
                resultPlan = arithm.formula2dImg("if (I3 == 0, I2, I1*" + str(value) + " + I2*" + str(1-value) + ")", InOptImg1=planOverlay,InOptImg2=plan,InOptImg3=refImage)
            else:
                resultPlan = arithm.blendImgImg(planOverlay, plan, value)
            resultPlan = util.convertImg(resultPlan, PyIPSDK.eIBT_UInt8)
            outPlan = PyIPSDK.extractPlan(0, c, 0, outImage)
            util.copyImg(resultPlan, outPlan)

    return outImage

def greyToColor(imageProcess, bufferType = PyIPSDK.eImageBufferType.eIBT_UInt8):
    outImage = PyIPSDK.createImageRgb(bufferType, imageProcess.getSizeX(), imageProcess.getSizeY())

    for c in range(0, 3):
        plan = PyIPSDK.extractPlan(0, c, 0, outImage)
        util.copyImg(imageProcess, plan)

    return outImage

def getMultiResolutionImage(image,minimumSize = 2000):

    interp = PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour
    # if image.getBufferType() not in bufferList:
    #     interp = PyIPSDK.eZoomInterpolationMethod.eZIM_Linear

    multiresImage = {}
    multiresImage[0] = image
    i = 0
    while multiresImage[i].getSizeX() > minimumSize and multiresImage[i].getSizeY() > minimumSize:
        newImage = gtrans.zoom2dImg(multiresImage[i],0.5,0.5, interp)
        i+=1
        multiresImage[i] = newImage

    multiresImage["maxZoom"] = i

    return multiresImage

def getMinMaxValue(image):

    mask = bin.thresholdImg(image,0,0)
    mask = logic.logicalNotImg(mask)

    if image.getSizeZ() == 1 and image.getSizeC() == 1:
        imageMeasures = glbmsr.statsMsr2d(image)
        valueMin = imageMeasures.min
        valueMax = imageMeasures.max
        imageMeasuresMasked = glbmsr.statsMaskMsr2d(image,mask)
        valueMinMask = imageMeasuresMasked.min
    else:
        planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr2d(image)
        planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)
        planIndexedStatsMsrResultMasked = glbmsr.multiSlice_statsMaskMsr2d(image,mask)
        planIndexedStatsMsrResultDictMasked = PyIPSDK.toPyDict(planIndexedStatsMsrResultMasked)
        valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]
        valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]
        valueMinMask = planIndexedStatsMsrResultDictMasked[(0, 0, 0)]["Min"]
        for z in range(image.getSizeZ()):
            for c in range(image.getSizeC()):
                valueMin = min(valueMin, planIndexedStatsMsrResultDict[(z, c, 0)]["Min"])
                valueMax = max(valueMax, planIndexedStatsMsrResultDict[(z, c, 0)]["Max"])
                valueMinMask = max(valueMinMask, planIndexedStatsMsrResultDictMasked[(z, c, 0)]["Max"])

    image.valueMin = valueMin
    image.valueMax = valueMax
    image.valueMinMask = valueMinMask

def imageToDisplay(image,ref):

    if image.getBufferType() == PyIPSDK.eIBT_Binary:
        outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
        util.eraseImg(outImage,0)
        plan = PyIPSDK.extractPlan(0, 2, 0, outImage)
        inPlan = util.convertImg(image, PyIPSDK.eImageBufferType.eIBT_UInt8)
        inPlan = arithm.multiplyScalarImg(inPlan,200)
        inPlan = util.convertImg(inPlan, PyIPSDK.eImageBufferType.eIBT_UInt8)
        util.copyImg(inPlan, plan)

    elif image.getBufferType() in [PyIPSDK.eIBT_Label8,PyIPSDK.eIBT_Label16,PyIPSDK.eIBT_Label32]:
        outImage = PyIPSDK.createImageRgb(PyIPSDK.eImageBufferType.eIBT_UInt8, image.getSizeX(), image.getSizeY())
        util.eraseImg(outImage,0)
        for c in range(0, 3):
            plan = PyIPSDK.extractPlan(0, c, 0, outImage)
            lutImage = itrans.lutTransform2dImg(image, ref.lut[c])
            lutImage = util.convertImg(lutImage, PyIPSDK.eImageBufferType.eIBT_UInt8)
            util.copyImg(lutImage, plan)
    else:
        if ref.valueMax - ref.valueMin != 0:
            outImage = util.convertImg(image, PyIPSDK.eIBT_Real32)
            outImage = arithm.addScalarImg(outImage, -ref.valueMin)
            outImage = arithm.multiplyScalarImg(outImage, 255 / (ref.valueMax - ref.valueMin))
        else:
            outImage = util.copyImg(image)
        outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)

    return outImage

ipsdkWidgets = []

def displayImg(image,title = None, overlayImage = None, pause = True):

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    widgetImage = WidgetImage()
    widgetImage.setImage(image)
    if overlayImage is not None:
        widgetImage.setImageOverlay(overlayImage)
        widgetImage.changeMode("overlay")
    else:
        widgetImage.changeMode("classic")

    if title is None:
        title = "Untitled"
    widgetImage.setWindowTitle(title)

    widgetImage.resize(800*ratioScreen, 800*ratioScreen)
    widgetImage.show()
    widgetImage.resizeEvent(None)

    if pause:
        app.exec_()

    ipsdkWidgets.append(widgetImage)
    ipsdkWidgets.append(app)

def interactiveThreshold(image,minValue=None,maxValue=None,title = None,thresholdImg = None):

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    widgetImage = WidgetImage()

    widgetImage.results.bValidated = False

    widgetImage.setImage(image)
    if thresholdImg is not None:
        widgetImage.setImageOverlay(thresholdImg,changeSlider=False)
    widgetImage.changeMode("threshold")

    if title is None:
        title = "Untitled"
    widgetImage.setWindowTitle(title)

    widgetImage.setWindowModality(QtCore.Qt.ApplicationModal)

    widgetImage.resize(800*ratioScreen,800*ratioScreen)

    widgetImage.resizeEvent(None)

    if minValue is None:
        minValue = widgetImage.rangeSlider.currentValueMin
    else:
        widgetImage.rangeSlider.currentValueMin = minValue
    if maxValue is None:
        maxValue = widgetImage.rangeSlider.currentValueMax
    else:
        widgetImage.rangeSlider.currentValueMax = maxValue

    widgetImage.rangeSlider.setValues(minValue,maxValue)

    widgetImage.show()
    widgetImage.resizeEvent(None)
    widgetImage.exec()

    ipsdkWidgets.append(widgetImage)

    return widgetImage.results



### Obsolete machine learning functions (use IPSDKFunctionsMachineLearning now)

def getQApplication():

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    return app

def computeFeaturesClassification(image,imageGrey,xmlElement):

    colorList = ["Red", "Green", "Blue"]

    dimension = xmlElement.get("Dimension")

    measures = xmlInfosetToMeasure(xmlElement, imageGrey, image, dimension=dimension)
    features = []
    listNamesFeatures = []
    allMeasures = measureIterator(xmlElement)
    for callName,userName in allMeasures:
        try:
            valuesInfosetColl = measures.getMeasure(callName).getMeasureResult()
            nbColorPlan = valuesInfosetColl.getNbColorPlans()

            for colorPlan in range(nbColorPlan):
                features.append(valuesInfosetColl.getColl(colorPlan))
                if nbColorPlan == 1:
                    listNamesFeatures.append(userName)
                elif nbColorPlan == 3:
                    listNamesFeatures.append(userName + " (" + colorList[colorPlan] + ")")
                else:
                    listNamesFeatures.append(userName + " (Channel " + str(colorPlan) + ")")
        except:
            pass

    print (listNamesFeatures)

    features = np.asarray(features)

    return features

def xmlToInfoset(xmlAllMeasures, infoSetName, dimension='2D',calibration = None,process=False,addBarycenter = True):
    text = ''
    if dimension == '2D':
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d()\n'
    else:
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d()\n'

    measures = []

    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Arithmetic':
                    prefix = "Custom_A_"
                    function = 'shapeanalysis.createArithmeticFormulaMsrParams'
                elif child2.tag == 'Logic':
                    prefix = "Custom_L_"
                    function = 'shapeanalysis.createLogicFormulaMsrParams'
                for measureNode in childIterator(child2, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        name = prefix + childText(measureNode, 'UserName')
                        objElement = SubElement(measureNode, "Object")
                        paramInfoSetCustom = ['"' + name + '"', '"' + childText(objElement, 'Name') + '"']
                        shortNames = []
                        for child2 in objElement:
                            # Add the variable to the infoSet
                            if child2.tag == "Variables":
                                for var in child2:
                                    shortName = childText(var, 'ShortName')
                                    shortNames.append(shortName)
                                    realName = name + "_" + shortName
                                    paramInfoSet = ['"' + realName + '"']
                                    fillParamInfoSet(SubElement(var, 'Measure'), paramInfoSet)
                                    text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                                    measures.append(paramInfoSetToString(paramInfoSet))
                        shortFormula = childText(objElement, "Formula")
                        completeFormula = shortToCompleteFormula(shortFormula, shortNames, name)
                        paramInfoSetCustom.append(function + '("' + completeFormula + '")')
                        text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSetCustom) + ')\n'
        else:
            # Classic measures
            for measureNode in childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    paramInfoSet = []
                    fillParamInfoSet(measureNode, paramInfoSet)
                    text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                    measures.append(paramInfoSetToString(paramInfoSet))

    return text

def paramInfoSetToString(paramInfoSet):
    text = ''
    for info in paramInfoSet:
        text += info + ', '
    return text[:-2]

def fillParamInfoSet(measureNode, paramInfoSet):

    objElement = SubElement(measureNode, "Object")
    paramInfoSet.append('"' + childText(objElement, 'Name') + '"')
    for child2 in objElement:
        if child2.tag == "Parameters":
            valueText = ""
            fonction = None
            for param in child2:
                fonction = childText(param, 'Name')
                type = childText(param, 'Type')
                value = None

                try:
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        value = valueParam
                except:
                    pass

                if type == "Boolean":
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        value = (False, True)[valueParam == 'True']
                elif type == "Enumerate":
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        try:
                            value = dictConversion[valueParam]['IPSDK']
                        except:
                            value = valueParam
                if value is None:
                    SubElement(param, 'Value').text = str(childText(param, 'Default'))
                    if type == "Boolean":
                        valueParam = childText(param, 'Value')
                        if valueParam == '':
                            value = None
                        else:
                            value = (False, True)[valueParam == 'True']
                    elif type == "Enumerate":
                        valueParam = childText(param, 'Value')
                        if valueParam == '':
                            value = None
                        else:
                            try:
                                value = dictConversion[valueParam]['IPSDK']
                            except:
                                value = valueParam
                valueText+=str(value)+","
            valueText = valueText[:-1]
            if fonction in ['HistogramMostPopulatedGLMsrParams','HistogramPopulationMaxMsrParams']:
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] == "None" or valueTextSplit[2] == "None":
                    valueText = valueTextSplit[0]
            if fonction == "HistogramQuantileMsrParams":
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] == "None" or valueTextSplit[2] == "None":
                    valueText = valueTextSplit[0] + "," + valueTextSplit[3]
            paramIPSDK = dictConversion[fonction]['IPSDK'] + '(' + valueText + ')'
            paramInfoSet.append(paramIPSDK)


maskSplit = [' ', '/', '+', '-', '*', '(', ')', '&', '|', '>', '<', '[', ']', '=', '%',',']
def shortToCompleteFormula(shortFormula, shortNames, prefix):
    shortFormula = shortFormula.replace(' ', '')
    completeFormula = ''

    print ('formula')
    print(shortFormula)

    i = 0
    while i < len(shortFormula):
        if shortFormula[i] in maskSplit:
            completeFormula += shortFormula[i]
            var = ''
            while i+1 < len(shortFormula) and shortFormula[i+1] not in maskSplit:
                var += shortFormula[i+1]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var
            i += 1
        elif i == 0:
            var = ''
            while i < len(shortFormula) and shortFormula[i] not in maskSplit:
                var += shortFormula[i]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var

    #print(completeFormula)

    return completeFormula

def xmlInfosetToMeasure(xmlElement,greyImage, labelImage, dimension="3D",intensity = False):

    text = ""
    if dimension == "2D":
        text += "calibration = PyIPSDK.createGeometricCalibration2d(1,1,'px')\n"
        if intensity == False:
            text += xmlToInfoset(xmlElement, 'inMeasureInfoSet2d', '2D', 'calibration', addBarycenter=False)
        else:
            text += xmlToInfosetIntensity(xmlElement, 'inMeasureInfoSet2d', '2D', 'calibration')
        text += 'outMeasure = shapeanalysis.labelAnalysis2d(greyImage,labelImage,inMeasureInfoSet2d)\n'
    else:
        text += "calibration = PyIPSDK.createGeometricCalibration3d(1,1,1,'px')\n"
        if intensity == False:
            text += xmlToInfoset(xmlElement, 'inMeasureInfoSet3d', '3D', 'calibration', addBarycenter=False)
        else:
            text += xmlToInfosetIntensity(xmlElement, 'inMeasureInfoSet3d', '3D', 'calibration')
        text += 'outMeasure = shapeanalysis.labelAnalysis3d(greyImage,labelImage,inMeasureInfoSet3d)\n'

    _locals = locals()
    exec(text, globals(), _locals)
    outMeasure = _locals['outMeasure']

    return outMeasure

def measureIterator(xmlAllMeasures):
    # iterator through all checked measures
    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Arithmetic':
                    prefix = "Custom_A_"
                elif child2.tag == 'Logic':
                    prefix = "Custom_L_"
                for measureNode in childIterator(child2, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        ipsdkCallName = prefix + childText(measureNode, 'UserName')
                        userName = childText(measureNode, 'UserName')
                        yield ipsdkCallName, userName
        else:
            # Classic measures
            for measureNode in childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    ipsdkCallName = childText(SubElement(measureNode, "Object"), 'Name')
                    userName = childText(measureNode, 'UserName')
                    yield ipsdkCallName, userName

# def measureIteratorByType(xmlAllMeasures,type):
#     # iterator through all checked measures
#     for child in xmlAllMeasures:
#         if child.tag == type:
#             for measureNode in childIterator(child, 'Measure'):
#                 if measureNode.get('CheckState') == '2':
#                     ipsdkCallName = childText(SubElement(measureNode, "Object"), 'Name')
#                     userName = childText(measureNode, 'UserName')
#                     yield ipsdkCallName, userName

def correctArrayValues(array):

    if array is not None:
        array = np.nan_to_num(array)
        array[array>10**100] = 0
        array[array<-10**100] = 0

    return array

def applySmartClassification(labelImage,greyImage,modelName):

    file = xmlet.parse(modelName + "/Model_Infoset.mho")
    xmlElement = file.getroot()
    if greyImage is not None:
        features = computeFeaturesClassification(labelImage,greyImage,xmlElement)
    else:
        features = computeFeaturesClassification(labelImage,labelImage,xmlElement)

    model = joblib.load(modelName + "/Model")

    featuresToPredict = correctArrayValues(features.T)
    featurePrediction = model.predict(featuresToPredict)
    featurePrediction[0] = 0

    lut = PyIPSDK.createIntensityLUT(0, 1, featurePrediction)
    outImage = itrans.lutTransform2dImg(labelImage, lut)

    return outImage

def applySuperPixelSegmentation(image,modelName):

    file = xmlet.parse(modelName + "/Settings.mho")
    xmlElement = file.getroot()

    model = joblib.load(modelName + "/Model")

    outImage = computeSuperPixelSegmentation(image,xmlElement,model)

    return outImage

def computeSuperPixelSegmentation(image,xmlElement,model):

    settingsSuperPixelsElement = SubElement(xmlElement, "SettingsSuperPixels")

    try:
        modelDimension = childText(settingsSuperPixelsElement, "ModelDimension")
        if modelDimension is None or modelDimension == "":
            modelDimension = "2D"
    except:
        modelDimension = "2D"

    try:
        size = int(childText(settingsSuperPixelsElement, "Size"))
    except:
        size = 10
    try:
        compactness = float(childText(settingsSuperPixelsElement, "Compactness"))
    except:
        compactness = 0.5

    nbIter = 3

    try:
        sizeRatio = int(childText(settingsSuperPixelsElement, "SizeRatio"))
    except:
        sizeRatio = 0.5

    if modelDimension == "2D":
        imageSuperPixels = advmorpho.superPixels2dImg(image, size, compactness, nbIter, sizeRatio, PyIPSDK.eSPT_Size)
    else:
        imageSuperPixels = advmorpho.superVoxels3dImg(image, size, compactness, nbIter, sizeRatio, PyIPSDK.eSPT_Size)


    if image.getSizeZ() == 1 or modelDimension == "3D":
        outImage = applyFeaturesSuperPixels(image,imageSuperPixels,xmlElement,model,modelDimension=modelDimension)
    else:
        labelClassElement = SubElement(xmlElement, "LabelClasses")
        nbClasses = int(childText(labelClassElement, "NumberLabels"))

        if nbClasses > 2:
            outImage = PyIPSDK.createImage(PyIPSDK.eIBT_Label8, image.getSizeX(), image.getSizeY(), image.getSizeZ())
        else:
            outImage = PyIPSDK.createImage(PyIPSDK.eIBT_Binary, image.getSizeX(), image.getSizeY(), image.getSizeZ())
        for z in range(image.getSizeZ()):
            if image.getSizeC() > 1:
                plan = PyIPSDK.extractColor(z, 0, image)
            else:
                plan = PyIPSDK.extractPlan(z, 0, 0, image)
            plan = util.copyImg(plan)
            planSuperPixels = PyIPSDK.extractPlan(z, 0, 0, imageSuperPixels)
            planSuperPixels = util.copyImg(planSuperPixels)
            outPlan = applyFeaturesSuperPixels(plan, planSuperPixels, xmlElement, model)
            planOutImage = PyIPSDK.extractPlan(z, 0, 0, outImage)
            util.copyImg(outPlan,planOutImage)

    writeSmartSegmentationImage(outImage,None,settingsElement=xmlElement)

    return outImage

def applyFeaturesSuperPixels(image,imageSuperPixels,xmlElement,model,modelDimension = "2D"):

    featuresElement = SubElement(xmlElement, "Features")
    listFeatures = []
    if modelDimension == "2D":
        inMeasureInfoSet = PyIPSDK.createMeasureInfoSet2d()
    else:
        inMeasureInfoSet = PyIPSDK.createMeasureInfoSet3d()

    if childText(featuresElement, "NbPixels") == "True":
        if modelDimension == "2D":
            PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels2dMsr")
            listFeatures.append(["NbPixels2dMsr", "Nb Pixels"])
        else:
            PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels3dMsr")
            listFeatures.append(["NbPixels3dMsr", "Nb Pixels"])
    if childText(featuresElement, "SizeX") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeXMsr")
        listFeatures.append(["BoundingBoxSizeXMsr", "Size X"])
    if childText(featuresElement, "SizeY") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeYMsr")
        listFeatures.append(["BoundingBoxSizeYMsr", "Size Y"])
    if childText(featuresElement, "SizeZ") == "True" and modelDimension == "3D":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeZMsr")
        listFeatures.append(["BoundingBoxSizeZMsr", "Size Z"])
    if childText(featuresElement, "Minimum") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MinMsr")
        listFeatures.append(["MinMsr", "Minimum"])
    if childText(featuresElement, "Maximum") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MaxMsr")
        listFeatures.append(["MaxMsr", "Maximum"])
    if childText(featuresElement, "Mean") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MeanMsr")
        listFeatures.append(["MeanMsr", "Mean"])
    if childText(featuresElement, "Median") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MedianMsr")
        listFeatures.append(["MedianMsr", "Median"])
    if childText(featuresElement, "Variance") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "VarianceMsr")
        listFeatures.append(["VarianceMsr", "Variance"])
    if childText(featuresElement, "Energy") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "EnergyMsr")
        listFeatures.append(["EnergyMsr", "Energy"])
    if childText(featuresElement, "Entropy") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "EntropyMsr")
        listFeatures.append(["EntropyMsr", "Entropy"])
    if childText(featuresElement, "Kurtosis") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "KurtosisMsr")
        listFeatures.append(["KurtosisMsr", "Kurtosis"])
    if childText(featuresElement, "Skewness") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "SkewnessMsr")
        listFeatures.append(["SkewnessMsr", "Skewness"])
    if childText(featuresElement, "Histogram") == "True":

        if childText(featuresElement, "NbPixels") != "True":
            if modelDimension == "2D":
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels2dMsr")
            else:
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels3dMsr")
        minValue = float(childText(featuresElement, "HistogramMin"))
        maxValue = float(childText(featuresElement, "HistogramMax"))
        nbClassesValue = int(childText(featuresElement, "HistogramNbClasses"))

        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "HistogramMsr", shapeanalysis.createHistogramMsrParamsNbClasses(nbClassesValue, minValue, maxValue))
        listFeatures.append(["HistogramMsr", "Histogram"])

    if modelDimension == "2D":
        analysis = shapeanalysis.labelAnalysis2d(image, imageSuperPixels, inMeasureInfoSet)
    else:
        analysis = shapeanalysis.labelAnalysis3d(image, imageSuperPixels, inMeasureInfoSet)
    nbColorPlan = image.getSizeC()

    features = []
    offset = 0

    for feature in listFeatures:
        if feature[0] in ["NbPixels2dMsr","NbPixels3dMsr", "BoundingBoxSizeXMsr", "BoundingBoxSizeYMsr","BoundingBoxSizeZMsr"]:
            values = analysis.getMeasure(feature[0]).getMeasureResult().getColl(0)
            features.append(values)
            offset += 1
        elif feature[0] != "HistogramMsr":
            for c in range(nbColorPlan):
                values = analysis.getMeasure(feature[0]).getMeasureResult().getColl(c)
                features.append(values)
                offset += 1

        else:
            nbClasses = len(PyIPSDK.toPyDict(analysis.getMeasure("HistogramMsr").getMeasureResult().getColl(0)[1])["Frequencies"])
            if modelDimension == "2D":
                valuesNbPixels = analysis.getMeasure("NbPixels2dMsr").getMeasureResult().getColl(0)
            else:
                valuesNbPixels = analysis.getMeasure("NbPixels3dMsr").getMeasureResult().getColl(0)
            for _ in range(nbClasses * nbColorPlan):
                features.append([0])
            for c in range(nbColorPlan):
                valuesHistogram = analysis.getMeasure("HistogramMsr").getMeasureResult().getColl(c)
                for numLabel in range(len(valuesHistogram)):
                    valueHisto = valuesHistogram[numLabel]
                    nbPixels = valuesNbPixels[numLabel]
                    if valueHisto is not None:
                        frequencies = PyIPSDK.toPyDict(valueHisto)["Frequencies"]
                        for clss in range(nbClasses):
                            features[offset + clss + c * nbClasses].append(frequencies[clss] / nbPixels)

    features = np.asarray(features)

    dataToPredict = features.T

    dataToPredict = np.nan_to_num(dataToPredict)
    dataToPredict[dataToPredict > 10 ** 100] = 0
    dataToPredict[dataToPredict < -10 ** 100] = 0

    vectorPrediction = model.predict(dataToPredict)

    lut = PyIPSDK.createIntensityLUT(0, 1, vectorPrediction)
    outImage = itrans.lutTransform2dImg(imageSuperPixels, lut)

    labelClassElement = SubElement(xmlElement, "LabelClasses")
    nbClasses = int(childText(labelClassElement,"NumberLabels"))

    if nbClasses > 2:
        outImage = util.convertImg(outImage,PyIPSDK.eIBT_Label8)
    else:
        outImage = util.convertImg(outImage,PyIPSDK.eIBT_Binary)

    return outImage

def writeSmartSegmentationImage(image,modelName,settingsElement=None,offset=0):

    try:
        if settingsElement is None:
            filename = modelName + "/Settings.mho"
            file = xmlet.parse(filename)
            settingsElement = file.getroot()

        labelClassElement = SubElement(settingsElement,"LabelClasses")

        text = "LabelSmartSegmentation:"

        for i in range(len(labelClassElement)-1):

            element = SubElement(labelClassElement,"Label_"+str(i))

            valueLabel = childText(element,"Value")
            if valueLabel is not None:
                valueLabel = int(valueLabel)
            else:
                valueLabel = i

            name = childText(element,"Name")
            # color = childText(element,"Color")

            colorRef = childText(element,"Color")
            colorSplit = colorRef.split(",")
            color = ""
            for j in range(len(colorSplit)):
                color += str(int(float(colorSplit[j])*0.7))
                if j != len(colorSplit)-1:
                    color += ","

            if i != len(labelClassElement)-2:
                text += str(valueLabel+offset) + ">" + "Name=" + name + "|" + "Color="+color + "_"
            else:
                text += str(valueLabel+offset) + ">" + "Name=" + name + "|" + "Color="+color

        text += "!"

        print(text)

        image.setUserPropertiesStr(text)

    except:

        import traceback
        traceback.print_exc(file=sys.stderr)

def writeSmartClassification(image,modelName,settingsElement=None):

    writeSmartSegmentationImage(image, modelName, settingsElement=settingsElement, offset=1)

def readSmartSegmentation(image):

    ddict = {}

    text = image.getUserPropertiesStr()

    if text != "" and text != None:
        split1 = text.split("!")
        for text1 in split1:
            split2 = text1.split(":")
            if split2[0] == "LabelSmartSegmentation":
                text2 = split2[1]
                split3 = text2.split("_")
                for text3 in split3:
                    split4 = text3.split(">")
                    num = int(split4[0])
                    ddict[num] = {}
                    text4 = split4[1]
                    split5 = text4.split("|")
                    for text5 in split5:
                        split6 = text5.split("=")
                        ddict[num][split6[0]]=split6[1]

    return ddict

