import os
import sys

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLColor as colorIP
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho


import numpy as np
import joblib
import random
import math
import xml.etree.ElementTree as xmlet

# import DatabaseFunction as Dfct
# import XMLtoInfoSet as xml2IS

try:
    from PyQt5.QtWidgets import QApplication
    app = QApplication(sys.argv)
    screen = app.screens()[0]
    physicalSize = screen.physicalSize()
    availableSize = screen.size()

    pixelSizeRef = 0.248
    pixelSize = ((physicalSize.width()/availableSize.width())+(physicalSize.height()/availableSize.height()))/2

    ratioScreen = pixelSizeRef/pixelSize
except:
    ratioScreen = 1

dictConversion = {}

# eWatershedSeparationMode
dictConversion['eSAT_Default'] = {}
dictConversion['eSAT_Default']['UserName'] = 'Default'
dictConversion['eSAT_Default']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Default'

dictConversion['eSAT_Smooth'] = {}
dictConversion['eSAT_Smooth']['UserName'] = 'Smooth'
dictConversion['eSAT_Smooth']['IPSDK'] = 'PyIPSDK.eSkeletonAlgoType.eSAT_Smooth'

# eWatershedSeparationMode
dictConversion['eWSM_Split_Binary'] = {}
dictConversion['eWSM_Split_Binary']['UserName'] = 'Split binary'
dictConversion['eWSM_Split_Binary']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Split'

dictConversion['eWSM_Split_Label'] = {}
dictConversion['eWSM_Split_Label']['UserName'] = 'Split label'
dictConversion['eWSM_Split_Label']['IPSDK'] = "Split_Label"

dictConversion['eWSM_Lines'] = {}
dictConversion['eWSM_Lines']['UserName'] = 'Lines'
dictConversion['eWSM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Lines'

dictConversion['eWSM_Basins'] = {}
dictConversion['eWSM_Basins']['UserName'] = 'Basins'
dictConversion['eWSM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedSeparationMode.eWSM_Basins'

# eWatershedOutputMode
dictConversion['eWOM_Lines'] = {}
dictConversion['eWOM_Lines']['UserName'] = 'Lines'
dictConversion['eWOM_Lines']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Lines'

dictConversion['eWOM_Basins'] = {}
dictConversion['eWOM_Basins']['UserName'] = 'Bassins'
dictConversion['eWOM_Basins']['IPSDK'] = 'PyIPSDK.eWatershedOutputMode.eWOM_Basins'

# eShapeGreyscaleType
dictConversion['eSGT_Dark'] = {}
dictConversion['eSGT_Dark']['UserName'] = 'Dark'
dictConversion['eSGT_Dark']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Dark'

dictConversion['eSGT_Light'] = {}
dictConversion['eSGT_Light']['UserName'] = 'Light'
dictConversion['eSGT_Light']['IPSDK'] = 'PyIPSDK.eShapeGreyscaleType.eSGT_Light'


# eNeighborhood2dType
dictConversion['eN2T_8Connexity'] = {}
dictConversion['eN2T_8Connexity']['UserName'] = 'Connexity 8'
dictConversion['eN2T_8Connexity']['IPSDK'] = 'PyIPSDK.eNeighborhood2dType.eN2T_8Connexity'

dictConversion['eN2T_4Connexity'] = {}
dictConversion['eN2T_4Connexity']['UserName'] = 'Connexity 4'
dictConversion['eN2T_4Connexity']['IPSDK'] = "PyIPSDK.eNeighborhood2dType.eN2T_4Connexity"

# eNeighborhood3dType
dictConversion['eN3T_6Connexity'] = {'UserName': 'Connexity 6', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_6Connexity'}
dictConversion['eN3T_18Connexity'] = {'UserName': 'Connexity 18', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_18Connexity'}
dictConversion['eN3T_26Connexity'] = {'UserName': 'Connexity 26', 'IPSDK': 'PyIPSDK.eNeighborhood3dType.eN3T_26Connexity'}

# eProcessingOptimizationPolicy
dictConversion['ePOP_MinimizeMemory'] = {}
dictConversion['ePOP_MinimizeMemory']['UserName'] = 'Minimiser Mémoire'
dictConversion['ePOP_MinimizeMemory']['IPSDK'] = 'PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory'

dictConversion['ePOP_MaximizeSpeed'] = {}
dictConversion['ePOP_MaximizeSpeed']['UserName'] = 'Maximiser Vitesse'
dictConversion['ePOP_MaximizeSpeed']['IPSDK'] = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"

# eZoomInterpolationMethod
dictConversion['eZIM_NearestNeighbour'] = {}
dictConversion['eZIM_NearestNeighbour']['UserName'] = 'Nearest Neighbour'
dictConversion['eZIM_NearestNeighbour']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour'

dictConversion['eZIM_Linear'] = {}
dictConversion['eZIM_Linear']['UserName'] = 'Linear'
dictConversion['eZIM_Linear']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Linear'

dictConversion['eZIM_Cubic'] = {}
dictConversion['eZIM_Cubic']['UserName'] = 'Cubic'
dictConversion['eZIM_Cubic']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_Cubic'

dictConversion['eZIM_VolumeWeightedMean'] = {}
dictConversion['eZIM_VolumeWeightedMean']['UserName'] = 'Volume Weighted Mean'
dictConversion['eZIM_VolumeWeightedMean']['IPSDK'] = 'PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean'

# eImageBufferType
dictConversion['eIBT_None'] = {}
dictConversion['eIBT_None']['UserName'] = 'Empty buffer type'
dictConversion['eIBT_None']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_None'

dictConversion['eIBT_Int8'] = {}
dictConversion['eIBT_Int8']['UserName'] = 'Int 8'
dictConversion['eIBT_Int8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int8'

dictConversion['eIBT_UInt8'] = {}
dictConversion['eIBT_UInt8']['UserName'] = 'UInt 8'
dictConversion['eIBT_UInt8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt8'

dictConversion['eIBT_Int16'] = {}
dictConversion['eIBT_Int16']['UserName'] = 'Int 16'
dictConversion['eIBT_Int16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int16'

dictConversion['eIBT_UInt16'] = {}
dictConversion['eIBT_UInt16']['UserName'] = 'UInt 16'
dictConversion['eIBT_UInt16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt16'

dictConversion['eIBT_Int32'] = {}
dictConversion['eIBT_Int32']['UserName'] = 'Int 32'
dictConversion['eIBT_Int32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Int32'

dictConversion['eIBT_UInt32'] = {}
dictConversion['eIBT_UInt32']['UserName'] = 'Uint 32'
dictConversion['eIBT_UInt32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_UInt32'

dictConversion['eIBT_Real32'] = {}
dictConversion['eIBT_Real32']['UserName'] = 'Float 32'
dictConversion['eIBT_Real32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Real32'

dictConversion['eIBT_Binary'] = {}
dictConversion['eIBT_Binary']['UserName'] = 'Binary'
dictConversion['eIBT_Binary']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Binary'

dictConversion['eIBT_Label8'] = {}
dictConversion['eIBT_Label8']['UserName'] = 'Label on 8 bits'
dictConversion['eIBT_Label8']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label8'

dictConversion['eIBT_Label16'] = {}
dictConversion['eIBT_Label16']['UserName'] = 'Label on 16 bits'
dictConversion['eIBT_Label16']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label16'

dictConversion['eIBT_Label32'] = {}
dictConversion['eIBT_Label32']['UserName'] = 'Label on 32 bits'
dictConversion['eIBT_Label32']['IPSDK'] = 'PyIPSDK.eImageBufferType.eIBT_Label32'


# eFrequencyBandPassFilterType
dictConversion['eFBPFT_Gaussian'] = {}
dictConversion['eFBPFT_Gaussian']['UserName'] = 'Gaussian'
dictConversion['eFBPFT_Gaussian']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_Gaussian'

dictConversion['eFBPFT_LogGabor'] = {}
dictConversion['eFBPFT_LogGabor']['UserName'] = 'Log Gabor'
dictConversion['eFBPFT_LogGabor']['IPSDK'] = 'PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_LogGabor'

# eProjStatType
dictConversion['ePST_Max'] = {}
dictConversion['ePST_Max']['UserName'] = 'Max'
dictConversion['ePST_Max']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Max'

dictConversion['ePST_Mean'] = {}
dictConversion['ePST_Mean']['UserName'] = 'Mean'
dictConversion['ePST_Mean']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Mean'

dictConversion['ePST_Median'] = {}
dictConversion['ePST_Median']['UserName'] = 'Median'
dictConversion['ePST_Median']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Median'

dictConversion['ePST_Min'] = {}
dictConversion['ePST_Min']['UserName'] = 'Min'
dictConversion['ePST_Min']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Min'

dictConversion['ePST_StdDev'] = {}
dictConversion['ePST_StdDev']['UserName'] = 'Standard Deviation'
dictConversion['ePST_StdDev']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_StdDev'

dictConversion['ePST_Sum'] = {}
dictConversion['ePST_Sum']['UserName'] = 'Sum'
dictConversion['ePST_Sum']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Sum'

dictConversion['ePST_Variance'] = {}
dictConversion['ePST_Variance']['UserName'] = 'Variance'
dictConversion['ePST_Variance']['IPSDK'] = 'PyIPSDK.eProjStatType.ePST_Variance'

# eSobelKernelType
dictConversion['eSKT_ScharrHalfKnlSz1'] = {}
dictConversion['eSKT_ScharrHalfKnlSz1']['UserName'] = 'Scharr 3'
dictConversion['eSKT_ScharrHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz1'] = {}
dictConversion['eSKT_SobelHalfKnlSz1']['UserName'] = 'Sobel 3'
dictConversion['eSKT_SobelHalfKnlSz1']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1'

dictConversion['eSKT_SobelHalfKnlSz2'] = {}
dictConversion['eSKT_SobelHalfKnlSz2']['UserName'] = 'Sobel 5'
dictConversion['eSKT_SobelHalfKnlSz2']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2'

dictConversion['eSKT_SobelHalfKnlSz3'] = {}
dictConversion['eSKT_SobelHalfKnlSz3']['UserName'] = 'Sobel 7'
dictConversion['eSKT_SobelHalfKnlSz3']['IPSDK'] = 'PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3'

# eLocalExtremumType
dictConversion['eLET_Max'] = {}
dictConversion['eLET_Max']['UserName'] = 'Maximum'
dictConversion['eLET_Max']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Max'

dictConversion['eLET_Min'] = {}
dictConversion['eLET_Min']['UserName'] = 'Minimum'
dictConversion['eLET_Min']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_Min'

dictConversion['eLET_StrictMax'] = {}
dictConversion['eLET_StrictMax']['UserName'] = 'Maximum without plateau'
dictConversion['eLET_StrictMax']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMax'

dictConversion['eLET_StrictMin'] = {}
dictConversion['eLET_StrictMin']['UserName'] = 'Minimum without plateau'
dictConversion['eLET_StrictMin']['IPSDK'] = 'PyIPSDK.eLocalExtremumType.eLET_StrictMin'

#Fourier Transform
dictConversion['eDFTC_Cartesian'] = {}
dictConversion['eDFTC_Cartesian']['UserName'] = 'Cartesian'
dictConversion['eDFTC_Cartesian']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Cartesian'

dictConversion['eDFTC_Polar'] = {}
dictConversion['eDFTC_Polar']['UserName'] = 'Polar'
dictConversion['eDFTC_Polar']['IPSDK'] = 'PyIPSDK.eDFTCoordinates.eDFTC_Polar'

dictConversion['eDFTQP_Centered'] = {}
dictConversion['eDFTQP_Centered']['UserName'] = 'Centered'
dictConversion['eDFTQP_Centered']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered'

dictConversion['eDFTQP_Native'] = {}
dictConversion['eDFTQP_Native']['UserName'] = 'Native'
dictConversion['eDFTQP_Native']['IPSDK'] = 'PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native'

# Statistical match
dictConversion['eMinMax'] = {}
dictConversion['eMinMax']['UserName'] = 'Min and Max'
dictConversion['eMinMax']['IPSDK'] = 'PyIPSDK.eMinMax'

dictConversion['eMeanStdDev'] = {}
dictConversion['eMeanStdDev']['UserName'] = 'Mean and Standard deviation'
dictConversion['eMeanStdDev']['IPSDK'] = 'PyIPSDK.eMeanStdDev'

dictConversion['eHistogram'] = {}
dictConversion['eHistogram']['UserName'] = 'Histogram'
dictConversion['eHistogram']['IPSDK'] = 'PyIPSDK.eHistogram'

# eColorGeometryType
dictConversion['eCGT_Grey'] = {'UserName': 'Grey', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Grey'}
dictConversion['eCGT_Rgb'] = {'UserName': 'RGB', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgb'}
dictConversion['eCGT_Rgba'] = {'UserName': 'RGBa', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_Rgba'}
dictConversion['eCGT_XYZ'] = {'UserName': 'XYZ', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_XYZ'}
dictConversion['eCGT_YPbPr'] = {'UserName': 'YPbPr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YPbPr'}
dictConversion['eCGT_YCbCr'] = {'UserName': 'YCbCr', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_YCbCr'}
dictConversion['eCGT_CieLab'] = {'UserName': 'CieLab', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLab'}
dictConversion['eCGT_CieLuv'] = {'UserName': 'CieLuv', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_CieLuv'}
dictConversion['eCGT_HLS'] = {'UserName': 'HLS', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HLS'}
dictConversion['eCGT_HSV'] = {'UserName': 'HSV', 'IPSDK': 'PyIPSDK.eColorGeometryType.eCGT_HSV'}

dictConversion['eRSP_Min'] = {}
dictConversion['eRSP_Min']['UserName'] = 'Min'
dictConversion['eRSP_Min']['IPSDK'] = 'shapeanalysis.eRSP_Min'

dictConversion['eRSP_Max'] = {}
dictConversion['eRSP_Max']['UserName'] = 'Max'
dictConversion['eRSP_Max']['IPSDK'] = 'shapeanalysis.eRSP_Max'

dictConversion['eSCP_SegCenter'] = {}
dictConversion['eSCP_SegCenter']['UserName'] = 'Center'
dictConversion['eSCP_SegCenter']['IPSDK'] = 'PyIPSDK.eSCP_SegCenter'

dictConversion['eSCP_SegEnds'] = {}
dictConversion['eSCP_SegEnds']['UserName'] = 'End'
dictConversion['eSCP_SegEnds']['IPSDK'] = 'PyIPSDK.eSCP_SegEnds'

dictConversion['eSCP_SegClosestPoint'] = {}
dictConversion['eSCP_SegClosestPoint']['UserName'] = 'Closest Point'
dictConversion['eSCP_SegClosestPoint']['IPSDK'] = 'PyIPSDK.eSCP_SegClosestPoint'

dictConversion['eSHP_Ignored'] = {}
dictConversion['eSHP_Ignored']['UserName'] = 'Ignored'
dictConversion['eSHP_Ignored']['IPSDK'] = 'PyIPSDK.eSHP_Ignored'

dictConversion['eSHP_ExtractedButNotAnalyzed'] = {}
dictConversion['eSHP_ExtractedButNotAnalyzed']['UserName'] = 'Extracted but not analysed'
dictConversion['eSHP_ExtractedButNotAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedButNotAnalyzed'

dictConversion['eSHP_ExtractedAndAnalyzed'] = {}
dictConversion['eSHP_ExtractedAndAnalyzed']['UserName'] = 'Extracted and analysed'
dictConversion['eSHP_ExtractedAndAnalyzed']['IPSDK'] = 'PyIPSDK.eSHP_ExtractedAndAnalyzed'

dictConversion['eSEC_Leaf'] = {}
dictConversion['eSEC_Leaf']['UserName'] = 'Leaf'
dictConversion['eSEC_Leaf']['IPSDK'] = 'PyIPSDK.eSEC_Leaf'

dictConversion['eSEC_Branch'] = {}
dictConversion['eSEC_Branch']['UserName'] = 'Branch'
dictConversion['eSEC_Branch']['IPSDK'] = 'PyIPSDK.eSEC_Branch'

dictConversion['eSEC_All'] = {}
dictConversion['eSEC_All']['UserName'] = 'All'
dictConversion['eSEC_All']['IPSDK'] = 'PyIPSDK.eSEC_All'

dictConversion['eSVC_Internal'] = {}
dictConversion['eSVC_Internal']['UserName'] = 'Internal'
dictConversion['eSVC_Internal']['IPSDK'] = 'PyIPSDK.eSVC_Internal'

dictConversion['eSVC_Junction'] = {}
dictConversion['eSVC_Junction']['UserName'] = 'Junction'
dictConversion['eSVC_Junction']['IPSDK'] = 'PyIPSDK.eSVC_Junction'

dictConversion['eSVC_Slab'] = {}
dictConversion['eSVC_Slab']['UserName'] = 'Slab'
dictConversion['eSVC_Slab']['IPSDK'] = 'PyIPSDK.eSVC_Slab'

dictConversion['eSVC_EndPoint'] = {}
dictConversion['eSVC_EndPoint']['UserName'] = 'End Point'
dictConversion['eSVC_EndPoint']['IPSDK'] = 'PyIPSDK.eSVC_EndPoint'

dictConversion['eSVC_All'] = {}
dictConversion['eSVC_All']['UserName'] = 'All'
dictConversion['eSVC_All']['IPSDK'] = 'PyIPSDK.eSVC_All'

#######################
# Info Set Parameters #
#######################

dictConversion['ProcessHoles'] = {}
dictConversion['ProcessHoles']['UserName'] = 'Process Holes'
dictConversion['ProcessHoles']['IPSDK'] = 'shapeanalysis.createHolesBasicPolicyMsrParams'

dictConversion['NbOrientations'] = {}
dictConversion['NbOrientations']['UserName'] = 'Number of orientation?'
dictConversion['NbOrientations']['IPSDK'] = 'shapeanalysis.createAspectRatioMsrParams'

dictConversion['Orientation2D'] = {}
dictConversion['Orientation2D']['UserName'] = 'Orientation'
dictConversion['Orientation2D']['IPSDK'] = 'shapeanalysis.createFeretDiameter2dMsrParams'

dictConversion['Orientation3D'] = {}
dictConversion['Orientation3D']['UserName'] = ['Phi','Theta']
dictConversion['Orientation3D']['IPSDK'] = 'shapeanalysis.createFeretDiameter3dMsrParams'

dictConversion['OutlineSlopeAngularity2dMsrParams'] = {}
dictConversion['OutlineSlopeAngularity2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['OutlineSlopeAngularity2dMsrParams']['IPSDK'] = 'shapeanalysis.createOutlineSlopeAngularity2dMsrParams'

dictConversion['MaxFeretDiameterMsrParams'] = {}
dictConversion['MaxFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretDiameterMsrParams'

dictConversion['MaxFeretOrientation2dMsrParams'] = {}
dictConversion['MaxFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientation2dMsrParams'

dictConversion['MeanFeretDiameterMsrParams'] = {}
dictConversion['MeanFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MeanFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMeanFeretDiameterMsrParams'

dictConversion['MinFeretDiameterMsrParams'] = {}
dictConversion['MinFeretDiameterMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretDiameterMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretDiameterMsrParams'

dictConversion['MinFeretOrientation2dMsrParams'] = {}
dictConversion['MinFeretOrientation2dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientation2dMsrParams'

dictConversion['MaxFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MaxFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationPhi3dMsrParams'

dictConversion['MaxFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MaxFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MaxFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMaxFeretOrientationTheta3dMsrParams'

dictConversion['MinFeretOrientationPhi3dMsrParams'] = {}
dictConversion['MinFeretOrientationPhi3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationPhi3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationPhi3dMsrParams'

dictConversion['MinFeretOrientationTheta3dMsrParams'] = {}
dictConversion['MinFeretOrientationTheta3dMsrParams']['UserName'] = 'Number of orientation'
dictConversion['MinFeretOrientationTheta3dMsrParams']['IPSDK'] = 'shapeanalysis.createMinFeretOrientationTheta3dMsrParams'

for extremum in ["Min","Max"]:
    for num in ["0","1"]:
        for letter in ["X","Y","Z"]:
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams'] = {}
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['UserName'] = 'Number of orientation'
            dictConversion[extremum+'FeretPt'+num+letter+'MsrParams']['IPSDK'] = 'shapeanalysis.create'+extremum+'FeretPt'+num+letter+'MsrParams'


dictConversion['OrientedExtentMsrParams'] = {}
dictConversion['OrientedExtentMsrParams']['UserName'] = ['Process Holes','Number of orientation']
dictConversion['OrientedExtentMsrParams']['IPSDK'] = 'shapeanalysis.createOrientedExtentMsrParams'

dictConversion['RelativeSizeMsrParams'] = {}
dictConversion['RelativeSizeMsrParams']['UserName'] = ['Process Holes','Size Policy']
dictConversion['RelativeSizeMsrParams']['IPSDK'] = 'shapeanalysis.createRelativeSizeMsrParams'

dictConversion['Roughness2dMsrParams'] = {}
dictConversion['Roughness2dMsrParams']['UserName'] = ['Process Holes','Max Distance']
dictConversion['Roughness2dMsrParams']['IPSDK'] = 'shapeanalysis.createRoughness2dMsrParams'

dictConversion['LengthOfContact2dMsrParams'] = {}
dictConversion['LengthOfContact2dMsrParams']['UserName'] = ['Contact distance','Segment contact Policy','Process Holes']
dictConversion['LengthOfContact2dMsrParams']['IPSDK'] = 'shapeanalysis.createLengthOfContact2dMsrParams'

dictConversion['NeighborsDistanceMsrParams'] = {}
dictConversion['NeighborsDistanceMsrParams']['UserName'] = ['Max distance','Process Holes']
dictConversion['NeighborsDistanceMsrParams']['IPSDK'] = 'shapeanalysis.createNeighborsDistanceMsrParams'

dictConversion['SurfaceOfContact3dMsrParams'] = {}
dictConversion['SurfaceOfContact3dMsrParams']['UserName'] = ['Contact distance','Process Holes']
dictConversion['SurfaceOfContact3dMsrParams']['IPSDK'] = 'shapeanalysis.createSurfaceOfContact3dMsrParams'

dictConversion['OBBCenterXMsrParams'] = {}
dictConversion['OBBCenterXMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterXMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterXMsrParams'

dictConversion['OBBCenterYMsrParams'] = {}
dictConversion['OBBCenterYMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterYMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterYMsrParams'

dictConversion['OBBCenterZMsrParams'] = {}
dictConversion['OBBCenterZMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBCenterZMsrParams']['IPSDK'] = 'shapeanalysis.createOBBCenterZMsrParams'

dictConversion['OBBWidthMsrParams'] = {}
dictConversion['OBBWidthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBWidthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBWidthMsrParams'

dictConversion['OBBLengthMsrParams'] = {}
dictConversion['OBBLengthMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBLengthMsrParams']['IPSDK'] = 'shapeanalysis.createOBBLengthMsrParams'

dictConversion['OBBHeightMsrParams'] = {}
dictConversion['OBBHeightMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBHeightMsrParams']['IPSDK'] = 'shapeanalysis.createOBBHeightMsrParams'

dictConversion['OBBOrientation2dMsrParams'] = {}
dictConversion['OBBOrientation2dMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientation2dMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientation2dMsrParams'

dictConversion['OBBOrientationAlphaMsrParams'] = {}
dictConversion['OBBOrientationAlphaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationAlphaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationAlphaMsrParams'

dictConversion['OBBOrientationBetaMsrParams'] = {}
dictConversion['OBBOrientationBetaMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationBetaMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationBetaMsrParams'

dictConversion['OBBOrientationChiMsrParams'] = {}
dictConversion['OBBOrientationChiMsrParams']['UserName'] = 'Orientation'
dictConversion['OBBOrientationChiMsrParams']['IPSDK'] = 'shapeanalysis.createOBBOrientationChiMsrParams'

dictConversion['Skeleton2dDiameterLengthMsrParams'] = {}
dictConversion['Skeleton2dDiameterLengthMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterLengthMsrParams'

dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams'] = {}
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterMeanCurvatureMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterMeanCurvatureMsrParams'

dictConversion['Skeleton2dDiameterTortuosityMsrParams'] = {}
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dDiameterTortuosityMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dDiameterTortuosityMsrParams'

dictConversion['Skeleton2dLengthMsrParams'] = {}
dictConversion['Skeleton2dLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dLengthMsrParams'

dictConversion['Skeleton2dMaxThicknessMsrParams'] = {}
dictConversion['Skeleton2dMaxThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMaxThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMaxThicknessMsrParams'

dictConversion['Skeleton2dMeanEdgeLengthMsrParams'] = {}
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['UserName'] = ['Holes Policy','Edge Catagory']
dictConversion['Skeleton2dMeanEdgeLengthMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanEdgeLengthMsrParams'

dictConversion['Skeleton2dMeanThicknessMsrParams'] = {}
dictConversion['Skeleton2dMeanThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMeanThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMeanThicknessMsrParams'

dictConversion['Skeleton2dMinThicknessMsrParams'] = {}
dictConversion['Skeleton2dMinThicknessMsrParams']['UserName'] = 'Holes Policy'
dictConversion['Skeleton2dMinThicknessMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dMinThicknessMsrParams'

dictConversion['Skeleton2dNbVertexMsrParams'] = {}
dictConversion['Skeleton2dNbVertexMsrParams']['UserName'] = ['Holes Policy','Vertex Catagory']
dictConversion['Skeleton2dNbVertexMsrParams']['IPSDK'] = 'shapeanalysis.createSkeleton2dNbVertexMsrParams'

dictConversion['HistogramMostPopulatedGLMsrParams'] = {}
dictConversion['HistogramMostPopulatedGLMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramMostPopulatedGLMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramMostPopulatedGLMsrParamsBinWidth'

dictConversion['HistogramPopulationMaxMsrParams'] = {}
dictConversion['HistogramPopulationMaxMsrParams']['UserName'] = ['Bin','Min','Max']
dictConversion['HistogramPopulationMaxMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramPopulationMaxMsrParamsBinWidth'

dictConversion['HistogramQuantileMsrParams'] = {}
dictConversion['HistogramQuantileMsrParams']['UserName'] = ['Bin','Min','Max','Quantile']
dictConversion['HistogramQuantileMsrParams']['IPSDK'] = 'shapeanalysis.createHistogramQuantileMsrParamsBinWidth'

def SubElement(element,text):

    toReturn=None
    for child in element:
        if child.tag==text:
            toReturn=child
    if toReturn is None:
        toReturn = xmlet.SubElement(element, text)
    return toReturn

def childIterator(xmlNode, tag):
    for child in xmlNode:
        if child.tag == tag:
            yield child
        else:
            for subChild in childIterator(child, tag):
                yield subChild

def convertTextToAscii(text):

    newText = ''
    if text != None:
        for char in text:
            newText += str(ord(char)) + '.'

        if newText != '':
            newText = newText[:-1]

    return newText

def convertTextFromAscii(text):

    newText = ''
    if text != '' and text != None:
        textSplit = text.split('.')
        for number in textSplit:
            char = chr(int(number))
            newText += char

    return newText

def childText(element,tag):

    text=None
    if element != None:
        for child in element:
            if child.tag==tag:
                text=child.text
                try:
                    if child.get('ASCII') == str(True):
                        text = convertTextFromAscii(text)
                except:
                    pass
    return text

def numberCalibration(value,numberMeaningful=3):

    if float(value) > 0:
        value = float(value) + 0.000001
    elif float(value) < 0:
        value = float(value) - 0.000001
    else:
        value = float(value)

    textValue = str(value)

    if "e-" in textValue:
        try:
            nbZeros = int(textValue.split("e-")[1])
            mainNumber = textValue.split("e-")[0]
            if mainNumber[0] == "-":
                outValue = "-0."
                mainNumber = mainNumber[1:]
            else:
                outValue = "0."
            for i in range(nbZeros-1):
                outValue += "0"

            for i in range(4):
                try:
                    if mainNumber[i] != ".":
                        outValue+=mainNumber[i]
                except:
                    pass

            while len(outValue)>numberMeaningful and outValue[len(outValue)-1]=="0":
                outValue = outValue[:-1]

        except:
            outValue = "0"

    else:

        numberAdded = 0
        firstValue = False
        hasPoint = False
        newValue = ""
        for caracter in textValue:
            if caracter not in ["0",".","-"]:
                firstValue = True
                numberAdded+=1
            else:
                if caracter == "0" and firstValue:
                    numberAdded+=1
            if caracter == ".":
                hasPoint = True
            if caracter != "." or numberAdded < numberMeaningful:
                newValue+=caracter
            if numberAdded >= numberMeaningful and hasPoint:
                break

        if hasPoint:
            hasValue = False
            outValue = ""
            hasPoint = "." in newValue
            for i in range(len(newValue)-1,-1,-1):
                if newValue[i] not in ["0","."] or hasValue or hasPoint == False:
                    outValue = newValue[i] + outValue
                    hasValue = True
                if newValue[i] == ".":
                    hasValue = True
        else:
            outValue = newValue

    return outValue

def getQApplication():

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    return app

def computeFeaturesClassification(image,imageGrey,xmlElement):

    colorList = ["Red", "Green", "Blue"]

    dimension = xmlElement.get("Dimension")

    measures = xmlInfosetToMeasure(xmlElement, imageGrey, image, dimension=dimension)
    features = []
    listNamesFeatures = []
    allMeasures = measureIterator(xmlElement)
    for callName,userName in allMeasures:
        try:
            valuesInfosetColl = measures.getMeasure(callName).getMeasureResult()
            nbColorPlan = valuesInfosetColl.getNbColorPlans()

            for colorPlan in range(nbColorPlan):
                features.append(valuesInfosetColl.getColl(colorPlan))
                if nbColorPlan == 1:
                    listNamesFeatures.append(userName)
                elif nbColorPlan == 3:
                    listNamesFeatures.append(userName + " (" + colorList[colorPlan] + ")")
                else:
                    listNamesFeatures.append(userName + " (Channel " + str(colorPlan) + ")")
        except:
            pass

    features = np.asarray(features)

    return features

def xmlToInfoset(xmlAllMeasures, infoSetName, dimension='2D',calibration = None,process=False,addBarycenter = True):
    text = ''
    if dimension == '2D':
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d()\n'
    else:
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d()\n'

    measures = []

    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Arithmetic':
                    prefix = "Custom_A_"
                    function = 'shapeanalysis.createArithmeticFormulaMsrParams'
                elif child2.tag == 'Logic':
                    prefix = "Custom_L_"
                    function = 'shapeanalysis.createLogicFormulaMsrParams'
                for measureNode in childIterator(child2, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        name = prefix + childText(measureNode, 'UserName')
                        objElement = SubElement(measureNode, "Object")
                        paramInfoSetCustom = ['"' + name + '"', '"' + childText(objElement, 'Name') + '"']
                        shortNames = []
                        for child2 in objElement:
                            # Add the variable to the infoSet
                            if child2.tag == "Variables":
                                for var in child2:
                                    shortName = childText(var, 'ShortName')
                                    shortNames.append(shortName)
                                    realName = name + "_" + shortName
                                    paramInfoSet = ['"' + realName + '"']
                                    fillParamInfoSet(SubElement(var, 'Measure'), paramInfoSet)
                                    text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                                    measures.append(paramInfoSetToString(paramInfoSet))
                        shortFormula = childText(objElement, "Formula")
                        completeFormula = shortToCompleteFormula(shortFormula, shortNames, name)
                        paramInfoSetCustom.append(function + '("' + completeFormula + '")')
                        text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSetCustom) + ')\n'
        else:
            # Classic measures
            for measureNode in childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    paramInfoSet = []
                    fillParamInfoSet(measureNode, paramInfoSet)
                    text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                    measures.append(paramInfoSetToString(paramInfoSet))

    return text

def paramInfoSetToString(paramInfoSet):
    text = ''
    for info in paramInfoSet:
        text += info + ', '
    return text[:-2]

def fillParamInfoSet(measureNode, paramInfoSet):

    objElement = SubElement(measureNode, "Object")
    paramInfoSet.append('"' + childText(objElement, 'Name') + '"')
    for child2 in objElement:
        if child2.tag == "Parameters":
            valueText = ""
            fonction = None
            for param in child2:
                fonction = childText(param, 'Name')
                type = childText(param, 'Type')
                value = None

                try:
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        value = valueParam
                except:
                    pass

                if type == "Boolean":
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        value = (False, True)[valueParam == 'True']
                elif type == "Enumerate":
                    valueParam = childText(param, 'Value')
                    if valueParam == '':
                        value = None
                    else:
                        try:
                            value = dictConversion[valueParam]['IPSDK']
                        except:
                            value = valueParam
                if value is None:
                    SubElement(param, 'Value').text = str(childText(param, 'Default'))
                    if type == "Boolean":
                        valueParam = childText(param, 'Value')
                        if valueParam == '':
                            value = None
                        else:
                            value = (False, True)[valueParam == 'True']
                    elif type == "Enumerate":
                        valueParam = childText(param, 'Value')
                        if valueParam == '':
                            value = None
                        else:
                            try:
                                value = dictConversion[valueParam]['IPSDK']
                            except:
                                value = valueParam
                valueText+=str(value)+","
            valueText = valueText[:-1]
            if fonction in ['HistogramMostPopulatedGLMsrParams','HistogramPopulationMaxMsrParams']:
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] == "None" or valueTextSplit[2] == "None":
                    valueText = valueTextSplit[0]
            if fonction == "HistogramQuantileMsrParams":
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] == "None" or valueTextSplit[2] == "None":
                    valueText = valueTextSplit[0] + "," + valueTextSplit[3]
            paramIPSDK = dictConversion[fonction]['IPSDK'] + '(' + valueText + ')'
            paramInfoSet.append(paramIPSDK)


maskSplit = [' ', '/', '+', '-', '*', '(', ')', '&', '|', '>', '<', '[', ']', '=', '%',',']
def shortToCompleteFormula(shortFormula, shortNames, prefix):
    shortFormula = shortFormula.replace(' ', '')
    completeFormula = ''

    i = 0
    while i < len(shortFormula):
        if shortFormula[i] in maskSplit:
            completeFormula += shortFormula[i]
            var = ''
            while i+1 < len(shortFormula) and shortFormula[i+1] not in maskSplit:
                var += shortFormula[i+1]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var
            i += 1
        elif i == 0:
            var = ''
            while i < len(shortFormula) and shortFormula[i] not in maskSplit:
                var += shortFormula[i]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var

    return completeFormula

def xmlInfosetToMeasure(xmlElement,greyImage, labelImage, dimension="3D",intensity = False):

    text = ""
    if dimension == "2D":
        text += "calibration = PyIPSDK.createGeometricCalibration2d(1,1,'px')\n"
        if intensity == False:
            text += xmlToInfoset(xmlElement, 'inMeasureInfoSet2d', '2D', 'calibration', addBarycenter=False)
        else:
            text += xmlToInfosetIntensity(xmlElement, 'inMeasureInfoSet2d', '2D', 'calibration')
        text += 'outMeasure = shapeanalysis.labelAnalysis2d(greyImage,labelImage,inMeasureInfoSet2d)\n'
    else:
        text += "calibration = PyIPSDK.createGeometricCalibration3d(1,1,1,'px')\n"
        if intensity == False:
            text += xmlToInfoset(xmlElement, 'inMeasureInfoSet3d', '3D', 'calibration', addBarycenter=False)
        else:
            text += xmlToInfosetIntensity(xmlElement, 'inMeasureInfoSet3d', '3D', 'calibration')
        text += 'outMeasure = shapeanalysis.labelAnalysis3d(greyImage,labelImage,inMeasureInfoSet3d)\n'

    _locals = locals()
    exec(text, globals(), _locals)
    outMeasure = _locals['outMeasure']

    return outMeasure

def measureIterator(xmlAllMeasures):
    # iterator through all checked measures
    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Arithmetic':
                    prefix = "Custom_A_"
                elif child2.tag == 'Logic':
                    prefix = "Custom_L_"
                for measureNode in childIterator(child2, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        ipsdkCallName = prefix + childText(measureNode, 'UserName')
                        userName = childText(measureNode, 'UserName')
                        yield ipsdkCallName, userName
        else:
            # Classic measures
            for measureNode in childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    ipsdkCallName = childText(SubElement(measureNode, "Object"), 'Name')
                    userName = childText(measureNode, 'UserName')
                    yield ipsdkCallName, userName

# def measureIteratorByType(xmlAllMeasures,type):
#     # iterator through all checked measures
#     for child in xmlAllMeasures:
#         if child.tag == type:
#             for measureNode in childIterator(child, 'Measure'):
#                 if measureNode.get('CheckState') == '2':
#                     ipsdkCallName = childText(SubElement(measureNode, "Object"), 'Name')
#                     userName = childText(measureNode, 'UserName')
#                     yield ipsdkCallName, userName

def correctArrayValues(array):

    if array is not None:
        array = np.nan_to_num(array)
        array[array>10**100] = 0
        array[array<-10**100] = 0

    return array

def applySmartClassification(labelImage,greyImage,modelName):

    file = xmlet.parse(modelName + "/Model_Infoset.mho")
    xmlElement = file.getroot()
    if greyImage is not None:
        features = computeFeaturesClassification(labelImage,greyImage,xmlElement)
    else:
        features = computeFeaturesClassification(labelImage,labelImage,xmlElement)

    model = joblib.load(modelName + "/Model")

    featuresToPredict = correctArrayValues(features.T)
    featurePrediction = model.predict(featuresToPredict)
    featurePrediction[0] = 0

    lut = PyIPSDK.createIntensityLUT(0, 1, featurePrediction)
    outImage = itrans.lutTransform2dImg(labelImage, lut)

    return outImage

def applySuperPixelSegmentation(image,modelName):

    file = xmlet.parse(modelName + "/Settings.mho")
    xmlElement = file.getroot()

    model = joblib.load(modelName + "/Model")

    outImage = computeSuperPixelSegmentation(image,xmlElement,model)

    return outImage

def computeSuperPixelSegmentation(image,xmlElement,model):

    settingsSuperPixelsElement = SubElement(xmlElement, "SettingsSuperPixels")

    try:
        modelDimension = childText(settingsSuperPixelsElement, "ModelDimension")
        if modelDimension is None or modelDimension == "":
            modelDimension = "2D"
    except:
        modelDimension = "2D"

    try:
        size = int(childText(settingsSuperPixelsElement, "Size"))
    except:
        size = 10
    try:
        compactness = float(childText(settingsSuperPixelsElement, "Compactness"))
    except:
        compactness = 0.5

    nbIter = 3

    try:
        sizeRatio = int(childText(settingsSuperPixelsElement, "SizeRatio"))
    except:
        sizeRatio = 0.5

    if modelDimension == "2D":
        imageSuperPixels = advmorpho.superPixels2dImg(image, size, compactness, nbIter, sizeRatio, PyIPSDK.eSPT_Size)
    else:
        imageSuperPixels = advmorpho.superVoxels3dImg(image, size, compactness, nbIter, sizeRatio, PyIPSDK.eSPT_Size)


    if image.getSizeZ() == 1 or modelDimension == "3D":
        outImage = applyFeaturesSuperPixels(image,imageSuperPixels,xmlElement,model,modelDimension=modelDimension)
    else:
        labelClassElement = SubElement(xmlElement, "LabelClasses")
        nbClasses = int(childText(labelClassElement, "NumberLabels"))

        if nbClasses > 2:
            outImage = PyIPSDK.createImage(PyIPSDK.eIBT_Label8, image.getSizeX(), image.getSizeY(), image.getSizeZ())
        else:
            outImage = PyIPSDK.createImage(PyIPSDK.eIBT_Binary, image.getSizeX(), image.getSizeY(), image.getSizeZ())
        for z in range(image.getSizeZ()):
            if image.getSizeC() > 1:
                plan = PyIPSDK.extractColor(z, 0, image)
            else:
                plan = PyIPSDK.extractPlan(z, 0, 0, image)
            plan = util.copyImg(plan)
            planSuperPixels = PyIPSDK.extractPlan(z, 0, 0, imageSuperPixels)
            planSuperPixels = util.copyImg(planSuperPixels)
            outPlan = applyFeaturesSuperPixels(plan, planSuperPixels, xmlElement, model)
            planOutImage = PyIPSDK.extractPlan(z, 0, 0, outImage)
            util.copyImg(outPlan,planOutImage)

    writeSmartSegmentationImage(outImage,None,settingsElement=xmlElement)

    return outImage

def applyFeaturesSuperPixels(image,imageSuperPixels,xmlElement,model,modelDimension = "2D"):

    featuresElement = SubElement(xmlElement, "Features")
    listFeatures = []
    if modelDimension == "2D":
        inMeasureInfoSet = PyIPSDK.createMeasureInfoSet2d()
    else:
        inMeasureInfoSet = PyIPSDK.createMeasureInfoSet3d()

    if childText(featuresElement, "NbPixels") == "True":
        if modelDimension == "2D":
            PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels2dMsr")
            listFeatures.append(["NbPixels2dMsr", "Nb Pixels"])
        else:
            PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels3dMsr")
            listFeatures.append(["NbPixels3dMsr", "Nb Pixels"])
    if childText(featuresElement, "SizeX") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeXMsr")
        listFeatures.append(["BoundingBoxSizeXMsr", "Size X"])
    if childText(featuresElement, "SizeY") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeYMsr")
        listFeatures.append(["BoundingBoxSizeYMsr", "Size Y"])
    if childText(featuresElement, "SizeZ") == "True" and modelDimension == "3D":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "BoundingBoxSizeZMsr")
        listFeatures.append(["BoundingBoxSizeZMsr", "Size Z"])
    if childText(featuresElement, "Minimum") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MinMsr")
        listFeatures.append(["MinMsr", "Minimum"])
    if childText(featuresElement, "Maximum") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MaxMsr")
        listFeatures.append(["MaxMsr", "Maximum"])
    if childText(featuresElement, "Mean") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MeanMsr")
        listFeatures.append(["MeanMsr", "Mean"])
    if childText(featuresElement, "Median") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "MedianMsr")
        listFeatures.append(["MedianMsr", "Median"])
    if childText(featuresElement, "Variance") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "VarianceMsr")
        listFeatures.append(["VarianceMsr", "Variance"])
    if childText(featuresElement, "Energy") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "EnergyMsr")
        listFeatures.append(["EnergyMsr", "Energy"])
    if childText(featuresElement, "Entropy") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "EntropyMsr")
        listFeatures.append(["EntropyMsr", "Entropy"])
    if childText(featuresElement, "Kurtosis") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "KurtosisMsr")
        listFeatures.append(["KurtosisMsr", "Kurtosis"])
    if childText(featuresElement, "Skewness") == "True":
        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "SkewnessMsr")
        listFeatures.append(["SkewnessMsr", "Skewness"])
    if childText(featuresElement, "Histogram") == "True":

        if childText(featuresElement, "NbPixels") != "True":
            if modelDimension == "2D":
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels2dMsr")
            else:
                PyIPSDK.createMeasureInfo(inMeasureInfoSet, "NbPixels3dMsr")
        minValue = float(childText(featuresElement, "HistogramMin"))
        maxValue = float(childText(featuresElement, "HistogramMax"))
        nbClassesValue = int(childText(featuresElement, "HistogramNbClasses"))

        PyIPSDK.createMeasureInfo(inMeasureInfoSet, "HistogramMsr", shapeanalysis.createHistogramMsrParamsNbClasses(nbClassesValue, minValue, maxValue))
        listFeatures.append(["HistogramMsr", "Histogram"])

    if modelDimension == "2D":
        analysis = shapeanalysis.labelAnalysis2d(image, imageSuperPixels, inMeasureInfoSet)
    else:
        analysis = shapeanalysis.labelAnalysis3d(image, imageSuperPixels, inMeasureInfoSet)
    nbColorPlan = image.getSizeC()

    features = []
    offset = 0

    for feature in listFeatures:
        if feature[0] in ["NbPixels2dMsr","NbPixels3dMsr", "BoundingBoxSizeXMsr", "BoundingBoxSizeYMsr","BoundingBoxSizeZMsr"]:
            values = analysis.getMeasure(feature[0]).getMeasureResult().getColl(0)
            features.append(values)
            offset += 1
        elif feature[0] != "HistogramMsr":
            for c in range(nbColorPlan):
                values = analysis.getMeasure(feature[0]).getMeasureResult().getColl(c)
                features.append(values)
                offset += 1

        else:
            nbClasses = len(PyIPSDK.toPyDict(analysis.getMeasure("HistogramMsr").getMeasureResult().getColl(0)[1])["Frequencies"])
            if modelDimension == "2D":
                valuesNbPixels = analysis.getMeasure("NbPixels2dMsr").getMeasureResult().getColl(0)
            else:
                valuesNbPixels = analysis.getMeasure("NbPixels3dMsr").getMeasureResult().getColl(0)
            for _ in range(nbClasses * nbColorPlan):
                features.append([0])
            for c in range(nbColorPlan):
                valuesHistogram = analysis.getMeasure("HistogramMsr").getMeasureResult().getColl(c)
                for numLabel in range(len(valuesHistogram)):
                    valueHisto = valuesHistogram[numLabel]
                    nbPixels = valuesNbPixels[numLabel]
                    if valueHisto is not None:
                        frequencies = PyIPSDK.toPyDict(valueHisto)["Frequencies"]
                        if len(frequencies) > 0:
                            for clss in range(nbClasses):
                                features[offset + clss + c * nbClasses].append(frequencies[clss] / nbPixels)


    features = np.asarray(features)

    dataToPredict = features.T

    dataToPredict = np.nan_to_num(dataToPredict)
    dataToPredict[dataToPredict > 10 ** 100] = 0
    dataToPredict[dataToPredict < -10 ** 100] = 0

    vectorPrediction = model.predict(dataToPredict)

    lut = PyIPSDK.createIntensityLUT(0, 1, vectorPrediction)
    outImage = itrans.lutTransform2dImg(imageSuperPixels, lut)

    labelClassElement = SubElement(xmlElement, "LabelClasses")
    nbClasses = int(childText(labelClassElement,"NumberLabels"))

    if nbClasses > 2:
        outImage = util.convertImg(outImage,PyIPSDK.eIBT_Label8)
    else:
        outImage = util.convertImg(outImage,PyIPSDK.eIBT_Binary)

    return outImage

def writeSmartSegmentationImage(image,modelName,settingsElement=None,offset=0):

    try:
        if settingsElement is None:
            filename = modelName + "/Settings.mho"
            file = xmlet.parse(filename)
            settingsElement = file.getroot()

        labelClassElement = SubElement(settingsElement,"LabelClasses")

        text = "LabelSmartSegmentation:"

        for i in range(len(labelClassElement)-1):

            element = SubElement(labelClassElement,"Label_"+str(i))

            valueLabel = childText(element,"Value")
            if valueLabel is not None:
                valueLabel = int(valueLabel)
            else:
                valueLabel = i

            name = childText(element,"Name")
            # color = childText(element,"Color")

            colorRef = childText(element,"Color")
            colorSplit = colorRef.split(",")
            color = ""
            for j in range(len(colorSplit)):
                color += str(int(float(colorSplit[j])*0.7))
                if j != len(colorSplit)-1:
                    color += ","

            if i != len(labelClassElement)-2:
                text += str(valueLabel+offset) + ">" + "Name=" + name + "|" + "Color="+color + "_"
            else:
                text += str(valueLabel+offset) + ">" + "Name=" + name + "|" + "Color="+color

        text += "!"

        image.setUserPropertiesStr(text)

    except:

        import traceback
        traceback.print_exc(file=sys.stderr)

def writeSmartClassification(image,modelName,settingsElement=None):

    writeSmartSegmentationImage(image, modelName, settingsElement=settingsElement, offset=1)

def readSmartSegmentation(image):

    ddict = {}

    text = image.getUserPropertiesStr()

    if text != "" and text != None:
        split1 = text.split("!")
        for text1 in split1:
            split2 = text1.split(":")
            if split2[0] == "LabelSmartSegmentation":
                text2 = split2[1]
                split3 = text2.split("_")
                for text3 in split3:
                    split4 = text3.split(">")
                    num = int(split4[0])
                    ddict[num] = {}
                    text4 = split4[1]
                    split5 = text4.split("|")
                    for text5 in split5:
                        split6 = text5.split("=")
                        ddict[num][split6[0]]=split6[1]

    return ddict