import os
import sys,traceback

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal,QPointF,Qt,QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLColor as colorIP
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho

import xml.etree.ElementTree as xmlet


import time

try:
    from vimba import *
except:
    pass

import PyIPSDK.IPSDKVariables as IPSDKVrb

# print(vrb.frame0)

# frame0 = None
# frame1 = None

def SubElement(element,text):

    toReturn=None
    for child in element:
        if child.tag==text:
            toReturn=child
    if toReturn is None:
        toReturn = xmlet.SubElement(element, text)
    return toReturn

def childText(element,tag):

    text=None
    if element != None:
        for child in element:
            if child.tag==tag:
                text=child.text
                try:
                    if child.get('ASCII') == str(True):
                        text = convertTextFromAscii(text)
                except:
                    pass
    return text

def applyImageContrast(image,minValue,maxValue):

    minValue = float(minValue)
    maxValue = float(maxValue)

    if maxValue - minValue != 0:
        image = util.convertImg(image, PyIPSDK.eIBT_Real32)
        image = arithm.addScalarImg(image, -minValue)
        image = arithm.multiplyScalarImg(image, 255 / (maxValue - minValue))
    outImage = util.convertImg(image, PyIPSDK.eIBT_UInt8)

    return outImage

def frame_handler0(cam, frame):

    cam.queue_frame(frame)
    IPSDKVrb.frame0 = frame

def frame_handler1(cam, frame):

    cam.queue_frame(frame)
    IPSDKVrb.frame1 = frame

def applySettings(cam,settingsFilename):

    try:
        file = xmlet.parse(settingsFilename)
        xmlElement = file.getroot()

        roiElement = SubElement(xmlElement, "ROI")
        if childText(roiElement, "CropImage") != "False":
            binning = int(childText(roiElement, "Binning"))
            offsetX = int(childText(roiElement, "OffsetX"))
            offsetY = int(childText(roiElement, "OffsetY"))
            sizeX = int(childText(roiElement, "SizeX"))
            sizeY = int(childText(roiElement, "SizeY"))
            cam.BinningVertical.set(binning)
            cam.BinningHorizontal.set(binning)
            try:
                cam.OffsetX.set(offsetX)
                cam.OffsetY.set(offsetY)
                cam.Width.set(sizeifX)
                cam.Height.set(sizeY)
            except:
                cam.Width.set(sizeX)
                cam.Height.set(sizeY)
                cam.OffsetX.set(offsetX)
                cam.OffsetY.set(offsetY)

        brightnessElement = SubElement(xmlElement, "Brightness")
        gain = int(childText(brightnessElement, "Gain"))
        exposureTime = int(childText(brightnessElement, "ExposureTime"))
        cam.Gain.set(gain / 100)
        cam.ExposureTime.set(exposureTime / 20)

        histogramElement = SubElement(xmlElement, "Histogram")
        minValue = int(childText(histogramElement, "MinValue"))
        maxValue = int(childText(histogramElement, "MaxValue"))
    except:
        minValue = None
        maxValue = None

    return minValue,maxValue

def getImageFromCamera(cameraNum=0):

    image = None

    if cameraNum == 0:
        frame = IPSDKVrb.frame0
    elif cameraNum == 1:
        frame = IPSDKVrb.frame1

    if frame is not None:
        frame.convert_pixel_format(PixelFormat.Mono8)

        openCvImage = frame.as_opencv_image()

        imageArray = openCvImage[:, :, 0]
        image = PyIPSDK.fromArray(imageArray)
        image = util.copyImg(image)

    return image

def getImageFromTwoCameras():

    image0 = None
    image1 = None

    frame0 = IPSDKVrb.frame0
    frame1 = IPSDKVrb.frame1

    if frame0 is not None:
        frame0.convert_pixel_format(PixelFormat.Mono8)
        openCvImage = frame0.as_opencv_image()
        imageArray = openCvImage[:, :, 0]
        image0 = PyIPSDK.fromArray(imageArray)

    if frame1 is not None:
        frame1.convert_pixel_format(PixelFormat.Mono8)
        openCvImage = frame1.as_opencv_image()
        imageArray = openCvImage[:, :, 0]
        image1 = PyIPSDK.fromArray(imageArray)

    image0 = util.copyImg(image0)
    image1 = util.copyImg(image1)

    return image0,image1

def timeInitCamera(cameraNum=0):

    iter = 0
    if cameraNum == 0:
        while iter < 100 and IPSDKVrb.frame0 is None:
            time.sleep(0.02)
            iter += 1
    if cameraNum == 1:
        while iter < 100 and IPSDKVrb.frame1 is None:
            time.sleep(0.02)
            iter += 1
    time.sleep(0.3)

def acquireImage(cameraNum=0,settingsFilename = None):

    # start = time.time()

    with Vimba.get_instance() as vimba:
        cams = vimba.get_all_cameras()

        with cams[cameraNum] as cam:
            minValue = None
            maxValue = None
            try:
                if settingsFilename is not None:
                    minValue, maxValue = applySettings(cam, settingsFilename)
                if cameraNum == 0:
                    cam.start_streaming(frame_handler0)
                elif cameraNum == 1:
                    cam.start_streaming(frame_handler1)
                timeInitCamera(cameraNum)
                image = getImageFromCamera(cameraNum)
                cam.stop_streaming()
            except:
                traceback.print_exc(file=sys.stderr)
                image = getImageFromCamera(cameraNum)

            if minValue is not None and maxValue is not None:
                image = applyImageContrast(image,minValue,maxValue)

    return image

def acquireImageSerie_SingleCamera(numberImages,timeStep,cameraNum = 0, settingsFilename = None):

    minValue = None
    maxValue = None

    with Vimba.get_instance() as vimba:
        cams = vimba.get_all_cameras()

        with cams[cameraNum] as cam:
            try:
                if settingsFilename is not None:
                    minValue, maxValue = applySettings(cam, settingsFilename)
                if cameraNum == 0:
                    cam.start_streaming(frame_handler0)
                elif cameraNum == 1:
                    cam.start_streaming(frame_handler1)
                timeInitCamera(cameraNum)
                imageList = getImageList(cameraNum,numberImages,timeStep,minValue=minValue,maxValue=maxValue)
                cam.stop_streaming()
            except:
                traceback.print_exc(file=sys.stderr)
                imageList = getImageList(cameraNum,numberImages,timeStep,minValue=minValue,maxValue=maxValue)

    return imageList

def acquireImageSerie_TwoCameras(numberImages,timeStep,settingsFilename = None):

    # frameList = []
    imageList = []
    minValue = None
    maxValue = None

    with Vimba.get_instance() as vimba:
        cams = vimba.get_all_cameras()

        with cams[0] as cam:
            with cams[1] as cam1:
                try:
                    if settingsFilename is not None:
                        minValue, maxValue = applySettings(cam, settingsFilename)
                        minValue, maxValue = applySettings(cam1, settingsFilename)
                    cam.start_streaming(frame_handler0)
                    cam1.start_streaming(frame_handler1)
                    timeInitCamera(0)
                    timeInitCamera(1)
                    imageList = getImageListTwoCameras(numberImages,timeStep,minValue=minValue,maxValue=maxValue)
                    cam.stop_streaming()
                    cam1.stop_streaming()
                except:
                    traceback.print_exc(file=sys.stderr)
                    imageList = getImageListTwoCameras(numberImages,timeStep,minValue=minValue,maxValue=maxValue)

    return imageList

def getImageList(cameraNum,numberImages,timeStep,minValue=None,maxValue=None):

    imageList = []

    for imageNum in range(numberImages):

        print(imageNum)
        timeStart = time.time()
        image = getImageFromCamera(cameraNum)
        if minValue is not None and maxValue is not None:
            image = applyImageContrast(image, minValue, maxValue)
        imageList.append(image)
        while time.time()-timeStart < timeStep:
            time.sleep(0.001)

    return imageList

def getImageListTwoCameras(numberImages,timeStep,minValue=None,maxValue=None):

    imageList0 = []
    imageList1 = []

    for imageNum in range(numberImages):
        print(imageNum)
        timeStart = time.time()
        image0 = getImageFromCamera(0)
        image1 = getImageFromCamera(1)
        if minValue is not None and maxValue is not None:
            image0 = applyImageContrast(image0, minValue, maxValue)
            image1 = applyImageContrast(image1, minValue, maxValue)
        imageList0.append(image0)
        imageList1.append(image1)

        while time.time()-timeStart < timeStep:
            time.sleep(0.001)

    return imageList0,imageList1

def saveImageList(imageList,folderName,prefix=""):

    if not os.path.exists(folderName):
        os.makedirs(folderName)
    for frameNum in range(len(imageList)):
            PyIPSDK.saveTiffImageFile(folderName + "/" + prefix + "frame_"+str(frameNum) + ".tif",imageList[frameNum])

def initCamera(cam,cameraNum=0,settingsFilename = None):

    try:
        if settingsFilename is not None:
            minValue, maxValue = applySettings(cam, settingsFilename)
    except:
        pass

    if cameraNum == 0:
        cam.start_streaming(frame_handler0)
    elif cameraNum == 1:
        cam.start_streaming(frame_handler1)

    timeInitCamera(cameraNum)

def stopCamera(cam):

    cam.stop_streaming()

