#! /bin/bash

# ------------------------------------------------------------------------------------------------ #
# Function evaluating a command and testing its result
runCmd() {
	eval $1
	
	if [ $? -ne 0 ]
	then
		echo "Error: the command $1 has failed"
		exit $2
	fi
}

# ------------------------------------------------------------------------------------------------ #
# Function wrinting the content of IPSDK_X_X_X_X.py in the python site-packages sub-directory
# with a relative path to IPSDK
rewriteIPSDKPath() {
    filePath=`ls ./Miniforge/envs/ipsdk-env/lib/python3.9/site-packages/PyIPSDK/IPSDK_*.py`
    echo '#!/usr/bin/env python' > $filePath
    echo '# coding: utf-8' >> $filePath
    echo '' >> $filePath
    echo 'import sys' >> $filePath
    echo 'import os' >> $filePath
    echo '' >> $filePath
    echo '# function allowing to retrieve IPSDK installation root path' >> $filePath
    echo 'def getIPSDKRootPath():' >> $filePath
    echo '    "function allowing to retrieve IPSDK root path"' >> $filePath
    echo '' >> $filePath
    echo '    dir_path = os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.realpath(__file__)))))))))' >> $filePath
    echo '' >> $filePath
    echo '    return dir_path' >> $filePath
    echo ""  >> $filePath
}

# Create the log directory if it does not already exist
[ -d ./Logs ] || mkdir ./Logs

errCode=1

# Download Miniforge if it has not been downloaded yes
if [ ! -f ./Miniforge.sh ]
then
    echo "Downloading Miniforge"
    runCmd "wget -O - https://github.com/conda-forge/miniforge/releases/download/24.7.1-0/Miniforge3-24.7.1-0-Linux-x86_64.sh -O ./miniforge.sh >./Logs/${errCode}_downloadMiniforge.log 2>&1" ${errCode}
fi
errCode=`expr $errCode + 1`

# Install Miniforge
echo "Installing Miniforge"
runCmd "sh ./miniforge.sh -b -p ./Miniforge >./Logs/${errCode}_installMiniforge.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`

export PYTHONPATH=$PYTHONPATH:./Miniforge/bin

# Create python 3.8 environment
echo "Create Python 3.9 environment"
runCmd "./Miniforge/bin/conda create -y -n ipsdk-env -c conda-forge python=3.9 >./Logs/${errCode}_createPyEnv.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`

# Activate the environment
echo "Activate Python 3.9 environment"
runCmd "source ./Miniforge/bin/activate ipsdk-env >./Logs/${errCode}_activatePyEnv.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`

# Install required modules
echo "Installing requirement modules"
runCmd "./Miniforge/envs/ipsdk-env/bin/pip install -r ./Explorer/requirements.txt --target=./Miniforge/envs/ipsdk-env/lib/python3.9/site-packages >./Logs/${errCode}_installRequirements.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`

# Patch Napari
echo "Patching Napari"
runCmd "cp ./patch_napari_volume.py ./Miniforge/envs/ipsdk-env/lib/python3.9/site-packages/napari/_vispy/visuals/volume.py >./Logs/${errCode}_patchNapari.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`
rewriteIPSDKPath

# Install IPSDK
echo "Installing IPSDK"
runCmd "./Miniforge/envs/ipsdk-env/bin/python ./python/install/setup.py >./Logs/${errCode}_installIPSDK.log 2>&1" ${errCode}
errCode=`expr $errCode + 1`
rewriteIPSDKPath

# Remove the Miniforge installer
echo "Removing temporary files"
rm -rf ./Miniforge.sh ./Logs ./patch_napari_volume.py

echo "Installation completed"
echo "You can run the command:"
echo "$PWD/explorer"

exit 0



