import sys,os
import traceback
import PyIPSDK

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, MeasureInfoSetConstraint

import scriptsCreation._FunctionToXML as fct2Xml
import scriptsCreation._DocumentationLinker as docLink

import UsefullVariables as vrb


def generateXmlElement(displayName, ipsdkName, listParams, savePath, docTitle, description, dimension='Both'):
    measureNode = xmlet.Element('Measure')
    measureNode.set('CheckState', '0')

    Dfct.SubElement(measureNode, 'Dimension').text = dimension
    Dfct.SubElement(measureNode, 'UserName').text = displayName
    Dfct.SubElement(measureNode, 'Description').text = description
    if docTitle is not None:
        Dfct.SubElement(measureNode, 'DocTitle').text = docTitle

    objectNode = Dfct.SubElement(measureNode, 'Object')
    Dfct.SubElement(objectNode, 'Name').text = ipsdkName
    if len(listParams):
        paramsNode = Dfct.SubElement(objectNode, 'Parameters')
        for nb, param in enumerate(listParams, 0):
            fct2Xml.insertParameterNode(paramsNode, nb, param)
    if savePath is not None and ipsdkName is not None:
        Dfct.saveXmlElement(measureNode, savePath + '/' + ipsdkName + '.mho')
    return measureNode

def createFolder(name,prefix=True):
    if prefix:
        folder = vrb.folderShapeAnalysis + name
    else:
        folder = name
    try:
        os.remove(folder)
    except:
        pass
    try:
        os.makedirs(folder)
    except:
        pass

    return folder


##################
#     Basic      #
##################
folder = createFolder('/1Geometry/Basic')

# Area 2D
listParams = [
]

description = 'Area measurement'
functionNode = generateXmlElement('Area 2D', 'Area2dMsr', listParams, folder, 'Area2d', description, '2D')

# Area 2D Polygon
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]

description = 'Area measurement (measure based on polygonal approximation)'
functionNode = generateXmlElement('Polygon Area 2D', 'PolygonArea2dMsr', listParams, folder, 'PolygonArea2d', description, '2D')

# Area 3D
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Area measurement'
functionNode = generateXmlElement('Area 3D', 'Area3dMsr', listParams, folder, 'Area3d', description, '3D')

# ImageRatio
listParams = [
]
description = 'Measures the ratio between the shapes areas and the image area'
functionNode = generateXmlElement('Image Ratio', 'ImageRatioMsr', listParams, folder, 'ImageRatio', description, 'Both')

# TODO: Image Borders Contact

# NbPixels2d
listParams = [
]
description = 'Returns the number of pixels.'
functionNode = generateXmlElement('Number of pixels', 'NbPixels2dMsr', listParams, folder, 'NbPixels2d', description, '2D')

# NbPixels3d
listParams = [
]
description = 'Returns the number of pixels.'
functionNode = generateXmlElement('Number of pixels', 'NbPixels3dMsr', listParams, folder, 'NbPixels3d', description, '3D')

# Perimeter
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Perimeter measurement (measure based on polygonal approximation)'
functionNode = generateXmlElement('Perimeter', 'Perimeter2dMsr', listParams, folder, 'Perimeter2d', description, '2D')

# Volume 3D
listParams = [
]
description = 'Volume measurement'
functionNode = generateXmlElement('Volume 3D', 'Volume3dMsr', listParams, folder, 'Volume3d', description, '3D')

# Mesh Volume 3D
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Volume measurement (measure based on polyhedral approximation)'
functionNode = generateXmlElement('Mesh Volume 3D', 'MeshVolume3dMsr', listParams, folder, 'MeshVolume3d', description, '3D')

# Number connected components 2D
listParams = [
]
description = 'Returns the number of connected components associated to each 2d shape'
functionNode = generateXmlElement('Number of 2D Connected Components', 'NbConnectedComponents2dMsr', listParams, folder, 'Number of 2D Connected Components', description, '2D')

# Number connected components 3D
listParams = [
]
description = 'Returns the number of connected components associated to each 3d shape'
functionNode = generateXmlElement('Number of 3D Connected Components', 'NbConnectedComponents3dMsr', listParams, folder, 'Number of 3D Connected Components', description, '3D')

##################
#  Bounding Box  #
##################
folder = createFolder('/1Geometry/BoundingBox')

# BoundingBoxCenterX
listParams = [
]
description = 'Computes the position of the centroid of the envelope along the x axis'
functionNode = generateXmlElement('Bounding Box Center X', 'BoundingBoxCenterXMsr', listParams, folder, 'BoundingBoxCenterX', description)
# BoundingBoxCenterY
listParams = [
]
description = 'Computes the position of the centroid of the envelope along the y axis'
functionNode = generateXmlElement('Bounding Box Center Y', 'BoundingBoxCenterYMsr', listParams, folder, 'BoundingBoxCenterY', description)
# BoundingBoxCenterZ
listParams = [
]
description = 'Computes the position of the centroid of the envelope along the z axis'
functionNode = generateXmlElement('Bounding Box Center Z', 'BoundingBoxCenterZMsr', listParams, folder, 'BoundingBoxCenterZ', description, '3D')

# BoundingBoxMaxXMsr
listParams = [
]
description = 'Computes the position of the max of the envelope along the x axis'
functionNode = generateXmlElement('Bounding Box Max X', 'BoundingBoxMaxXMsr', listParams, folder, 'BoundingBoxMaxX', description)
# BoundingBoxMaxYMsr
listParams = [
]
description = 'Computes the position of the max of the envelope along the y axis'
functionNode = generateXmlElement('Bounding Box Max Y', 'BoundingBoxMaxYMsr', listParams, folder, 'BoundingBoxMaxY', description)
# BoundingBoxMaxZMsr
listParams = [
]
description = 'Computes the position of the max of the envelope along the z axis'
functionNode = generateXmlElement('Bounding Box Max Z', 'BoundingBoxMaxZMsr', listParams, folder, 'BoundingBoxMaxZ', description, '3D')

# BoundingBoxMinXMsr
listParams = [
]
description = 'Computes the position of the min of the envelope along the x axis'
functionNode = generateXmlElement('Bounding Box Min X', 'BoundingBoxMinXMsr', listParams, folder, 'BoundingBoxMinX', description)
# BoundingBoxMinYMsr
listParams = [
]
description = 'Computes the position of the min of the envelope along the y axis'
functionNode = generateXmlElement('Bounding Box Min Y', 'BoundingBoxMinYMsr', listParams, folder, 'BoundingBoxMinY', description)
# BoundingBoxMinZMsr
listParams = [
]
description = 'Computes the position of the min of the envelope along the z axis'
functionNode = generateXmlElement('Bounding Box Min Z', 'BoundingBoxMinZMsr', listParams, folder, 'BoundingBoxMinZ', description, '3D')

# BoundingBoxSizeXMsr
listParams = [
]
description = 'Computes the position of the size of the envelope along the x axis'
functionNode = generateXmlElement('Bounding Box Size X', 'BoundingBoxSizeXMsr', listParams, folder, 'BoundingBoxSizeX', description)
# BoundingBoxSizeYMsr
listParams = [
]
description = 'Computes the position of the size of the envelope along the y axis'
functionNode = generateXmlElement('Bounding Box Size Y', 'BoundingBoxSizeYMsr', listParams, folder, 'BoundingBoxSizeY', description)
# BoundingBoxSizeZMsr
listParams = [
]
description = 'Computes the position of the size of the envelope along the z axis'
functionNode = generateXmlElement('Bounding Box Size Z', 'BoundingBoxSizeZMsr', listParams, folder, 'BoundingBoxSizeZ', description, '3D')

##################
#   Convex Hull  #
##################

folder = createFolder('/1Geometry/ConvexHull')

# ConvexHullArea2d
listParams = [
]
description = 'Compute the area of the 2d convex hull for shape.'
functionNode = generateXmlElement('Convex Hull Area 2D', 'ConvexHullArea2dMsr', listParams, folder, 'ConvexHullArea2d', description,"2D")
# ConvexHullArea3d
listParams = [
]
description = 'Compute the area of the 3d convex hull for shape.'
functionNode = generateXmlElement('Convex Hull Area 3D', 'ConvexHullArea3dMsr', listParams, folder, 'ConvexHullArea3d', description, '3D')

# ConvexHullPerimeter2d
listParams = [
]
description = 'Compute the perimeter of the 2d convex hull for shape.'
functionNode = generateXmlElement('Convex Hull Perimeter 2D', 'ConvexHullPerimeter2dMsr', listParams, folder, 'ConvexHullPerimeter2d', description,"2D")
# ConvexHullVolume3d
listParams = [
]
description = 'Compute the volume of the 3d convex hull for shape.'
functionNode = generateXmlElement('Convex Hull Volume 3D', 'ConvexHullVolume3dMsr', listParams, folder, 'ConvexHullVolume3d', description, '3D')

##################
#     Fitting    #
##################

folder = createFolder('/1Geometry/Fitting')

# LeastSquareBallCenterX
listParams = [
]
description = 'X coordinates for center of least square ball associated to shape tops'
functionNode = generateXmlElement('Least Square Ball Center X', 'LeastSquareBallCenterXMsr', listParams, folder, 'LeastSquareBallCenterX', description, 'Both')

# LeastSquareBallCenterY
listParams = [
]
description = 'Y coordinates for center of least square ball associated to shape tops'
functionNode = generateXmlElement('Least Square Ball Center Y', 'LeastSquareBallCenterYMsr', listParams, folder, 'LeastSquareBallCenterY', description, 'Both')

# LeastSquareBallCenterZ
listParams = [
]
description = 'Z coordinates for center of least square ball associated to shape tops'
functionNode = generateXmlElement('Least Square Ball Center Z', 'LeastSquareBallCenterZMsr', listParams, folder, 'LeastSquareBallCenterZ', description, '3D')

# LeastSquareBallCenterRadius
listParams = [
]
description = 'Radius of least square ball associated to shape tops'
functionNode = generateXmlElement('Least Square Ball Radius', 'LeastSquareBallRadiusMsr', listParams, folder, 'LeastSquareBallRadius', description, 'Both')


# TODO: All Least... parametre a plusieurs entrees
# MaxInscribedBallCenterX
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'X coordinates for center of ball of maximum radius enclosed by shape.'
functionNode = generateXmlElement('Max Inscribed Ball Center X', 'MaxInscribedBallCenterXMsr', listParams, folder, 'MaxInscribedBallCenterX', description, '2D')
# MaxInscribedBallCenterY
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Y coordinates for center of ball of maximum radius enclosed by shape.'
functionNode = generateXmlElement('Max Inscribed Ball Center Y', 'MaxInscribedBallCenterYMsr', listParams, folder, 'MaxInscribedBallCenterY', description, '2D')
# MaxInscribedBallRadius
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Radius of ball of maximum radius enclosed by shape.'
functionNode = generateXmlElement('Max Inscribed Ball Radius', 'MaxInscribedBallRadiusMsr', listParams, folder, 'MaxInscribedBallRadius', description, '2D')

# TODO: MaxInscribedCircle2dMsr: return value

# MinEnclosingBallCenterX
listParams = [
]
description = 'X coordinates for center of ball of minimum radius enclosing shape.'
functionNode = generateXmlElement('Min Enclosing Ball Center X', 'MinEnclosingBallCenterXMsr', listParams, folder, 'MinEnclosingBallCenterX', description, 'Both')
# MinEnclosingBallCenterY
listParams = [
]
description = 'Y coordinates for center of ball of minimum radius enclosing shape.'
functionNode = generateXmlElement('Min Enclosing Ball Center Y', 'MinEnclosingBallCenterYMsr', listParams, folder, 'MinEnclosingBallCenterY', description, 'Both')
# MinEnclosingBallCenterZ
listParams = [
]
description = 'Z coordinates for center of ball of minimum radius enclosing shape.'
functionNode = generateXmlElement('Min Enclosing Ball Center Z', 'MinEnclosingBallCenterZMsr', listParams, folder, 'MinEnclosingBallCenterZ', description, '3D')

# MinEnclosingBallRadius
listParams = [
]
description = 'Radius of ball of minimum radius enclosing shape.'
functionNode = generateXmlElement('Min Enclosing Ball Radius', 'MinEnclosingBallRadiusMsr', listParams, folder, 'MinEnclosingBallRadius', description, '3D')

# TODO: MinEnclosingCircle2d: return value
# TODO: MinEnclosingSphere3d: return value

##################
#   Form Factor  #
##################
folder = createFolder('/1Geometry/FormFactor')

folderAngularity = createFolder(folder + '/Angularity',prefix=False)

folderAngularity = folder + '/Angularity'
# Degree of angularity 2d
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Ratio of the bounding edge angles and the distance of the edges from the center of the particle which is defined by the largest inscribed circle to the radius of the maximum inscribed circle'
functionNode = generateXmlElement('Degree of angularity', 'DegreeOfAngularity2dMsr', listParams, folderAngularity, 'Degree of angularity 2d', description, '2D')

# TODO : Disparity angularity 2d: Histogram

# Edge angularity 2d
listParams = [
]
description = 'Compute an angularity criterion based on a simple successive edge angle variation'
functionNode = generateXmlElement('Edge angularity', 'EdgeAngularity2dMsr', listParams, folderAngularity, 'Edge angularity 2d', description, '2D')
# Gradient angularity index 2d
listParams = [
]
description = 'Compute average of the change in the angles of the gradient vectors around the particle circumference '
functionNode = generateXmlElement('Gradient angularity index 2d', 'GradientAngularityIndex2dMsr', listParams, folderAngularity, 'Gradient angularity index 2d', description, '2D')

# Outline slope angularity 2d
listParams = [
    fct2Xml.ParameterDescription('OutlineSlopeAngularity2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=18)
]
description = 'Compute changes in the slope of the shape outline'
functionNode = generateXmlElement('Outline slope angularity 2d', 'OutlineSlopeAngularity2dMsr', listParams, folderAngularity, 'Outline slope angularity 2d', description, '2D')

# TODO: Radius angularity index 2d

# AspectRatio
listParams = [
    fct2Xml.ParameterDescription('NbOrientations', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=12)
]
description = 'Measures the aspect ratio of a shape (measure based on polygonal or polyhedral approximation)'
functionNode = generateXmlElement('Aspect Ratio', 'AspectRatioMsr', listParams, folder, 'AspectRatio', description)

# Circularity2d
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Compute the circularity of a shape.'
functionNode = generateXmlElement('Circularity 2D', 'Circularity2dMsr', listParams, folder, 'Circularity2d', description, '2D')
# ConvexityMsr
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Compute the convexity of a shape.'
functionNode = generateXmlElement('Convexity', 'ConvexityMsr', listParams, folder, 'Convexity', description)
# EquivalentRadius
listParams = [
]
description = 'Compute radius of equivalent 2d circle or 3d sphere (circle with same area or sphere with same volume).'
functionNode = generateXmlElement('Equivalent Radius', 'EquivalentRayMsr', listParams, folder, 'Equivalent Radius', description)
# EquivalentDiameter
listParams = [
]
description = 'Compute diameter of equivalent 2d circle or 3d sphere (circle with same area or sphere with same volume).'
functionNode = generateXmlElement('Equivalent Diameter', 'EquivalentDiameterMsr', listParams, folder, 'Equivalent Diameter', description)
# Extent
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Measure the extent of an object into its bounding box.'
functionNode = generateXmlElement('Extent', 'ExtentMsr', listParams, folder, 'Extent', description)

# FeretDiameter2d
listParams = [
    fct2Xml.ParameterDescription('Orientation2D', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=0)
]
description = 'Computes, for a given orientation, Feret diameter (measure based on polyhedral approximation)'
functionNode = generateXmlElement('Feret Diameter 2d', 'FeretDiameter2dMsr', listParams, folder, 'FeretDiameter2d', description, '2D')

listParams = [
    fct2Xml.ParameterDescription('Orientation3D', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=0),
    fct2Xml.ParameterDescription('Orientation3D', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=0)
]
description = 'Computes, for a given orientation, Feret diameter (measure based on polyhedral approximation)'
functionNode = generateXmlElement('Feret Diameter 3d', 'FeretDiameter3dMsr', listParams, folder, 'FeretDiameter3d', description, '3D')

# MaxFeretDiameter
listParams = [
    fct2Xml.ParameterDescription('MaxFeretDiameterMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the maximal Feret diameter over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Max Feret Diameter', 'MaxFeretDiameterMsr', listParams, folder, 'MaxFeretDiameter', description)

# MeanFeretDiameter
listParams = [
    fct2Xml.ParameterDescription('MeanFeretDiameterMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the mean or Feret diameter over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Mean Feret Diameter', 'MeanFeretDiameterMsr', listParams, folder, 'MeanFeretDiameter', description)

# MinFeretDiameter
listParams = [
    fct2Xml.ParameterDescription('MinFeretDiameterMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the minimal Feret diameter over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Min Feret Diameter', 'MinFeretDiameterMsr', listParams, folder, 'MinFeretDiameter', description)

# MinFeretOrientation2dMsr
listParams = [
    fct2Xml.ParameterDescription('MinFeretOrientation2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the minimal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Min Feret Orientation 2D', 'MinFeretOrientation2dMsr', listParams, folder, 'MinFeretOrientation2d', description, '2D')

# MaxFeretOrientation2dMsr
listParams = [
    fct2Xml.ParameterDescription('MaxFeretOrientation2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the maximal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Max Feret Orientation 2D', 'MaxFeretOrientation2dMsr', listParams, folder, 'MaxFeretOrientation2d', description, '2D')

# MaxFeretOrientationPhi3dMsr
listParams = [
    fct2Xml.ParameterDescription('MaxFeretOrientationPhi3dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the maximal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Max Feret Orientation 3D Phi', 'MaxFeretOrientationPhi3dMsr', listParams, folder, 'MaxFeretOrientationPhi3d', description, '3D')

# MaxFeretOrientationTheta3dMsr
listParams = [
    fct2Xml.ParameterDescription('MaxFeretOrientationTheta3dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the maximal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Max Feret Orientation 3D Theta', 'MaxFeretOrientationTheta3dMsr', listParams, folder, 'MaxFeretOrientationTheta3d', description, '3D')

# MinFeretOrientationPhi3dMsr
listParams = [
    fct2Xml.ParameterDescription('MinFeretOrientationPhi3dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the minimal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Min Feret Orientation 3D Phi', 'MinFeretOrientationPhi3dMsr', listParams, folder, 'MinFeretOrientationPhi3d', description, '3D')

# MinFeretOrientationTheta3dMsr
listParams = [
    fct2Xml.ParameterDescription('MinFeretOrientationTheta3dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Compute the minimal Feret orientation over a range of uniformly distributed orientations.'
functionNode = generateXmlElement('Min Feret Orientation 3D Theta', 'MinFeretOrientationTheta3dMsr', listParams, folder, 'MinFeretOrientationTheta3d', description, '3D')

for extremum in ["Min","Max"]:
    for num in ["0","1"]:
        for letter in ["X","Y","Z"]:
            if letter == "Z":
                dim = "3D"
            else:
                dim = "Both"
            if extremum == "Min":
                textExtremum = "minimal"
            else:
                textExtremum = "maximal"
            listParams = [
                fct2Xml.ParameterDescription(extremum+'FeretPt'+ num + letter +'MsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
            ]
            description = 'Compute the '+ textExtremum +' Feret orientation over a range of uniformly distributed orientations.'
            functionNode = generateXmlElement(extremum+' Feret Point '+ num + " " + letter , extremum+'FeretPt'+num+letter+'Msr', listParams, folder, extremum+'FeretPt'+num+letter, description, dim)

#Oriented Extent
listParams = [
    fct2Xml.ParameterDescription('OrientedExtentMsrParams', InputType.BOOLEAN, defaultValue=False),
    fct2Xml.ParameterDescription('OrientedExtentMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=12)
]
description = 'Measure the extent of an object into its oriented bounding box'
functionNode = generateXmlElement('Oriented Extent', 'OrientedExtentMsr', listParams, folder, 'Oriented extent', description)

#Relative Size
listParams = [
    fct2Xml.EnumParameterDescription('RelativeSizeMsrParams', enumList=["eRSP_Min", "eRSP_Max"],defaultValue="eRSP_Min")
]
description = 'Measure allowing to get the number of shapes equivalent to the shape with minimum area'
functionNode = generateXmlElement('Relative Size', 'RelativeSizeMsr', listParams, folder, 'RelativeSize', description)

# TODO: Roughness2d: Il manque le wrapper IPSDK
# listParams = [
#     fct2Xml.ParameterDescription('Roughness2dMsrParams', InputType.BOOLEAN, defaultValue=False),
#     fct2Xml.ParameterDescription('Roughness2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=10)
# ]
# description = 'Measure the roughness'
# functionNode = generateXmlElement('Roughness 2d', 'Roughness2dMsr', listParams, folder, 'Roughness2d', description,'2D')

# Sphericity3d
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Compute the sphericity of a 3d shape.'
functionNode = generateXmlElement('Sphericity', 'Sphericity3dMsr', listParams, folder, 'Sphericity3d', description,'3D')


##################
#     Inertia    #
##################

folder = vrb.folderShapeAnalysis + '/1Geometry/Inertia'

# BarycenterX
listParams = [
]
description = 'Gives the barycenter X'
functionNode = generateXmlElement('Barycenter X', 'BarycenterXMsr', listParams, folder, 'BarycenterX', description)
# BarycenterY
listParams = [
]
description = 'Gives the barycenter Y'
functionNode = generateXmlElement('Barycenter Y', 'BarycenterYMsr', listParams, folder, 'BarycenterY', description)
# BarycenterZ
listParams = [
]
description = 'Gives the barycenter Z'
functionNode = generateXmlElement('Barycenter Z', 'BarycenterZMsr', listParams, folder, 'BarycenterZ', description, '3D')
# Eccentricity
listParams = [
]
description = 'Measure eccentricity of the ellipse that has the same second moments as 2d shape'
functionNode = generateXmlElement('Eccentricity 2D', 'Eccentricity2dMsr', listParams, folder, 'Eccentricity2d', description,'2D')
# Inertia3dLambdaInter
listParams = [
]
description = 'Measure allowing to compute the intermediary eigen value from the second order moment matrix computed from the Inertia measurement for 3d shape'
functionNode = generateXmlElement('Inertia Lambda Inter 3D', 'Inertia3dLambdaInterMsr', listParams, folder, 'Inertia3dLambdaInter', description,'3D')
# Inertia3dOrientationAlpha
listParams = [
]
description = "Measure allowing to compute the shape orientation (alpha component) from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Orientation Alpha 3D', 'Inertia3dOrientationAlphaMsr', listParams, folder, 'Inertia3dOrientationAlpha', description,'3D')
# Inertia3dOrientationBeta
listParams = [
]
description = "Measure allowing to compute the shape orientation (beta component) from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Orientation Beta 3D', 'Inertia3dOrientationBetaMsr', listParams, folder, 'Inertia3dOrientationBeta', description,'3D')
# Inertia3dOrientationChi
listParams = [
]
description = "Measure allowing to compute the shape orientation (chi component) from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Orientation Chi 3D', 'Inertia3dOrientationChiMsr', listParams, folder, 'Inertia3dOrientationChi', description,'3D')
# InertiaLambdaMax
listParams = [
]
description = "Measure allowing to compute the maximum eigen value from the second order moment matrix computed from the Inertia measurement for shape"
functionNode = generateXmlElement('Inertia Lambda Max', 'InertiaLambdaMaxMsr', listParams, folder, 'InertiaLambdaMax', description)
# InertiaLambdaMin
listParams = [
]
description = "Measure allowing to compute the minimum eigen value from the second order moment matrix computed from the Inertia measurement for shape"
functionNode = generateXmlElement('Inertia Lambda Min', 'InertiaLambdaMinMsr', listParams, folder, 'InertiaLambdaMin', description)
# InertiaOrientation2dMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the Inertia2d measurement for 2d shape"
functionNode = generateXmlElement('Inertia Orientation 2D', 'InertiaOrientation2dMsr', listParams, folder, 'Inertia Orientation 2d', description,'2D')
# Inertia3dOrientationPhiMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Orientation 3D Phi', 'Inertia3dOrientationPhiMsr', listParams, folder, 'Inertia3dOrientationPhi', description,'3D')
# Inertia3dOrientationThetaMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Orientation 3D Theta', 'Inertia3dOrientationThetaMsr', listParams, folder, 'Inertia3dOrientationTheta', description,'3D')
# Inertia3dNormalOrientationPhiMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Normal Orientation 3D Phi', 'Inertia3dNormalOrientationPhiMsr', listParams, folder, 'Inertia3dNormalOrientationPhi', description,'3D')
# Inertia3dNormalOrientationThetaMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the Inertia3d measurement for 3d shape"
functionNode = generateXmlElement('Inertia Normal Orientation 3D Theta', 'Inertia3dNormalOrientationThetaMsr', listParams, folder, 'Inertia3dNormalOrientationTheta', description,'3D')

##################
#     Matching    #
#Outputs and wrappers
##################

####################
#     Metrology    #
####################

folder = vrb.folderShapeAnalysis + '/1Geometry/Metrology'

# FlatnessPeakMsr
listParams = [
]
description = "Out of flatness highest peak given measure reference hyper plan"
functionNode = generateXmlElement('Flatness Peak', 'FlatnessPeakMsr', listParams, folder, 'FlatnessPeak', description)
# FlatnessTotalMsr
listParams = [
]
description = "Out of flatness expressed as difference between highest peak and lowest valley given measure reference hyper plan"
functionNode = generateXmlElement('Flatness Total', 'FlatnessTotalMsr', listParams, folder, 'FlatnessTotal', description)
# FlatnessValleyMsr
listParams = [
]
description = "Out of flatness lowest valley given measure reference hyper plan"
functionNode = generateXmlElement('Flatness Valley', 'FlatnessValleyMsr', listParams, folder, 'FlatnessValley', description)
# RoundnessPeakMsr
listParams = [
]
description = "Out of Roundness highest peak given measure reference hyper plan"
functionNode = generateXmlElement('Roundness Peak', 'RoundnessPeakMsr', listParams, folder, 'RoundnessPeak', description)
# RoundnessTotalMsr
listParams = [
]
description = "Out of Roundness expressed as difference between highest peak and lowest valley given measure reference hyper plan"
functionNode = generateXmlElement('Roundness Total', 'RoundnessTotalMsr', listParams, folder, 'RoundnessTotal', description)
# RoundnessValleyMsr
listParams = [
]
description = "Out of Roundness lowest valley given measure reference hyper plan"
functionNode = generateXmlElement('Roundness Valley', 'RoundnessValleyMsr', listParams, folder, 'RoundnessValley', description)

####################
#     Neighborhood    #
####################

folder = vrb.folderShapeAnalysis + '/1Geometry/Neighborhood'

# DistanceToNearestBarycenter2dMsr
listParams = [
]
description = "Computation of distance from shape barycenter to nearest neighbor shape barycenter for each shape"
functionNode = generateXmlElement('Distance to nearest barycenter 2D', 'DistanceToNearestBarycenter2dMsr', listParams, folder, 'Distance to nearest barycenter 2d', description,'2D')
# DistanceToNearestBarycenter3dMsr
listParams = [
]
description = "Computation of distance from shape barycenter to nearest neighbor shape barycenter for each shape"
functionNode = generateXmlElement('Distance to nearest barycenter 3D', 'DistanceToNearestBarycenter3dMsr', listParams, folder, 'Distance to nearest barycenter 3d', description,'3D')
# DistanceToNearestNeighbor2dMsr
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Computation of distance to nearest neighbor for each shape'
functionNode = generateXmlElement('Distance to nearest neighbor 2D', 'DistanceToNearestNeighbor2dMsr', listParams, folder, 'Distance to nearest neighbor 2d', description, '2D')
# DistanceToNearestNeighbor3dMsr
listParams = [
    fct2Xml.ParameterDescription('ProcessHoles', InputType.BOOLEAN, defaultValue=False)
]
description = 'Computation of distance to nearest neighbor for each shape'
functionNode = generateXmlElement('Distance to nearest neighbor 3D', 'DistanceToNearestNeighbor3dMsr', listParams, folder, 'Distance to nearest neighbor 3d', description, '3D')

# LengthOfContact2dMsr
listParams = [
    fct2Xml.ParameterDescription('LengthOfContact2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=3),
    fct2Xml.EnumParameterDescription('LengthOfContact2dMsrParams', enumList=["eSCP_SegCenter", "eSCP_SegEnds","eSCP_SegClosestPoint"],defaultValue="eSCP_SegCenter"),
    fct2Xml.ParameterDescription('LengthOfContact2dMsrParams', InputType.BOOLEAN, defaultValue=False)
]
description = 'Compute length of contact between shapes'
functionNode = generateXmlElement('Length of contact 2D', 'LengthOfContact2dMsr', listParams, folder, 'Length of contact 2d', description,'2D')

# NbNeighborsMsr
listParams = [
    fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=3),
    fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.BOOLEAN, defaultValue=False)
]
description = 'Measure allowing to compute number of neighbors of shapes given a distance threshold'
functionNode = generateXmlElement('Number of neighbors', 'NbNeighborsMsr', listParams, folder, 'Number of neighbors', description)

# Plusieurs paramètres de sortie
# # NearestNeighbors2dMsr
# listParams = [
#     fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=3),
#     fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.BOOLEAN, defaultValue=False)
# ]
# description = 'Measure allowing to retrieve shapes at a given distance of measured shape'
# functionNode = generateXmlElement('Nearest neighbors 2D', 'NearestNeighbors2dMsr', listParams, folder, 'Nearest neighbors 2d', description,'2D')
#
# # NearestNeighbors3dMsr
# listParams = [
#     fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=3),
#     fct2Xml.ParameterDescription('NeighborsDistanceMsrParams', InputType.BOOLEAN, defaultValue=False)
# ]
# description = 'Measure allowing to retrieve shapes at a given distance of measured shape'
# functionNode = generateXmlElement('Nearest neighbors 3D', 'NearestNeighbors3dMsr', listParams, folder, 'Nearest neighbors 3d', description,'3D')

# SurfaceOfContact3dMsr
listParams = [
    fct2Xml.ParameterDescription('SurfaceOfContact3dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=3),
    fct2Xml.ParameterDescription('SurfaceOfContact3dMsrParams', InputType.BOOLEAN, defaultValue=False)
]
description = 'Measure allowing to compute surface of contact between shapes'
functionNode = generateXmlElement('Surface of contact 3D', 'SurfaceOfContact3dMsr', listParams, folder, 'Surface of contact 3d', description,'3D')

################################
#     Oriented Bounding Box    #
################################

folder = vrb.folderShapeAnalysis + '/1Geometry/OrientedBoundingBox'

# OBBCenterXMsr
listParams = [
    fct2Xml.ParameterDescription('OBBCenterXMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to compute the position of the centroid of the minimal oriented bounding box along the x axis'
functionNode = generateXmlElement('OBB Center X', 'OBBCenterXMsr', listParams, folder, 'OBBCenterX', description)
# OBBCenterYMsr
listParams = [
    fct2Xml.ParameterDescription('OBBCenterYMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to compute the position of the centroid of the minimal oriented bounding box along the y axis'
functionNode = generateXmlElement('OBB Center Y', 'OBBCenterYMsr', listParams, folder, 'OBBCenterY', description)
# OBBCenterZMsr
listParams = [
    fct2Xml.ParameterDescription('OBBCenterZMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to compute the position of the centroid of the minimal oriented bounding box along the z axis'
functionNode = generateXmlElement('OBB Center Z', 'OBBCenterZMsr', listParams, folder, 'OBBCenterZ', description,'3D')
# OBBLengthMsr
listParams = [
    fct2Xml.ParameterDescription('OBBLengthMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the length of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Length', 'OBBLengthMsr', listParams, folder, 'OBBLength', description)
# OBBWidthMsr
listParams = [
    fct2Xml.ParameterDescription('OBBWidthMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the width of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Width', 'OBBWidthMsr', listParams, folder, 'OBBWidth', description)
# OBBHeightMsr
listParams = [
    fct2Xml.ParameterDescription('OBBHeightMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the height of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Height', 'OBBHeightMsr', listParams, folder, 'OBBHeight', description,'3D')
# OBBOrientation2dMsr
listParams = [
    fct2Xml.ParameterDescription('OBBOrientation2dMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the orientation of the minimal oriented bounding box of a 2d shape'
functionNode = generateXmlElement('OBB Orientation 2D', 'OBBOrientation2dMsr', listParams, folder, 'OBBOrientation2d', description,'2D')
# OBBOrientationAlphaMsr
listParams = [
    fct2Xml.ParameterDescription('OBBOrientationAlphaMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the orientation (alpha component, in radians) of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Orientation Alpha', 'OBBOrientationAlphaMsr', listParams, folder, 'OBBOrientationAlpha', description,'3D')
# OBBOrientationBetaMsr
listParams = [
    fct2Xml.ParameterDescription('OBBOrientationBetaMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the orientation (beta component, in radians) of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Orientation Beta', 'OBBOrientationBetaMsr', listParams, folder, 'OBBOrientationBeta', description,'3D')
# OBBOrientationChiMsr
listParams = [
    fct2Xml.ParameterDescription('OBBOrientationChiMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.NATURAL], defaultValue=36)
]
description = 'Measure allowing to get the orientation (chi component, in radians) of the minimal oriented bounding box of a shape'
functionNode = generateXmlElement('OBB Orientation Chi', 'OBBOrientationChiMsr', listParams, folder, 'OBBOrientationChi', description,'3D')

###################
#     Porosity    #
###################

folder = vrb.folderShapeAnalysis + '/1Geometry/Porosity'

# NbHolesMsr
listParams = [
]
description = "Compute number of holes associated to shape"
functionNode = generateXmlElement('Number of holes', 'NbHolesMsr', listParams, folder, 'NbHoles', description)
# Porosity
listParams = [
]
description = "Material porosity measurement : fraction of the volume of voids over the total volume"
functionNode = generateXmlElement('Porosity', 'PorosityMsr', listParams, folder, 'Porosity', description)

###################
#     Skeleton    #
###################

folder = vrb.folderShapeAnalysis + '/1Geometry/Skeleton'

# Skeleton2dDiameterLengthMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dDiameterLengthMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed","eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Length of the longest shortest path between any two skeleton 2d verticies'
functionNode = generateXmlElement('Skeleton 2D Diameter Length', 'Skeleton2dDiameterLengthMsr', listParams, folder, 'Skeleton2dDiameterLength', description, '2D')
# Skeleton2dDiameterMeanCurvatureMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dDiameterMeanCurvatureMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Mean curvature of the longest shortest path between any two skeleton 2d verticies'
functionNode = generateXmlElement('Skeleton 2D Diameter Mean Curvature', 'Skeleton2dDiameterMeanCurvatureMsr', listParams, folder, 'Skeleton2dDiameterMeanCurvature', description, '2D')
# Skeleton2dDiameterTortuosityMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dDiameterTortuosityMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Tortuosity of the longest shortest path between any two skeleton 2d verticies'
functionNode = generateXmlElement('Skeleton 2D Diameter Tortuosity', 'Skeleton2dDiameterTortuosityMsr', listParams, folder, 'Skeleton2dDiameterTortuosity', description, '2D')
# Skeleton2dLengthMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dLengthMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored"),
    fct2Xml.EnumParameterDescription('Skeleton2dLengthMsrParams', enumList=["eSEC_Leaf ", "eSEC_Branch", "eSEC_All"], defaultValue="eSEC_Leaf")
]
description = 'Length of graph associated to skeleton 2d'
functionNode = generateXmlElement('Skeleton 2D Length', 'Skeleton2dLengthMsr', listParams, folder, 'Skeleton2dLength', description, '2D')
# Skeleton2dMaxThicknessMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dMaxThicknessMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Maximum thickness of shape 2d defined using branches of its skeleton'
functionNode = generateXmlElement('Skeleton 2D Max Thickness', 'Skeleton2dMaxThicknessMsr', listParams, folder, 'Skeleton2dMaxThickness', description, '2D')
# Skeleton2dMeanEdgeLengthMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dMeanEdgeLengthMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored"),
    fct2Xml.EnumParameterDescription('Skeleton2dMeanEdgeLengthMsrParams', enumList=["eSEC_Leaf ", "eSEC_Branch", "eSEC_All"], defaultValue="eSEC_Leaf")
]
description = 'Mean edge length for graph associated to skeleton 2d'
functionNode = generateXmlElement('Skeleton 2D Mean Edge Length', 'Skeleton2dMeanEdgeLengthMsr', listParams, folder, 'Skeleton2dMeanEdgeLength', description, '2D')
# Skeleton2dMeanThicknessMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dMeanThicknessMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Mean thickness of shape 2d defined using branches of its skeleton'
functionNode = generateXmlElement('Skeleton 2D Mean Thickness', 'Skeleton2dMeanThicknessMsr', listParams, folder, 'Skeleton2dMeanThickness', description, '2D')
# Skeleton2dMinThicknessMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dMinThicknessMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored")
]
description = 'Minimum thickness of shape 2d defined using branches of its skeleton'
functionNode = generateXmlElement('Skeleton 2D Min Thickness', 'Skeleton2dMinThicknessMsr', listParams, folder, 'Skeleton2dMinThickness', description, '2D')
# Skeleton2dNbVertexMsr
listParams = [
    fct2Xml.EnumParameterDescription('Skeleton2dNbVertexMsrParams', enumList=["eSHP_Ignored ", "eSHP_ExtractedButNotAnalyzed", "eSHP_ExtractedAndAnalyzed"], defaultValue="eSHP_Ignored"),
    fct2Xml.EnumParameterDescription('Skeleton2dNbVertexMsrParams', enumList=["eSVC_Internal ", "eSVC_Junction", "eSVC_Slab","eSVC_EndPoint","eSVC_All"], defaultValue="eSVC_Internal")
]
description = 'Number of vertex in graph associated to skeleton 2d'
functionNode = generateXmlElement('Skeleton 2D Number of Vertex', 'Skeleton2dNbVertexMsr', listParams, folder, 'Skeleton2dNbVertex', description, '2D')

############
############
############
# Intesity #
############
############
############

####################
#     Histogram    #
####################
folder = vrb.folderShapeAnalysis + '/2Intensity/Histogram'

# HistogramMostPopulatedGLMsr
listParams = [
    fct2Xml.ParameterDescription('HistogramMostPopulatedGLMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=1),
    fct2Xml.ParameterDescription('HistogramMostPopulatedGLMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL]),
    fct2Xml.ParameterDescription('HistogramMostPopulatedGLMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL])
]
description = 'Compute the intensity of the most populated class'
functionNode = generateXmlElement('Histogram Most Populated Class', 'HistogramMostPopulatedGLMsr', listParams, folder, 'HistogramMostPopulatedGL', description)

# HistogramPopulationMaxMsr
listParams = [
    fct2Xml.ParameterDescription('HistogramPopulationMaxMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=1),
    fct2Xml.ParameterDescription('HistogramPopulationMaxMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL]),
    fct2Xml.ParameterDescription('HistogramPopulationMaxMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL])
]
description = 'Compute the population of the most populated class'
functionNode = generateXmlElement('Histogram Population Maximum', 'HistogramPopulationMaxMsr', listParams, folder, 'HistogramPopulationMax', description)

# HistogramQuantileMsr
listParams = [
    fct2Xml.ParameterDescription('HistogramQuantileMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL], defaultValue=1),
    fct2Xml.ParameterDescription('HistogramQuantileMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL]),
    fct2Xml.ParameterDescription('HistogramQuantileMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL]),
    fct2Xml.ParameterDescription('HistogramQuantileMsrParams', InputType.SCALAR, constraints=[ScalarConstraint.REAL],defaultValue=25)
]
description = 'Gives the quantile of the intensity histogram'
functionNode = generateXmlElement('Histogram Quantile', 'HistogramQuantileMsr', listParams, folder, 'HistogramQuantile', description)

##################
#     Inertia    #
##################
folder = vrb.folderShapeAnalysis + '/2Intensity/Inertia'

# TODO : Barycenter2d: Outputs
# TODO : Barycenter3d: Outputs

# GreyBarycenterX
listParams = [
]
description = 'Gives the barycenter X weighted by the gray level of each pixel for shape'
functionNode = generateXmlElement('Grey Barycenter X', 'GreyBarycenterXMsr', listParams, folder, 'GreyBarycenterX', description)
# GreyBarycenterY
listParams = [
]
description = 'Gives the barycenter Y weighted by the gray level of each pixel for shape'
functionNode = generateXmlElement('Grey Barycenter Y', 'GreyBarycenterYMsr', listParams, folder, 'GreyBarycenterY', description)
# GreyBarycenterZ
listParams = [
]
description = 'Gives the barycenter Z weighted by the gray level of each pixel for shape'
functionNode = generateXmlElement('Grey Barycenter Z', 'GreyBarycenterZMsr', listParams, folder, 'GreyBarycenterZ', description, '3D')
# GreyInertiaLambdaInterMsr
listParams = [
]
description = 'Measure allowing to compute the intermediary eigen value from the second order moment matrix computed from the GreyInertia measurement for shape'
functionNode = generateXmlElement('Grey Inertia Lambda Inter 3D', 'GreyInertiaLambdaInterMsr', listParams, folder, 'GreyInertiaLambdaInter', description, '3D')
# GreyInertiaOrientationAlphaMsr
listParams = [
]
description = "Measure allowing to compute the shape 3d orientation (alpha component) from the second order moment matrix computed from the GreyInertia measurement for shape"
functionNode = generateXmlElement('Grey Inertia Orientation Alpha 3D', 'GreyInertiaOrientationAlphaMsr', listParams, folder, 'GreyInertiaOrientationAlpha', description, '3D')
# GreyInertiaOrientationBetaMsr
listParams = [
]
description = "Measure allowing to compute the shape 3d orientation (beta component) from the second order moment matrix computed from the GreyInertia measurement for shape"
functionNode = generateXmlElement('Grey Inertia Orientation Beta 3D', 'GreyInertiaOrientationBetaMsr', listParams, folder, 'GreyInertiaOrientationBeta', description, '3D')
# GreyInertiaOrientationChiMsr
listParams = [
]
description = "Measure allowing to compute the shape 3d orientation (chi component) from the second order moment matrix computed from the GreyInertia measurement for shape"
functionNode = generateXmlElement('Grey Inertia Orientation Chi 3D', 'GreyInertiaOrientationChiMsr', listParams, folder, 'GreyInertiaOrientationChi', description, '3D')
# GreyInertiaLambdaMaxMsr
listParams = [
]
description = "Measure allowing to compute the maximum eigen value from the second order moment matrix computed from the GreyInertia measurement for shape"
functionNode = generateXmlElement('Grey Inertia Lambda Max', 'GreyInertiaLambdaMaxMsr', listParams, folder, 'GreyInertiaLambdaMax', description)
# GreyInertiaLambdaMinMsr
listParams = [
]
description = "Measure allowing to compute the minimum eigen value from the second order moment matrix computed from the GreyInertia measurement for shape"
functionNode = generateXmlElement('Grey Inertia Lambda Min', 'GreyInertiaLambdaMinMsr', listParams, folder, 'GreyInertiaLambdaMin', description)
# GreyInertiaOrientation2dMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the GreyInertia2d measurement for 2d shape"
functionNode = generateXmlElement('Grey Inertia Orientation 2D', 'GreyInertiaOrientation2dMsr', listParams, folder, 'GreyInertiaOrientation2d', description, '2D')

# GreyInertia3dOrientationPhiMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the GreyInertia3d measurement for 3d shape"
functionNode = generateXmlElement('Grey Inertia Orientation 3D Phi', 'GreyInertia3dOrientationPhiMsr', listParams, folder, 'GreyInertia3dOrientationPhi', description, '3D')

# GreyInertia3dOrientationThetaMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the GreyInertia3d measurement for 3d shape"
functionNode = generateXmlElement('Grey Inertia Orientation 3D Theta', 'GreyInertia3dOrientationThetaMsr', listParams, folder, 'GreyInertia3dOrientationTheta', description, '3D')

# GreyInertia3dNormalOrientationPhiMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the GreyInertia3d measurement for 3d shape"
functionNode = generateXmlElement('Grey Inertia Normal Orientation 3D Phi', 'GreyInertia3dNormalOrientationPhiMsr', listParams, folder, 'GreyInertia3dNormalOrientationPhi', description, '3D')

# GreyInertia3dNormalOrientationThetaMsr
listParams = [
]
description = "Measure allowing to compute the shape orientation from the second order moment matrix computed from the GreyInertia3d measurement for 3d shape"
functionNode = generateXmlElement('Grey Inertia Normal Orientation 3D Theta', 'GreyInertia3dNormalOrientationThetaMsr', listParams, folder, 'GreyInertia3dNormalOrientationTheta', description, '3D')

##################
#   Statistics   #
##################
folder = vrb.folderShapeAnalysis + '/2Intensity/Statistics'

# Energy
listParams = [
]
description = 'Measure allowing to compute energy of intensities for shape'
functionNode = generateXmlElement('Energy', 'EnergyMsr', listParams, folder, 'Energy', description, 'Both')

# Entropy
listParams = [
]
description = 'Measure allowing to compute entropy of intensities for shape'
functionNode = generateXmlElement('Entropy', 'EntropyMsr', listParams, folder, 'Entropy', description, 'Both')

# Kurtosis
listParams = [
]
description = 'Measure allowing to compute kurtosis of intensities for shape'
functionNode = generateXmlElement('Kurtosis', 'KurtosisMsr', listParams, folder, 'Kurtosis', description, 'Both')

# Local histogram module
listParams = [
]
description = 'Measure allowing to compute Lowitz local histogram module'
functionNode = generateXmlElement('Local histogram module', 'LocalHistogramModuleMsr', listParams, folder, 'Local histogram module', description, 'Both')

# Mean
listParams = [
]
description = 'Computes the mean of intensities for shape'
functionNode = generateXmlElement('Mean', 'MeanMsr', listParams, folder, 'Mean', description, 'Both')

# Min
listParams = [
]
description = 'Computes the minimum of intensities for shape'
functionNode = generateXmlElement('Minimum', 'MinMsr', listParams, folder, 'Min', description, 'Both')

# Max
listParams = [
]
description = 'Computes the maximum of intensities for shape'
functionNode = generateXmlElement('Maximum', 'MaxMsr', listParams, folder, 'Max', description, 'Both')

# Sum
listParams = [
]
description = 'Computes the sum of intensities for shape'
functionNode = generateXmlElement('Sum', 'SumMsr', listParams, folder, 'Sum', description, 'Both')

# MeanAbs
listParams = [
]
description = 'Computes the mean of absolute intensities for shape'
functionNode = generateXmlElement('Mean Abs', 'MeanAbsMsr', listParams, folder, 'MeanAbs', description, 'Both')

# MinAbs
listParams = [
]
description = 'Computes the minimum of absolute intensities for shape'
functionNode = generateXmlElement('Minimum Abs', 'MinAbsMsr', listParams, folder, 'MinAbs', description, 'Both')

# MaxAbs
listParams = [
]
description = 'Computes the maximum of absolute intensities for shape'
functionNode = generateXmlElement('Maximum Abs', 'MaxAbsMsr', listParams, folder, 'MaxAbs', description, 'Both')

# SumAbs
listParams = [
]
description = 'Computes the sum of absolute intensities for shape'
functionNode = generateXmlElement('SumAbs', 'SumAbsMsr', listParams, folder, 'SumAbs', description, 'Both')

# Median
listParams = [
]
description = 'Measure allowing to compute median of intensities for shape'
functionNode = generateXmlElement('Median', 'MedianMsr', listParams, folder, 'Median', description, 'Both')

# Variance
listParams = [
]
description = 'Computes the variance of intensities for shape'
functionNode = generateXmlElement('Variance', 'VarianceMsr', listParams, folder, 'Variance', description, 'Both')

# Skewness
listParams = [
]
description = 'Measure allowing to compute skewness of intensities for shape'
functionNode = generateXmlElement('Skewness', 'SkewnessMsr', listParams, folder, 'Skewness', description, 'Both')

# StdDev
listParams = [
]
description = 'Measure allowing to compute standard deviation of intensities for shape'
functionNode = generateXmlElement('StdDev', 'StdDevMsr', listParams, folder, 'StdDev', description, 'Both')

# SumSquare
listParams = [
]
description = 'Measure allowing to compute sum of squares of intensities for shape'
functionNode = generateXmlElement('SumSquare', 'SumSquareMsr', listParams, folder, 'SumSquare', description, 'Both')

##################
#     Custom     #
##################
try:
    os.makedirs(vrb.folderShapeAnalysis + '/3Custom/Logic')
    os.makedirs(vrb.folderShapeAnalysis + '/3Custom/Arithmetic')
except:
    pass

# docLink.updateAllLinkInXmlElement(vrb.folderShapeAnalysis)
