import os
import platform

import PyIPSDK

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import scriptsCreation._DocumentationLinker as docLink

from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, MeasureInfoSetConstraint, SelectorType, FunctionDimension

import UsefullVariables as vrb

def removeObsoleteFunctions():

    functionsList = ["GlobalMeasure/HistogramMaskMsr2d","GlobalMeasure/HistogramMaskMsr3d","GlobalMeasure/StatsMaskMsr2d","GlobalMeasure/StatsMaskMsr3d",
                     "Binarization/IsoDataThreshold","Binarization/KapurThreshold","Binarization/KittlerThreshold","Binarization/OtsuThreshold",
                     "FeatureDetection/HoughCircles2dImg","FeatureDetection/HoughCirclesPhaseCoded2dImg","Registration/ExtractVectorialField"]
    functionsListLinux = ["ColorOperation/lightnessImg", "Geometric/flipXImg", "Geometric/flipYImg", "Geometric/flipZImg",
                          "AdvMorphology/binaryReconstruction2dImg", "AdvMorphology/binaryReconstruction3dImg", "ShapeSegmentation/labelShapeExtraction2d",
                          "ShapeSegmentation/labelShapeExtraction3d"]
    for functionFilename in functionsList:
        try:
            filename = vrb.folderFunctions + "/" + functionFilename + ".mho"
            if os.path.exists(filename):
                os.remove(filename)
        except:
            pass

    if platform.system() == 'Linux':
        for functionFilename in functionsListLinux:
            try:
                filename = vrb.folderFunctions + "/" + functionFilename + ".mho"
                if os.path.exists(filename):
                    os.remove(filename)
            except:
                pass

def updateInfosets():

    try:
        folderInfoSet = vrb.folderUserData + '/InfoSet'
        for fileName in os.listdir(folderInfoSet):
            filePath = folderInfoSet + '/' + fileName
            file = xmlet.parse(filePath)
            xmlElement = file.getroot()

            try:
                dimension = xmlElement.get('Dimension')
            except:
                dimension = "2D"

            element = Dfct.createInfosetXmlElement(dimension)
            Dfct.updateInfosetXmlElement(element, xmlElement)

            Dfct.saveXmlElement(element, folderInfoSet + '/' + fileName)

    except:
        pass


def generateXmlElement(niceName, realName, listParams, listOutputs, savePath=None, docTitle=None, tags=None, dimension=None,favorite=False):
    functionNode = xmlet.Element('Function')
    if dimension is None:
        if '2D' in niceName.upper() and '2D' in realName.upper():
            dimension = FunctionDimension.TWO_DIMENSIONS
        elif '3D' in niceName.upper() and '3D' in realName.upper():
            dimension = FunctionDimension.THREE_DIMENSIONS
        else:
            dimension = FunctionDimension.BOTH
        #print('[WARNING]: inferred dimension for ' + realName + ': ' + dimension.value)
    functionNode.set('Dimension', dimension.value)

    Dfct.SubElement(functionNode, 'Name').text = niceName
    Dfct.SubElement(functionNode, 'FunctionName').text = realName
    if docTitle is not None:
        Dfct.SubElement(functionNode, 'DocTitle').text = docTitle
    if tags is not None:
        tagsNode = Dfct.SubElement(functionNode, 'Tags')
        tagsText = ''
        for tag in tags:
            tagsText += str(tag) + ','
        tagsNode.text = tagsText[:-1]
    if favorite:
        Dfct.SubElement(functionNode, 'Favorite').text = "True"
    else:
        Dfct.SubElement(functionNode, 'Favorite').text = "False"

    paramsNode = Dfct.SubElement(functionNode, 'Parameters')
    for nb, param in enumerate(listParams, 0):
        insertParameterNode(paramsNode, nb, param)
    outputsNode = Dfct.SubElement(functionNode, 'Outputs')
    for nb, output in enumerate(listOutputs, 0):
        outputNode = Dfct.SubElement(outputsNode, 'Output_' + str(nb))
        Dfct.SubElement(outputNode, 'Name').text = output.name
        Dfct.SubElement(outputNode, 'Type').text = output.type.value
        Dfct.SubElement(outputNode, 'Mandatory').text = str(output.isMandatory)
    if savePath is not None:
        try:
            file = xmlet.parse(savePath + '/' + realName + '.mho')
            element = file.getroot()
            if Dfct.SubElement(element, 'Favorite').text == "True":
                Dfct.SubElement(functionNode, 'Favorite').text = "True"
            elif Dfct.SubElement(element, 'Favorite').text == "False":
                Dfct.SubElement(functionNode, 'Favorite').text = "False"
        except:
            pass

        Dfct.saveXmlElement(functionNode, savePath + '/' + realName + '.mho')
    return functionNode


def insertParameterNode(parent, num, param):
    paramNode = Dfct.SubElement(parent, 'Parameter_' + str(num))
    Dfct.SubElement(paramNode, 'Name').text = param.name
    Dfct.SubElement(paramNode, 'Type').text = param.type.value
    # Constraints
    constraintsNode = Dfct.SubElement(paramNode, 'Constraints')
    text = ''
    if param.constraints is not None:
        for constraint in param.constraints:
            text += constraint.value + ','
    constraintsNode.text = text[0: len(text) - 1]
    # Default value

    if isinstance(param.defaultValue,list):
        defaultValue = ""
        for i in range(len(param.defaultValue)):
            if i != len(param.defaultValue)-1:
                defaultValue+= str(param.defaultValue[i]) + ","
            else:
                defaultValue += str(param.defaultValue[i])
    else:
        if param.defaultValue is not None:
            defaultValue = str(param.defaultValue)
        else:
            defaultValue = ""

    Dfct.SubElement(paramNode, 'Default').text = defaultValue
    #Dfct.SubElement(paramNode, 'Default').text = (str(param.defaultValue), '')[param.defaultValue is None]
    # Mandatory
    Dfct.SubElement(paramNode, 'Mandatory').text = str(param.isMandatory)

    # Advanced parameters
    param.insertAdditional(paramNode)


class OutputDescription:
    def __init__(self, name, _type, isMandatory=True):
        self.name = name
        self.type = _type
        self.isMandatory = isMandatory


class ParameterDescription:
    def __init__(self, name, _type, constraints=None, defaultValue=None, isMandatory=True):
        self.name = name
        self.type = _type
        self.constraints = constraints
        self.defaultValue = defaultValue
        self.isMandatory = isMandatory

    def insertAdditional(self, parent):
        # nothing to do
        pass


class SelectorParameterDescription(ParameterDescription):
    def __init__(self, name, _type=InputType.SELECTOR, constraints=None, defaultValue=None, isMandatory=True, selectorType=None, textWhileSelecting='', additionalInfoDict=None):
        self.name = name
        self.type = _type
        self.constraints = constraints
        self.selectorType = selectorType
        self.defaultValue = defaultValue
        self.isMandatory = isMandatory
        self.textWhileSelecting = textWhileSelecting
        self.additionalInfoDict = additionalInfoDict

    def insertAdditional(self, parent):
        selectorNode = Dfct.SubElement(parent, 'Selector')
        Dfct.SubElement(selectorNode, 'Text').text = self.textWhileSelecting
        Dfct.SubElement(selectorNode, 'SelectorType').text = self.selectorType.value
        if self.additionalInfoDict is not None:
            for info in self.additionalInfoDict.keys():
                Dfct.SubElement(selectorNode, info).text = self.additionalInfoDict[info]


class EnumParameterDescription(ParameterDescription):
    def __init__(self, name, _type=InputType.ENUM, constraints=None, defaultValue=None, isMandatory=True, enumList=None):
        self.name = name
        self.type = _type
        self.constraints = constraints
        self.defaultValue = defaultValue
        self.isMandatory = isMandatory
        self.enumList = enumList

    def insertAdditional(self, parent):
        # enum list
        if self.enumList is not None:
            nameListNode = Dfct.SubElement(parent, 'List')
            text = ''
            for elem in self.enumList:
                text += str(elem) + ','
            nameListNode.text = text[0: len(text) - 1]


class AdvancedEnumParameterDescription(ParameterDescription):
    def __init__(self, name, _type=InputType.ADVANCED, constraints=None, defaultValue=None, isMandatory=True, usernameList=None, nameList=None, parametersDescriptionsList=None, special=None):
        self.name = name
        self.type = _type
        self.constraints = constraints
        self.defaultValue = defaultValue
        self.isMandatory = isMandatory
        self.userNameList = usernameList
        self.nameList = nameList
        self.parametersDescriptionsList = parametersDescriptionsList
        self.special = special

    def insertAdditional(self, parent):
        advancedEnumNode = Dfct.SubElement(parent, 'AdvancedEnum')
        if self.special:
            advancedEnumNode.set('Special', self.special)
        for nbEnum, parameterDescriptionList in enumerate(self.parametersDescriptionsList, 0):
            enumNode = Dfct.SubElement(advancedEnumNode, 'Enum_' + str(nbEnum))
            enumNode.set('Name', self.nameList[nbEnum])
            enumNode.set('UserName', self.userNameList[nbEnum])
            for nbParam, param in enumerate(parameterDescriptionList, 0):
                insertParameterNode(enumNode, nbParam, param)
        return advancedEnumNode


class UserParameterDescription(ParameterDescription):
    def __init__(self, name, _type, constraints=None, defaultValue=None, isMandatory=True, additional=None):
        super().__init__(name, _type, constraints, defaultValue, isMandatory)
        self.additional = additional

    def insertAdditional(self, parent):
        parent.append(self.additional)


def kernel2DParameterDescription(name='Convolution Element'):
    return UserParameterDescription(name, InputType.KERNEL_2D, additional=xmlet.parse(vrb.folderInformation + '/defaultKernel.mho').getroot())

listUserName = ['Circular', 'Square', 'Rectangle', 'Linear', 'Half-Linear']
listName = ['Circular', 'Square', 'Rectangular', 'Linear', 'SemiLinear']
parametersDescriptionsCircular = [
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsSquare = [
    ParameterDescription('Size', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsRectangular = [
    ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True),
    ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsLinear = [
    ParameterDescription('Angle (degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Size', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsSemiLinear = [
    ParameterDescription('Angle(degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Size', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsList = [parametersDescriptionsCircular, parametersDescriptionsSquare, parametersDescriptionsRectangular, parametersDescriptionsLinear, parametersDescriptionsSemiLinear]
structuringElem2DParameterDescription = AdvancedEnumParameterDescription('Structuring Element', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList, special='StructuringElement2D')

listUserName = ['Spherical', 'Cubic', 'Rectangular', 'Linear', 'Half-Linear']
listName = ['Spherical', 'Cubic', 'Rectangular', 'Linear', 'Half-Linear']
parametersDescriptionsSpherical = [
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsCubic = [
    ParameterDescription('Half size', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsRectangular = [
    ParameterDescription('Half size X', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True),
    ParameterDescription('Half size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True),
    ParameterDescription('Half size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsLinear = [
    ParameterDescription('Angle Theta (degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Angle Phi (degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Radius length', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsSemiLinear = [
    ParameterDescription('Angle Theta (degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Angle Phi (degree)', InputType.SCALAR, [ScalarConstraint.REAL], 0, True),
    ParameterDescription('Radius length', InputType.SCALAR, [ScalarConstraint.NATURAL], 3, True)
]
parametersDescriptionsList = [parametersDescriptionsSpherical, parametersDescriptionsCubic, parametersDescriptionsRectangular, parametersDescriptionsLinear, parametersDescriptionsSemiLinear]
structuringElem3DParameterDescription = AdvancedEnumParameterDescription('Structuring Element', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList, special='StructuringElement3D')



eImageBufferTypeList = [PyIPSDK.eImageBufferType.eIBT_Int8, PyIPSDK.eImageBufferType.eIBT_UInt8, PyIPSDK.eImageBufferType.eIBT_Int16, PyIPSDK.eImageBufferType.eIBT_UInt16,
                        PyIPSDK.eImageBufferType.eIBT_Int32, PyIPSDK.eImageBufferType.eIBT_UInt32, PyIPSDK.eImageBufferType.eIBT_Real32, PyIPSDK.eImageBufferType.eIBT_Binary,PyIPSDK.eImageBufferType.eIBT_Label8,
                        PyIPSDK.eImageBufferType.eIBT_Label16, PyIPSDK.eImageBufferType.eIBT_Label32]

eImageBufferTypeListIntOrReal = [PyIPSDK.eImageBufferType.eIBT_Int8, PyIPSDK.eImageBufferType.eIBT_UInt8, PyIPSDK.eImageBufferType.eIBT_Int16, PyIPSDK.eImageBufferType.eIBT_UInt16,
                        PyIPSDK.eImageBufferType.eIBT_Int32, PyIPSDK.eImageBufferType.eIBT_UInt32, PyIPSDK.eImageBufferType.eIBT_Real32]
