import os
import sys

import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet
import UsefullVariables as vrb

# Once the analysis of all files has been done one time, this contains the link between the title and the path
dictAllPages = {}
dictAllPagesCore = {}

def findPageInDocumentation(title, folder=None):
    """
    Looks in all files of folder if the title of the page contains title and returns its path
    :param title: String corresponding to the title of the page
    :param folder: Folder of the doc
    :return: A string equals to the paths if found, None otherwise
    """

    if folder is None or folder == vrb.folderDoc:
        if len(dictAllPages) == 0:
            if folder is None:
                folder = vrb.folderDoc
            startMarker = '<title>IPSDK: '
            endMarker = '</title>'

            nbFile = 0
            nbHTML = 0

            for fileName in os.listdir(folder):
                try:
                    filePath = folder + '/' + fileName
                    nbFile += 1
                    if str.endswith(filePath, '.html'):
                        nbHTML += 1
                        file = open(filePath)
                        for line in file:
                            if startMarker in line and endMarker in line:
                                text = line.replace(startMarker, '').replace(endMarker, '').replace('\n', '')
                                dictAllPages[text] = filePath
                                break
                        file.close()
                except:
                    pass

            print('Analyzed :', nbFile, 'files (', nbHTML, 'html)', file=sys.stderr)

        return dictAllPages.get(title, None)

    elif folder == vrb.folderDocCore:
        if len(dictAllPagesCore) == 0:
            if folder is None:
                folder = vrb.folderDoc
            startMarker = '<title>IPSDK: '
            endMarker = '</title>'

            nbFile = 0
            nbHTML = 0

            for fileName in os.listdir(folder):
                try:
                    filePath = folder + '/' + fileName
                    nbFile += 1
                    if str.endswith(filePath, '.html'):
                        nbHTML += 1
                        file = open(filePath)
                        for line in file:
                            if startMarker in line and endMarker in line:
                                text = line.replace(startMarker, '').replace(endMarker, '').replace('\n', '')
                                dictAllPagesCore[text] = filePath
                                break
                        file.close()
                except:
                    pass

            print('Analyzed :', nbFile, 'files (', nbHTML, 'html)', file=sys.stderr)

        return dictAllPagesCore.get(title, None)


def updateLinkInXmlElement(xmlElementPath):
    """
    Takes a MHO file which is a function description and adds the path to the doc
    :param xmlElementPath: paths of the MHO file we want to append a link to doc
    """

    try:
        if xmlElementPath.endswith('.mho'):
            xmlElement = xmlet.parse(xmlElementPath).getroot()
            if xmlElement.tag == 'Function' or xmlElement.tag == 'Measure':
                title = Dfct.childText(xmlElement, 'DocTitle')
                if title is not None:
                    page = findPageInDocumentation(title)
                    if page is None:
                        page = findPageInDocumentation(title,folder=vrb.folderDocCore)
                    # if page is None:
                    #     print('No page found for', title, file=sys.stderr)
                    if page is not None:
                        page = page.split('/')[-1]
                        Dfct.SubElement(xmlElement, 'DocPath').text = page
                        Dfct.saveXmlElement(xmlElement, xmlElementPath)
    except:
        print("Can't save : ",xmlElementPath)

def updateLinkInXmlElementMeasure(xmlElementPath,elementRef):
    """
    Takes a MHO file which is a function description and adds the path to the doc
    :param xmlElementPath: paths of the MHO file we want to append a link to doc
    """

    try:
        if xmlElementPath.endswith('.mho'):
            xmlElement = xmlet.parse(xmlElementPath).getroot()
            if xmlElement.tag == 'Measure':
                title = Dfct.childText(xmlElement, 'DocTitle')
                if title is not None:
                    page = findPageInDocumentation(title)
                    if page is None:
                        print('No page found for', title, file=sys.stderr)
                    else:
                        page = page.split('/')[-1]
                        objectElement = Dfct.SubElement(xmlElement,"Object")
                        name = Dfct.childText(objectElement,"Name")
                        measureElement = Dfct.SubElement(elementRef,name)
                        measureElement.text = page

    except:
        print("Can't save : ",xmlElementPath)

def updateAllLinkInXmlElement(folder=None):
    """
    Recursive : Updates every file MHO in every repertory with its doc
    :param folder: where to start to search for files
    """
    for fileName in os.listdir(folder):
        filePath = folder + '/' + fileName
        if os.path.isdir(filePath):
            updateAllLinkInXmlElement(filePath)
        else:
            updateLinkInXmlElement(filePath)

def updateAllLinkInXmlElementMeasure(folder,xmlElement):
    """
    Recursive : Updates every file MHO in every repertory with its doc
    :param folder: where to start to search for files
    """
    for fileName in os.listdir(folder):
        filePath = folder + '/' + fileName
        if os.path.isdir(filePath):
            updateAllLinkInXmlElementMeasure(filePath,xmlElement)
        else:
            updateLinkInXmlElementMeasure(filePath,xmlElement)


def createDirectoryLinks(folder):
    xmlElement = xmlet.Element('Directories')
    shapeAnalysisNode = Dfct.SubElement(xmlElement, 'ShapeAnalysis')
    geoNode = Dfct.SubElement(shapeAnalysisNode, 'Geometry')
    geoNode.text = findPageInDocumentation('Geometry').split('/')[-1]

    Dfct.SubElement(geoNode, 'Basic').text = findPageInDocumentation('Basic').split('/')[-1]
    Dfct.SubElement(geoNode, 'BoundingBox').text = findPageInDocumentation('BoundingBox').split('/')[-1]
    Dfct.SubElement(geoNode, 'ConvexHull').text = findPageInDocumentation('ConvexHull').split('/')[-1]
    Dfct.SubElement(geoNode, 'Fitting').text = findPageInDocumentation('Fitting').split('/')[-1]
    Dfct.SubElement(geoNode, 'FormFactor').text = findPageInDocumentation('FormFactor').split('/')[-1]
    Dfct.SubElement(geoNode, 'Angularity').text = findPageInDocumentation('FormFactor').split('/')[-1]
    Dfct.SubElement(geoNode, 'Inertia').text = findPageInDocumentation('Inertia').split('/')[-1]
    Dfct.SubElement(geoNode, 'Matching').text = findPageInDocumentation('Matching').split('/')[-1]
    Dfct.SubElement(geoNode, 'Metrology').text = findPageInDocumentation('Metrology').split('/')[-1]
    Dfct.SubElement(geoNode, 'Neighborhood').text = findPageInDocumentation('Neighborhood').split('/')[-1]
    Dfct.SubElement(geoNode, 'Oriented_Bounding_Box').text = findPageInDocumentation('Oriented Bounding Box').split('/')[-1]
    Dfct.SubElement(geoNode, 'Porosity').text = findPageInDocumentation('Porosity').split('/')[-1]
    Dfct.SubElement(geoNode, 'Skeleton').text = findPageInDocumentation('Skeleton').split('/')[-1]

    intensityNode = Dfct.SubElement(shapeAnalysisNode, 'Intensity')
    intensityNode.text = findPageInDocumentation('Intensity').split('/')[-1]
    Dfct.SubElement(intensityNode, 'Histogram').text = findPageInDocumentation('Histogram').split('/')[-1]
    Dfct.SubElement(intensityNode, 'Inertia').text = findPageInDocumentation('Inertia').split('/')[-1]
    Dfct.SubElement(intensityNode, 'Statistics').text = findPageInDocumentation('Statistics').split('/')[-1]

    customNode = Dfct.SubElement(shapeAnalysisNode, 'Custom')
    customNode.text = findPageInDocumentation('Formula').split('/')[-1]
    Dfct.SubElement(customNode, 'Arithmetic').text = findPageInDocumentation('Arithmetic Formula').split('/')[-1]
    Dfct.SubElement(customNode, 'Logic').text = findPageInDocumentation('Logic Formula').split('/')[-1]

    Dfct.saveXmlElement(xmlElement, folder)

def machineLearningModuleDocs():

    xmlElement = xmlet.Element('MachineLearningDoc')
    smartClassificationElement = Dfct.SubElement(xmlElement, 'SmartClassification')
    smartSegmentationElement = Dfct.SubElement(xmlElement, 'SmartSegmentation')

    folder = vrb.folderDocCore
    startMarker = '<title>IPSDK: '
    endMarker = '</title>'

    found = 0

    for fileName in os.listdir(folder):
        if found <2:
            try:
                filePath = folder + '/' + fileName
                if str.endswith(filePath, '.html'):
                        file = open(filePath)
                        for line in file:
                            if startMarker in line and endMarker in line:
                                text = line.replace(startMarker, '').replace(endMarker, '').replace('\n', '')
                                if text == "Smart classification module":
                                    smartClassificationElement.text = fileName
                                    found += 1
                                if text == "Smart segmentation module":
                                    smartSegmentationElement.text = fileName
                                    found += 1
            except:
                pass

    Dfct.saveXmlElement(xmlElement, vrb.folderInformation + "/MachineLearningDoc.mho")


def createAllDocs():
    vrb.printDebug('Creation doc functions')
    updateAllLinkInXmlElement(vrb.folderFunctions)
    vrb.printDebug('Creation doc shape analysis')
    try:
        file = xmlet.parse(vrb.folderInformation + "/DocMeasure.mho")
        docMeasureElement = file.getroot()
    except:
        docMeasureElement = xmlet.Element('DocMeasure')
    updateAllLinkInXmlElementMeasure(vrb.folderShapeAnalysis,docMeasureElement)
    Dfct.saveXmlElement(docMeasureElement, vrb.folderInformation + "/DocMeasure.mho")
    vrb.printDebug('Creation directory links')
    createDirectoryLinks(vrb.folderInformation + '/DirectoryLinks.mho')
    machineLearningModuleDocs()

# if __name__ == '__main__':
#     createAllDocs()
