from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, eImageBufferTypeListIntOrReal
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

###################
#     Utility     #
###################
folder = vrb.folderFunctions + '/Utility'

# TODO : Concatenation of 2 sequences

# Build Lines 2d
listUserName = ['From geometry', 'From image']
listName = ['Geometry', 'Image']
parametersDescriptionsGeometry = [
    ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100)
]
parametersDescriptionsImage = [
    ParameterDescription('Reference image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
]
parametersDescriptionsList = [parametersDescriptionsGeometry, parametersDescriptionsImage]
listParams = [
    AdvancedEnumParameterDescription('Geometry', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList),
    ParameterDescription('Orientation (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=20)
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('Build Lines 2D', 'BuildLines2dImg', listParams, listOutputs, folder, docTitle='Build 2D Lines',favorite=False)

# Build Lines 3d
listUserName = ['From geometry', 'From image']
listName = ['Geometry', 'Image']
parametersDescriptionsGeometry = [
    ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100)
]
parametersDescriptionsImage = [
    ParameterDescription('Reference image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
]
parametersDescriptionsList = [parametersDescriptionsGeometry, parametersDescriptionsImage]
listParams = [
    AdvancedEnumParameterDescription('Geometry', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList),
    ParameterDescription('Theta (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Phi (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Alpha (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=20)
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('Build Lines 3D', 'BuildLines3dImg', listParams, listOutputs, folder, docTitle='Build 3D Lines',favorite=False)

# Copy
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Copy', 'CopyImg', listParams, listOutputs, folder, docTitle='Copy',favorite=True)

# TODO : Comparison

# Convert
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    EnumParameterDescription('Output type', defaultValue=1, enumList=eImageBufferTypeList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Convert Image', 'ConvertImg', listParams, listOutputs, folder, docTitle='Convert',favorite=True)

# Erase
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Erase value', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0)
]
listOutputs = [OutputDescription('Erased image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Erase Image', 'EraseImg', listParams, listOutputs, folder, docTitle='Erase')

# TODO : Extract image 2d values
# TODO : Extract image 3d values

# Normal Random
listUserName = ['Image', 'Geometry']
listName = ['Image', 'Geometry']
parametersDescriptions0 = [ParameterDescription('Image', InputType.IMAGE)]
parametersDescriptions1 = [EnumParameterDescription('Output type', defaultValue=1, enumList=eImageBufferTypeListIntOrReal),ParameterDescription('SizeX', InputType.SCALAR,[ScalarConstraint.NATURAL], defaultValue=100),
                           ParameterDescription('SizeY', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),ParameterDescription('SizeZ', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100,isMandatory=False)]
listParams = [
    AdvancedEnumParameterDescription('Reference element', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[parametersDescriptions0, parametersDescriptions1]),
    ParameterDescription('Mean', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=100),
    ParameterDescription('Standard Deviation', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=25)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Generate normal random image', 'GaussianRandomImg', listParams, listOutputs, folder, docTitle='Normal random')

# Get 2d ROI
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Offset X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Width', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10),
    ParameterDescription('Height', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Get ROI 2D', 'GetROI2dImg', listParams, listOutputs, folder, docTitle='Get 2d ROI',favorite=True)

# Get 3d ROI
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Offset X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10),
    ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10),
    ParameterDescription('Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Get ROI 3D', 'GetROI3dImg', listParams, listOutputs, folder, docTitle='Get 3d ROI',favorite=True)

# Put 2d ROI
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('ROI', InputType.IMAGE),
    ParameterDescription('Offset X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Put ROI 2D', 'PutROI2dImg', listParams, listOutputs, folder, docTitle='Put 2d ROI',favorite=True)

# Put 3d ROI
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('ROI', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Offset X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Offset Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Put ROI 3D', 'PutROI3dImg', listParams, listOutputs, folder, docTitle='Put 3d ROI',favorite=True)

# Uniform random
listUserName = ['Image', 'Geometry']
listName = ['Image', 'Geometry']
parametersDescriptions0 = [ParameterDescription('Image', InputType.IMAGE)]
parametersDescriptions1 = [EnumParameterDescription('Output type', defaultValue=1, enumList=eImageBufferTypeListIntOrReal),ParameterDescription('SizeX', InputType.SCALAR,[ScalarConstraint.NATURAL], defaultValue=100),
                           ParameterDescription('SizeY', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),ParameterDescription('SizeZ', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100,isMandatory=False)]
listParams = [
    AdvancedEnumParameterDescription('Reference element', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[parametersDescriptions0, parametersDescriptions1]),
    ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=255)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Generate uniform random image', 'RandomImg', listParams, listOutputs, folder, docTitle='Uniform Random')

# Extract Plan
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Z Value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
    ParameterDescription('Channel Value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0,isMandatory=False),
    ParameterDescription('Sequence Value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Extract Plan', 'ExtractPlan', listParams, listOutputs, folder,docTitle="Manipulating sub-parts of images",favorite=True)

# Create Image
listParams = [
    ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1000),
    ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1000),
    ParameterDescription('Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1),
    ParameterDescription('Size T', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1),
    ParameterDescription('Size C', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1),
    EnumParameterDescription('Buffer Type', enumList=eImageBufferTypeList,defaultValue=1),
    ParameterDescription('Value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Create Image', 'CreateImage', listParams, listOutputs, folder,docTitle="Basic image manipulation")

# Put slice
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Slice', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
    EnumParameterDescription('Axis', InputType.ENUM, enumList=["eA_X", "eA_Y", "eA_Z"], defaultValue=0),
    ParameterDescription('Slice index', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Put Slice', 'PutSlice3dImg', listParams, listOutputs, folder, docTitle='Put a 2d image in a 3d image',favorite=True)

# Get slice
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Axis', InputType.ENUM, enumList=["eA_X", "eA_Y", "eA_Z"], defaultValue=0),
    ParameterDescription('Slice index', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Get Slice', 'GetSlice3dImg', listParams, listOutputs, folder, docTitle='Get a slice from a 3d image',favorite=True)


# Reinterpret Geometry
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    EnumParameterDescription('Reinterpret', InputType.ENUM, enumList=["Volume <-> Sequence",
                                                                      "Volume <-> Multi-channel",
                                                                      "Sequence <-> Multi-channel"], defaultValue=0)]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Reinterpret Geometry', 'ReinterpretGeometry', listParams, listOutputs, folder, docTitle='Reinterprets the geometry of an input dataset',favorite=False)


# Append Sequence
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Append Sequence', 'AppendSeqImg', listParams, listOutputs, folder, docTitle='Concatenation of 2 sequences',favorite=False)

#LabelToColorImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL])
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('Label to color image', 'LabelToColorImg', listParams, listOutputs, folder, docTitle='Label to color image',favorite=False)