from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

###################
#    Statistics   #
###################

folder = vrb.folderFunctions + '/Statistics'

# Kurtosis 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Kurtosis 2D', 'Kurtosis2dImg', listParams, listOutputs, folder, docTitle='Kurtosis 2d',favorite=True)

# Kurtosis 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Kurtosis 3D', 'Kurtosis3dImg', listParams, listOutputs, folder, docTitle='Kurtosis 3d',favorite=True)

# Local Energy 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Energy 2D', 'LocalEnergy2dImg', listParams, listOutputs, folder, docTitle='Local Energy 2d',favorite=True)

# Local Energy 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Energy 3D', 'LocalEnergy3dImg', listParams, listOutputs, folder, docTitle='Local Energy 3d',favorite=True)

# Local Entropy 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Entropy 2D', 'LocalEntropy2dImg', listParams, listOutputs, folder, docTitle='Local Entropy 2d',favorite=True)

# Local Entropy 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Entropy 3D', 'LocalEntropy3dImg', listParams, listOutputs, folder, docTitle='Local Entropy 3d',favorite=True)

# Local Histogram Module 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Histogram Module 2D', 'LocalHistogramModule2dImg', listParams, listOutputs, folder, docTitle='Local histogram module 2d')

# Local Histogram module 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Number of classes', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=16, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Histogram Module 3D', 'LocalHistogramModule3dImg', listParams, listOutputs, folder, docTitle='Local histogram module 3d')

# Skewness 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Skewness 2D', 'Skewness2dImg', listParams, listOutputs, folder, docTitle='Skewness 2d')

# Skewness 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Skewness 3D', 'Skewness3dImg', listParams, listOutputs, folder, docTitle='Skewness 3d')

# Variance 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Variance 2D', 'Variance2dImg', listParams, listOutputs, folder, docTitle='Variance 2d',favorite=True)

# Variance  3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Variance 3D', 'Variance3dImg', listParams, listOutputs, folder, docTitle='Variance 3d',favorite=True)

### Law's 2D Texture
### Law's 3D Texture