from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, ShapeConstraints
import UsefullVariables as vrb

import PyIPSDK

######################
# Shape segmentation #
######################
folder = vrb.folderFunctions + '/ShapeSegmentation'

# Label Shape Extraction 2d
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Approximation', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5,isMandatory=False)
]

listOutputs = [OutputDescription('Output name', OutputType.SHAPES)]
functionNode = generateXmlElement('Label Shape Extraction 2D', 'LabelShapeExtraction2d', listParams, listOutputs, folder, docTitle='Label shape extraction 2d',favorite=True)

# Label Shape Extraction 3d
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Approximation', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0,isMandatory=False),
    ParameterDescription('Simplification ratio', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.9,isMandatory=False),
    ParameterDescription('Min number of triangles', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1000,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.SHAPES)]
functionNode = generateXmlElement('Label Shape Extraction 3D', 'LabelShapeExtraction3d', listParams, listOutputs, folder, docTitle='Label shape extraction 3d',favorite=True)

# Shape to label 2d image
listParams = [
    ParameterDescription('Shape 2D', InputType.SHAPES, [ShapeConstraints.TWO_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Shape to Label 2D', 'ShapeToLabel2dImg', listParams, listOutputs, folder, docTitle='Shape to label 2d image')

# Shape to label 3d image
listParams = [
    ParameterDescription('Shape 3D', InputType.IMAGE, [ImageConstraint.MESH])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Shape to Label 3D', 'ShapeToLabel3dImg', listParams, listOutputs, folder, docTitle='Shape to label 3d image')