from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, MeasureInfoSetConstraint
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, ShapeConstraints
import UsefullVariables as vrb

import PyIPSDK

###################
#  Shape analysis #
###################
folder = vrb.folderFunctions + '/ShapeAnalysis'

# Label Ananlysis 2d
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [], isMandatory=False),
    ParameterDescription('Measures', InputType.MEASURE_INFO_SET, [MeasureInfoSetConstraint.TWO_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.SHAPE_ANALYSIS)]
functionNode = generateXmlElement('Label Analysis 2D', 'LabelAnalysis2d', listParams, listOutputs, folder, docTitle='Label Analysis 2d',favorite=True)

# Label analysis 3d
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS], isMandatory=False),
    ParameterDescription('Measures', InputType.MEASURE_INFO_SET, [MeasureInfoSetConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Approximation', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0, isMandatory=False),
    ParameterDescription('Simplification ratio', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.9, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.SHAPE_ANALYSIS)]
functionNode = generateXmlElement('Label Analysis 3D', 'LabelAnalysis3d', listParams, listOutputs, folder, docTitle='Label Analysis 3d',favorite=True)

# Shape Ananlysis 2d
listParams = [
    ParameterDescription('Shapes', InputType.SHAPES, [ShapeConstraints.TWO_DIMENSIONS]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [], isMandatory=False),
    ParameterDescription('Measures', InputType.MEASURE_INFO_SET, [MeasureInfoSetConstraint.TWO_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.SHAPE_ANALYSIS)]
functionNode = generateXmlElement('Shape Analysis 2D', 'ShapeAnalysis2d', listParams, listOutputs, folder, docTitle='Shape Analysis 2d',favorite=True)

# Shape analysis 3d
listParams = [
    ParameterDescription('Shapes', InputType.IMAGE, [ImageConstraint.MESH]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS], isMandatory=False),
    ParameterDescription('Measures', InputType.MEASURE_INFO_SET, [MeasureInfoSetConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.SHAPE_ANALYSIS)]
functionNode = generateXmlElement('Shape Analysis 3D', 'ShapeAnalysis3d', listParams, listOutputs, folder, docTitle='Shape Analysis 3d',favorite=True)

# Shape filtering 2d

listUserName = ['From filter', 'From formula']
listName = ['Filter', 'Formula']
parametersDescriptionsFilter = [
    EnumParameterDescription('Filter', enumList=['Classic','Custom Arithmetic','Custom Logic']),
    ParameterDescription('Condition', InputType.STRING_EDIT, isMandatory=True)
]
parametersDescriptionsFormula = [
    ParameterDescription('Condition', InputType.STRING_EDIT, isMandatory=True)
]

parametersDescriptionsList = [parametersDescriptionsFilter, parametersDescriptionsFormula]

listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [], isMandatory=False),
    AdvancedEnumParameterDescription('Filtering',InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Shape filtering 2D', 'ShapeFiltering2dImg', listParams, listOutputs, folder, docTitle='Shape Filtering 2d')

# Shape filtering 3d

listUserName = ['From filter', 'From formula']
listName = ['Filter', 'Formula']
parametersDescriptionsFilter = [
    EnumParameterDescription('Filter', enumList=['Classic','Custom Arithmetic','Custom Logic']),
    ParameterDescription('Condition', InputType.STRING_EDIT, isMandatory=True)
]
parametersDescriptionsFormula = [
    ParameterDescription('Condition', InputType.STRING_EDIT, isMandatory=True)
]

parametersDescriptionsList = [parametersDescriptionsFilter, parametersDescriptionsFormula]

listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [], isMandatory=False),
    AdvancedEnumParameterDescription('Filtering',InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Shape filtering 3D', 'ShapeFiltering3dImg', listParams, listOutputs, folder, docTitle='Shape Filtering 3d')

# Label to measure
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Shape analysis', InputType.SHAPE_ANALYSIS),
    EnumParameterDescription('Measure name', enumList=['Classic','Custom Arithmetic','Custom Logic']),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Label to Measure', 'LabelToMeasureImg', listParams, listOutputs, folder)

# Histogram of measure
listParams = [
    ParameterDescription('Shape analysis', InputType.SHAPE_ANALYSIS),
    EnumParameterDescription('Measure name', enumList=['Classic','Custom Arithmetic','Custom Logic']),
    ParameterDescription('Sieve', InputType.SIEVE),
]
listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM_MEASURE)]
functionNode = generateXmlElement('Histogram of Measure', 'HistogramOfMeasure', listParams, listOutputs, folder)