from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

##################
#   Registration   #
##################
folder = vrb.folderFunctions + '/Registration'

# DeepFlow2dImg
listUserName = ['Simple', 'Advanced', 'Complete']
listName = ['Simple', 'Advanced', 'Complete']
simpleList = [
    EnumParameterDescription('Nb Max Layers', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100, isMandatory=False)
]
advancedList = [
    EnumParameterDescription('Nb Max Layers', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    EnumParameterDescription('Fixed point iterations', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=25),
    EnumParameterDescription('Nb SOR iterations', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=5)
]
completeList = [
    EnumParameterDescription('Nb Max Layers', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    EnumParameterDescription('Downscale Factor', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.95),
    EnumParameterDescription('Fixed point iterations', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=25),
    EnumParameterDescription('Nb SOR iterations', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=5),
    EnumParameterDescription('Smoothness', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    EnumParameterDescription('Color consistency', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5),
    EnumParameterDescription('Gradient consistency', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=5),
    EnumParameterDescription('Relaxation factor', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1.6)
]

parametersDescriptionsList = [simpleList, advancedList, completeList]
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE),
    AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]

listOutputs = [OutputDescription('Dx', OutputType.IMAGE),OutputDescription('Dy', OutputType.IMAGE)]
functionNode = generateXmlElement('Deep Flow 2D', 'DeepFlow2dImg', listParams, listOutputs, folder, docTitle='DeepFlow between two 2d images',favorite=True)

# ExtractVectorialField2d
listParams = [
    ParameterDescription('Dx', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    ParameterDescription('Dy', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    ParameterDescription('Spacing', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True)
]
listOutputs = [OutputDescription('Output name', OutputType.VECTORIAL_FILED)]
functionNode = generateXmlElement('Extract vectorial field 2D', 'ExtractVectorialField2d', listParams, listOutputs, folder, docTitle='Extract vectorial field')

# GreySignedFeatures2dRegistrationImg
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
    ParameterDescription('Image 2', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
    EnumParameterDescription('Model', InputType.ENUM,
                             enumList=[PyIPSDK.eRMM2d_Translation, PyIPSDK.eRMM2d_Rigid, PyIPSDK.eRMM2d_Similarity, PyIPSDK.eRMM2d_Homography], defaultValue=2),
    EnumParameterDescription('Interpolation Method', InputType.ENUM,
                             enumList=[PyIPSDK.eIP_NearestNeighbour, PyIPSDK.eIP_Linear, PyIPSDK.eIP_Cubic], defaultValue=1),
    ParameterDescription('Nb points', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100)
]

listOutputs = [OutputDescription('Output name', OutputType.IMAGE),OutputDescription('Transformation name', OutputType.TRANSFORMATION)]
functionNode = generateXmlElement('Feature Image Registration 2D', 'GreySignedFeatures2dRegistrationImg', listParams, listOutputs, folder, docTitle='Image registration using 2D grey signed features',favorite=True)


# StackRegistrationImg
listParams = [
    ParameterDescription('Stack Image 3D', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Theta', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Translation max', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=50)
]

listOutputs = [OutputDescription('Output name', OutputType.IMAGE),OutputDescription('Transformation name', OutputType.STACKTRANSFORMATION)]
functionNode = generateXmlElement('Stack registration 3D', 'StackRegistrationImg', listParams, listOutputs, folder, docTitle='Stack registration',dimension=FunctionDimension.THREE_DIMENSIONS,favorite=False)

# StackRegistrationImg
listParams = [
    ParameterDescription('Stack Image 3D', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Stack transformation 3D', InputType.STACKTRANSFORMATION)
]

# StackRegistrationFromTransformationImg
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Stack registration from 3D transformation', 'StackRegistrationFromTransformationImg', listParams, listOutputs, folder, docTitle='StackRegistrationImg',dimension=FunctionDimension.THREE_DIMENSIONS,favorite=False)
