from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, MeasureInfoSetConstraint
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, ShapeConstraints,MachineLearningConstraint
import UsefullVariables as vrb

import PyIPSDK

import os

###################
#  Shape analysis #
###################
folder = vrb.folderFunctions + '/MachineLearning'

if os.path.exists(folder)==False:
    os.makedirs(folder)

# Pixel classification

# listParams = [
#     ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
#     EnumParameterDescription('Model', enumList=['Classic','Custom Arithmetic','Custom Logic']),
#     ParameterDescription('Memory ratio', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5, isMandatory=False)
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Smart Segmentation', 'PixelClassificationImg', listParams, listOutputs, folder, docTitle='Pixel Classification Random Forest Algorithm')
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    EnumParameterDescription('Model', enumList=['_'],constraints=[MachineLearningConstraint.SMART_SEGMENTATION]),
    ParameterDescription('Memory ratio', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Smart Segmentation', 'PixelClassificationImg', listParams, listOutputs, folder, docTitle='Pixel Classification Random Forest Algorithm',favorite=True)

# Pixel classification with probabilities

listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    EnumParameterDescription('Model', enumList=['_'],constraints=[MachineLearningConstraint.SMART_SEGMENTATION]),
    ParameterDescription('Memory ratio', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE), OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Smart Segmentation With Probabilities', 'PixelClassificationWithProbabilitiesImg', listParams, listOutputs, folder, docTitle='Pixel Classification Random Forest Algorithm')

# Shape classification

listParams = [

    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Optional intensity image', InputType.IMAGE, [], isMandatory=False),
    EnumParameterDescription('Model', enumList=['_'],constraints=[MachineLearningConstraint.SMART_CLASSIFICATION])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Smart Classification', 'ShapeClassificationImg', listParams, listOutputs, folder, docTitle='',favorite=True)

# Super Pixel segmentation

listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    EnumParameterDescription('Model', enumList=['_'],constraints=[MachineLearningConstraint.SMART_SUPER_PIXELS])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Super Pixel Segmentation', 'SuperPixelSegmentationImg', listParams, listOutputs, folder, docTitle='Super Pixel Segmentation Algorithm',favorite=True)