from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

################
#   Logical   #
################
folder = vrb.folderFunctions + '/Logical'

# Bitwise and
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('And', 'BitwiseAndImgImg', listParams, listOutputs, folder, docTitle='Bitwise and',favorite=True)

# Bitwise nand
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Nand', 'BitwiseNandImgImg', listParams, listOutputs, folder, docTitle='Bitwise nand')

# Bitwise nor
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Nor', 'BitwiseNorImgImg', listParams, listOutputs, folder, docTitle='Bitwise nor')

# Logical not
listParams = [
    ParameterDescription('Image Binary', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Not', 'LogicalNotImg', listParams, listOutputs, folder, docTitle='Bitwise not',favorite=True)

# Bitwise nxor
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Nxor', 'BitwiseNxorImgImg', listParams, listOutputs, folder, docTitle='Bitwise nxor')

# Bitwise or
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Or', 'BitwiseOrImgImg', listParams, listOutputs, folder, docTitle='Bitwise or',favorite=True)

# Bitwise exlusive or
listParams = [
    ParameterDescription('Image Binary 1', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary 2', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Exclusive or', 'BitwiseExclusiveOrImgImg', listParams, listOutputs, folder, docTitle='Bitwise exlusive or')

# Difference
listParams = [
    ParameterDescription('Image Binary', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Image Binary to subtract', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Difference', 'DifferenceImgImg', listParams, listOutputs, folder, docTitle='Bitwise Subtraction',favorite=True)

# Mask filter (one input image)
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mask Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Reversed',InputType.BOOLEAN, defaultValue=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Mask filter (one input image)', 'MaskImg', listParams, listOutputs, folder, docTitle='Mask filter (one input image)',favorite=True)

# Mask filter (two input image)
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE),
    ParameterDescription('Mask Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Mask filter (two input images)', 'MaskImgImg', listParams, listOutputs, folder, docTitle='Mask filter (two input images)')

#Logical Not