from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

############################
# Intensity Transformation #
############################
folder = vrb.folderFunctions + '/IntensityTransformation'

#Backward Discrete Fourier Transform 2d
listUserName = ['Default', 'Unitary','Custom']
listName = ['Default', 'Unitary','Custom']
parametersDescriptionsDefault = [
]
parametersDescriptionsUnitary = [
]
parametersDescriptionsCustom = [
    ParameterDescription('Scale Factor X', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Y', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsDefault, parametersDescriptionsUnitary,parametersDescriptionsCustom]

listParams = [
    ParameterDescription('Image 1', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_REAL]),
    ParameterDescription('Image 2', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_REAL]),
    EnumParameterDescription('Coordinates', InputType.ENUM,enumList=[PyIPSDK.eDFTCoordinates.eDFTC_Cartesian,PyIPSDK.eDFTCoordinates.eDFTC_Polar], defaultValue=0),
    EnumParameterDescription('Quadrant Policy', InputType.ENUM,enumList=[PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered,PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native], defaultValue=0),
    AdvancedEnumParameterDescription('Scale Policy', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList,special="ScalePolicy2D")
]

listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Backward Discrete Fourier Transform 2D', 'BackwardDiscreteFourierTransform2dImg', listParams, listOutputs, folder, docTitle='Backward Discrete Fourier Transform 2d',favorite=True)

#Backward Discrete Fourier Transform 3d
listUserName = ['Default', 'Unitary','Custom']
listName = ['Default', 'Unitary','Custom']
parametersDescriptionsDefault = [
]
parametersDescriptionsUnitary = [
]
parametersDescriptionsCustom = [
    ParameterDescription('Scale Factor X', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Y', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Z', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsDefault, parametersDescriptionsUnitary,parametersDescriptionsCustom]

listParams = [
    ParameterDescription('Image 1', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_REAL]),
    ParameterDescription('Image 2', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_REAL]),
    EnumParameterDescription('Coordinates', InputType.ENUM,enumList=[PyIPSDK.eDFTCoordinates.eDFTC_Cartesian,PyIPSDK.eDFTCoordinates.eDFTC_Polar], defaultValue=0),
    EnumParameterDescription('Quadrant Policy', InputType.ENUM,enumList=[PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered,PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native], defaultValue=0),
    AdvancedEnumParameterDescription('Scale Policy', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList,special="ScalePolicy3D")
]

listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Backward Discrete Fourier Transform 3D', 'BackwardDiscreteFourierTransform3dImg', listParams, listOutputs, folder, docTitle='Backward Discrete Fourier Transform 3d',favorite=True)

# Index Compacting
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_LABEL])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Index Compacting', 'CompactIndexImg', listParams, listOutputs, folder, docTitle='Index Compacting')

# Image Equalization 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Min value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Max value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Image Equalization 2D', 'Equalize2dImg', listParams, listOutputs, folder, docTitle='Image Equalization 2d')

# Image Equalization 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Min value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Max value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Image Equalization 3D', 'Equalize3dImg', listParams, listOutputs, folder, docTitle='Image Equalization 3d')

#Forward Discrete Fourier Transform 2d
listUserName = ['Default', 'Unitary','Custom']
listName = ['Default', 'Unitary','Custom']
parametersDescriptionsDefault = [
]
parametersDescriptionsUnitary = [
]
parametersDescriptionsCustom = [
    ParameterDescription('Scale Factor X', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Y', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsDefault, parametersDescriptionsUnitary,parametersDescriptionsCustom]

listParams = [
    ParameterDescription('Image', InputType.IMAGE, []),
    EnumParameterDescription('Coordinates', InputType.ENUM,enumList=[PyIPSDK.eDFTCoordinates.eDFTC_Cartesian,PyIPSDK.eDFTCoordinates.eDFTC_Polar], defaultValue=0),
    EnumParameterDescription('Quadrant Policy', InputType.ENUM,enumList=[PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered,PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native], defaultValue=0),
    AdvancedEnumParameterDescription('Scale Policy', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList,special="ScalePolicy2D")
]

listOutputs = [
    OutputDescription('Real or Rho Image', OutputType.IMAGE),
    OutputDescription('Imaginary or Theta Image', OutputType.IMAGE)
]
functionNode = generateXmlElement('Forward Discrete Fourier Transform 2D', 'ForwardDiscreteFourierTransform2dImg', listParams, listOutputs, folder, docTitle='Forward Discrete Fourier Transform 2d',favorite=True)

#Forward Discrete Fourier Transform 3d
listUserName = ['Default', 'Unitary','Custom']
listName = ['Default', 'Unitary','Custom']
parametersDescriptionsDefault = [
]
parametersDescriptionsUnitary = [
]
parametersDescriptionsCustom = [
    ParameterDescription('Scale Factor X', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Z', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Scale Factor Y', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsDefault, parametersDescriptionsUnitary,parametersDescriptionsCustom]

listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Coordinates', InputType.ENUM,enumList=[PyIPSDK.eDFTCoordinates.eDFTC_Cartesian,PyIPSDK.eDFTCoordinates.eDFTC_Polar], defaultValue=0),
    EnumParameterDescription('Quadrant Policy', InputType.ENUM,enumList=[PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Centered,PyIPSDK.eDFTQuadrantsPolicy.eDFTQP_Native], defaultValue=0),
    AdvancedEnumParameterDescription('Scale Policy', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList,special="ScalePolicy3D")
]

listOutputs = [
    OutputDescription('Real or Rho Image', OutputType.IMAGE),
    OutputDescription('Imaginary or Theta Image', OutputType.IMAGE)
]
functionNode = generateXmlElement('Forward Discrete Fourier Transform 3D', 'ForwardDiscreteFourierTransform3dImg', listParams, listOutputs, folder, docTitle='Forward Discrete Fourier Transform 3d',favorite=True)

# Greyscale inversion of 2d image
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Greyscale inversion 2D', 'Invert2dImg', listParams, listOutputs, folder, docTitle='Greyscale inversion of 2d image',favorite=True)

# Greyscale inversion of 3d image
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Greyscale inversion 3D', 'Invert3dImg', listParams, listOutputs, folder, docTitle='Greyscale inversion of 3d image',favorite=True)

# Histograms Matching 2d
listUserName = ['From histogram', 'From image']
listName = ['Histogram', 'Image']
parametersDescriptionsHistogram = [
    ParameterDescription('Reference histogram', InputType.HISTOGRAM)
]
parametersDescriptionsImage = [
    ParameterDescription('Reference image', InputType.IMAGE, []),
    ParameterDescription('Min value', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Max value', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=255),
    ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsHistogram, parametersDescriptionsImage]
listParams = [
    ParameterDescription('Image to transform', InputType.IMAGE, []),
    AdvancedEnumParameterDescription('Matching Element', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Transformed image', InputType.IMAGE)]
functionNode = generateXmlElement('Histograms Matching 2D', 'MatchHistograms2dImg', listParams, listOutputs, folder, docTitle='Image Histograms Matching 2d',favorite=True)

# Histograms Matching 3d
listUserName = ['From histogram', 'From image']
listName = ['Histogram', 'Image']
parametersDescriptionsHistogram = [
    ParameterDescription('Reference histogram', InputType.HISTOGRAM)
]
parametersDescriptionsImage = [
    ParameterDescription('Reference image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Min value', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Max value', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=255),
    ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1)
]
parametersDescriptionsList = [parametersDescriptionsHistogram, parametersDescriptionsImage]
listParams = [
    ParameterDescription('Image to transform', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    AdvancedEnumParameterDescription('Matching Element', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Transformed image', InputType.IMAGE)]
functionNode = generateXmlElement('Histograms Matching 3D', 'MatchHistograms3dImg', listParams, listOutputs, folder, docTitle='Image Histograms Matching 3d',favorite=True)

# Statistical Match
listUserName = ['From image', 'From stats']
listName = ['Image', 'Stats']

parametersDescriptionsImage = [
    ParameterDescription('Reference image', InputType.IMAGE)
]
parametersDescriptionsStats = [
    ParameterDescription('Reference stats', InputType.IMAGE)
]
parametersDescriptionsList = [parametersDescriptionsImage, parametersDescriptionsStats]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    AdvancedEnumParameterDescription('Matching Element', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList),
    EnumParameterDescription('Matching Criterion', InputType.ENUM,enumList=[PyIPSDK.eMinMax,PyIPSDK.eMeanStdDev ,PyIPSDK.eHistogram], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Statistical Match', 'MatchStatsImg', listParams, listOutputs, folder, docTitle='Statistical Match')

#Linear normalization
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Out range min', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Out range max', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255),
    ParameterDescription('In range min', InputType.SCALAR, [ScalarConstraint.REAL],isMandatory=False,defaultValue=0),
    ParameterDescription('In range max', InputType.SCALAR, [ScalarConstraint.REAL],isMandatory=False,defaultValue=255)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Linear normalization', 'NormalizeImg', listParams, listOutputs, folder, docTitle='Linear normalization',favorite=True)

#Shading correction (white image represented as a paraboloid)
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Image for paraboloid', InputType.IMAGE),
    ParameterDescription('Mask for paraboloid', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False),
    ParameterDescription('Factor', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=130),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL],isMandatory=False,defaultValue=0),
    ParameterDescription('Image black', InputType.IMAGE,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Shading correction (with paraboloid)', 'ParaboloidShadingCorrection2dImg', listParams, listOutputs, folder, docTitle='Shading correction (white image represented as a paraboloid)')

#Shading correction
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Image white', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY],isMandatory=False),
    ParameterDescription('Factor', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=130),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL],isMandatory=False,defaultValue=0),
    ParameterDescription('Image black', InputType.IMAGE,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Shading correction', 'ShadingCorrectionImg', listParams, listOutputs, folder, docTitle='Shading correction')

#Normalization with a sigmoid
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Alpha', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=20),
    ParameterDescription('Beta', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=128),
    ParameterDescription('Range Min', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Range Max', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255),
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Normalization with a sigmoid', 'SigmoidNormalizeImg', listParams, listOutputs, folder, docTitle='Normalization with a sigmoid')

#Smart shading correction (white image represented as a paraboloid)
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Image for paraboloid', InputType.IMAGE),
    ParameterDescription('Mask for paraboloid', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False),
    ParameterDescription('Range Min', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Range Max', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255),
    ParameterDescription('Image black', InputType.IMAGE,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Smart shading correction (with paraboloid)', 'SmartParaboloidShadingCorrection2dImg', listParams, listOutputs, folder, docTitle='Smart shading correction (white image represented as a paraboloid)',favorite=True)

#Smart shading correction
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Image mask', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False),
    ParameterDescription('Image white', InputType.IMAGE,isMandatory=False),
    ParameterDescription('Range Min', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Range Max', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255),
    ParameterDescription('Image black', InputType.IMAGE,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Smart shading correction', 'SmartShadingCorrectionImg ', listParams, listOutputs, folder, docTitle='Smart shading correction',favorite=True)

#Image Standardization
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Image mask', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False),
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Image Standardization', 'StandardizeImg', listParams, listOutputs, folder, docTitle='Image Standardization')

#Adaptive contrast enhancement 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=15),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=10),
    ParameterDescription('Blend value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Adaptive contrast enhancement 2D', 'AdaptiveContrastEnhancement2dImg', listParams, listOutputs, folder, docTitle='Adaptive Contrast Enhancement 2d',favorite=True)

#Adaptive contrast enhancement 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=15),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=10),
    ParameterDescription('Blend value', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
]
listOutputs = [OutputDescription('Output name', InputType.IMAGE)]
functionNode = generateXmlElement('Adaptive contrast enhancement 3D', 'AdaptiveContrastEnhancement3dImg', listParams, listOutputs, folder, docTitle='Adaptive Contrast Enhancement 3d',favorite=True)

#colorMapping2dImg
#colorMapping3dImg
#equalizeLut
#lutTransformation2d
#lutTransformation3d
#histogramMatching