from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

###################
#  Global Measure #
###################
folder = vrb.folderFunctions + '/GlobalMeasure'

# Gaussian Estimation Noise
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Gaussian noise estimation', 'GaussianNoiseMsr', listParams, listOutputs, folder, docTitle='Gaussian noise estimation')

# Global Entropy 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Histogram', InputType.HISTOGRAM, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Global Entropy 2D', 'GlobalEntropyMsr2d', listParams, listOutputs, folder, docTitle='Global Entropy 2d')

# Histogram measurement 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0,isMandatory=False),
    ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255,isMandatory=False),
    ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM)]
functionNode = generateXmlElement('Histogram 2D', 'HistogramMsr2d', listParams, listOutputs, folder, docTitle='Histogram measurement 2d',favorite=True)

# Histogram measurement 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0,isMandatory=False),
    ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255,isMandatory=False),
    ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM)]
functionNode = generateXmlElement('Histogram 3D', 'HistogramMsr3d', listParams, listOutputs, folder, docTitle='Histogram measurement 3d',favorite=True)

##########################
# Obsolete
##########################
# # Histogram masked measurement 2d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE),
#     ParameterDescription('Mask', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
#     ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0,isMandatory=False),
#     ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255,isMandatory=False),
#     ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1,isMandatory=False)
# ]
# listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM)]
# functionNode = generateXmlElement('Masked Histogram 2D', 'HistogramMaskMsr2d', listParams, listOutputs, folder, docTitle='Masked histogram measurement 2d')
#
# # Histogram masked measurement 3d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
#     ParameterDescription('Mask', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_BINARY]),
#     ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0,isMandatory=False),
#     ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255,isMandatory=False),
#     ParameterDescription('Bin width', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1,isMandatory=False)
# ]
# listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM)]
# functionNode = generateXmlElement('Masked Histogram 3D', 'HistogramMaskMsr3d', listParams, listOutputs, folder, docTitle='Masked histogram measurement 3d')

# Paraboloid Image Fitting 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    ParameterDescription('Mask', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Paraboloid Fitting 2D', 'ParaboloidImgFit2d', listParams, listOutputs, folder, docTitle='Paraboloid Image Fitting 2d')

# Pearson Correlation Coefficient 2d
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Pearson Correlation Coefficient 2D', 'PearsonCorrelationCoefficient2d', listParams, listOutputs, folder, docTitle='Pearson Correlation Coefficient 2d')

# Pearson Correlation Coefficient 3d
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Image 2', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Pearson Correlation Coefficient 3D', 'PearsonCorrelationCoefficient3d', listParams, listOutputs, folder, docTitle='Pearson Correlation Coefficient 3d')

# Similarity measurement
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Similarity Measurement', 'SimilarityMsr', listParams, listOutputs, folder, docTitle='Similarity measurement')

# Statistics measurement 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mask', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.STATISTICS)]
functionNode = generateXmlElement('Statistics Measurement 2D', 'StatsMsr2d', listParams, listOutputs, folder, docTitle='Statistics measurement 2d',favorite=True)

# Statistics measurement 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_BINARY],isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.STATISTICS)]
functionNode = generateXmlElement('Statistics Measurement 3D', 'StatsMsr3d', listParams, listOutputs, folder, docTitle='Statistics measurement 3d',favorite=True)

##########################
# Obsolete
##########################
# # Statistics masked measurement 2d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE),
#     ParameterDescription('Mask', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY])
# ]
# listOutputs = [OutputDescription('Output name', OutputType.STATISTICS)]
# functionNode = generateXmlElement('Masked Statistics Measurement 2D', 'StatsMaskMsr2d', listParams, listOutputs, folder, docTitle='Masked statistics measurement 2d')
#
# # Statistics masked measurement 3d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
#     ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_BINARY])
# ]
# listOutputs = [OutputDescription('Output name', OutputType.STATISTICS)]
# functionNode = generateXmlElement('Masked Statistics Measurement 3D', 'StatsMaskMsr3d', listParams, listOutputs, folder, docTitle='Masked statistics measurement 3d')

# X projection 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    EnumParameterDescription('Statistics', constraints=[ScalarConstraint.REAL], enumList=[PyIPSDK.eProjStatType.ePST_Max, PyIPSDK.eProjStatType.ePST_Mean, PyIPSDK.eProjStatType.ePST_Median,
                                                                                       PyIPSDK.eProjStatType.ePST_Min, PyIPSDK.eProjStatType.ePST_StdDev, PyIPSDK.eProjStatType.ePST_Sum,
                                                                                       PyIPSDK.eProjStatType.ePST_Variance])

]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('X projection 2D', 'XProjection2d', listParams, listOutputs, folder, docTitle='X projection 2d : Statistic measurement along the y axis',favorite=True)
# Y projection 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    EnumParameterDescription('Statistics', constraints=[ScalarConstraint.REAL], enumList=[PyIPSDK.eProjStatType.ePST_Max, PyIPSDK.eProjStatType.ePST_Mean, PyIPSDK.eProjStatType.ePST_Median,
                                                                                       PyIPSDK.eProjStatType.ePST_Min, PyIPSDK.eProjStatType.ePST_StdDev, PyIPSDK.eProjStatType.ePST_Sum,
                                                                                       PyIPSDK.eProjStatType.ePST_Variance])

]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Y projection 2D', 'YProjection2d', listParams, listOutputs, folder, docTitle='Y projection 2d : Statistic measurement along the x axis',favorite=True)

# Z ProjectionImg algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Minimum', constraints=[ScalarConstraint.REAL], enumList=[PyIPSDK.eProjStatType.ePST_Max, PyIPSDK.eProjStatType.ePST_Mean, PyIPSDK.eProjStatType.ePST_Median,
                                                                                       PyIPSDK.eProjStatType.ePST_Min, PyIPSDK.eProjStatType.ePST_StdDev, PyIPSDK.eProjStatType.ePST_Sum, PyIPSDK.eProjStatType.ePST_Variance])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Z Projection', 'ZProjectionImg', listParams, listOutputs, folder, docTitle='Z ProjectionImg algorithm', dimension=FunctionDimension.THREE_DIMENSIONS,favorite=True)

# Locate Pixels 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Nb Points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Locate Pixels 2D', 'LocatePixels2d', listParams, listOutputs, folder, docTitle='Pixel localization 2d')

# Locate Voxels 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Nb Points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Locate Voxels 3D', 'LocateVoxels3d', listParams, listOutputs, folder, docTitle='Voxel localization 3d')

# Label Histogram 2d
listName = ['Bounds', 'Quantile']
listParamBounds = [
    ParameterDescription('Min', InputType.SCALAR, [ScalarConstraint.REAL], 0,isMandatory=False),
    ParameterDescription('Max', InputType.SCALAR, [ScalarConstraint.REAL], 255, isMandatory=False)
]
listParamQuantile = [
    ParameterDescription('Min (%)', InputType.SCALAR, [ScalarConstraint.REAL], 0.1),
    ParameterDescription('Max (%)', InputType.SCALAR, [ScalarConstraint.REAL], 99.9)
]
advancedHistogramParameter = AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listName, listName,
                                                [listParamBounds, listParamQuantile])

listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Image grey', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS,ImageConstraint.GREY]),
    advancedHistogramParameter,
    ParameterDescription('Bin Width', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM_LABEL)]
functionNode = generateXmlElement('Label Histogram 2D', 'LabelHistogram2d', listParams, listOutputs, folder, docTitle='Label Histogram 2D')

# Label Histogram 3d
listName = ['Bounds', 'Quantile']
listParamBounds = [
    ParameterDescription('Min', InputType.SCALAR, [ScalarConstraint.REAL], 0, isMandatory=False),
    ParameterDescription('Max', InputType.SCALAR, [ScalarConstraint.REAL], 255, isMandatory=False)
]
listParamQuantile = [
    ParameterDescription('Min (%)', InputType.SCALAR, [ScalarConstraint.REAL], 0.1),
    ParameterDescription('Max (%)', InputType.SCALAR, [ScalarConstraint.REAL], 99.9)
]
advancedHistogramParameter = AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listName, listName,
                                                [listParamBounds, listParamQuantile])

listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Image grey', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.GREY]),
    advancedHistogramParameter,
    ParameterDescription('Bin Width', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.HISTOGRAM_LABEL)]
functionNode = generateXmlElement('Label Histogram 3D', 'LabelHistogram3d', listParams, listOutputs, folder, docTitle='Label Histogram 3D')

# Normalized Cross-Correlation Measure 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Template', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Normalized Cross Correlation Measure 2d', 'NormalizedCrossCorrelationMsr2d', listParams, listOutputs, folder, docTitle='Normalized Cross-Correlation Measure 2d')

# Normalized Cross-Correlation Measure 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Template', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Normalized Cross Correlation Measure 3d', 'NormalizedCrossCorrelationMsr3d', listParams, listOutputs, folder, docTitle='Normalized Cross-Correlation Measure 3d')

# AreaPercent2dMsr
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY] ,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Area Percent Measure 2D', 'AreaPercent2dMsr', listParams, listOutputs, folder, docTitle='Area Percent 2d measurement')

# VolumePercent3dMsr
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY] ,isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Volume Percent Measure 3D', 'VolumePercent3dMsr', listParams, listOutputs, folder, docTitle='Volume Percent 3d measurement')

# Counting2dMsr
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Counting Measure 2D', 'Counting2dMsr', listParams, listOutputs, folder, docTitle='Counting 2d objects')

# Counting3dMsr
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_LABEL]),
]
listOutputs = [OutputDescription('Output name', OutputType.MEASURE)]
functionNode = generateXmlElement('Counting Measure 3D', 'Counting3dMsr', listParams, listOutputs, folder, docTitle='Counting 3d objects')
