from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint,FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

###################
#    Geometric    #
###################
folder = vrb.folderFunctions + '/Geometric'

# 2D Zoom
listName = ['Factor', 'Size']
listParamFactor = [
    ParameterDescription('Zoom X (%)', InputType.SCALAR, [ScalarConstraint.REAL], 100),
    ParameterDescription('Zoom Y (%)', InputType.SCALAR, [ScalarConstraint.REAL], 100)
]
listParamSize = [
    ParameterDescription('Final Width', InputType.SCALAR, [ScalarConstraint.NATURAL]),
    ParameterDescription('Final Height', InputType.SCALAR, [ScalarConstraint.NATURAL])
]
advancedZoom = AdvancedEnumParameterDescription('Zoom', InputType.ADVANCED, None, 0, True, listName, listName, [listParamFactor, listParamSize])
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    EnumParameterDescription('Interpolation Method', InputType.ENUM, enumList=[PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour, PyIPSDK.eZoomInterpolationMethod.eZIM_Linear, PyIPSDK.eZoomInterpolationMethod.eZIM_Cubic, PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean], defaultValue=0),
    advancedZoom
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Zoom 2D', 'Zoom2dImg', listParams, listOutputs, folder, docTitle='2d zoom',favorite=True)

# 3D Zoom
listName = ['Factor', 'Size']
listParamFactor = [
    ParameterDescription('Zoom X (%)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=100),
    ParameterDescription('Zoom Y (%)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=100),
    ParameterDescription('Zoom Z (%)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=100)
]
listParamSize = [
    ParameterDescription('Final Width', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=1),
    ParameterDescription('Final Height', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=1),
    ParameterDescription('Final Height', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=1)
]
advancedZoom = AdvancedEnumParameterDescription('Zoom', InputType.ADVANCED, None, 0, True, listName, listName, [listParamFactor, listParamSize])
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Interpolation Method', InputType.ENUM, enumList=[PyIPSDK.eZoomInterpolationMethod.eZIM_NearestNeighbour, PyIPSDK.eZoomInterpolationMethod.eZIM_Linear, PyIPSDK.eZoomInterpolationMethod.eZIM_Cubic, PyIPSDK.eZoomInterpolationMethod.eZIM_VolumeWeightedMean], defaultValue=0),
    advancedZoom
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Zoom 3D', 'Zoom3dImg', listParams, listOutputs, folder, docTitle='3d zoom',favorite=True)

# x flip
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('X-flip', 'FlipXImg', listParams, listOutputs, folder, docTitle='Image x-flip algorithm')

# y flip
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Y-flip', 'FlipYImg', listParams, listOutputs, folder, docTitle='Image y-flip algorithm')

# z flip
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Z-flip', 'FlipZImg', listParams, listOutputs, folder, docTitle='Image z-flip algorithm')

# Translation 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Translation X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Translation Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Translation 2D', 'Translation2dImg', listParams, listOutputs, folder, docTitle='Warping 2d algorithm',favorite=True)

# Translation 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Translation X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Translation Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Translation Z', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Translation 3D', 'Translation3dImg', listParams, listOutputs, folder, docTitle='Warping 3d algorithm',favorite=True)

# Rotation 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Angle (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Keep the entire image', InputType.BOOLEAN,defaultValue=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Rotation 2D', 'Rotation2dImg', listParams, listOutputs, folder, docTitle='Warping 2d algorithm',favorite=True)

# Rotation 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Angle Chi (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Angle Beta (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Angle Alpha (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Keep the entire image', InputType.BOOLEAN,defaultValue=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Rotation 3D', 'Rotation3dImg', listParams, listOutputs, folder, docTitle='Warping 3d algorithm',favorite=True)

# Ring unrolling algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Center X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Center Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50),
    ParameterDescription('Half thickness', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50),
    EnumParameterDescription('Interpolation Method', InputType.ENUM,
                             enumList=[PyIPSDK.eIP_NearestNeighbour,PyIPSDK.eIP_Linear,PyIPSDK.eIP_Cubic], defaultValue=0, isMandatory= False),
    ParameterDescription('Out Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=200)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Ring Unrolling', 'UnrollRingImg', listParams, listOutputs, folder, docTitle='Ring unrolling algorithm')

# Ring unrolling algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Center X', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Center Y', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=100),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50),
    EnumParameterDescription('Interpolation Method', InputType.ENUM,
                             enumList=[PyIPSDK.eIP_NearestNeighbour, PyIPSDK.eIP_Linear, PyIPSDK.eIP_Cubic], defaultValue=0),
    ParameterDescription('Half thickness', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50, isMandatory=False),
    EnumParameterDescription('Integration Type', InputType.ENUM,
                             enumList=[PyIPSDK.eCUIT_Max, PyIPSDK.eCUIT_Mean, PyIPSDK.eCUIT_Min], defaultValue=1, isMandatory=False),
    ParameterDescription('Out Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=200)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Cylinder Unrolling', 'UnrollCylinderImg', listParams, listOutputs, folder,dimension=FunctionDimension.THREE_DIMENSIONS, docTitle='Cylinder unrolling algorithm')

# ElasticWarp2dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Dx', InputType.IMAGE),
    ParameterDescription('Dy', InputType.IMAGE),
    EnumParameterDescription('Interpolation Method', InputType.ENUM,
                             enumList=[PyIPSDK.eIP_NearestNeighbour, PyIPSDK.eIP_Linear], defaultValue=1),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Elastic Warp 2D', 'ElasticWarp2dImg', listParams, listOutputs, folder, docTitle='Elastic Warp 2d')

# Warp2dImg
listUserName = ['From parameters', 'From transformation']
listName = ['From parameters', 'From transformation']

fromParametersList = [
    EnumParameterDescription('Tx', InputType.SCALAR, [ScalarConstraint.RELATIVE], defaultValue=0),
    EnumParameterDescription('Ty', InputType.SCALAR, [ScalarConstraint.RELATIVE], defaultValue=0),
    EnumParameterDescription('Theta (degree)', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    EnumParameterDescription('Scale', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),

]
fromTransformationList = [
    EnumParameterDescription('Transformation', InputType.TRANSFORMATION)
]

parametersDescriptionsList = [fromParametersList, fromTransformationList]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList),
    EnumParameterDescription('Interpolation Method', InputType.ENUM,enumList=[PyIPSDK.eIP_NearestNeighbour, PyIPSDK.eIP_Linear, PyIPSDK.eIP_Cubic],defaultValue=1)
]

listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Warp 2D', 'Warp2dImg', listParams, listOutputs, folder, docTitle='Warping 2d algorithm',favorite=False)