from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, kernel2DParameterDescription
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK
import xml.etree.ElementTree as xmlet

###################
#    Filtering    #
###################
folder = vrb.folderFunctions + '/Filtering'
# Anisotropic diffusion 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Number of steps', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10),
    ParameterDescription('Sharpness', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1.0),
    ParameterDescription('Anisotropy', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.6)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Anisotropic diffusion 2D', 'AnisotropicDiffusion2dImg', listParams, listOutputs, folder, docTitle='Anisotropic diffusion 2d')
# Anisotropic diffusion 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number of steps', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10),
    ParameterDescription('Sharpness', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1.0),
    ParameterDescription('Anisotropy', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.6)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Anisotropic diffusion 3D', 'AnisotropicDiffusion3dImg', listParams, listOutputs, folder, docTitle='Anisotropic diffusion 3d')

# Bilateral smoothing 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=5),
    ParameterDescription('Spacial gaussian sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=5),
    ParameterDescription('Range gaussian sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Bilateral smoothing 2D', 'Bilateral2dImg', listParams, listOutputs, folder, docTitle='Bilateral smoothing 2d')

# Bilateral smoothing 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=5),
    ParameterDescription('Spacial gaussian sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=5),
    ParameterDescription('Range gaussian sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Bilateral smoothing 3D', 'Bilateral3dImg', listParams, listOutputs, folder, docTitle='Bilateral smoothing 3d')

# Convolution 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    kernel2DParameterDescription(),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True)
    # TODO : Border policy
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Convolution 2D', 'Convolution2dImg', listParams, listOutputs, folder, docTitle='Convolution 2d')

# Despeckle Filter 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half kernel size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Half kernel size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Factor', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Despeckle Filter 2D', 'DespeckleFilter2dImg', listParams, listOutputs, folder, docTitle='Despeckle Filter 2d')


# Band-pass frequency filtering 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    EnumParameterDescription('Filter type', enumList=[PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_Gaussian, PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_LogGabor]),
    ParameterDescription('Cutoff frequency', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.2),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.25),
    ParameterDescription('Theta', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Theta range', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=180)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Band-pass frequency filtering 2D', 'FrequencyFiltering2dImg', listParams, listOutputs, folder, docTitle='Band-pass frequency filtering 2d')

# Band-pass frequency filtering 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Filter type', enumList=[PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_Gaussian, PyIPSDK.eFrequencyBandPassFilterType.eFBPFT_LogGabor]),
    ParameterDescription('Cutoff frequency', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.2),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.25),
    ParameterDescription('Theta', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Theta range', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=180),
    ParameterDescription('Phi', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Phi range', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=180)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Band-pass frequency filtering 3D', 'FrequencyFiltering3dImg', listParams, listOutputs, folder, docTitle='Band-pass frequency filtering 3d')

# DIC Integration 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Theta', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('DIC Integration 2D', 'DicIntegration2dImg', listParams, listOutputs, folder, docTitle='Differential Interference Contrast (DIC) Integration 2D')

# DIC Phase Retrieval 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Mu', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=1000),
    ParameterDescription('Delta', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=0.01),
    ParameterDescription('Defocus distance', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=0.001),
    ParameterDescription('Lambda', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=161.2e-10),
    ParameterDescription('Lengthscale', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=10e-6),
    ParameterDescription('Energy', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=13)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('DIC Phase Retrieval 2D', 'DicPhaseRetrieval2dImg', listParams, listOutputs, folder, docTitle='Differential Interference Contrast (DIC) Phase Retrieval 2D')

# Gaussian Gradient 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2),
    EnumParameterDescription('Mode', InputType.ENUM, enumList=["Cartesian", "Polar"], defaultValue=0)
]
listOutputs = [OutputDescription('Output image 1', OutputType.IMAGE), OutputDescription('Output image 2', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Gradient 2D', 'GaussianGradient2dImg', listParams, listOutputs, folder, docTitle='Gaussian Gradient 2d',favorite=True)

# Gaussian Gradient 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output image X', OutputType.IMAGE), OutputDescription('Output image Y', OutputType.IMAGE), OutputDescription('Output image Z', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Gradient 3D', 'GaussianGradient3dImg', listParams, listOutputs, folder, docTitle='Gaussian Gradient 3d',favorite=True)


# Gaussian Hessian 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output image XX', OutputType.IMAGE), OutputDescription('Output image XY', OutputType.IMAGE), OutputDescription('Output image YY', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Hessian 2D', 'GaussianHessian2dImg', listParams, listOutputs, folder, docTitle='Gaussian Hessian 2d')
# Gaussian Hessian 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output image XX', OutputType.IMAGE), OutputDescription('Output image XY', OutputType.IMAGE), OutputDescription('Output image XZ', OutputType.IMAGE),
               OutputDescription('Output image YY', OutputType.IMAGE), OutputDescription('Output image YZ', OutputType.IMAGE), OutputDescription('Output image ZZ', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Hessian 3D', 'GaussianHessian3dImg', listParams, listOutputs, folder, docTitle='Gaussian Hessian 3d')

# gaussianSmoothing2dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Smoothing 2D', 'GaussianSmoothing2dImg', listParams, listOutputs, folder, docTitle='Gaussian Smoothing 2d',favorite=True)
# gaussianSmoothing3dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Gaussian Smoothing 3D', 'GaussianSmoothing3dImg', listParams, listOutputs, folder, docTitle='Gaussian Smoothing 3d',favorite=True)

# High-pass 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('High-pass 2D', 'HighPass2dImg', listParams, listOutputs, folder, docTitle='High-pass 2d',favorite=True)
# High-pass 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('High-pass 3D', 'HighPass3dImg', listParams, listOutputs, folder, docTitle='High-pass 3d',favorite=True)

# Laplacian DoG 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard Deviation Factor', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1.6),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Laplacian DoG 2D', 'LaplacianDoG2dImg', listParams, listOutputs, folder, docTitle='Laplacian DoG 2d')
# Laplacian DoG 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard Deviation Factor', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1.6),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Laplacian DoG 3D', 'LaplacianDoG3dImg', listParams, listOutputs, folder, docTitle='Laplacian DoG 3d')


# Difference of Gaussian based Laplacian deblur 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Standard Deviation Factor', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Difference of Gaussian based Laplacian deblur 2D', 'LaplacianDoGDeblur2dImg', listParams, listOutputs, folder, docTitle='Difference of Gaussian based Laplacian deblur 2d')
# Difference of Gaussian based Laplacian deblur 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Standard Deviation Factor', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Difference of Gaussian based Laplacian deblur 3D', 'LaplacianDoGDeblur3dImg', listParams, listOutputs, folder, docTitle='Difference of Gaussian based Laplacian deblur 3d')


# Mean Smoothing 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Mean Smoothing 2D', 'MeanSmoothing2dImg', listParams, listOutputs, folder, docTitle='Mean Smoothing 2d',favorite=True)
# Mean Smoothing 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Mean Smoothing 3D', 'MeanSmoothing3dImg', listParams, listOutputs, folder, docTitle='Mean Smoothing 3d',favorite=True)


# median2dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Allow 8 bits Compression?', InputType.BOOLEAN, defaultValue=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Median 2D', 'Median2dImg', listParams, listOutputs, folder, docTitle='Median 2d',favorite=True)
# median3dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Half Kernel Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Half Kernel Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Half Kernel Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Allow 8 bits Compression?', InputType.BOOLEAN, defaultValue=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Median 3D', 'Median3dImg', listParams, listOutputs, folder, docTitle='Median 3d',favorite=True)


# TODO : Scales = vector
# # Multiscale vessel enhancement 2d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE),
#     ParameterDescription('Blobness sensitivity threshold', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5),
#     ParameterDescription('Bright vessels on dark', InputType.BOOLEAN),
#     ParameterDescription('Scales', InputType.SCALAR, [ScalarConstraint.REAL])
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Multiscale vessel enhancement 2D', 'MultiscaleVesselEnhancement2dImg', listParams, listOutputs, folder, docTitle='Multiscale vessel enhancement 2d')
# # Multiscale vessel enhancement 3d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
#     ParameterDescription('Blobness sensitivity threshold', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5),
#     ParameterDescription('Area sensitivity threshold', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5),
#     ParameterDescription('Bright vessels on dark', InputType.BOOLEAN),
#     ParameterDescription('Scales', InputType.SCALAR, [ScalarConstraint.REAL])
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Multiscale vessel enhancement 3D', 'MultiscaleVesselEnhancement3dImg', listParams, listOutputs, folder, docTitle='Multiscale vessel enhancement 3d')


# Normalized Cross-Correlation 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('SubImage', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Normalized Cross-Correlation 2D', 'NormalizedCrossCorrelation2dImg', listParams, listOutputs, folder, docTitle='Normalized Cross-Correlation 2d')

# Normalized Cross-Correlation 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('SubImage', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.GREY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Normalized Cross-Correlation 3D', 'NormalizedCrossCorrelation3dImg', listParams, listOutputs, folder, docTitle='Normalized Cross-Correlation 3d')

# Patch-based bilateral filter 2d
listUserName = ['Simple', 'Range']
listName = ['Simple', 'Range']
easyList = [
    ParameterDescription('Noise sigma', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3)
]
rangeList = [
    ParameterDescription('Noise sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Range minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Range maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255)
]

parametersDescriptionsList = [easyList, rangeList]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Patch-based bilateral filter 2D', 'PatchBasedBilateral2dImg', listParams, listOutputs, folder, docTitle='Patch-based bilateral filter 2d',favorite=True)

# Patch-based bilateral filter 3d
parametersDescriptionsList = [easyList, rangeList]
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    AdvancedEnumParameterDescription('Parameters', InputType.ADVANCED, None, 0, True, listUserName, listName, parametersDescriptionsList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Patch-based bilateral filter 3D', 'PatchBasedBilateral3dImg', listParams, listOutputs, folder, docTitle='Patch-based bilateral filter 3d',favorite=True)

# Pearson colocalization mapping 2d
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output image', OutputType.IMAGE)]
functionNode = generateXmlElement('Pearson colocalization mapping 2D', 'PearsonColocalization2dImg', listParams, listOutputs, folder, docTitle='Pearson colocalization mapping 2d')

# Pearson colocalization mapping 3d
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Image 2', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output image', OutputType.IMAGE)]
functionNode = generateXmlElement('Pearson colocalization mapping 3D', 'PearsonColocalization3dImg', listParams, listOutputs, folder, docTitle='Pearson colocalization mapping 3d')

# Richardson-Lucy deblur 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Number of iteration', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Richardson-Lucy deblur 2D', 'RichardsonLucyDeblur2dImg', listParams, listOutputs, folder, docTitle='Richardson-Lucy deblur 2d',favorite=True)

# Richardson-Lucy deblur 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number of iteration', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=2),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=2),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Richardson-Lucy deblur 3D', 'RichardsonLucyDeblur3dImg', listParams, listOutputs, folder, docTitle='Richardson-Lucy deblur 3d',favorite=True)


# Separated bilateral smoothing 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Space sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Range sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Half kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Separated bilateral smoothing 2D', 'SeparatedBilateral2dImg', listParams, listOutputs, folder, docTitle='Separated bilateral smoothing 2d',favorite=True)

# Separated bilateral smoothing 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Space sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Range sigma', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Half kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=3)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Separated bilateral smoothing 3D', 'SeparatedBilateral3dImg', listParams, listOutputs, folder, docTitle='Separated bilateral smoothing 3d',favorite=True)

# Sobel Gradient 2d
sobelEnum = [PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    EnumParameterDescription('Kernel type', enumList=sobelEnum, isMandatory=False),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True),
    EnumParameterDescription('Mode', InputType.ENUM, enumList=["Cartesian", "Polar"], defaultValue=0)
]
listOutputs = [OutputDescription('Image 1', OutputType.IMAGE), OutputDescription('Image 2', OutputType.IMAGE)]
functionNode = generateXmlElement('Sobel Gradient 2D', 'SobelGradient2dImg', listParams, listOutputs, folder, docTitle='Sobel Gradient 2d',favorite=True)

# Sobel Gradient 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Kernel type', enumList=sobelEnum, isMandatory=False),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True)
]
listOutputs = [OutputDescription('Image X', OutputType.IMAGE), OutputDescription('Image Y', OutputType.IMAGE), OutputDescription('Image Z', OutputType.IMAGE)]
functionNode = generateXmlElement('Sobel Gradient 3D', 'SobelGradient3dImg', listParams, listOutputs, folder, docTitle='Sobel Gradient 3d',favorite=True)

# Unsharp Mask 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Blur weight [0;1]', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=5),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=5),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Unsharp Mask 2D', 'UnsharpMask2dImg', listParams, listOutputs, folder, docTitle='Unsharp Mask 2d')

# Unsharp Mask 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Blur weight [0;1]', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=5),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=5),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=5),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Unsharp Mask 3D', 'UnsharpMask3dImg', listParams, listOutputs, folder, docTitle='Unsharp Mask 3d')

# Z Stack Focus Maximum
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS_OR_SEQUENCE]),
    ParameterDescription('Contrast radius', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10, isMandatory=False),
    ParameterDescription('Mean smoothing value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1, isMandatory=False),
    ParameterDescription('Zoom factor', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False)
]
listOutputs = [OutputDescription('Output image', OutputType.IMAGE), OutputDescription('Depth map', OutputType.IMAGE)]
functionNode = generateXmlElement('Z Stack Focus Maximum', 'ZStackFocusMaximumImg', listParams, listOutputs, folder, docTitle='Z Stack Focus Maximum', dimension=FunctionDimension.THREE_DIMENSIONS)

# Z Stack Focus Ponderation
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS_OR_SEQUENCE]),
    ParameterDescription('Contrast radius', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=10, isMandatory=False),
    ParameterDescription('Mean smoothing value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1, isMandatory=False),
    ParameterDescription('Zoom factor', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Z Stack Focus Ponderation', 'ZStackFocusPonderationImg', listParams, listOutputs, folder, docTitle='Z Stack Focus Ponderation', dimension=FunctionDimension.THREE_DIMENSIONS)


# FastCrossCorrelation2dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Template', InputType.IMAGE, [ImageConstraint.GREY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Fast Cross Correlation 2d', 'FastCrossCorrelation2dImg', listParams, listOutputs, folder, docTitle='Fast Cross-Correlation 2d')


# FastCrossCorrelation3dImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('Template', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.GREY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Fast Cross Correlation 3d', 'FastCrossCorrelation3dImg', listParams, listOutputs, folder, docTitle='Fast Cross-Correlation 3d')

# VSNR 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    ParameterDescription('Nb Iterations', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=12),
    ParameterDescription('Standard deviation X', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=30),
    ParameterDescription('Theta', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Alpha', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
listOutputs = [OutputDescription('Corrected image', OutputType.IMAGE), OutputDescription('Noise image', OutputType.IMAGE)]
functionNode = generateXmlElement('VSNR 2D', 'VSNR2dImg', listParams, listOutputs, folder, docTitle='Variational Stationary Noise Remover 2D',favorite=True)

