from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, FunctionDimension
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FeatureConstraints
import UsefullVariables as vrb

import PyIPSDK

#####################
# Feature Detection #
#####################
folder = vrb.folderFunctions + '/FeatureDetection'

# 2d Canny edge detector
gaussianParamList = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=5),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=3)
]
sobelEnum = [PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3]
sobelParamList = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS]),
    EnumParameterDescription('Kernel type', enumList=sobelEnum, isMandatory=False),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True)
]
customParamList = [
    ParameterDescription('Image X', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS]),
    ParameterDescription('Image Y', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS])
]
nameList = ['Sobel', 'Gaussian', 'Custom']
listParams = [
    ParameterDescription('Threshold minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=30),
    ParameterDescription('Threshold maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=70),
    AdvancedEnumParameterDescription('Type of gradient', usernameList=nameList, nameList=nameList, parametersDescriptionsList=[sobelParamList, gaussianParamList, customParamList])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Canny edge detector 2D', 'CannyEdges2dImg', listParams, listOutputs, folder, docTitle='2d Canny edge detector')


# 3d Canny surface detector
gaussianParamList = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Standard deviation Y', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Standard deviation Z', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=3),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=5),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=3)
]
sobelEnum = [PyIPSDK.eSobelKernelType.eSKT_ScharrHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz1, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz2, PyIPSDK.eSobelKernelType.eSKT_SobelHalfKnlSz3]
sobelParamList = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Kernel type', enumList=sobelEnum, isMandatory=False),
    ParameterDescription('Normalize', InputType.BOOLEAN, defaultValue=True)
]
customParamList = [
    ParameterDescription('Image X', InputType.IMAGE),
    ParameterDescription('Image Y', InputType.IMAGE),
    ParameterDescription('Image Z', InputType.IMAGE)
]
nameList = ['Sobel', 'Gaussian', 'Custom']
listParams = [
    ParameterDescription('Threshold minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=30),
    ParameterDescription('Threshold maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=70),
    AdvancedEnumParameterDescription('Type of gradient', usernameList=nameList, nameList=nameList, parametersDescriptionsList=[sobelParamList, gaussianParamList, customParamList])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Canny surface detector 3D', 'CannySurfaces3dImg', listParams, listOutputs, folder, docTitle='3d Canny surface detector')


# Local Extrema Extraction 2d
extremaTypeList = [PyIPSDK.eLocalExtremumType.eLET_Max, PyIPSDK.eLocalExtremumType.eLET_Min, PyIPSDK.eLocalExtremumType.eLET_StrictMax, PyIPSDK.eLocalExtremumType.eLET_StrictMin]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Feature distance X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Feature distance Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=extremaTypeList),
    ParameterDescription('Extremum Threshold', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=300)
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Local Extrema Extraction 2D', 'ExtractLocalExtrema2d', listParams, listOutputs, folder, docTitle='Local Extrema Extraction 2d')
# Local Extrema Extraction 3d
extremaTypeList = [PyIPSDK.eLocalExtremumType.eLET_Max, PyIPSDK.eLocalExtremumType.eLET_Min, PyIPSDK.eLocalExtremumType.eLET_StrictMax, PyIPSDK.eLocalExtremumType.eLET_StrictMin]
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Feature distance X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Feature distance Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Feature distance Z', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=extremaTypeList),
    ParameterDescription('Extremum Threshold', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=300)
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Local Extrema Extraction 3D', 'ExtractLocalExtrema3d', listParams, listOutputs, folder, docTitle='Local Extrema Extraction 3d')


# Harris corner detection 2d
simpleList = [
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.5),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=300),
    ParameterDescription('Feature distance', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5)
]
completeList = [
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2),
    AdvancedEnumParameterDescription('Corner detection method', usernameList=['Default', 'Harris', 'Shi-Thomasi'], nameList=['Default', 'Harris', 'ShiThosmasi'], parametersDescriptionsList=[[], [ParameterDescription('Sensitivity', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0)], []]),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=300),
    ParameterDescription('Threshold', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=750),
    ParameterDescription('Feature distance X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5),
    ParameterDescription('Feature distance Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5)
]
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    AdvancedEnumParameterDescription('Type of call', usernameList=['Simple', 'Complete'], nameList=['Simple', 'Complete'], parametersDescriptionsList=[simpleList, completeList])
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Harris corner detection 2D', 'HarrisCorner2d', listParams, listOutputs, folder, docTitle='Harris corner detection 2d',favorite=True)
# Harris corner detection 3d
simpleList = [
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.5),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=300),
    ParameterDescription('Feature distance', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5)
]
completeList = [
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5),
    ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.997),
    ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=2),
    AdvancedEnumParameterDescription('Corner detection method', usernameList=['Default', 'Harris', 'Shi-Thomasi'], nameList=['Default', 'Harris', 'ShiThosmasi'], parametersDescriptionsList=[[], [ParameterDescription('Sensitivity', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0)], []]),
    ParameterDescription('Total number of points', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=300),
    ParameterDescription('Threshold', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=750),
    ParameterDescription('Feature distance X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5),
    ParameterDescription('Feature distance Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5),
    ParameterDescription('Feature distance Z', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=5)
]
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    AdvancedEnumParameterDescription('Type of call', usernameList=['Simple', 'Complete'], nameList=['Simple', 'Complete'], parametersDescriptionsList=[simpleList, completeList])
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Harris corner detection 3D', 'HarrisCorner3d', listParams, listOutputs, folder, docTitle='Harris corner detection 3d',favorite=True)

# Harris corner detection 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
    # ParameterDescription('Gaussian Ratio', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False),
    # ParameterDescription('MinHalfKernelSize', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False),
    # AdvancedEnumParameterDescription('Corner detection method', usernameList=['Default', 'Harris', 'Shi-Thomasi'], nameList=['Default', 'Harris', 'ShiThosmasi'], parametersDescriptionsList=[[], [ParameterDescription('Sensitivity', InputType.SCALAR, [ScalarConstraint.REAL])], []])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Harris corner detection 2D image', 'HarrisCorner2dImg', listParams, listOutputs, folder, docTitle='Harris corner detection 2d image')

# Harris corner detection 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Gradient standard deviation', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Harris corner detection 3D image', 'HarrisCorner3dImg', listParams, listOutputs, folder, docTitle='Harris corner detection 3d image')

# Hough circles detection 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('Radius minimum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10),
    ParameterDescription('Radius maximum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=20),
    EnumParameterDescription('Circles type', enumList=['eCIT_BrightCircles','eCIT_DarkCircles','eCIT_Both'], isMandatory=False,defaultValue=2),
    ParameterDescription('Number of points for detection', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=128),
    ParameterDescription('Accumulated intensity threshold', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1),
    ParameterDescription('Ratio remove too close circles', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.3),
    ParameterDescription('Number of circles', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Hough circles detection 2D', 'HoughCircles2d', listParams, listOutputs, folder, docTitle='Hough circles detection', dimension=FunctionDimension.TWO_DIMENSIONS,favorite=True)

# Hough spheres detection 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('Radius minimum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10),
    ParameterDescription('Radius maximum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=20),
    EnumParameterDescription('Circles type', enumList=['eCIT_BrightCircles','eCIT_DarkCircles','eCIT_Both'],defaultValue=2),
    ParameterDescription('Number of points for detection', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=128),
    ParameterDescription('Accumulated intensity threshold', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=1),
    ParameterDescription('Ratio remove too close circles', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=0.3),
    ParameterDescription('Number of spheres', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.FEATURE)]
functionNode = generateXmlElement('Hough spheres detection 3D', 'HoughSpheres3d', listParams, listOutputs, folder, docTitle='Hough spheres detection', dimension=FunctionDimension.THREE_DIMENSIONS,favorite=True)

# Hough Spheres 3d Label Image
listParams = [
    ParameterDescription('Spheres feature', InputType.FEATURE, [FeatureConstraints.SPHERE]),
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Hough spheres label 3D image', 'HoughSpheres3dLabelImg', listParams, listOutputs, folder, docTitle='Hough spheres label 3d image')


# # Computation of accumulator matrix for Hough circles detection
# listParams = [
#     ParameterDescription('Image X', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
#     ParameterDescription('Image Y', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
#     ParameterDescription('Radius minimum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10),
#     ParameterDescription('Radius maximum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=20)
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Hough circles accumulator image', 'HoughCircles2dImg', listParams, listOutputs, folder, docTitle='Computation of accumulator matrix for Hough circles detection', dimension=FunctionDimension.TWO_DIMENSIONS)
#
# # Computation of complex accumulator matrix for Hough circles detection
# listParams = [
#     ParameterDescription('Image X', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
#     ParameterDescription('Image Y', InputType.IMAGE,[ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
#     ParameterDescription('Radius minimum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=10),
#     ParameterDescription('Radius maximum', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=20)
# ]
# listOutputs = [OutputDescription('Real image name', OutputType.IMAGE), OutputDescription('Imaginary image name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Hough circles complex accumulator image', 'HoughCirclesPhaseCoded2dImg', listParams, listOutputs, folder, docTitle='Computation of complex accumulator matrix for Hough circles detection', dimension=FunctionDimension.TWO_DIMENSIONS)

# Hough lines detection
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('Theta min', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Theta max', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=3.14),
    ParameterDescription('Minimal allowed intensity', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Accumulator threshold', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.5),
    ParameterDescription('Merge line ratio', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1)
]
listOutputs = [OutputDescription('Lines name', OutputType.FEATURE)]
functionNode = generateXmlElement('Hough lines detection', 'HoughLines2d', listParams, listOutputs, folder, docTitle='Hough lines detection', dimension=FunctionDimension.TWO_DIMENSIONS,favorite=True)

# Computation of accumulator matrix for Hough lines detection
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS, ImageConstraint.GREY]),
    ParameterDescription('Theta min', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Theta max', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=3.14),
    ParameterDescription('Minimal allowed intensity', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Hough lines accumulator image', 'HoughLines2dImg', listParams, listOutputs, folder, docTitle='Computation of accumulator matrix for Hough lines detection', dimension=FunctionDimension.TWO_DIMENSIONS)
