from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

##################
#    Color OP    #
##################
folder = vrb.folderFunctions + '/ColorOperation'
# lightness Img
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.COLOR]),
    EnumParameterDescription('Method', enumList=['eLT_Average', 'eLT_Lightness', 'eLT_Luminosity'])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Lightness', 'LightnessImg', listParams, listOutputs, folder, docTitle='Lightness',favorite=True)

# colorConvertImg
colors = [
    # PyIPSDK.eColorGeometryType.eCGT_Grey,
    PyIPSDK.eColorGeometryType.eCGT_Rgb,
    PyIPSDK.eColorGeometryType.eCGT_Rgba, PyIPSDK.eColorGeometryType.eCGT_XYZ,
    PyIPSDK.eColorGeometryType.eCGT_YPbPr, PyIPSDK.eColorGeometryType.eCGT_YCbCr,
    PyIPSDK.eColorGeometryType.eCGT_CieLab, PyIPSDK.eColorGeometryType.eCGT_CieLuv,
    PyIPSDK.eColorGeometryType.eCGT_HLS, PyIPSDK.eColorGeometryType.eCGT_HSV
]
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.COLOR]),
    EnumParameterDescription('Target color space', enumList=colors)
]
listOutputs = [OutputDescription('Output name 1', OutputType.IMAGE), OutputDescription('Output name 2', OutputType.IMAGE), OutputDescription('Output name 3', OutputType.IMAGE)]
functionNode = generateXmlElement('Color Space Conversion', 'ColorConvertImg', listParams, listOutputs, folder, docTitle='Color Space Conversion',favorite=True)

# SplitChannelsImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.COLOR])
]
listOutputs = [OutputDescription('Output name 1', OutputType.IMAGE), OutputDescription('Output name 2', OutputType.IMAGE), OutputDescription('Output name 3', OutputType.IMAGE)]
functionNode = generateXmlElement('Split channels', 'SplitChannelsImg', listParams, listOutputs, folder,favorite=True)

# MergeChannels
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Image 2', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Image 3', InputType.IMAGE, [ImageConstraint.GREY])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Merge channels', 'MergeChannelsImg', listParams, listOutputs, folder,favorite=True)


# splitByPCAImg
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.COLOR])
]
listOutputs = [OutputDescription('Output name 1', OutputType.IMAGE), OutputDescription('Output name 2', OutputType.IMAGE), OutputDescription('Output name 3', OutputType.IMAGE)]
functionNode = generateXmlElement('Image dimensionality reduction using PCA', 'SplitByPCAImg', listParams, listOutputs, folder,docTitle="Image dimensionality reduction using PCA",favorite=True)

# AppendColorChannel
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Append Color Channel', 'AppendColorChannelImg', listParams, listOutputs, folder,favorite=True)

# Extract Channel
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Channel Value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Extract Channel', 'ExtractChannel', listParams, listOutputs, folder,docTitle="Manipulating sub-parts of images",favorite=True)
