from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, CentroidConstraints, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

###################
#  Classification #
###################
folder = vrb.folderFunctions + '/Classification'

# Kernel K-means algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
    ParameterDescription('Number of clusters', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Number of samples', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=4)
]
listOutputs = [OutputDescription('Class image name', OutputType.IMAGE), OutputDescription('Centroids name', OutputType.CENTROID)]
functionNode = generateXmlElement('Kernel K-means algorithm', 'KernelKMeansImg', listParams, listOutputs, folder, docTitle='Kernel K-means algorithm', dimension=FunctionDimension.TWO_DIMENSIONS,favorite=True)


# Kernel K-means assignment
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.TWO_DIMENSIONS]),
    ParameterDescription('KMean centroids', InputType.CENTROID, [CentroidConstraints.KKMEANS_CENTROID])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Kernel K-means assignment', 'KernelKMeansAssignImg', listParams, listOutputs, folder, docTitle='Kernel K-means assignment', dimension=FunctionDimension.TWO_DIMENSIONS)


# K-means algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    ParameterDescription('Number of clusters', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    ParameterDescription('Number of attempts', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=3, isMandatory=False),
    ParameterDescription('Maximum iteration per attempt', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=10),
    ParameterDescription('Center shift tolerance', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0.0001, isMandatory=False),
    ParameterDescription('Mask image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False)
]
listOutputs = [ OutputDescription('Class image name', OutputType.IMAGE),OutputDescription('Centroids name', OutputType.CENTROID)]
functionNode = generateXmlElement('K-Means algorithm', 'KMeansImg', listParams, listOutputs, folder, docTitle='K-means algorithm',favorite=True)

# Clusters assignment algorithm (clusters centroids given in input)
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mask image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Cluster centers', InputType.CENTROID, [CentroidConstraints.CLUSTER_CENTER])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Clusters assignment algorithm', 'KMeansAssignImg', listParams, listOutputs, folder, docTitle='Clusters assignment algorithm (clusters centroids given in input)')

# Clusters centroids computation algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Class image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_UINT]),  # TODO : make it take Labels?
    ParameterDescription('Mask image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False)
]
listOutputs = [OutputDescription('Centroids name', OutputType.CENTROID)]
functionNode = generateXmlElement('Clusters centroids from class', 'KMeansComputeCenters', listParams, listOutputs, folder, docTitle='Clusters centroids computation algorithm')

# Image posterization from k-means results algorithm
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Class image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_UINT]),  # TODO : Labels?
    # ParameterDescription('Mask image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    ParameterDescription('Clusters centers', InputType.CENTROID, [CentroidConstraints.CLUSTER_CENTER])
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Image posterization from cluster centers', 'KMeansPosterizeImg', listParams, listOutputs, folder, docTitle='Image posterization from k-means results algorithm')
