from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement,\
    eImageBufferTypeList, SelectorType, structuringElem2DParameterDescription, kernel2DParameterDescription, structuringElem3DParameterDescription
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

###################
#   Binarization  #
###################
folder = vrb.folderFunctions + '/Binarization'

# Adaptive Threshold 2d binarization
listUserName = ['Gaussian', 'Kernel']
listName = ['Gaussian', 'Kernel']
choice1 = [ParameterDescription('Half Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3)]
choice2 = [kernel2DParameterDescription('Normalized kernel')]
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    AdvancedEnumParameterDescription('Threshold type', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[choice1, choice2]),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Adaptive Threshold 2D', 'AdaptiveThreshold2dImg', listParams, listOutputs, folder, docTitle='Adaptive Threshold 2d binarization')

# Adaptive Threshold 3d binarization
listUserName = ['Gaussian']
listName = ['Gaussian']
choice1 = [ParameterDescription('Half Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3)]
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.GREY]),
    AdvancedEnumParameterDescription('Threshold type', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[choice1]),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Adaptive Threshold 3D', 'AdaptiveThreshold3dImg', listParams, listOutputs, folder, docTitle='Adaptive Threshold 3d binarization')

# Adaptive Threshold Mean 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Half Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Adaptive Threshold Mean 2D', 'AdaptiveThresholdMean2dImg', listParams, listOutputs, folder, docTitle='Adaptive Threshold Mean 2d')

# Adaptive Threshold Mean 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.GREY]),
    ParameterDescription('Half Kernel size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=3),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Adaptive Threshold Mean 3D', 'AdaptiveThresholdMean3dImg', listParams, listOutputs, folder, docTitle='Adaptive Threshold Mean 3d')

# Hysteresis Threshold 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_NOTBINARY]),
    # EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True),
    SelectorParameterDescription('Threshold', selectorType=SelectorType.HYSTERESIS,textWhileSelecting='Select values on the slider then validate')
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Hysteresis Threshold 2d', 'HysteresisThreshold2dImg', listParams, listOutputs, folder, docTitle='Hysteresis Threshold 2d',favorite=True)

# Hysteresis Threshold 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_NOTBINARY]),
    # EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True),
    SelectorParameterDescription('Threshold', selectorType=SelectorType.HYSTERESIS,textWhileSelecting='Select values on the slider then validate')
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Hysteresis Threshold 3d', 'HysteresisThreshold3dImg', listParams, listOutputs, folder, docTitle='Hysteresis Threshold 3d',favorite=True)

# Isodata Threshold binarization
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
    ]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Isodata Threshold binarization', 'IsoDataThresholdImg', listParams, listOutputs, folder, docTitle='Isodata Threshold binarization')

# Kapur Threshold binarization
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Histogram', InputType.HISTOGRAM, defaultValue='', isMandatory=False),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Kapur Threshold binarization', 'KapurThresholdImg', listParams, listOutputs, folder, docTitle='Kapur Threshold binarization')
""

# Kittler Threshold binarization
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Histogram', InputType.HISTOGRAM, defaultValue='', isMandatory=False),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Kittler Threshold binarization', 'KittlerThresholdImg', listParams, listOutputs, folder, docTitle='Kittler Threshold binarization')

# Otsu Threshold binarization
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Histogram', InputType.HISTOGRAM, defaultValue='', isMandatory=False),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE)]
functionNode = generateXmlElement('Otsu Threshold binarization', 'OtsuThresholdImg', listParams, listOutputs, folder, docTitle='Otsu Threshold binarization',favorite=True)

# Simple Threshold binarization
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_NOTBINARY]),
    SelectorParameterDescription('Threshold', selectorType=SelectorType.RANGE, textWhileSelecting='Select values on the slider then validate')
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('Simple Threshold', 'ThresholdImg', listParams, listOutputs, folder, docTitle='Simple Threshold binarization', tags=['Threshold'],favorite=True)
#The attribute "tags" allows to have a custom name if the function search bar

# TopHat 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_NOTBINARY]),
    structuringElem2DParameterDescription,
    # ParameterDescription('Threshold', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True),
    SelectorParameterDescription('Threshold', selectorType=SelectorType.SIMPLERANGE, textWhileSelecting='Select values on the slider then validate')
    # todo border policy
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('TopHat 2D', 'TopHat2d', listParams, listOutputs, folder, docTitle='TopHat 2d',favorite=True)

# TopHat 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_NOTBINARY]),
    structuringElem3DParameterDescription,
    EnumParameterDescription('Type', InputType.ENUM, enumList=['Light', 'Dark'], defaultValue=0, isMandatory=True),
    SelectorParameterDescription('Threshold', selectorType=SelectorType.SIMPLERANGE, textWhileSelecting='Select values on the slider then validate')
    # todo border policy
]
listOutputs = [OutputDescription('Output image', InputType.IMAGE)]
functionNode = generateXmlElement('TopHat 3D', 'TopHat3d', listParams, listOutputs, folder, docTitle='TopHat 3d',favorite=True)
