from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList, structuringElem2DParameterDescription, structuringElem3DParameterDescription
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

####################
# Basic Morphology #
####################
folder = vrb.folderFunctions + '/BasicMorphology'

neighboor2D=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity]
neighboor3D=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity]

# Boundary 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=neighboor2D, defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Boundary 2D', 'Boundary2dImg', listParams, listOutputs, folder, docTitle='Boundary 2d',favorite=True)
# Boundary 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.BUFFER_TYPE_BINARY]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=neighboor3D, defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Boundary 3D', 'Boundary3dImg', listParams, listOutputs, folder, docTitle='Boundary 3d',favorite=True)

# Closing 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    structuringElem2DParameterDescription,
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Closing 2D', 'Closing2dImg', listParams, listOutputs, folder, docTitle='Closing 2d',favorite=True)
# Closing 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    structuringElem3DParameterDescription,
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Closing 3D', 'Closing3dImg', listParams, listOutputs, folder, docTitle='Closing 3d',favorite=True)

# Dilation 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    structuringElem2DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilation 2D', 'Dilate2dImg', listParams, listOutputs, folder, docTitle='Dilation 2d',favorite=True)
# Dilation 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    structuringElem3DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilation 3D', 'Dilate3dImg', listParams, listOutputs, folder, docTitle='Dilation 3d',favorite=True)

# Distance Map 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Output in Real32', InputType.BOOLEAN ,defaultValue=False),
    ParameterDescription('Maximum distance', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=30)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Distance Map 2D', 'DistanceMap2dImg', listParams, listOutputs, folder, docTitle='Distance Map 2d',favorite=True)
# Distance Map 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS, ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Output in Real32', InputType.BOOLEAN, defaultValue=False),
    ParameterDescription('Maximum distance', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False,defaultValue=30)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Distance Map 3D', 'DistanceMap3dImg', listParams, listOutputs, folder, docTitle='Distance Map 3d',favorite=True)

# Erosion 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    structuringElem2DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Erosion 2D', 'Erode2dImg', listParams, listOutputs, folder, docTitle='Erosion 2d',favorite=True)
# Erosion 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    structuringElem3DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Erosion 3D', 'Erode3dImg', listParams, listOutputs, folder, docTitle='Erosion 3d',favorite=True)

# Morphological Gradient 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    structuringElem2DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Morphological Gradient 2D', 'MorphoGradient2dImg', listParams, listOutputs, folder, docTitle='Morphological Gradient 2d')
# Morphological Gradient 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    structuringElem3DParameterDescription
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Morphological Gradient 3D', 'MorphoGradient3dImg', listParams, listOutputs, folder, docTitle='Morphological Gradient 3d')

# Opening 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    structuringElem2DParameterDescription,
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Opening 2D', 'Opening2dImg', listParams, listOutputs, folder, docTitle='Opening 2d',favorite=True)
# Opening 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    structuringElem3DParameterDescription,
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Opening 3D', 'Opening3dImg', listParams, listOutputs, folder, docTitle='Opening 3d',favorite=True)

# Union linear closing 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Number of angles', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=8),
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Union linear closing 2D', 'UnionLinearClosing2dImg', listParams, listOutputs, folder, docTitle='Union linear closing 2d')

# Union linear closing 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Number of angles', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=16),
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Union linear closing 3D', 'UnionLinearClosing3dImg', listParams, listOutputs, folder, docTitle='Union linear closing 3d')

# Union linear opening 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Number of angles', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=8),
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Union linear opening 2D', 'UnionLinearOpening2dImg', listParams, listOutputs, folder, docTitle='Union linear opening 2d')

# Union linear opening 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Radius', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=3),
    ParameterDescription('Number of angles', InputType.SCALAR, [ScalarConstraint.NATURAL], isMandatory=False,defaultValue=16),
    ParameterDescription('Border extension', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Union linear opening 3D', 'UnionLinearOpening3dImg', listParams, listOutputs, folder, docTitle='Union linear opening 3d')


# Skeleton 2D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    EnumParameterDescription('Skeleton Type', InputType.ENUM, enumList=[PyIPSDK.eSkeletonAlgoType.eSAT_Default, PyIPSDK.eSkeletonAlgoType.eSAT_Smooth], defaultValue=0, isMandatory=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Skeleton 2D', 'Skeleton2dImg', listParams, listOutputs, folder, docTitle='Skeleton 2d calculation')

# Skeleton 3D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY,ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Skeleton Type', InputType.ENUM, enumList=[PyIPSDK.eSkeletonAlgoType.eSAT_Default, PyIPSDK.eSkeletonAlgoType.eSAT_Smooth], defaultValue=0, isMandatory=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Skeleton 3D', 'Skeleton3dImg', listParams, listOutputs, folder, docTitle='Skeleton 3d calculation')

# Pruning 2D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Number Max Iter', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=0, isMandatory=False),
    ParameterDescription('Keep all', InputType.BOOLEAN, defaultValue=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Pruning 2D', 'Pruning2dImg', listParams, listOutputs, folder, docTitle='Pruning of 2d skeletons')

# Pruning 3D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY,ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number Max Iter', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=0, isMandatory=False),
    ParameterDescription('Keep all', InputType.BOOLEAN, defaultValue=False),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Pruning 3D', 'Pruning3dImg', listParams, listOutputs, folder, docTitle='Pruning of 3d skeletons')

# Add marker
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Label value', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Add marker', 'AddMarkerImg', listParams, listOutputs, folder, docTitle='Add a marker in a label image')

# checkMultiphasedNeighourhood2dImg
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Number of labels', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Ignore Foreground', InputType.BOOLEAN, defaultValue=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Check number of neighbouring labels 2D', 'CheckMultiphasedNeighourhood2dImg', listParams, listOutputs, folder, docTitle='Check multiphased 2d neighourhood')

# checkMultiphasedNeighourhood3dImg
listParams = [
    ParameterDescription('Label Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL,ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number of labels', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=2),
    ParameterDescription('Ignore Foreground', InputType.BOOLEAN, defaultValue=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Check number of neighbouring labels 3D', 'CheckMultiphasedNeighourhood3dImg', listParams, listOutputs, folder, docTitle='Check multiphased 3d neighourhood')