from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint, FunctionDimension
import UsefullVariables as vrb

import PyIPSDK

##################
#   Arithmetic   #
##################
folder = vrb.folderFunctions + '/Arithmetic'
# Absolute value
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Absolute value', 'AbsImg', listParams, listOutputs, folder, docTitle='Absolute value',favorite=True)

# AddImgImg
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Addition Image', 'AddImgImg', listParams, listOutputs, folder, docTitle='Addition',favorite=True)

# AddScalarImg
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Scalar', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Addition Image Scalar', 'AddScalarImg', listParams, listOutputs, folder, docTitle='Addition with a scalar',favorite=True)

# Blending
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE),
    ParameterDescription('Mult. coef [0;1]', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Blending', 'BlendImgImg', listParams, listOutputs, folder, docTitle='Blending')

# Bounding
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    ParameterDescription('Minimum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Maximum', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=255)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Bounding', 'BoundImg', listParams, listOutputs, folder, docTitle='Bounding')

# Cartesian to polar
listParams = [
    ParameterDescription('Image X', InputType.IMAGE),
    ParameterDescription('Image Y', InputType.IMAGE)
]
listOutputs = [
    OutputDescription('Output name Image Rho', OutputType.IMAGE),
    OutputDescription('Output name Image Theta', OutputType.IMAGE)
]
functionNode = generateXmlElement('Cartesian To Polar', 'CartesianToPolarImg', listParams, listOutputs, folder, docTitle='Cartesian to polar transformation')

# Division
listParams = [
    ParameterDescription('Image Numerator', InputType.IMAGE),
    ParameterDescription('Image Denominator', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Division', 'DivideImgImg', listParams, listOutputs, folder, docTitle='Division')

# Formula 2d
listUserName = ['Number optional image: 0', '1 Image', '2 Images', '3 Images']
listName = ['0', '1', '2', '3']
parametersDescriptions0 = [ParameterDescription('Width', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=500), ParameterDescription('Height', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=500),
                           EnumParameterDescription('Buffer Type', enumList=eImageBufferTypeList), ParameterDescription('Color?', InputType.BOOLEAN, defaultValue=False)]
parametersDescriptions1 = [ParameterDescription('I1', InputType.IMAGE)]
parametersDescriptions2 = [ParameterDescription('I1', InputType.IMAGE), ParameterDescription('I2', InputType.IMAGE)]
parametersDescriptions3 = [ParameterDescription('I1', InputType.IMAGE), ParameterDescription('I2', InputType.IMAGE), ParameterDescription('I3', InputType.IMAGE)]
listParams = [
    AdvancedEnumParameterDescription('Images', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[parametersDescriptions0, parametersDescriptions1, parametersDescriptions2, parametersDescriptions3]),
    ParameterDescription('Formula', InputType.FORMULA)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Formula 2D', 'Formula2dImg', listParams, listOutputs, folder, docTitle='Formula 2d image algorithm',favorite=True)


# Formula 3d
listUserName = ['Number optional image: 0', '1 Image', '2 Images', '3 Images']
listName = ['0', '1', '2', '3']
parametersDescriptions0 = [ParameterDescription('Size X', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100), ParameterDescription('Size Y', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100), ParameterDescription('Size Z', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100),
                           EnumParameterDescription('Buffer Type', enumList=eImageBufferTypeList)]
parametersDescriptions1 = [ParameterDescription('I1', InputType.IMAGE)]
parametersDescriptions2 = [ParameterDescription('I1', InputType.IMAGE), ParameterDescription('I2', InputType.IMAGE)]
parametersDescriptions3 = [ParameterDescription('I1', InputType.IMAGE), ParameterDescription('I2', InputType.IMAGE), ParameterDescription('I3', InputType.IMAGE)]
listParams = [
    AdvancedEnumParameterDescription('Images', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[parametersDescriptions0, parametersDescriptions1, parametersDescriptions2, parametersDescriptions3]),
    ParameterDescription('Formula', InputType.FORMULA)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Formula 3D', 'Formula3dImg', listParams, listOutputs, folder, docTitle='Formula 3d image algorithm',favorite=True)

# Addition between images with different dimensions
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Addition different dimensions', 'GenericAddImgImg', listParams, listOutputs, folder, docTitle='Addition between images with different dimensions', dimension=FunctionDimension.BOTH)
# Division between images with different dimensions
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Division different dimensions', 'GenericDivideImgImg', listParams, listOutputs, folder, docTitle='Division between images with different dimensions', dimension=FunctionDimension.BOTH)
# Multiplication between images with different dimensions
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Multiplication different dimensions', 'GenericMultiplyImgImg', listParams, listOutputs, folder, docTitle='Multiplication between images with different dimensions', dimension=FunctionDimension.BOTH)
# Subtraction between images with different dimensions
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [
    OutputDescription('Output name', OutputType.IMAGE),
]
functionNode = generateXmlElement('Subtraction different dimensions', 'GenericSubtractImgImg', listParams, listOutputs, folder, docTitle='Subtraction between images with different dimensions', dimension=FunctionDimension.BOTH)


# L1 Norm
listUserName = ['2 Images', '3 Images']
listName = ['2', '3']
choice1 = [ParameterDescription('Image 1', InputType.IMAGE), ParameterDescription('Image 2', InputType.IMAGE)]
choice2 = [ParameterDescription('Image 1', InputType.IMAGE), ParameterDescription('Image 2', InputType.IMAGE), ParameterDescription('Image 3', InputType.IMAGE)]
listParams = [
    AdvancedEnumParameterDescription('Images', usernameList=listUserName, nameList=listName, parametersDescriptionsList=[choice1, choice2]),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('L1 Norm', 'L1Norm', listParams, listOutputs, folder, docTitle='L1 Norm (taxicab) of 2 images')

# L2 Norm
functionNode = generateXmlElement('L2 Norm', 'L2Norm', listParams, listOutputs, folder, docTitle='L2 Norm (Euclidian) of 2 images',favorite=True)

# Linear combination
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE),
    ParameterDescription('Coef Image 1', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5),
    ParameterDescription('Coef Image 2', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0.5)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Linear Combination', 'LinearCombineImgImg', listParams, listOutputs, folder, docTitle='Linear combination')

# Maximum (+ of absolute values)
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE),
    ParameterDescription('Absolute values', InputType.BOOLEAN)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Maximum', 'MaxImgImg', listParams, listOutputs, folder, docTitle='Maximum',favorite=True)

# Minimum
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Minimum', 'MinImgImg', listParams, listOutputs, folder, docTitle='Minimum',favorite=True)

# Addition Ponderated Image Scalar
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Mult Factor', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1),
    ParameterDescription('Offset', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Addition Ponderated Image And Scalar', 'MultiplyAddScalarImg', listParams, listOutputs, folder, docTitle='Addition between a ponderated image and a scalar')

# Multiplication Image
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Multiplication Image', 'MultiplyImgImg', listParams, listOutputs, folder, docTitle='Multiplication')

# Multiplication Scalar
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Factor', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Multiplication Scalar', 'MultiplyScalarImg', listParams, listOutputs, folder, docTitle='Multiplication by a scalar',favorite=True)

# Polar to cartesian
listParams = [
    ParameterDescription('Image Rho', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_REAL]),
    ParameterDescription('Image Theta', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_REAL])
]
listOutputs = [OutputDescription('Output name Image X', OutputType.IMAGE), OutputDescription('Output name Image Y', OutputType.IMAGE)]
functionNode = generateXmlElement('Polar To Cartesian', 'PolarToCartesianImg', listParams, listOutputs, folder, docTitle='Polar to cartesian transformation')

# Rounding
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_REAL]),
    EnumParameterDescription('Output buffer', enumList=eImageBufferTypeList)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Rounding', 'RoundImg', listParams, listOutputs, folder, docTitle='Rounding')
# Square root
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Square Root', 'SqrtImg', listParams, listOutputs, folder, docTitle='Square root')
# Square
listParams = [
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Square', 'SquareImg', listParams, listOutputs, folder, docTitle='Square')
# Subtraction Image
listParams = [
    ParameterDescription('Image 1', InputType.IMAGE),
    ParameterDescription('Image 2', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Subtraction Image', 'SubtractImgImg', listParams, listOutputs, folder, docTitle='Subtraction',favorite=True)
# Subtraction Scalar
listParams = [
    ParameterDescription('Scalar', InputType.SCALAR, [ScalarConstraint.REAL],defaultValue=0),
    ParameterDescription('Image', InputType.IMAGE)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Subtraction Scalar Image', 'SubtractScalarImg', listParams, listOutputs, folder, docTitle='Subtraction of a scalar and an image',favorite=True)