from scriptsCreation._FunctionToXML import ParameterDescription, EnumParameterDescription, AdvancedEnumParameterDescription, \
    SelectorParameterDescription, UserParameterDescription, OutputDescription, generateXmlElement, eImageBufferTypeList
from WidgetTypes import InputType, OutputType, ImageConstraint, ScalarConstraint
import UsefullVariables as vrb

import PyIPSDK

##################
# Adv Morphology #
##################
folder = vrb.folderFunctions + '/AdvMorphology'

# Binary reconstruction 2D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Binary mark image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Binary Reconstruction 2D', 'BinaryReconstruction2dImg', listParams, listOutputs, folder, docTitle='Binary Reconstruction 2d',favorite=True)

# Binary reconstruction 3D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Binary mark image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY,ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Binary Reconstruction 3D', 'BinaryReconstruction3dImg', listParams, listOutputs, folder, docTitle='Binary Reconstruction 3d',favorite=True)

# Connected Component 2D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Connected Component 2D', 'ConnectedComponent2dImg', listParams, listOutputs, folder, docTitle='Connected Component 2d',favorite=True)

# Connected Component 3D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Connected Component 3D', 'ConnectedComponent3dImg', listParams, listOutputs, folder, docTitle='Connected Component 3d',favorite=True)

# Dilate Local Extrema 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE,[ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    ParameterDescription('Dilate factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1),
    EnumParameterDescription('Extrema', InputType.ENUM, enumList=['Maxima', 'Minima'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilate Local Extrema 2D', 'DilateLocalExtrema2dImg', listParams, listOutputs, folder, docTitle='Dilate Local Extrema 2d',favorite=True)

# Dilate Local Extrema 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    ParameterDescription('Dilate factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=1),
    EnumParameterDescription('Extrema', InputType.ENUM, enumList=['Maxima', 'Minima'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilate Local Extrema 3D', 'DilateLocalExtrema3dImg', listParams, listOutputs, folder, docTitle='Dilate Local Extrema 3d')

# Fill Hole 2D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Fill Hole 2D', 'FillHole2dImg', listParams, listOutputs, folder, docTitle='Fill hole 2d',favorite=True)

# Fill Hole 3D
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Fill Hole 3D', 'FillHole3dImg', listParams, listOutputs, folder, docTitle='Fill hole 3d',favorite=True)

# Generic Seeded Distance Map 2d
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Binary Seed Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Weight X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    ParameterDescription('Weight Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    ParameterDescription('Weight Diagonals', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Generic Seeded Distance Map 2D', 'GenericSeededDistanceMap2dImg', listParams, listOutputs, folder, docTitle='Generic Seeded Distance Map 2d')

# Generic Seeded Distance Map 3d
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Binary Seed Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Weight X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    ParameterDescription('Weight Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    ParameterDescription('Weight Z', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1),
    ParameterDescription('Weight XY', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Weight XZ', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Weight YZ', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
    ParameterDescription('Weight XYZ', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=0),
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Generic Seeded Distance Map 3D', 'GenericSeededDistanceMap3dImg', listParams, listOutputs, folder, docTitle='Generic Seeded Distance Map 3d')

# Grey Reconstruction 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, []),
    ParameterDescription('Grey mark image', InputType.IMAGE, [ImageConstraint.GREY]),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Grey Reconstruction 2D', 'GreyReconstruction2dImg', listParams, listOutputs, folder, docTitle='Grey Reconstruction 2d')


# Grey Reconstruction 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Grey mark image', InputType.IMAGE, [ImageConstraint.GREY, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Grey Reconstruction 3D', 'GreyReconstruction3dImg', listParams, listOutputs, folder, docTitle='Grey Reconstruction 3d')

# Keep big shape 2d
listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    ParameterDescription('Number of shapes to keep', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Keep big shape 2D', 'KeepBigShape2dImg', listParams, listOutputs, folder, docTitle='Keep big shape 2d',favorite=True)

# Keep big shape 3d
listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number of shapes to keep', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Keep big shape 3D', 'KeepBigShape3dImg', listParams, listOutputs, folder, docTitle='Keep big shape 3d',favorite=True)


# Local Extrema 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, []),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Extrema 2D', 'LocalExtrema2dImg', listParams, listOutputs, folder, docTitle='Local Extrema 2d')

# Local Extrema 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Local Extrema 3D', 'LocalExtrema3dImg', listParams, listOutputs, folder, docTitle='Local Extrema 3d')


# Extrema Propagation 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, []),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Extrema Propagation 2D', 'ExtremaPropagation2dImg', listParams, listOutputs, folder, docTitle='Max Propagation 2d')

# Extrema Propagation 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Extremum type', InputType.ENUM, enumList=['Minimum', 'Maximum'], defaultValue=0, isMandatory=True),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Extrema Propagation 3D', 'ExtremaPropagation3dImg', listParams, listOutputs, folder, docTitle='Max Propagation 3d')


# Remove Border 2D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Remove Border 2D', 'RemoveBorder2dImg', listParams, listOutputs, folder, docTitle='Remove Border 2d',favorite=True)

# Remove Border 3D
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False),
    EnumParameterDescription('Optimization Policy', InputType.ENUM, enumList=[PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed, PyIPSDK.eProcessingOptimizationPolicy.ePOP_MinimizeMemory], defaultValue=0, isMandatory=False)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Remove Border 3D', 'RemoveBorder3dImg', listParams, listOutputs, folder, docTitle='Remove Border 3d',favorite=True)

# Remove small shape 2d
listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL]),
    ParameterDescription('Minimal shapes size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Remove small shape 2D', 'RemoveSmallShape2dImg', listParams, listOutputs, folder, docTitle='Remove small shape 2d',favorite=True)

# Remove small shape 3d
listParams = [
    ParameterDescription('Image label', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY_OR_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Minimal shape size', InputType.SCALAR, [ScalarConstraint.NATURAL],defaultValue=100)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Remove small shapes 3D', 'RemoveSmallShape3dImg', listParams, listOutputs, folder, docTitle='Remove small shape 3d',favorite=True)


# Seeded Distance Map 2d
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Binary Seed Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Pixel size X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False),
    ParameterDescription('Pixel size Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood2dType.eN2T_4Connexity, PyIPSDK.eNeighborhood2dType.eN2T_8Connexity], defaultValue=0, isMandatory=False),
    ParameterDescription('Maximum distance', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=30)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Seeded Distance Map 2D', 'SeededDistanceMap2dImg', listParams, listOutputs, folder, docTitle='Seeded Distance Map 2d')

# Seeded Distance Map 3d
listParams = [
    ParameterDescription('Binary Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Binary Seed Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Pixel size X', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False),
    ParameterDescription('Pixel size Y', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False),
    ParameterDescription('Pixel size Z', InputType.SCALAR, [ScalarConstraint.REAL], defaultValue=1, isMandatory=False),
    EnumParameterDescription('Neighborhood', InputType.ENUM, enumList=[PyIPSDK.eNeighborhood3dType.eN3T_6Connexity, PyIPSDK.eNeighborhood3dType.eN3T_18Connexity, PyIPSDK.eNeighborhood3dType.eN3T_26Connexity], defaultValue=0, isMandatory=False),
    ParameterDescription('Maximum distance', InputType.SCALAR, [ScalarConstraint.REAL], isMandatory=False, defaultValue=30)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Seeded Distance Map 3D', 'SeededDistanceMap3dImg', listParams, listOutputs, folder, docTitle='Seeded Distance Map 3d')


# Seeded Watershed 2d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Label mark image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    EnumParameterDescription('Separation Mode', enumList=['eWOM_Basins', 'eWOM_Lines']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed'], isMandatory=False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Seeded Watershed 2D', 'SeededWatershed2dImg', listParams, listOutputs, folder, docTitle='Seeded Watershed 2d')

# Seeded Watershed 3d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Label mark image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Separation Mode', enumList=['eWOM_Basins', 'eWOM_Lines']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed'], isMandatory=False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Seeded Watershed 3D', 'SeededWatershed3dImg', listParams, listOutputs, folder, docTitle='Seeded Watershed 3d')


# Watershed 2d
listParams = [
    ParameterDescription('Binary image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Dilation Factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=4),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split_Binary', 'eWSM_Split_Label', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed' ],isMandatory = False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Binary Separation 2D', 'WatershedBinarySeparation2dImg', listParams, listOutputs, folder, docTitle='Watershed Binary Separation 2d',favorite=True)

# Watershed 3d
listParams = [
    ParameterDescription('Binary image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Dilation Factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=4),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split_Binary', 'eWSM_Split_Label', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed'], isMandatory=False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Binary Separation 3D', 'WatershedBinarySeparation3dImg', listParams, listOutputs, folder, docTitle='Watershed Binary Separation 3d',favorite=True)

# Adaptative Watershed 2d
listParams = [
    ParameterDescription('Binary image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY]),
    ParameterDescription('Ratio', InputType.SCALAR, defaultValue=0.5),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split_Binary', 'eWSM_Split_Label', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed'], isMandatory=False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Binary Adaptive 2D', 'AdaptiveBinaryWatershed2dImg', listParams, listOutputs, folder, docTitle='Adaptive Watershed Binary Separation 2d',favorite=True)

# Adaptative Watershed 3d
listParams = [
    ParameterDescription('Binary image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY, ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Ratio', InputType.SCALAR, defaultValue=0.5),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split_Binary', 'eWSM_Split_Label', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed'], isMandatory=False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Binary Adaptive 3D', 'AdaptiveBinaryWatershed3dImg', listParams, listOutputs, folder, docTitle='Adaptive Watershed Binary Separation 3d',favorite=True)

# Watershed grey 2d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    EnumParameterDescription('Shapes consideration mode', enumList=['eSGT_Light', 'eSGT_Dark'], defaultValue=0),
    ParameterDescription('Dilation Factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=4),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed' ],isMandatory = False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Grey Separation 2D', 'WatershedGreySeparation2dImg', listParams, listOutputs, folder, docTitle='Watershed Grey Separation 2d',favorite=True)

# Watershed grey 3d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY, ImageConstraint.THREE_DIMENSIONS,ImageConstraint.BUFFER_TYPE_INT_OR_REAL]),
    EnumParameterDescription('Shapes consideration mode', enumList=['eSGT_Light', 'eSGT_Dark'], defaultValue=0),
    ParameterDescription('Dilation Factor', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=4),
    EnumParameterDescription('Separation Mode', enumList=['eWSM_Split', 'eWSM_Lines', 'eWSM_Basins']),
    EnumParameterDescription('Processing Mode', enumList=['eWPM_Repeatable', 'eWPM_OptimizeSpeed' ],isMandatory = False,defaultValue=1)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Watershed Grey Separation 3D', 'WatershedGreySeparation3dImg', listParams, listOutputs, folder, docTitle='Watershed Grey Separation 3d',favorite=True)

# Ridge Line 2d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY]),
    ParameterDescription('Optional mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY], isMandatory=False),
    EnumParameterDescription('Propagation axis', enumList=['ePA_X', 'ePA_Y'], defaultValue=0),
    ParameterDescription('Number iteration', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50, isMandatory=False),
    EnumParameterDescription('Intensity', enumList=['Dark','Light'], defaultValue=0)
]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE), OutputDescription('Output list', OutputType.MEASURE)]
functionNode = generateXmlElement('Ridge Line 2D', 'RidgeLine2dImg', listParams, listOutputs, folder, docTitle='Ridge Line 2d')

# Ridge Line 3d
listParams = [
    ParameterDescription('Grey image', InputType.IMAGE, [ImageConstraint.GREY,ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Optional mask', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_BINARY,ImageConstraint.THREE_DIMENSIONS], isMandatory=False),
    EnumParameterDescription('Propagation axis', enumList=['ePA_X', 'ePA_Y','ePA_Z'], defaultValue=0),
    ParameterDescription('Number iteration', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=50, isMandatory=False),
    EnumParameterDescription('Intensity', enumList=['Dark','Light'], defaultValue=0)

]
listOutputs = [OutputDescription('Output image name', OutputType.IMAGE), OutputDescription('Output list', OutputType.MEASURE)]
functionNode = generateXmlElement('Ridge Line 3D', 'RidgeLine3dImg', listParams, listOutputs, folder, docTitle='Ridge Line 3d')

# # Super pixels 2d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE),
#     ParameterDescription('Parameter value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=500),
#     ParameterDescription('Compactness', InputType.SCALAR, defaultValue=0.5),
#     ParameterDescription('Nb Iter', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=3),
#     ParameterDescription('Size ratio', InputType.SCALAR, defaultValue=0.5,isMandatory=False),
#     EnumParameterDescription('Parameter type', enumList=['eSPT_Number', 'eSPT_Size'], defaultValue=0,isMandatory=False),
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Super Pixels 2D', 'SuperPixels2dImg', listParams, listOutputs, folder, docTitle='Super Pixels 2d')

# Super pixels 2d
listParams = [
    ParameterDescription('Image', InputType.IMAGE),
    ParameterDescription('Number,Size', InputType.SCALAR_CHOICE, [ScalarConstraint.NATURAL], defaultValue=[500,10]),
    ParameterDescription('Compactness', InputType.SCALAR, defaultValue=0.5),
    ParameterDescription('Nb Iter', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=3),
    ParameterDescription('Size ratio', InputType.SCALAR, defaultValue=0.5,isMandatory=False),
    EnumParameterDescription('Separation Mode', enumList=['Label,Lines,Basins'],defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Super Pixels 2D', 'SuperPixels2dImg', listParams, listOutputs, folder, docTitle='Super Pixels 2d')

# Super voxels 3d
listParams = [
    ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
    ParameterDescription('Number,Size', InputType.SCALAR_CHOICE, [ScalarConstraint.NATURAL], defaultValue=[500,10]),
    ParameterDescription('Compactness', InputType.SCALAR, defaultValue=0.5),
    ParameterDescription('Nb Iter', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=3),
    ParameterDescription('Size ratio', InputType.SCALAR, defaultValue=0.5,isMandatory=False),
    EnumParameterDescription('Separation Mode', enumList=['Label,Lines,Basins'],defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Super Voxels 3D', 'SuperVoxels3dImg', listParams, listOutputs, folder, docTitle='Super Voxels 3d')

# # Super voxels 3d
# listParams = [
#     ParameterDescription('Image', InputType.IMAGE, [ImageConstraint.THREE_DIMENSIONS]),
#     ParameterDescription('Parameter value', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=500),
#     ParameterDescription('Compactness', InputType.SCALAR, defaultValue=0.5),
#     ParameterDescription('Nb Iter', InputType.SCALAR, [ScalarConstraint.NATURAL], defaultValue=3),
#     ParameterDescription('Size ratio', InputType.SCALAR, defaultValue=0.5,isMandatory=False),
#     EnumParameterDescription('Parameter type', enumList=['eSPT_Number', 'eSPT_Size'], defaultValue=0,isMandatory=False),
# ]
# listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
# functionNode = generateXmlElement('Super Voxels 3D', 'SuperVoxels3dImg', listParams, listOutputs, folder, docTitle='Super Voxels 3d')


# Dilate Label 2D
listParams = [
    ParameterDescription('Input Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL]),
    EnumParameterDescription('Mode', InputType.ENUM, enumList=["eDLM_Basins", "eDLM_Split"], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilate Label 2D', 'DilateLabel2dImg', listParams, listOutputs, folder, docTitle='Dilation of 2D labels')

# Dilate Label 3D
listParams = [
    ParameterDescription('Input Image', InputType.IMAGE, [ImageConstraint.BUFFER_TYPE_LABEL, ImageConstraint.THREE_DIMENSIONS]),
    EnumParameterDescription('Mode', InputType.ENUM, enumList=[PyIPSDK.eDilateLabelMode.eDLM_Basins, PyIPSDK.eDilateLabelMode.eDLM_Split], defaultValue=0)
]
listOutputs = [OutputDescription('Output name', OutputType.IMAGE)]
functionNode = generateXmlElement('Dilate Label 3D', 'DilateLabel3dImg', listParams, listOutputs, folder, docTitle='Dilation of 3D labels')
