import sys,os

import DatabaseFunction as Dfct

import UsefullVariables as vrb
import UsefullFunctions as fct

import WidgetTypes

##############
#   Useful   #
##############


def xmlToParamList(xmlElement, listParameters=None, process=True):

    paramsDict = {}
    for param in Dfct.SubElement(xmlElement, 'Parameters'):
        numParam = int(param.tag.split("_")[1])
        typeParam = WidgetTypes.InputType.stringToType(Dfct.childText(param, 'Type'))
        if typeParam == WidgetTypes.InputType.ADVANCED:
            if listParameters is not None:
                paramName = listParameters[numParam]
            else:
                paramName = None
            paramsDict[numParam] = WidgetTypes.InputType.typeToClass(typeParam).xmlToValue(param, paramName=paramName, process=process)
        else:
            paramsDict[numParam] = WidgetTypes.InputType.typeToClass(typeParam).xmlToValue(param)

    params = [paramsDict[i] for i in range(len(paramsDict))]
    vrb.printDebug('Parameters: ' + str(params))
    return params


def xmlFunctionCallAdvancedToXmlFunctionCall(xmlFunctionCall, paramNumber):
    xmlParameterAdvanced = Dfct.SubElement(Dfct.SubElement(xmlFunctionCall, 'Parameters'), 'Parameter_' + str(paramNumber))
    xmlParameterAdvancedCopy = Dfct.copyXmlElement(xmlParameterAdvanced)
    Dfct.SubElement(xmlParameterAdvancedCopy, 'Values').tag = 'Parameters'
    return xmlParameterAdvancedCopy


def addToText(text, newText, isEqual):
    if isEqual:
        text += newText
    return text

def copyImageOnScreen(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    text = ""
    text += outImage + ' = copyImageOnScreen()\n'
    return text

def interactiveZStack(xmlFunctionCall, outImage="outImage", process=True):

    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    method = str(Dfct.childText(Dfct.SubElement(parameters, 'Parameter_0'),"Value"))
    contrastSize = str(Dfct.childText(Dfct.SubElement(parameters, 'Parameter_1'),"Value"))
    meanSmoothing = str(Dfct.childText(Dfct.SubElement(parameters, 'Parameter_2'),"Value"))
    zoomFactor = str(Dfct.childText(Dfct.SubElement(parameters, 'Parameter_3'),"Value"))

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)

    text += '#image3D must be defined before calling the function\n'
    if method == "Poderation":
        text += outImage + ' = filtering.zStackFocusPonderationImg(image3D, ' + contrastSize + ', ' + meanSmoothing + ', ' + zoomFactor + ')\n'
    else:
        text += outImage + ' = filtering.zStackFocusMaximumImg(image3D, ' + contrastSize + ', ' + meanSmoothing + ', ' + zoomFactor + ')\n'

    return text

def generateImageCalibration(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    parameters[7] = parameters[7][1:-1]
    parameters[8] = parameters[8][1:-1]
    if parameters[9] == '"True"':
        parameters[9] = "True"
    else:
        parameters[9] = "False"
    text = ""

    text = addToText(text, '###import UsefullFunctions as fct\n', not process)

    text += outImage + ' = fct.calibrationIncrustationImg('+parameters[0]+','+str(parameters[1])+','+str(parameters[2])+','+str(parameters[3])+','+str(parameters[4])+','+str(parameters[5]) +','+str(parameters[6])+','+str(parameters[7])+','+str(parameters[8])+','+str(parameters[9])+')\n'

    return text

def createMaskFromPolygon(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    param_0 = Dfct.SubElement(parameters, 'Parameter_0')
    polygon = Dfct.SubElement(param_0, 'Value').text
    text = ""
    text += outImage + ' = createMaskFromPolygon("' + polygon + '")\n'
    return text

def createColorCalibrationImage(xmlFunctionCall, outImage="outImage", process=True):

    text = ""
    text += outImage + ' = createMaskFromPolygon()\n'
    return text

def createMaskedImageFromPolygon(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    param_0 = Dfct.SubElement(parameters, 'Parameter_0')
    polygon = Dfct.SubElement(param_0, 'Value').text
    text = ""
    text += outImage + ' = createMaskedImageFromPolygon("' + polygon + '")\n'
    return text

def createLabelImageFromPolygon(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    param_0 = Dfct.SubElement(parameters, 'Parameter_0')
    polygon = Dfct.SubElement(param_0, 'Value').text
    text = ""
    text += outImage + ' = createLabelImageFromPolygon("' + polygon + '")\n'
    return text

def loadImage(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    parameter0 = Dfct.SubElement(parameters, 'Parameter_0')
    parameter1 = Dfct.SubElement(parameters, 'Parameter_1')
    url = Dfct.convertTextFromAscii(Dfct.childText(parameter0, 'Value'))
    isDisk = Dfct.childText(parameter1, 'Value')
    urlSplit = url.split('.')
    extension = urlSplit[len(urlSplit) - 1]
    text = ""

    if extension in ["jpg", "JPG","jpeg", "JPEG", "PNG", "png", "BMP", "bmp","czi","CZI","dcm","DCM","nii","NII","txm","TXM","am","AM"]:
        text += '#####function readImage\n'
        text = addToText(text, '###import UsefullFunctions as fct\n', not process)
        text += outImage + ' = fct.readImage("' + url + '")\n'
    else:
        if isDisk == "True":
            if len(urlSplit) > 1:
                text += outImage + ' = PyIPSDK.openTiffImageFile("' + url + '", PyIPSDK.eTDM_Volume, PyIPSDK.eTBM_Default))\n'
            else:
                text += outImage + ' = PyIPSDK.openTiffImageFiles("' + url + '", PyIPSDK.eTDM_Volume, PyIPSDK.eTBM_Default))\n'
        else:
            if len(urlSplit) > 1:
                text += outImage + ' = PyIPSDK.loadTiffImageFile("' + url + '")\n'
            else:
                text += outImage + ' = PyIPSDK.loadTiffImageFiles("' + url + '")\n'
    return text

def loadObject(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    parameter0 = Dfct.SubElement(parameters, 'Parameter_0')
    url = Dfct.convertTextFromAscii(Dfct.childText(parameter0, 'Value'))
    urlSplit = url.split('.')
    extension = urlSplit[len(urlSplit) - 1]
    text = ""
    if extension.lower() == "xml":
        text += outImage + ' = PyIPSDK.readFromXmlFile("' + url + '")\n'
    elif extension.lower() == "bin":
        text += outImage + ' = PyIPSDK.readFromBinaryFile("' + url + '")\n'
    return text

def loadImageRaw(xmlFunctionCall, outImage="outImage", process=True):
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    parameter0 = Dfct.SubElement(parameters, 'Parameter_0')
    url = Dfct.convertTextFromAscii(Dfct.childText(parameter0, 'Value'))
    parameter1 = Dfct.SubElement(parameters, 'Parameter_1')
    geometry = Dfct.childText(parameter1, 'Value')
    parameter2 = Dfct.SubElement(parameters, 'Parameter_2')
    offset = Dfct.childText(parameter2, 'Value')
    text = ""
    text += "geometry = "+geometry
    text += "offset = "+offset
    text += outImage + ' = PyIPSDK.loadRawImageFile("' + url + '",geometry,offset)\n'
    return text

def extractImage(xmlFunctionCall, outImage="outImage", process=True):
    #parameters = xmlToParamList(xmlFunctionCall)
    #image,axis,numPlan = parameters
    parameters = Dfct.SubElement(xmlFunctionCall, 'Parameters')
    param0 = Dfct.SubElement(parameters, 'Parameter_0')
    image = "ID_Image_"+Dfct.childText(param0,"Value")+"_ID"
    param1 = Dfct.SubElement(parameters, 'Parameter_1')
    axis = Dfct.childText(param1,"Value")
    param2 = Dfct.SubElement(parameters, 'Parameter_2')
    numPlan = Dfct.childText(param2,"Value")
    param3 = Dfct.SubElement(parameters, 'Parameter_3')
    numSeq = Dfct.childText(param3,"Value")

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeC = Dfct.childText(child, "C")
            colorType = Dfct.childText(child, "ColorType")
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, '###import PyIPSDK\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)
    text = addToText(text, '###import numpy as np\n', not process)

    if sizeC != "1":
        text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
        if colorType == "eCGT_User":
            text += "colorGeometry.initUser("+image+".getSizeC())\n"
        else:
            text += "colorGeometry.init(PyIPSDK."+colorType+")\n"
        text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
        text += "volumeGeometry.init2d()\n"
        text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
        text += "temporalGeometry.initSingle()\n"

    if sizeT != "1":
        if sizeZ == "1":
            if sizeC == "1":
                text += "currentSequence = PyIPSDK.extractPlan(0, 0, " + numSeq + ", " + image + ")\n"
            else:
                text += "currentSequence = PyIPSDK.extractColor(0, " + numSeq + ", " + image + ")\n"
        else:
            if sizeC == "1":
                text += "currentSequence = PyIPSDK.extractVolume(0, " + numSeq + ", " + image + ")\n"
            else:
                text += "currentSequence = PyIPSDK.extractColorVolume(" + numSeq + ", " + image + ")\n"

    if sizeZ != "1":
        if sizeT != "1":
            text += "currentSequence = util.copyImg(currentSequence)\n"
            image = "currentSequence"
        if axis == "Z":
            if sizeC == "1":
                text += outImage + " = PyIPSDK.extractPlan(" + numPlan + ",0,0," + image + ")\n"
            else:
                text += outImage + " = PyIPSDK.extractColor(" + numPlan + ", 0," + image + ")\n"
        else:
            if axis == "X":
                if sizeC == "1":
                    text +="planArray = np.ascontiguousarray("+image+".array[:, :, "+ numPlan +"])\n"
                    text +="geometry = PyIPSDK.geometry2d("+image+".getBufferType(), "+image+".getSizeY(), "+image+".getSizeZ())\n"
                else:
                    text+= "planArray = np.ascontiguousarray("+image+".array[:, :, :, "+ numPlan +"])\n"
                    text+= "geometry = PyIPSDK.geometry("+image+".getBufferType(), " + image + ".getSizeY(), " + image + ".getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)\n"
            if axis == "Y":
                if sizeC == "1":
                    text +="planArray = np.ascontiguousarray("+image+".array[:, "+numPlan+", :])\n"
                    text +="geometry = PyIPSDK.geometry2d("+image+".getBufferType(), "+image+".getSizeX(), "+image+".getSizeZ())\n"
                else:
                    text+= "planArray = np.ascontiguousarray("+image+".array[:, :, "+numPlan+", :])\n"
                    text+= "geometry = PyIPSDK.geometry("+image+".getBufferType(), " + image + ".getSizeX(), " + image + ".getSizeZ(), volumeGeometry, colorGeometry, temporalGeometry)\n"
            text += outImage + ' = PyIPSDK.fromArray(planArray, geometry)\n'
        text += outImage + ' = util.copyImg('+outImage+')\n'

            # if sizeC == "1":
            #     text +="planArray = np.ascontiguousarray("+image+".array[" + numPlan + ", :, :])\n"
            #     text +="geometry = PyIPSDK.geometry2d("+image+".getBufferType(), "+image+".getSizeX(), "+image+".getSizeY())\n"
            # else:
            #     text+= "planArray = np.ascontiguousarray("+image+".array[ :," + numPlan + ", :, :])\n"
            #     text+= "geometry = PyIPSDK.geometry("+image+".getBufferType(), " + image + ".getSizeX(), " + image + ".getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)\n"

    else:
        text += outImage + ' = util.copyImg(currentSequence)\n'

    text = addToText(text, "outputs = " + outImage, process)

    return text

def exportImage(xmlFunctionCall, outImage="outImage", process=True):
    text = ""
    text += outImage + ' = exportImageFromCamera()\n'
    return text

def mergeChannelsImage(xmlFunctionCall, outImage="outImage", process=True):
    text = ""
    text += outImage + ' = mergeChannelsImage()\n'
    return text

def createSequenceImage(xmlFunctionCall, outImage="outImage", process=True):
    text = ""
    text += outImage + ' = createSequenceImage()\n'
    return text

def macroFunction(xmlFunctionCall, outImage=None, process=True,preview=False,synchrone = False,forExec=False):

    # Get script text
    pythonPath = vrb.folderFunctions + '/' + Dfct.childText(xmlFunctionCall, 'PythonName') + '.py'
    file = open(pythonPath, 'r')
    scriptText = file.read()
    text = ""
    # Name of the function to call
    functionName = Dfct.childText(xmlFunctionCall, 'ProcessName')
    moduleName = os.path.basename(Dfct.childText(xmlFunctionCall, 'PythonName'))

    if " " in moduleName:
        moduleNameRef = moduleName
        moduleName = moduleName.replace(" ","_")
        text = addToText(text, moduleName +'=__import__("' + moduleNameRef + '")\n', process)
        text = addToText(text, '###'+moduleName +'=__import__("' + moduleNameRef + '")\n', not process)
    else:
        text = addToText(text, "import "+moduleName + "\n",process)
        text = addToText(text, "###import " + moduleName + "\n", not process)

    text = addToText(text, "import importlib\n",process)
    text = addToText(text, "importlib.reload("+moduleName + ")\n",process)
    text = addToText(text, "###import importlib\n",not process)
    text = addToText(text, "###importlib.reload("+moduleName + ")\n",not process)

    if forExec == False:
        text = addToText(text, scriptText, process)

    # Get the parameters of the function
    scriptText = scriptText.replace(' ', '')
    splited = scriptText.split('def' + functionName + '(')[1]
    parametersText = splited.split('):')[0]
    parametersNames = parametersText.split(',')

    vrb.paramMacro = True
    parameters = xmlToParamList(xmlFunctionCall, listParameters=parametersNames, process=process)
    vrb.paramMacro = False
    strParameter = []
    for parameter in parameters:
        # list of parameters name which are not trivial (not a scalar)
        try:
            if not isinstance(parameter, type("")):
                text += parameter[0]
                parameter = parameter[1]
        except:
            pass
        strParameter.append(str(parameter))

    if len(strParameter) != 0:
        textFunction = moduleName+"."+functionName + '(' + '{},' * len(strParameter)
        if process and preview == False and synchrone == False:
            textFunction = textFunction[:-1] + ',self)'
        else:
            textFunction = textFunction[:-1] + ')'
        textFunction = textFunction.format(*strParameter)
    else:
        if process and preview == False and synchrone == False:
            textFunction = moduleName+"."+functionName + '(self)'
        else:
            textFunction = moduleName+"."+functionName + '()'

    if outImage is None:
        outImage = []
        for nb, output in enumerate(Dfct.SubElement(xmlFunctionCall, 'Outputs'), 1):
            outImage.append(Dfct.childText(output, 'Type') + str(nb))
    outputList = ''

    if not isinstance(outImage, type("")):
        for out in outImage:
            outputList += out + ','
        outputList = outputList[:-1]
    else:
        outputList = outImage

    text += outputList + (' = ', '')[outputList == ''] + textFunction + '\n'
    text = addToText(text, "outputs = [" + outputList + ']', process)

    return text
