import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

import math

from processFunction._ProcessFunction import xmlToParamList, addToText

def buildLines2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    listOption, theta, offset = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    if listOption[0] == 'Geometry':
        sizeX = listOption[1]
        sizeY = listOption[2]
        text += outImage + ' = util.buildLines2dImg(' + str(sizeX) + ', '  + str(sizeY) + ', '  + str(theta*math.pi/180) + ', '  + str(offset) + ')\n'
    elif listOption[0] == 'Image':
        imageRef = listOption[1]
        text += "sizeX = {image}.getSizeX()\n"
        text += "sizeY = {image}.getSizeY()\n"
        text += outImage + ' = util.buildLines2dImg(sizeX, sizeY, '  + str(theta*math.pi/180) + ', '  + str(offset) + ')\n'
        text = text.format(image=imageRef)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def buildLines3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    listOption, theta, phi, alpha, offset = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    if listOption[0] == 'Geometry':
        sizeX = listOption[1]
        sizeY = listOption[2]
        sizeZ = listOption[3]
        text += outImage + ' = util.buildLines3dImg(' + str(sizeX) + ', '  + str(sizeY) + ', '  + str(sizeZ) + ', '  + str(theta*math.pi/180) + ', '  + str(phi*math.pi/180) + ', '  + str(alpha*math.pi/180) + ', '  + str(offset) + ')\n'
    elif listOption[0] == 'Image':
        imageRef = listOption[1]
        text += "sizeX = {image}.getSizeX()\n"
        text += "sizeY = {image}.getSizeY()\n"
        text += "sizeZ = {image}.getSizeZ()\n"
        text += outImage + ' = util.buildLines3dImg(sizeX, sizeY, sizeZ, '  + str(theta) + ', '  + str(phi) + ', '  + str(alpha) + ', '  + str(offset) + ')\n'
        text = text.format(image=imageRef)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def copyImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text += outImage + ' = util.copyImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def eraseImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,value = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
    text += "util.eraseImg(" + outImage + "," + str(value) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def convertImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, bufferType = parameters[0], parameters[1]
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    if bufferType == 'PyIPSDK.eImageBufferType.eIBT_Binary':
        text += "###import PyIPSDK.IPSDKIPLLogical as logic\n"
        text += "###import PyIPSDK.IPSDKIPLBinarization as bin\n"
        text += outImage + ' = bin.thresholdImg(' + image + ', 0, 0)\n'
        text += 'logic.logicalNotImg(' + outImage + ', ' + outImage + ')\n'
    else:
        text += outImage + ' = util.convertImg(' + image + ', ' + str(bufferType) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def getROI2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, posX, posY, sizeX, sizeY = parameters
    text = ""
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + ' = util.getROI2dImg(' + image + ', ' + str(posX) + ', ' + str(posY) + ', ' + str(sizeX) + ', ' + str(sizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def getROI3dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image, posX, posY, posZ, sizeX, sizeY, sizeZ = parameters
    text = ""
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + ' = util.getROI3dImg(' + image + ', ' + str(posX) + ', ' + str(posY) + ', ' + str(posZ) + ', ' + str(sizeX) + ', ' + str(sizeY) + ', ' + str(sizeZ) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def gaussianRandomImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    list,mean, stdDev = parameters
    text = ""
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    if list[0] == "Image":
        text += outImage + " = PyIPSDK.createImage("+ list[1] + ", PyIPSDK.eIBT_UInt8)\n"
    elif list[0] == "Geometry":
        if list[4] is None:
            text += outImage + " = PyIPSDK.createImage("+list[1] + "," + str(list[2]) + "," + str(list[3]) + ")\n"
        else:
            text += outImage + " = PyIPSDK.createImage(" + list[1] + "," + str(list[2]) + "," + str(list[3]) + "," + str(list[4]) + ")\n"
    text += "gaussianParameter = PyIPSDK.createGaussianParameter(" + str(mean) + "," + str(stdDev) + ")\n"
    text +=  "util.gaussianRandomImg(gaussianParameter, " + outImage + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def putROI2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, roi, offsetX, offsetY = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + " = PyIPSDK.createImage("+image+")\n"
    text += "util.putROI2dImg("+image+","+ roi+","+ str(offsetX)+","+ str(offsetY)+","+ outImage+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text


def putROI3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, roi, offsetX, offsetY, offsetZ = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + " = PyIPSDK.createImage("+image+")\n"
    text += "util.putROI3dImg("+image+","+ roi+","+ str(offsetX)+","+ str(offsetY)+ "," + str(offsetZ) + "," + outImage+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def randomImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    list,minimum, maximum = parameters
    text = ""
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    if list[0] == "Image":
        text += outImage + " = PyIPSDK.createImage("+ list[1]+")\n"
    elif list[0] == "Geometry":
        if list[4] is None:
            text += outImage + " = PyIPSDK.createImage("+list[1] + "," + str(list[2]) + "," + str(list[3]) + ")\n"
        else:
            text += outImage + " = PyIPSDK.createImage(" + list[1] + "," + str(list[2]) + "," + str(list[3]) + "," + str(list[4]) + ")\n"
    text += "rangeParameter = PyIPSDK.createRange(" + str(minimum) + "," + str(maximum) + ")\n"
    text +=  "util.randomImg(rangeParameter, " + outImage + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def extractPlan(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,zValue,cValue,tValue = parameters[0],parameters[1],parameters[2],parameters[3]

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(image)

    text = ""
    text = addToText(text, "###import PyIPSDK\n", not process)
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"

    text += ""

    if cValue is None:
        if tValue is not None:
            if sizeC == "1":
                text += outImage + "=PyIPSDK.extractPlan(" + str(zValue) + ",0, " + str(tValue) + "," + image + ")\n"
            else:
                text += outImage + "=PyIPSDK.extractColor(" + str(zValue) + "," + str(tValue) + "," + image + ")\n"
        else:
            if sizeC == "1":
                if sizeT == "1":
                    text += outImage + "=PyIPSDK.extractPlan(" + str(zValue) + ",0, 0," + image + ")\n"
                else:
                    text += outImage + "=PyIPSDK.extractTemporal(" + str(zValue) + ",0," + image + ")\n"
            else:
                if sizeT == "1":
                    text += outImage + "=PyIPSDK.extractColor(" + str(zValue) + ", 0," + image + ")\n"
                else:
                    text += outImage + "=PyIPSDK.extractTemporalColor(" + str(zValue) + "," + image + ")\n"
    else:
        if tValue is None:
            if sizeT == "1":
                text += outImage + "=PyIPSDK.extractPlan(" + str(zValue) + "," + str(cValue) + ", 0," + image + ")\n"
            else:
                text += outImage + "=PyIPSDK.extractTemporal(" + str(zValue) + ", " + str(cValue) + ", " + image + ")\n"
        else:
            text += outImage + "=PyIPSDK.extractPlan(" + str(zValue) + "," + str(cValue) + ", " + str(tValue) + "," + image + ")\n"

    text += outImage + "=util.copyImg("+outImage+")\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def createImage(xmlFunctionCall, outImage="outImage", process=True):

    sizeX, sizeY, sizeZ, sizeT, sizeC, bufferType, value = xmlToParamList(xmlFunctionCall)

    text = ""
    text = addToText(text, "###import PyIPSDK\n", not process)

    if sizeZ == 1 and sizeT == 1 and sizeC == 1:
        text += outImage + "=PyIPSDK.createImage(" + bufferType + "," + str(sizeX) + "," + str(sizeY) + ")\n"
    elif sizeZ > 1 and sizeT == 1 and sizeC == 1:
        text += outImage + "=PyIPSDK.createImage(" + bufferType + "," + str(sizeX) + "," + str(sizeY) + "," + str(sizeZ) +")\n"
    elif sizeZ == 1 and sizeT == 1 and sizeC == 3:
        text += outImage + "=PyIPSDK.createImageRgb(" + bufferType + "," + str(sizeX) + "," + str(sizeY) + ")\n"
    elif sizeZ == 1 and sizeT > 1 and sizeC == 1:
        text += outImage + "=PyIPSDK.createImageSeq(" + bufferType + "," + str(sizeX) + "," + str(sizeY) + "," + str(sizeT) +")\n"
    else:
        text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
        if sizeC == 1:
            text += "colorGeometry.initGrey()\n"
        elif sizeC == 3:
            text += "colorGeometry.init(PyIPSDK.eCGT_Rgb)\n"
        else:
            text += "colorGeometry.initUser("+str(sizeC)+")\n"
        text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
        if sizeZ == "1":
            text += "volumeGeometry.init2d()\n"
        else:
            text += "volumeGeometry.init3d("+str(sizeZ)+")\n"
        text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
        if sizeT == "1":
            text += "temporalGeometry.initSingle()\n"
        else:
            text += "temporalGeometry.initSequence("+str(sizeT)+")\n"
        text += "geometry = PyIPSDK.geometry(" + bufferType + "," + str(sizeX) + "," + str(sizeY) + ",volumeGeometry,colorGeometry,temporalGeometry)\n"
        text += outImage + " = PyIPSDK.createImage(geometry)\n"

    # if value is not None:
    text += "util.eraseImg(" + outImage + "," + str(value) + ")\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text


def putSlice3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, sliceImg, axis, sliceIndex = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + " = util.putSlice3dImg("+image+","+ sliceImg +","+ axis+","+ str(sliceIndex) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text


def getSlice3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, axis, sliceIndex = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + " = util.getSlice3dImg("+image+","+ axis+","+ str(sliceIndex) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text


def reinterpretGeometry(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, geometryType = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    if geometryType == 'Volume <-> Sequence':
        text += "img1 = PyIPSDK.reinterpretVolumeSequence(" + image + ")\n"
    elif geometryType == 'Volume <-> Multi-channel':
        text += "img1 = PyIPSDK.reinterpretVolumeMultiChannel(" + image + ")\n"
    elif geometryType == 'Sequence <-> Multi-channel':
        text += "img1 = PyIPSDK.reinterpretSequenceMultiChannel(" + image + ")\n"
    text += outImage + " =  util.copyImg(img1)\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text


def appendSeqImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters
    text = ""
    text += "###import PyIPSDK\n"
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"
    text += outImage + " = util.appendSeqImg("+image1+", "+image2+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def labelToColorImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import UsefullFunctions as fct\n", not process)
    text += outImage + ' = fct.imageLabelToColor(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text