import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import XMLtoInfoSet as xml2IS
from processFunction._ProcessFunction import xmlToParamList, addToText

##################
#   Statistics   #
##################

def kurtosis2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.kurtosis2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def kurtosis3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.kurtosis3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) +","+str(sizeZ)+ ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localEnergy2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localEnergy2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    else:
        text += outImage + ' = stats.localEnergy2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localEnergy3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localEnergy3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ')\n'
    else:
        text += outImage + ' = stats.localEnergy3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localEntropy2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localEntropy2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    else:
        text += outImage + ' = stats.localEntropy2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localEntropy3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localEntropy3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ')\n'
    else:
        text += outImage + ' = stats.localEntropy3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localHistogramModule2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localHistogramModule2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    else:
        text += outImage + ' = stats.localHistogramModule2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def localHistogramModule3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ,nbClass = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    if nbClass is None:
        text += outImage + ' = stats.localHistogramModule3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ')\n'
    else:
        text += outImage + ' = stats.localHistogramModule3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ','+ str(sizeZ) + ',' + str(nbClass) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def skewness2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.skewness2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def skewness3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.skewness3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) +","+str(sizeZ)+ ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def variance2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.variance2dImg(' + image + "," + str(sizeX) + "," +str(sizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def variance3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,sizeX,sizeY,sizeZ = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLStats as stats\n", not process)
    text += outImage + ' = stats.variance3dImg(' + image + "," + str(sizeX) + "," +str(sizeY) +","+str(sizeZ)+ ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text
