import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

from processFunction._ProcessFunction import xmlToParamList, addToText

import UsefullFunctions as fct
import DatabaseFunction as Dfct
import UsefullVariables as vrb


def labelShapeExtraction2d(xmlFunctionCall, outImage="outShapes", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage = parameters[0]
    approximation = parameters[1]

    # numID = fct.getNumId(labelImage)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")

    sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(labelImage)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation\n", not process)

    if sizeZ == "1":
        if approximation is None:
            text += outImage + " = shapesegmentation.labelShapeExtraction2d(" + labelImage + ")\n"
        else:
            text += "contourSettings = PyIPSDK.createContourExtractionSettings(PyIPSDK.eNeighborhood2dType.eN2T_8Connexity,"+str(approximation)+", 10)\n"
            text += outImage + " = shapesegmentation.labelShapeExtraction2d(" + labelImage + ", contourSettings)\n"

        text = addToText(text,outImage + '.objectType = "2D"\n', process)

    text = addToText(text, "outputs = " + outImage, process)
    return text

def labelShapeExtraction3d(xmlFunctionCall, outImage="outShapes", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage = parameters[0]
    approximation = parameters[1]
    ratio = parameters[2]
    minTriangles = parameters[3]

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation\n", not process)

    # numID = fct.getNumId(labelImage)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         bufferType = Dfct.childText(child, "BufferType")

    sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(labelImage)


    if bufferType == "eIBT_Binary":
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
        text += labelImage + " = util.convertImg("+labelImage+",PyIPSDK.eIBT_Label16)\n"

    if approximation is None and ratio is None:
        text += outImage + " = shapesegmentation.labelShapeExtraction3d(" + labelImage + ")\n"
    else:
        if approximation is not None and ratio is None:
            ratio = 0.9
            if minTriangles is None:
                minTriangles = 1000
            text += "contourSettings = PyIPSDK.createSubSampledSurfaceExtractionSettings (" + str(int(approximation)) + ","+ str(ratio) + "," + str(int(minTriangles)) + ")\n"
            # text += "contourSettings = PyIPSDK.createSubSampledSurfaceExtractionSettings (" + str(int(approximation)) + ")\n"
        elif approximation is None and ratio is not None:
            if minTriangles is None:
                minTriangles = 1000
            text += "contourSettings = PyIPSDK.createSimplifiedSurfaceExtractionSettings (" + str(ratio) + "," + str(int(minTriangles)) + ")\n"
        else:
            if minTriangles is None:
                minTriangles = 1000
            text += "contourSettings = PyIPSDK.createSubSampledSurfaceExtractionSettings (" + str(int(approximation)) + ","+ str(ratio) + "," + str(int(minTriangles)) + ")\n"

        text += outImage + " = shapesegmentation.labelShapeExtraction3d(" + labelImage + ", contourSettings)\n"

    text = addToText(text, outImage + '.objectType = "3D"\n', process)

    text = addToText(text,'if '+labelImage+'.hasGeometricCalibration():\n',process)
    text = addToText(text,'\t'+outImage+'.calibration = '+labelImage+'.getGeometricCalibration()\n',process)

    text = addToText(text, "outputs = " + outImage, process)
    return text


def shapeToLabel2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    shapes = parameters[0]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation\n", not process)
    text += outImage + ' = shapesegmentation.shapeToLabel2dImg({shapes})\n'.format(shapes=shapes)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def shapeToLabel3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    shapes = parameters[0]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation\n", not process)
    text += outImage + ' = shapesegmentation.shapeToLabel3dImg({shapes})\n'.format(shapes=shapes)
    text = addToText(text, "outputs = " + outImage, process)
    return text