import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import XMLtoInfoSet as xml2IS
from processFunction._ProcessFunction import xmlToParamList, addToText
import DatabaseFunction as Dfct

import UsefullVariables as vrb
import UsefullFunctions as fct


def labelAnalysis2d(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, greyImage, xmlAllMeasures = parameters

    # sizeZ="1"
    # sizeT="1"
    # numID = fct.getNumId(labelImage)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # Dfct.saveXmlElement(allElements, "C:/dev/allElements_labAnalysisBatch.mho")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(labelImage)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text += 'if '+labelImage+'.hasGeometricCalibration():\n'
    text+= "\tcalibration = "+labelImage+'.getGeometricCalibration()\n'
    text += "else:\n"
    text+="\tcalibration = PyIPSDK.createGeometricCalibration2d(1,1,'px')\n"
    text += xml2IS.xmlToInfoset(xmlAllMeasures, 'inMeasureInfoSet2d', '2D','calibration',process=process)

    if sizeZ == "1" and sizeT == "1":
        if greyImage is None:
            text += outImage + ' = shapeanalysis.labelAnalysis2d(' + labelImage + ', ' + labelImage + ', inMeasureInfoSet2d)\n'
        else:
            text += outImage + ' = shapeanalysis.labelAnalysis2d(' + greyImage + ', ' + labelImage + ', inMeasureInfoSet2d)\n'
    else:
        if greyImage is None:
            text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis2d(' + labelImage + ', ' + labelImage + ', inMeasureInfoSet2d)\n'
        else:
            text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis2d(' + greyImage + ', ' + labelImage + ', inMeasureInfoSet2d)\n'

    text += '\n'
    text += '#Used in Explorer\n'
    text += labelImage + ".infoSet = "+ outImage + "\n"
    text += outImage + ".imageLabel = "+ labelImage + "\n"
    if greyImage is not None:
        text += outImage + ".imageGrey = "+ greyImage + "\n"
    else:
        text += outImage + ".imageGrey = None\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text


def labelAnalysis3d(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, greyImage, xmlAllMeasures,approximation,ratio = parameters

    # sizeT="1"
    # numID = fct.getNumId(labelImage)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeT = Dfct.childText(child, "T")

    sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(labelImage)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text += 'if ' + labelImage + '.hasGeometricCalibration():\n'
    text += "\tcalibration = " + labelImage + '.getGeometricCalibration()\n'
    text += "else:\n"
    text += "\tcalibration = PyIPSDK.createGeometricCalibration3d(1,1,1,'px')\n"
    text += xml2IS.xmlToInfoset(xmlAllMeasures, 'inMeasureInfoSet3d', '3D','calibration',process=process)

    if approximation is None and ratio is None:
        if sizeT == "1":
            if greyImage is None:
                text += outImage + ' = shapeanalysis.labelAnalysis3d(' + labelImage + ', ' + labelImage + ', inMeasureInfoSet3d)\n'
            else:
                text += outImage + ' = shapeanalysis.labelAnalysis3d(' + greyImage + ', ' + labelImage + ', inMeasureInfoSet3d)\n'
        else:
            if greyImage is None:
                text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis3d(' + labelImage + ', ' + labelImage + ', inMeasureInfoSet3d)\n'
            else:
                text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis3d(' + greyImage + ', ' + labelImage + ', inMeasureInfoSet3d)\n'
    else:
        minTriangles = 1000
        if approximation is not None:
            if ratio is None:
                ratio = 0.9
            text += "contourSettings = PyIPSDK.createSubSampledSurfaceExtractionSettings (" + str(int(approximation)) + ","+ str(ratio) + "," + str(int(minTriangles)) + ")\n"
        else:
            text += "contourSettings = PyIPSDK.createSimplifiedSurfaceExtractionSettings (" + str(ratio) + "," + str(int(minTriangles)) + ")\n"

        if sizeT == "1":
            if greyImage is None:
                text += outImage + ' = shapeanalysis.labelAnalysis3d(' + labelImage + ', ' + labelImage + ',contourSettings , inMeasureInfoSet3d)\n'
            else:
                text += outImage + ' = shapeanalysis.labelAnalysis3d(' + greyImage + ', ' + labelImage + ',contourSettings , inMeasureInfoSet3d)\n'
        else:
            if greyImage is None:
                text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis3d(' + labelImage + ', ' + labelImage + ',contourSettings , inMeasureInfoSet3d)\n'
            else:
                text += outImage + ' = shapeanalysis.multiSlice_labelAnalysis3d(' + greyImage + ', ' + labelImage + ',contourSettings , inMeasureInfoSet3d)\n'


    text = addToText(text, labelImage + ".infoSet = " + outImage + "\n", process)
    text = addToText(text, outImage + ".imageLabel = "+ labelImage + "\n", process)
    if greyImage is not None:
        text = addToText(text, outImage + ".imageGrey = "+ greyImage + "\n", process)
    else:
        text = addToText(text, outImage + ".imageGrey = None\n", process)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def shapeAnalysis2d(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    shapes, greyImage, xmlAllMeasures = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)
    text += xml2IS.xmlToInfoset(xmlAllMeasures, 'inMeasureInfoSet2d', '2D')
    if greyImage is None:
        text += 'if (PyIPSDK.Shape2dColl == type(' + shapes + ')):\n'
        text += '\t' + outImage + ' = shapeanalysis.shapeAnalysis2d(inMeasureInfoSet2d, ' + shapes + ')\n'
        text += 'else:\n'
        text += '\t' + outImage + ' = shapeanalysis.multiSlice_shapeAnalysis2d(inMeasureInfoSet2d, ' + shapes + ')\n'
    else:
        text += 'if (PyIPSDK.Shape2dColl == type(' + shapes + ')):\n'
        text += '\t' + outImage + ' = shapeanalysis.shapeAnalysis2d(' + greyImage + ', ' + shapes + ', inMeasureInfoSet2d)\n'
        text += 'else:\n'
        text += '\t' + outImage + ' = shapeanalysis.multiSlice_shapeAnalysis2d(' + greyImage + ', ' + shapes + ', inMeasureInfoSet2d)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def shapeAnalysis3d(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    shapes, greyImage, xmlAllMeasures = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text += xml2IS.xmlToInfoset(xmlAllMeasures, 'inMeasureInfoSet3d', '3D')
    if greyImage is None:
        text += outImage + ' = shapeanalysis.shapeAnalysis3d(inMeasureInfoSet3d, ' + shapes + ')\n'
    else:
        text += outImage + ' = shapeanalysis.shapeAnalysis3d(' + greyImage + ', ' + shapes + ', inMeasureInfoSet3d)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def shapeFiltering2dImg(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, greyImage, choiceElement = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)

    formula = choiceElement[1]
    if formula[0]== '"':
        formula = formula[1:-1]

    if choiceElement[0] == 'Filter':
        if greyImage is None:
            text += outImage + ' = shapeanalysis.shapeFiltering2dImg(' + labelImage + ', ' + labelImage + ', "' + formula + '")\n'
        else:
            text += outImage + ' = shapeanalysis.shapeFiltering2dImg(' + labelImage + ', ' + greyImage + ', "' + formula + '")\n'
    elif choiceElement[0] == 'Formula':

        if greyImage is None:
            text += outImage + ' = shapeanalysis.shapeFiltering2dImg(' + labelImage + ', ' + labelImage + ', "' + formula + '")\n'
        else:
            text += outImage + ' = shapeanalysis.shapeFiltering2dImg(' + labelImage + ', ' + greyImage + ', "' + formula + '")\n'
    text += outImage + ' = itrans.compactIndexImg('+outImage+')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def shapeFiltering3dImg(xmlFunctionCall, outImage="outMeasureSet", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, greyImage, choiceElement = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)

    formula = choiceElement[1]
    if formula[0]== '"':
        formula = formula[1:-1]

    if choiceElement[0] == 'Filter':
        if greyImage is None:
            text += outImage + ' = shapeanalysis.shapeFiltering3dImg(' + labelImage + ', ' + labelImage + ', "' + formula + '")\n'
        else:
            text += outImage + ' = shapeanalysis.shapeFiltering3dImg(' + labelImage + ', ' + greyImage + ', "' + formula + '")\n'
    elif choiceElement[0] == 'Formula':
        if greyImage is None:
            text += outImage + ' = shapeanalysis.shapeFiltering3dImg(' + labelImage + ', ' + labelImage + ', "' + formula + '")\n'
        else:
            text += outImage + ' = shapeanalysis.shapeFiltering3dImg(' + labelImage + ', ' + greyImage + ', "' + formula + '")\n'
    text += outImage + ' = itrans.compactIndexImg('+outImage+')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def labelToMeasureImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, shapeAnalysis, measureName = parameters[0], parameters[1], parameters[2]

    vrb.currentDataLabelToMeasure = measureName

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)


    text += "resultsMeasure = "+shapeAnalysis+".getMeasure('"+measureName+"').getMeasureResult()\n"
    text += "results = resultsMeasure.getColl(0)\n"
    text += "lut = PyIPSDK.createIntensityLUT(0,1,results)\n"
    if measureName.startswith("Custom_L_"):
        text += outImage + "=itrans.lutTransform2dImg(" + labelImage + ", lut)\n"
        text += outImage + ' = util.convertImg(' + outImage + ', PyIPSDK.eIBT_Binary)\n'
    else:
        text += outImage + ' = PyIPSDK.createImage(' + labelImage + ', PyIPSDK.eIBT_Real32)\n'
        text +=  "itrans.lutTransform2dImg(" + labelImage + ", lut,"+ outImage +")\n"

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def histogramOfMeasure(xmlFunctionCall, outImage="outHistogram", process=True):

    parameters = xmlToParamList(xmlFunctionCall)

    shapeAnalysis, measureName, sieveName = parameters[0], parameters[1],parameters[2]

    vrb.currentDataLabelToMeasure = measureName

    text = ""

    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text = addToText(text, '###import UsefullFunctions as fct\n', not process)

    text += "resultsMeasure = "+shapeAnalysis+".getMeasure('"+measureName+"').getMeasureResult()\n"
    text += "values = resultsMeasure.getColl(0)[1:]\n"
    text += "sieve = fct.computeSieve('"+sieveName+"', values)\n"
    text += outImage + " = fct.computeHistogramWithSieve(values,sieve,title = '"+measureName+"')\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def histogramOfMeasureMultiSlice(xmlFunctionCall, outImage="outHistogram", process=True):

    parameters = xmlToParamList(xmlFunctionCall)

    shapeAnalysis, measureName, sieveName = parameters[0], parameters[1],parameters[2]

    vrb.currentDataLabelToMeasure = measureName

    text = ""

    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text = addToText(text, '###import UsefullFunctions as fct\n', not process)

    text += "dictAnalysis = PyIPSDK.toPyDict("+shapeAnalysis+")\n"
    text += "planNum = 0\n"
    text += "values = []\n"
    text += "while (planNum,0,0) in dictAnalysis:\n"
    text += "\tinfoSet = dictAnalysis[(planNum, 0, 0)]\n"
    text += "\tresultsMeasure = infoSet.getMeasure('"+measureName+"').getMeasureResult()\n"
    text += "\tvalues += resultsMeasure.getColl(0)[1:]\n"
    text += "\tplanNum+=1\n"

    text += "sieve = fct.computeSieve('"+sieveName+"', values)\n"
    text += outImage + " = fct.computeHistogramWithSieve(values,sieve,title = '"+measureName+"')\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def histogramOfMeasureFromList(xmlFunctionCall, outImage="outHistogram", process=True):

    parameters = xmlToParamList(xmlFunctionCall)

    valueList, sieveName = parameters[0], parameters[1]

    text = ""

    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text = addToText(text, '###import UsefullFunctions as fct\n', not process)

    text += "sieve = fct.computeSieve('"+sieveName+"', "+valueList+")\n"
    text += outImage + " = fct.computeHistogramWithSieve(values,sieve)\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text