import PyIPSDK.IPSDKIPLRegistration as registration
import PyIPSDK

import UsefullFunctions as fct
from processFunction._ProcessFunction import xmlToParamList, addToText

##################
#   Registration #
##################

def deepFlow2dImg(xmlFunctionCall, outImage=["Dx","Dy"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2, parametersDesc = parameters

    text = ''

    text = addToText(text, '###import PyIPSDK.IPSDKIPLRegistration as registration\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)

    if parametersDesc[0] == 'Simple':
        if parametersDesc[1] is None:
            text += 'imageSeq = registration.deepFlow2dImg(' + image1 + ', ' + image2 + ')\n'
        else:
            text += 'deepFlowParams = PyIPSDK.createDeepFlowParams('+str(parametersDesc[1])+')\n'
            text += 'imageSeq = registration.deepFlow2dImg(' + image1 + ', ' + image2  + ', deepFlowParams)\n'
    else:
        text += 'deepFlowParams = PyIPSDK.createDeepFlowParams('+str(parametersDesc[1])
        for param in parametersDesc[2:]:
            text += ', ' + str(param)
        text += ')\n'
        text += 'imageSeq = registration.deepFlow2dImg(' + image1 + ', ' + image2  + ', deepFlowParams)\n'

    text += 'plan = PyIPSDK.extractPlan(0, 0, 0, imageSeq)\n'
    text += outImage[0] + ' = util.copyImg(plan)\n'
    text += 'plan = PyIPSDK.extractPlan(0, 0, 1, imageSeq)\n'
    text += outImage[1] + ' = util.copyImg(plan)\n'

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def extractVectorialField2d(xmlFunctionCall, outImage="vectorialField", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageX, imageY, spacing, normalize = parameters

    text = ''

    text = addToText(text, '###import PyIPSDK.IPSDKIPLRegistration as registration\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    if normalize:
        text += 'factor = '+str(spacing)+'/max(glbmsr.statsMsr2d(' + imageX + ').max,abs(glbmsr.statsMsr2d(' + imageX + ').min),glbmsr.statsMsr2d(' + imageY + ').max,abs(glbmsr.statsMsr2d(' + imageY + ').min))\n'

    text += outImage + ' = {}\n'
    text += 'for xValue in range(0,' + imageX + '.getSizeX(),'+str(spacing)+'):\n'
    text += '\t' + outImage + '[xValue] = {}\n'
    text += '\tfor yValue in range(0,' + imageX + '.getSizeY(),'+str(spacing)+'):\n'
    if normalize:
        text += '\t\t ' + outImage + '[xValue][yValue] = (' + imageX + '.array[yValue,xValue]*factor,' + imageY + '.array[yValue,xValue]*factor)\n'
    else:
        text += '\t\t ' + outImage + '[xValue][yValue] = (' + imageX + '.array[yValue,xValue],' + imageY + '.array[yValue,xValue])\n'

    text += "output = Measure()\n"
    text += 'output.value = ' + outImage + '\n'
    text += "output.subType = 'VectorialField'\n"

    text = addToText(text, "outputs = output", process)
    return text

def greySignedFeatures2dRegistrationImg(xmlFunctionCall, outImage=["outImage","outTransform"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2, model, interpPolicy, nbPoints = parameters

    text = ''

    text = addToText(text, '###import PyIPSDK.IPSDKIPLRegistration as registration\n', not process)

    text += outImage[0] + ', ' + outImage[1] + ' = registration.greySignedFeatures2dRegistrationImg(' + image1 + ', ' + image2 + ', ' + model + ', ' + interpPolicy + ', ' + str(nbPoints) + ')\n'

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def stackRegistrationImg(xmlFunctionCall, outImage=["outImage","outTransform"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, theta, maxT = parameters

    text = ''

    text = addToText(text, '###import PyIPSDK.IPSDKIPLRegistration as registration\n', not process)

    text += outImage[0] + ', ' + outImage[1] + ' = registration.stackRegistrationImg(' + image + ', ' + str(theta) + ',' + str(maxT) +')\n'

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)

    return text

def stackRegistrationFromTransformationImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, transformation = parameters

    text = ''

    text = addToText(text, '###import PyIPSDK.IPSDKIPLRegistration as registration\n', not process)

    text += outImage + ' = registration.stackRegistrationImg(' + image + ', ' + transformation + ')\n'

    text = addToText(text, "outputs = " + outImage, process)

    return text

