import os

import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK.IPSDKIPLMachineLearning as ml
import PyIPSDK

import xml.etree.ElementTree as xmlet
import XMLtoInfoSet as xml2IS
from processFunction._ProcessFunction import xmlToParamList, addToText
import DatabaseFunction as Dfct
import UsefullFunctions as fct

import UsefullVariables as vrb

def pixelClassificationImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, modelName,memoryRatio = parameters[0], parameters[1],parameters[2]
    text = ""

    text = addToText(text, "###import PyIPSDK.IPSDKIPLMachineLearning as ml\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKFunctionsMachineLearning as fctML\n", not process)

    #folderPixelClassification = vrb.folderPixelClassification.replace("\\","/")
    folderPixelClassification = 'PyIPSDK.getUserRootDataDir()+"/ReactivIP/Explorer/Machine_Learning/Pixel_Classification'

    if os.path.exists(vrb.folderPixelClassification + "/" + modelName + "/ModelIPSDK.bin"):
        text += 'model = PyIPSDK.readRandomForestModel(' + folderPixelClassification + '/' + modelName + '/ModelIPSDK.bin")\n'
    else:
        text += 'model = PyIPSDK.readRandomForestModel(' + folderPixelClassification + '/' + modelName + '/ModelIPSDK.xml")\n'

    if memoryRatio is None:
        text += outImage + ' =  ml.pixelClassificationRFImg('+image+',model)\n'
    else:
        text += outImage + ' =  ml.pixelClassificationRFImg('+image+',model,'+str(memoryRatio)+')\n'

    text += '\n'
    text += '#Used in Explorer\n'
    text += "fctML.writeSmartSegmentationImage("+outImage+","+ folderPixelClassification + '/' + modelName +'")\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def pixelClassificationWithProbabilitiesImg(xmlFunctionCall, outImage=["outImage","outImageProbabilities"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, modelName,memoryRatio = parameters[0], parameters[1],parameters[2]
    text = ""

    text = addToText(text, "###import PyIPSDK.IPSDKIPLMachineLearning as ml\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKFunctionsMachineLearning as fctML\n", not process)

    #folderPixelClassification = vrb.folderPixelClassification.replace("\\","/")
    folderPixelClassification = 'PyIPSDK.getUserRootDataDir()+"/ReactivIP/Explorer/Machine_Learning/Pixel_Classification'

    if os.path.exists(vrb.folderPixelClassification + "/" + modelName + "/ModelIPSDK.bin"):
        text += 'model = PyIPSDK.readRandomForestModel(' + folderPixelClassification + '/' + modelName + '/ModelIPSDK.bin")\n'
    else:
        text += 'model = PyIPSDK.readRandomForestModel(' + folderPixelClassification + '/' + modelName + '/ModelIPSDK.xml")\n'

    if memoryRatio is None:
        text += outImage[0] + ', ' + outImage[1] + ' =  ml.pixelClassificationRFWithProbabilitiesImg('+image+',model)\n'
    else:
        text += outImage[0] + ', ' + outImage[1] + ' =  ml.pixelClassificationRFWithProbabilitiesImg('+image+',model,'+str(memoryRatio)+')\n'

    text += '\n'
    text += '#Used in Explorer\n'
    text += "fctML.writeSmartSegmentationImage("+outImage[0]+","+ folderPixelClassification + '/' + modelName +'")\n'

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def shapeClassificationImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    labelImage, greyImage, modelName = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKFunctionsMachineLearning as fctML\n", not process)

    # folderShapeClassification = vrb.folderShapeClassification.replace("\\", "/")
    folderShapeClassification = 'PyIPSDK.getUserRootDataDir()+"/ReactivIP/Explorer/Machine_Learning/Shape_Classification'

    if greyImage is not None:
        text += outImage + '= fctML.applySmartClassification(' + labelImage + ',' + greyImage + ',' + folderShapeClassification + '/' +modelName + '")\n'
    else:
        text += outImage + '= fctML.applySmartClassification(' + labelImage + ',' + labelImage + ',' + folderShapeClassification + '/' + modelName + '")\n'

    text += "fctML.writeSmartClassification("+outImage+","+ folderShapeClassification + '/' + modelName +'")\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def superPixelSegmentationImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image, modelName = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKFunctionsMachineLearning as fctML\n", not process)

    folderSuperPixelSegmentation = 'PyIPSDK.getUserRootDataDir()+"/ReactivIP/Explorer/Machine_Learning/Super_Pixel_Segmentation'

    text += outImage + '= fctML.applySuperPixelSegmentation(' + image + ',' + folderSuperPixelSegmentation + '/' + modelName + '")\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text