import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import XMLtoInfoSet as xml2IS
from processFunction._ProcessFunction import xmlToParamList, addToText

##################
#   Logical Operations   #
##################

def bitwiseAndImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseAndImgImg(' + image1 + "," + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def bitwiseNandImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseAndImgImg(' + image1 + "," + image2 + ')\n'
    text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def bitwiseNorImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseOrImgImg(' + image1 + "," + image2 + ')\n'
    text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def logicalNotImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.logicalNotImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def bitwiseNxorImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseXOrImgImg(' + image1 + "," + image2 + ')\n'
    text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def bitwiseOrImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseOrImgImg(' + image1 + "," + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def bitwiseExclusiveOrImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseXOrImgImg(' + image1 + "," + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def differenceImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.bitwiseSubImgImg(' + image1 + "," + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def maskImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask,reversed = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    if reversed == False:
        text += outImage + ' = logic.maskImg(' + image + "," + mask + ')\n'
    else:
        text += outImage + ' = logic.reverseMaskImg(' + image + "," + mask + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def maskImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2,mask = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
    text += outImage + ' = logic.maskImgImg(' + image1 + "," + image2+ "," + mask + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text