import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct


from processFunction._ProcessFunction import xmlToParamList, addToText

def backwardDiscreteFourierTransform2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2, coordinate,quadrantPolicy,quadrantScale = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += quadrantScale[0] + '\n'
    text += 'dftConfig = PyIPSDK.createDFTConfig('+ quadrantPolicy + ','+ coordinate + ',' + quadrantScale[1] + ')\n'
    text += outImage + '=itrans.backwardDiscreteFourierTransform2dImg(' + image1 + ',' + image2 + ', dftConfig)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def backwardDiscreteFourierTransform3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2, coordinate,quadrantPolicy,quadrantScale = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += quadrantScale[0] + '\n'
    text += 'dftConfig = PyIPSDK.createDFTConfig('+ quadrantPolicy + ','+ coordinate + ',' + quadrantScale[1] + ')\n'
    text += outImage + '=itrans.backwardDiscreteFourierTransform3dImg(' + image1 + ',' + image2 + ', dftConfig)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def compactIndexImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += outImage + ' = itrans.compactIndexImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def equalize2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, minValue, maxValue = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += "equalizeRange = PyIPSDK.createRange("+str(minValue)+", "+str(maxValue)+")\n"
    text += outImage +" = itrans.equalize2dImg("+image+",  equalizeRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def equalize3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, minValue, maxValue = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += "equalizeRange = PyIPSDK.createRange("+str(minValue)+", "+str(maxValue)+")\n"
    text += outImage +" = itrans.equalize3dImg("+image+",  equalizeRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def forwardDiscreteFourierTransform2dImg(xmlFunctionCall, outImage=["realImage","imaginaryImage"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, coordinate,quadrantPolicy,quadrantScale = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += quadrantScale[0] + '\n'
    text += 'dftConfig = PyIPSDK.createDFTConfig('+ quadrantPolicy + ','+ coordinate + ',' + quadrantScale[1] + ')\n'
    if coordinate == "PyIPSDK.eDFTCoordinates.eDFTC_Polar":
        outImage = ["rhoImage","thetaImage"]
    text += outImage[0] + "," + outImage[1] + '=itrans.forwardDiscreteFourierTransform2dImg(' + image + ', dftConfig)\n'
    text = addToText(text, "outputs = [" + outImage[0] + ", " + outImage[1] + ']', process)
    return text

def forwardDiscreteFourierTransform3dImg(xmlFunctionCall, outImage=["realImage","imaginaryImage"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, coordinate,quadrantPolicy,quadrantScale = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += quadrantScale[0] + '\n'
    text += 'dftConfig = PyIPSDK.createDFTConfig('+ quadrantPolicy + ','+ coordinate + ',' + quadrantScale[1] + ')\n'
    if coordinate == "PyIPSDK.eDFTCoordinates.eDFTC_Polar":
        outImage = ["rhoImage","thetaImage"]
    text += outImage[0] + "," + outImage[1] + '=itrans.forwardDiscreteFourierTransform3dImg(' + image + ', dftConfig)\n'
    text = addToText(text, "outputs = [" + outImage[0] + ", " + outImage[1] + ']', process)
    return text

def invert2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += outImage + ' = itrans.invert2dImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def invert3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n", not process)
    text += outImage + ' = itrans.invert3dImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def matchHistograms2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageToTransform, listOption = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    if listOption[0] == 'Image':
        text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    if listOption[0] == 'Histogram':
        histo = listOption[1]
        text += outImage + ' = itrans.matchHistograms2dImg(' + imageToTransform + ', ' + histo + ')\n'
    elif listOption[0] == 'Image':
        imageRef = listOption[1]
        valueMin = listOption[2]
        valueMax = listOption[3]
        binWidth = listOption[4]

        if valueMin is None and valueMax is None and binWidth is None:
            text += outImage + ' = itrans.matchHistograms2dImg(' + imageToTransform + ', ' + imageRef + ')\n'

        else:
            # numID = fct.getNumId(imageRef)
            # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
            # for child in allElements:
            # 	if Dfct.childText(child, "ElementID") == numID:
            # 		sizeZ = Dfct.childText(child, "Z")
            # 		sizeC = Dfct.childText(child, "C")
            # 		sizeT = Dfct.childText(child, "T")
            # 		bufferType = Dfct.childText(child, "BufferType")

            sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(imageRef)

            if sizeZ == "1" and sizeC == "1" and sizeT == "1":
                if valueMin is None or valueMax is None:
                    text+= "imageMeasures = glbmsr.statsMsr2d("+imageRef+")\n"
                if valueMin is None:
                    text+= "valueMin = imageMeasures.min\n"
                    textValueMin ="valueMin"
                else:
                    textValueMin = str(valueMin)
                if valueMax is None:
                    text+= "valueMax = imageMeasures.max\n"
                    textValueMax = "valueMax"
                else:
                    textValueMax = str(valueMax)
            else:
                if valueMin is None or valueMax is None:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr2d(" + imageRef + ")\n"
                    text += "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
                if valueMin is None:
                    text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                    text += "for z in range(" + imageRef + ".getSizeZ()):\n"
                    text += "\tfor c in range(" + imageRef + ".getSizeC()):\n"
                    text += "\t\tfor t in range(" + imageRef + ".getSizeT()):\n"
                    text += '\t\t\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(z, c, t)]["Min"])\n'
                    textValueMin = "valueMin"
                else:
                    textValueMin = str(valueMin)
                if valueMax is None:
                    text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                    text += "for z in range(" + imageRef + ".getSizeZ()):\n"
                    text += "\tfor c in range(" + imageRef + ".getSizeC()):\n"
                    text += "\t\tfor t in range(" + imageRef + ".getSizeT()):\n"
                    text += '\t\t\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(z, c, t)]["Max"])\n'
                    textValueMax = "valueMax"
                else:
                    textValueMax = str(valueMax)

            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text+= "binWidth = ("+textValueMax+"-"+textValueMin+")/255\n"
                else:
                    text+= "binWidth = max(1,int(("+textValueMax+"-"+textValueMin+")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)

            text+="histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth("+textValueMin+", "+textValueMax+", "+textBinWidth+")\n"
            text += outImage + ' = itrans.matchHistograms2dImg(' + imageToTransform + ', histogramMsrParams, ' + imageRef + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def matchHistograms3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageToTransform, listOption = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    if listOption[0] == 'Image':
        text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    if listOption[0] == 'Histogram':
        histo = listOption[1]
        text += outImage + ' = itrans.matchHistograms3dImg(' + imageToTransform + ', ' + histo + ')\n'
    elif listOption[0] == 'Image':
        imageRef = listOption[1]
        valueMin = listOption[2]
        valueMax = listOption[3]
        binWidth = listOption[4]

        if valueMin is None and valueMax is None and binWidth is None:
            text += outImage + ' = itrans.matchHistograms3dImg(' + imageToTransform + ', ' + imageRef + ')\n'

        else:
            # numID = fct.getNumId(imageRef)
            # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
            # for child in allElements:
            #     if Dfct.childText(child, "ElementID") == numID:
            #         sizeC = Dfct.childText(child, "C")
            #         sizeT = Dfct.childText(child, "T")
            #         bufferType = Dfct.childText(child, "BufferType")

            sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(imageRef)

            if sizeC == "1" and sizeT == "1":
                if valueMin is None or valueMax is None:
                    text+= "imageMeasures = glbmsr.statsMsr3d("+imageRef+")\n"
                if valueMin is None:
                    text+= "valueMin = imageMeasures.min\n"
                    textValueMin ="valueMin"
                else:
                    textValueMin = str(valueMin)
                if valueMax is None:
                    text+= "valueMax = imageMeasures.max\n"
                    textValueMax = "valueMax"
                else:
                    textValueMax = str(valueMax)
            else:
                if valueMin is None or valueMax is None:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr3d(" + imageRef + ")\n"
                    text += "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
                if valueMin is None:
                    text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                    text += "for c in range(" + imageRef + ".getSizeC()):\n"
                    text += "\tfor t in range(" + imageRef + ".getSizeT()):\n"
                    text += '\t\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(0, c, t)]["Min"])\n'
                    textValueMin = "valueMin"
                else:
                    textValueMin = str(valueMin)
                if valueMax is None:
                    text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                    text += "for c in range(" + imageRef + ".getSizeC()):\n"
                    text += "\tfor t in range(" + imageRef + ".getSizeT()):\n"
                    text += '\t\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(0, c, t)]["Max"])\n'
                    textValueMax = "valueMax"
                else:
                    textValueMax = str(valueMax)

            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text+= "binWidth = ("+textValueMax+"-"+textValueMin+")/255\n"
                else:
                    text+= "binWidth = max(1,int(("+textValueMax+"-"+textValueMin+")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)

            text+="histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth("+textValueMin+", "+textValueMax+", "+textBinWidth+")\n"
            text += outImage + ' = itrans.matchHistograms3dImg(' + imageToTransform + ', histogramMsrParams, ' + imageRef + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def matchStatsImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, choiceElement,criterion = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text += outImage + " = itrans.matchStatsImg("+image+",  "+choiceElement[1]+","+criterion+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def normalizeImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, outMin,outMax,inMin,inMax = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    if inMin is None or inMax is None:
        text += "outRange = PyIPSDK.createRange(" + str(outMin) + ",  " + str(outMax) + ")\n"
        text += outImage + " = itrans.normalizeImg("+image+",outRange)\n"
    else:
        text += "inRange = PyIPSDK.createRange(" + str(inMin) + ",  " + str(inMax) + ")\n"
        text += "outRange = PyIPSDK.createRange(" + str(outMin) + ",  " + str(outMax) + ")\n"
        text += outImage + " = itrans.normalizeImg(" + image + ",inRange,outRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def paraboloidShadingCorrection2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, imageParaboloid,mask,factor,offset,imageBlack = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if mask is None:
        text += "paraboloid = glbmsr.paraboloidImgFit2d("+imageParaboloid+")\n"
    else:
        text += "paraboloid = glbmsr.paraboloidImgFit2d(" + imageParaboloid + ","+mask+")\n"
    if offset is None:
        text += outImage + " = itrans.paraboloidShadingCorrection2dImg(" + image + ",paraboloid,"+str(factor)+")\n"
    else:
        if imageBlack is None:
            text += outImage + " = itrans.paraboloidShadingCorrection2dImg(" + image + ",paraboloid," + str(offset) + ","+ str(factor) + ")\n"
        else:
            text += outImage + " = itrans.paraboloidShadingCorrection2dImg(" + image + "," + imageBlack + ",paraboloid," + str(offset) + "," + str(factor) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def shadingCorrectionImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, imageWhite,factor,offset,imageBlack = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    if imageWhite is None:
        text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
        text += "imageWhite = filtering.meanSmoothing2dImg("+image+", 50, 50)\n"
        imageWhite = "imageWhite"
    if offset is None:
        text += outImage + " = itrans.shadingCorrectionImg(" + image + ","+imageWhite+","+str(factor)+")\n"
    else:
        if imageBlack is None:
            text += outImage + " = itrans.shadingCorrectionImg(" + image + ","+imageWhite+","+ str(offset) + ","+ str(factor) + ")\n"
        else:
            text += outImage + " = itrans.shadingCorrectionImg(" + image + "," + imageBlack + ","+imageWhite+","+ str(offset) + "," + str(factor) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def sigmoidNormalizeImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, alpha,beta,rangeMin,rangeMax = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text += "outputRange = PyIPSDK.createRange(" + str(rangeMin) + ",  " + str(rangeMax) + ")\n"
    text += outImage + " = itrans.sigmoidNormalizeImg(" + image + "," + str(alpha) + ","+ str(beta) + "," +"outputRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def smartParaboloidShadingCorrection2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, imageParaboloid,mask,rangeMin,rangeMax,imageBlack = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text += "outputRange = PyIPSDK.createRange(" + str(rangeMin) + ",  " + str(rangeMax) + ")\n"
    if mask is None:
        text += "paraboloid = glbmsr.paraboloidImgFit2d("+imageParaboloid+")\n"
    else:
        text += "paraboloid = glbmsr.paraboloidImgFit2d(" + imageParaboloid + ","+mask+")\n"
    if imageBlack is None:
        text += outImage + " ,offset, factor= itrans.smartParaboloidShadingCorrection2dImg(" + image + ",paraboloid,outputRange)\n"
    else:
        text += outImage + " ,offset, factor= itrans.smartParaboloidShadingCorrection2dImg(" + image +","+imageBlack+ ",paraboloid,outputRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def smartShadingCorrectionImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, maskImg, imageWhite,rangeMin,rangeMax,imageBlack = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text += "outputRange = PyIPSDK.createRange(" + str(rangeMin) + ",  " + str(rangeMax) + ")\n"

    # Smooth the input image first by taking into account the mask if provided
    if maskImg is None:
        if imageWhite is None:
            text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
            text += "imageWhite = filtering.meanSmoothing2dImg("+image+", 50, 50)\n"
            imageWhite = "imageWhite"
    else:
        if imageWhite is None:
            text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)

            # Image 2D or 3D
            # numID = fct.getNumId(image)
            # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
            # for child in allElements:
            #     if Dfct.childText(child, "ElementID") == numID:
            #         print(Dfct.childText(child, "Z"))
            #         sizeZ = Dfct.childText(child, "Z")

            sizeZ, sizeC, sizeT, bufferType = fct.computesMultisliceSizes(image)

            if sizeZ == "1":
                text += "imageWhite = filtering.meanSmoothing2dMaskImg("+image+", "+maskImg+", 50, 50)\n"
            else:
                text += "imageWhite = filtering.meanSmoothing3dMaskImg("+image+", "+maskImg+", 50, 50, 50)\n"
            imageWhite = "imageWhite"
    if imageBlack is None:
        text += outImage + " ,offset, factor= itrans.smartShadingCorrectionImg(" + image + ","+imageWhite + ",outputRange)\n"
    else:
        text += outImage + " ,offset,  factor= itrans.smartShadingCorrectionImg(" + image +","+imageBlack + ","+imageWhite +  ",outputRange)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def standardizeImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    if mask is None:
        text += outImage + " = itrans.standardizeImg(" + image +")\n"
    else:
        text += outImage + " = itrans.standardizeImg(" + image +","+mask+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def adaptiveContrastEnhancement2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,kernelSize,offset,blendValue = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text += outImage + " = itrans.adaptiveContrastEnhancement2dImg(" + image + "," + str(kernelSize) + "," + str(kernelSize) + ","+ str(offset) + "," + str(blendValue) +")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def adaptiveContrastEnhancement3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,kernelSize,offset,blendValue = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)
    text += outImage + " = itrans.adaptiveContrastEnhancement3dImg(" + image + "," + str(kernelSize) + "," + str(kernelSize) + "," + str(kernelSize) + ","+ str(offset) + "," + str(blendValue) +")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text