import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
from UsefullWidgets import Measure
import PyIPSDK

import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

from processFunction._ProcessFunction import xmlToParamList, addToText

def gaussianNoiseMsr(xmlFunctionCall, outImage="gaussianNoise", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text += outImage + ' = glbmsr.gaussianNoiseMsr(' + image + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'GaussianNoise'", process)
    return text

def globalEntropyMsr2d(xmlFunctionCall, outImage="entropyValue", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, histogram = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if histogram is None:
        if sizeZ == "1" and sizeC == "1" and sizeT == "1":
            text += outImage + ' = glbmsr.globalEntropyMsr2d(' + image + ')\n'
        else:
            text += outImage + ' = glbmsr.multiSlice_globalEntropyMsr2d(' + image + ')\n'
    else:
        if sizeZ == "1" and sizeC == "1" and sizeT == "1":
            text += outImage + ' = glbmsr.globalEntropyMsr2d(' + image + ', ' + histogram + ')\n'
        else:
            text += outImage + ' = glbmsr.multiSlice_globalEntropyMsr2d(' + image + ', ' + histogram + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'Entropy'", process)
    return text

def histogramMsr2d(xmlFunctionCall, outImage="histogram2d", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask, valueMin, valueMax, binWidth = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                if mask is None:
                    text+= "imageMeasures = glbmsr.statsMsr2d("+image+")\n"
                else:
                    text+= "imageMeasures = glbmsr.statsMaskMsr2d("+image+"," + mask+")\n"
            if valueMin is None:
                text+= "valueMin = imageMeasures.min\n"
                textValueMin ="valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text+= "valueMax = imageMeasures.max\n"
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text+= "binWidth = ("+textValueMax+"-"+textValueMin+")/255\n"
                else:
                    text+= "binWidth = max(1,int(("+textValueMax+"-"+textValueMin+")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)

            text+="histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth("+textValueMin+", "+textValueMax+", "+textBinWidth+")\n"
            if mask is None:
                text+= outImage +" = glbmsr.histogramMsr2d(" + image + ", histogramMsrParams)\n"
            else:
                text+= outImage +" = glbmsr.histogramMaskMsr2d(" + image + "," + mask + ", histogramMsrParams)\n"
        else:
            if mask is None:
                text += outImage + " = glbmsr.histogramMsr2d(" + image + ")\n"
            else:
                text+= outImage +" = glbmsr.histogramMaskMsr2d(" + image + "," + mask + ")\n"
    else:
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                if mask is None:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr2d("+image+")\n"
                else:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMaskMsr2d("+image+"," + mask+")\n"
                text+= "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
            if valueMin is None:
                text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                text += "for z in range("+image+".getSizeZ()):\n"
                text += "\tfor c in range("+image+".getSizeC()):\n"
                text += "\t\tfor t in range("+image+".getSizeT()):\n"
                text += '\t\t\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(z, c, t)]["Min"])\n'
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                text += "for z in range("+image+".getSizeZ()):\n"
                text += "\tfor c in range("+image+".getSizeC()):\n"
                text += "\t\tfor t in range("+image+".getSizeT()):\n"
                text += '\t\t\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(z, c, t)]["Max"])\n'
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text+= "binWidth = ("+textValueMax+"-"+textValueMin+")/255\n"
                else:
                    text+= "binWidth = max(1,int(("+textValueMax+"-"+textValueMin+")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)

            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            if mask is None:
                text += outImage + " = glbmsr.multiSlice_histogramMsr2d(" + image + ", histogramMsrParams)\n"
            else:
                text += outImage + " = glbmsr.multiSlice_histogramMaskMsr2d(" + image + "," + mask + ", histogramMsrParams)\n"
        else:
            if mask is None:
                text += outImage + " = glbmsr.multiSlice_histogramMsr2d(" + image + ")\n"
            else:
                text += outImage + " = glbmsr.multiSlice_histogramMaskMsr2d(" + image + "," + mask + ")\n"

    if sizeC != "1":
        text += outImage + ".image = " + image + "\n"

    text = addToText(text, "\noutputs = " + outImage, process)

    return text

def histogramMsr3d(xmlFunctionCall, outImage="histogram3d", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask, valueMin, valueMax, binWidth = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)


    if sizeC == "1" and sizeT == "1":
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                if mask is None:
                    text += "imageMeasures = glbmsr.statsMsr3d(" + image + ")\n"
                else:
                    text += "imageMeasures = glbmsr.statsMaskMsr3d(" + image + "," + mask +")\n"
            if valueMin is None:
                text += "valueMin = imageMeasures.min\n"
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += "valueMax = imageMeasures.max\n"
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)
            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            if mask is None:
                text += outImage + " = glbmsr.histogramMsr3d(" + image + ", histogramMsrParams)\n"
            else:
                text += outImage + " = glbmsr.histogramMaskMsr3d(" + image + "," + mask + ", histogramMsrParams)\n"
        else:
            if mask is None:
                text += outImage + " = glbmsr.histogramMsr3d(" + image + ")\n"
            else:
                text += outImage + " = glbmsr.histogramMaskMsr3d(" + image + "," + mask +")\n"
    else:
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                if mask is None:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMsr3d(" + image + ")\n"
                else:
                    text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMaskMsr3d(" + image + "," + mask +")\n"
                text += "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
            if valueMin is None:
                text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                text += "for c in range(" + image + ".getSizeC()):\n"
                text += "\tfor t in range(" + image + ".getSizeT()):\n"
                text += '\t\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(0, c, t)]["Min"])\n'
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                text += "for c in range(" + image + ".getSizeC()):\n"
                text += "\tfor t in range(" + image + ".getSizeT()):\n"
                text += '\t\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(0, c, t)]["Max"])\n'
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)
            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            if mask is None:
                text += outImage + " = glbmsr.multiSlice_histogramMsr3d(" + image + ", histogramMsrParams)\n"
            else:
                text += outImage + " = glbmsr.multiSlice_histogramMaskMsr3d(" + image + "," + mask +", histogramMsrParams)\n"
        else:
            if mask is None:
                text += outImage + " = glbmsr.multiSlice_histogramMsr3d(" + image + ")\n"
            else:
                text += outImage + " = glbmsr.multiSlice_histogramMaskMsr3d(" + image + "," + mask +")\n"

    if sizeC != "1":
        text += outImage + ".image = " + image + "\n"

    text = addToText(text, "\noutputs = " + outImage, process)

    return text

##########################
# Obsolete
##########################
def histogramMaskMsr2d(xmlFunctionCall, outImage="histogram2d", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask, valueMin, valueMax, binWidth = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)


    if sizeZ == "1" and sizeC == "1":
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                text += "imageMeasures = glbmsr.statsMaskMsr2d(" + image + ", "+mask+")\n"
            if valueMin is None:
                text += "valueMin = imageMeasures.min\n"
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += "valueMax = imageMeasures.max\n"
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)
            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            text += outImage + " = glbmsr.histogramMaskMsr2d(" + image + ", "+mask+", histogramMsrParams)\n"
        else:
            text += outImage + " = glbmsr.histogramMaskMsr2d(" + image + ", "+mask+")\n"
    else:
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMaskMsr2d(" + image + ", "+mask+")\n"
                text += "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
            if valueMin is None:
                text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                text += "for z in range(" + image + ".getSizeZ()):\n"
                text += "\tfor c in range(" + image + ".getSizeC()):\n"
                text += '\t\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(z, c, 0)]["Min"])\n'
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                text += "for z in range(" + image + ".getSizeZ()):\n"
                text += "\tfor c in range(" + image + ".getSizeC()):\n"
                text += '\t\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(z, c, 0)]["Max"])\n'
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)

            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            text += outImage + " = glbmsr.multiSlice_histogramMaskMsr2d(" + image + ", "+mask+", histogramMsrParams)\n"
        else:
            text += outImage + " = glbmsr.multiSlice_histogramMaskMsr2d(" + image + ", "+mask+")\n"
    text = addToText(text, "\noutputs = " + outImage, process)

    return text

##########################
# Obsolete
##########################
def histogramMaskMsr3d(xmlFunctionCall, outImage="histogram3d", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask, valueMin, valueMax, binWidth = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)


    if sizeC == "1":
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                text += "imageMeasures = glbmsr.statsMaskMsr3d(" + image + ", " + mask + ")\n"
            if valueMin is None:
                text += "valueMin = imageMeasures.min\n"
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += "valueMax = imageMeasures.max\n"
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)
            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            text += outImage + " = glbmsr.histogramMaskMsr3d(" + image + ", " + mask + ", histogramMsrParams)\n"
        else:
            text += outImage + " = glbmsr.histogramMaskMsr3d(" + image + ", " + mask + ")\n"
    else:
        if valueMin is not None or valueMax is not None or binWidth is not None:
            if valueMin is None or valueMax is None:
                text += "planIndexedStatsMsrResult = glbmsr.multiSlice_statsMaskMsr3d(" + image + ", " + mask + ")\n"
                text += "planIndexedStatsMsrResultDict = PyIPSDK.toPyDict(planIndexedStatsMsrResult)\n"
            if valueMin is None:
                text += 'valueMin = planIndexedStatsMsrResultDict[(0, 0, 0)]["Min"]\n'
                text += "for c in range(" + image + ".getSizeC()):\n"
                text += '\tvalueMin = min(valueMin, planIndexedStatsMsrResultDict[(0, c, 0)]["Min"])\n'
                textValueMin = "valueMin"
            else:
                textValueMin = str(valueMin)
            if valueMax is None:
                text += 'valueMax = planIndexedStatsMsrResultDict[(0, 0, 0)]["Max"]\n'
                text += "for c in range(" + image + ".getSizeC()):\n"
                text += '\tvalueMax = max(valueMax, planIndexedStatsMsrResultDict[(0, c, 0)]["Max"])\n'
                textValueMax = "valueMax"
            else:
                textValueMax = str(valueMax)
            if binWidth is None:
                if bufferType == "eIBT_Real32":
                    text += "binWidth = (" + textValueMax + "-" + textValueMin + ")/255\n"
                else:
                    text += "binWidth = max(1,int((" + textValueMax + "-" + textValueMin + ")/255))\n"
                textBinWidth = "binWidth"
            else:
                textBinWidth = str(binWidth)
            text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(" + textValueMin + ", " + textValueMax + ", " + textBinWidth + ")\n"
            text += outImage + " = glbmsr.multiSlice_histogramMaskMsr3d(" + image + ", " + mask + ", histogramMsrParams)\n"
        else:
            text += outImage + " = glbmsr.multiSlice_histogramMaskMsr3d(" + image + ", " + mask + ")\n"
    text = addToText(text, "\noutputs = " + outImage, process)
    return text

def paraboloidImgFit2d(xmlFunctionCall, outImage="paraboloid", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if mask == None:
        text += outImage + "= glbmsr.paraboloidImgFit2d("+image+")\n"
    else:
        text += outImage + "= glbmsr.paraboloidImgFit2d("+image+","+mask+")\n"

    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'Paraboloid'", process)
    return text

def pearsonCorrelationCoefficient2d(xmlFunctionCall, outImage="pearsonCoeff", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image1)


    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        text += outImage + ' = glbmsr.pearsonCorrelationCoefficient2d(' + image1 + ', ' + image2 + ')\n'
    else:
        text += outImage + ' = glbmsr.multiSlice_pearsonCorrelationCoefficient2d(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'Pearson'", process)
    return text

def pearsonCorrelationCoefficient3d(xmlFunctionCall, outImage="pearsonCoeff", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image1)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1" and sizeT == "1":
        text += outImage + ' = glbmsr.pearsonCorrelationCoefficient3d(' + image1 + ', ' + image2 + ')\n'
    else:
        text += outImage + ' = glbmsr.multiSlice_pearsonCorrelationCoefficient3d(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'Pearson'", process)
    return text

def similarityMsr(xmlFunctionCall, outImage="similarity", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text += outImage + ' = glbmsr.similarityMsr(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'Similarity'", process)
    return text

def statsMsr2d(xmlFunctionCall, outImage="stats2dResult", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    mask = parameters[1]

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1" and sizeZ == "1" and sizeT == "1":
        if mask is None:
            text += outImage+' = glbmsr.statsMsr2d('+ image +')\n'
        else:
            text += outImage + ' = glbmsr.statsMaskMsr2d(' + image + ',' + mask + ')\n'
    else:
        if mask is None:
            text += outImage+' = glbmsr.multiSlice_statsMsr2d('+ image +')\n'
        else:
            text += outImage +' = glbmsr.multiSlice_statsMaskMsr2d('+ image + ',' + mask +')\n'

    text += outImage + ".image = "+ image + "\n"
    text += outImage + '.subType = "Dict"\n'
    text += outImage + ".value = PyIPSDK.toPyDict("+ outImage + ")\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def statsMsr3d(xmlFunctionCall, outImage="stats3dResult", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    mask = parameters[1]

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1" and sizeT == "1":
        if mask is None:
            text += outImage+' = glbmsr.statsMsr3d(' + image + ')\n'
        else:
            text += outImage + ' = glbmsr.statsMaskMsr3d(' + image + ',' + mask + ')\n'
    else:
        if mask is None:
            text += outImage+' = glbmsr.multiSlice_statsMsr3d(' + image + ')\n'
        else:
            text += outImage + ' = glbmsr.multiSlice_statsMaskMsr3d(' + image + ',' + mask +')\n'

    text += outImage + ".image = "+ image + "\n"
    text += outImage + '.subType = "Dict"\n'
    text += outImage + ".value = PyIPSDK.toPyDict(" + outImage + ")\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

##########################
# Obsolete
##########################
def statsMaskMsr2d(xmlFunctionCall, outImage="stats2dResult", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1" and sizeZ == "1":
        text += outImage+' = glbmsr.statsMaskMsr2d({image},{mask})\n'.format(image=image,mask=mask)
    else:
        text += outImage+' = glbmsr.multiSlice_statsMaskMsr2d({image},{mask})\n'.format(image=image,mask=mask)

    text = addToText(text, "outputs = " + outImage, process)
    return text

##########################
# Obsolete
##########################
def statsMaskMsr3d(xmlFunctionCall, outImage="stats3dResult", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,mask = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1":
        text += outImage+' = glbmsr.statsMaskMsr3d({image},{mask})\n'.format(image=image,mask=mask)
    else:
        text += outImage+' = glbmsr.multiSlice_statsMaskMsr3d({image},{mask})\n'.format(image=image,mask=mask)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def xProjection2d(xmlFunctionCall, outImage="xProj", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, projType = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text += 'projection = glbmsr.xProjection2d(' + image + ', ' + projType + ')\n'

    text +=outImage + " = Measure()\n"
    text +=outImage + ".value = projection\n"
    text +=outImage + ".subType = 'XProjection'\n"
    text +=outImage + ".projectionType =" + projType + "\n"

    # text = addToText(text, "outputs = Measure()\n", process)
    # text = addToText(text, "outputs.value = " + outImage + "\n", process)
    # text = addToText(text, "outputs.subType = 'XProjection'\n", process)
    # text = addToText(text, "outputs.projectionType =" + projType + "\n", process)

    text = addToText(text, "outputs = " + outImage, process)

    return text

def yProjection2d(xmlFunctionCall, outImage="xProj", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, projType = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text += 'projection = glbmsr.yProjection2d(' + image + ', ' + projType + ')\n'

    text +=outImage + " = Measure()\n"
    text +=outImage + ".value = projection\n"
    text +=outImage + ".subType = 'YProjection'\n"
    text +=outImage + ".projectionType =" + projType + "\n"

    # text = addToText(text, "outputs = Measure()\n", process)
    # text = addToText(text, "outputs.value = " + outImage + "\n", process)
    # text = addToText(text, "outputs.subType = 'YProjection'\n", process)
    # text = addToText(text, "outputs.projectionType =" + projType + "\n", process)

    text = addToText(text, "outputs = " + outImage, process)

    return text

def zProjectionImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, projType = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text += outImage + ' = glbmsr.zProjectionImg(' + image + ', ' + projType + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def locatePixels2d(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbPoints = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    if nbPoints is not None:
        if sizeZ == "1" and sizeT == "1":
            text += 'listPixels = glbmsr.locatePixels2d(' + image + ', ' + str(nbPoints) + ')\n'
        else:
            text += 'listPixels = glbmsr.multiSlice_locatePixels2d(' + image + ', ' + str(nbPoints) + ')\n'
    else:
        text = addToText(text, '###import numpy as np\n', not process)
        if sizeZ == "1" and sizeT == "1":
            text += 'listPixels = glbmsr.locatePixels2d(' + image + ')\n'
        else:
            text += 'listPixels = glbmsr.multiSlice_locatePixels2d(' + image + ', np.iinfo(np.uint32).max)\n'

    text +=outImage + " = Measure()\n"
    text +=outImage + ".value = listPixels\n"
    text +=outImage + ".subType = 'ListPixels'\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def locateVoxels3d(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbPoints = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    if nbPoints is not None:
        if sizeT == "1":
            text += 'listVoxels = glbmsr.locateVoxels3d(' + image + ', ' + str(nbPoints) + ')\n'
        else:
            text += 'listVoxels = glbmsr.multiSlice_locateVoxels3d(' + image + ', ' + str(nbPoints) + ')\n'
    else:
        text = addToText(text, '###import numpy as np\n', not process)
        if sizeT == "1":
            text += 'listVoxels = glbmsr.locateVoxels3d(' + image + ')\n'
        else:
            text += 'listVoxels = glbmsr.multiSlice_locateVoxels3d(' + image + ', np.iinfo(np.uint32).max)\n'

    text +=outImage + " = Measure()\n"
    text +=outImage + ".value = listVoxels\n"
    text +=outImage + ".subType = 'ListVoxels'\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def labelHistogram2d(xmlFunctionCall, outImage="outHistogram", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageLabel, imageGrey, minMaxParameters, binWidth = parameters

    # numID = fct.getNumId(imageGrey)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         bufferType = Dfct.childText(child, "BufferType")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(imageGrey)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBinarization as bin\n', not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)

    if minMaxParameters[0] == 'Bounds':

        if minMaxParameters[1] is None or minMaxParameters[2] is None:
            text += "imageMeasures = glbmsr.statsMsr2d(" + imageGrey + ")\n"

        if minMaxParameters[1] is None:
            text += "minValue = imageMeasures.min\n"
        else:
            text += "minValue =" + str(minMaxParameters[1]) + "\n"
        if minMaxParameters[2] is None:
            text += "maxValue = imageMeasures.max\n"
        else:
            text += "maxValue =" + str(minMaxParameters[2]) + "\n"

    elif minMaxParameters[0] == 'Quantile':
        text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(1)\n"
        text += "histogram = glbmsr.histogramMsr2d(" + imageGrey + ", histogramMsrParams)\n"
        text += "cumulativeHistogram = PyIPSDK.createCumulativeHistogramData(histogram)\n"
        text += "minValue = cumulativeHistogram.getQuantile("+ str(minMaxParameters[1]) + ")\n"
        text += "maxValue = cumulativeHistogram.getQuantile("+ str(minMaxParameters[2]) + ")\n"

    if binWidth is None:
        if bufferType == "eIBT_Real32":
            text += "binWidth = (maxValue - minValue)/255\n"
        else:
            text += "binWidth = max(1,int((maxValue - minValue)/255))\n"
        binWidth = "binWidth"
    else:
        binWidth = str(binWidth)

    text += "inMeasureInfoSet2d = PyIPSDK.createMeasureInfoSet2d()\n"
    text += "PyIPSDK.createMeasureInfo(inMeasureInfoSet2d, 'HistogramMsr',shapeanalysis.createHistogramMsrParamsBinWidth(" \
             + binWidth + ", minValue, maxValue))\n"
    text += outImage + " = shapeanalysis.labelAnalysis2d(" + imageGrey + ", " + imageLabel + ", inMeasureInfoSet2d)\n"
    text += outImage + ".imageLabel = " + imageLabel + "\n"
    text += "greyHistogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(minValue, maxValue, " + binWidth + ")\n"
    text += outImage + ".histogramGrey = glbmsr.histogramMsr2d(" + imageGrey + ", greyHistogramMsrParams)\n"
    text += outImage + ".imageGrey = " + imageGrey + "\n"
    text = addToText(text, "\noutputs = " + outImage, process)

    return text


def labelHistogram3d(xmlFunctionCall, outImage="outHistogram", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageLabel, imageGrey, minMaxParameters, binWidth = parameters

    # numID = fct.getNumId(imageGrey)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         bufferType = Dfct.childText(child, "BufferType")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(imageGrey)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBinarization as bin\n', not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis\n", not process)

    if minMaxParameters[0] == 'Bounds':
        if minMaxParameters[1] is None or minMaxParameters[2] is None:
            text += "imageMeasures = glbmsr.statsMsr3d(" + imageGrey + ")\n"

        if minMaxParameters[1] is None:
            text += "minValue = imageMeasures.min\n"
        else:
            text += "minValue =" + str(minMaxParameters[1]) + "\n"
        if minMaxParameters[2] is None:
            text += "maxValue = imageMeasures.max\n"
        else:
            text += "maxValue =" + str(minMaxParameters[2]) + "\n"

    elif minMaxParameters[0] == 'Quantile':
        text += "histogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(1)\n"
        text += "histogram = glbmsr.histogramMsr3d(" + imageGrey + ", histogramMsrParams)\n"
        text += "cumulativeHistogram = PyIPSDK.createCumulativeHistogramData(histogram)\n"
        text += "minValue = cumulativeHistogram.getQuantile("+ str(minMaxParameters[1]) + ")\n"
        text += "maxValue = cumulativeHistogram.getQuantile("+ str(minMaxParameters[2]) + ")\n"

    if binWidth is None:
        if bufferType == "eIBT_Real32":
            text += "binWidth = (maxValue - minValue)/255\n"
        else:
            text += "binWidth = max(1,int((maxValue - minValue)/255))\n"
        binWidth = "binWidth"
    else:
        binWidth = str(binWidth)

    text += "inMeasureInfoSet3d = PyIPSDK.createMeasureInfoSet3d()\n"
    text += "PyIPSDK.createMeasureInfo(inMeasureInfoSet3d, 'HistogramMsr',shapeanalysis.createHistogramMsrParamsBinWidth(" \
            + str(binWidth) + ", minValue, maxValue))\n"
    text += outImage + " = shapeanalysis.labelAnalysis3d(" + imageGrey + ", " + imageLabel + ", inMeasureInfoSet3d)\n"
    text += outImage + ".imageLabel = " + imageLabel + "\n"
    text += "greyHistogramMsrParams = PyIPSDK.createHistoMsrParamsWithBinWidth(minValue, maxValue, " + str(
        binWidth) + ")\n"
    text += outImage + ".histogramGrey = glbmsr.histogramMsr3d(" + imageGrey + ", greyHistogramMsrParams)\n"
    text += outImage + ".imageGrey = " + imageGrey + "\n"
    text = addToText(text, "\noutputs = " + outImage, process)

    return text

def normalizedCrossCorrelationMsr2d(xmlFunctionCall, outImage="nccValue", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, template = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        text += outImage + ' = glbmsr.normalizedCrossCorrelationMsr2d(' + image + ', ' + template + ')\n'
    else:
        text += outImage + ' = glbmsr.multiSlice_normalizedCrossCorrelationMsr2d(' + image + ', ' + template + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'NCC'", process)
    return text

def normalizedCrossCorrelationMsr3d(xmlFunctionCall, outImage="nccValue", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, template = parameters

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    if sizeC == "1" and sizeT == "1":
        text += outImage + ' = glbmsr.normalizedCrossCorrelationMsr3d(' + image + ', ' + template + ')\n'
    else:
        text += outImage + ' = glbmsr.multiSlice_normalizedCrossCorrelationMsr2d(' + image + ', ' + template + ')\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, "outputs.value = " + outImage + "\n", process)
    text = addToText(text, "outputs.subType = 'NCC'", process)
    return text

def areaPercent2dMsr(xmlFunctionCall, outImage="areaPercent", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    mask = None
    if len(parameters) > 1:
        mask = parameters[1]

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)

    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        text += 'resAreaPercent = glbmsr.areaPercent2dMsr(' + image
    else:
        text += 'resAreaPercent = glbmsr.multiSlice_areaPercent2dMsr(' + image

    if mask is not None:
        text += ", " + mask
    text +=  ')\n'

    text += outImage + " = Measure()\n"
    text += outImage + ".value = resAreaPercent\n"
    text += outImage + ".subType = 'AreaPercent'\n"
    # text += outImage + ".subType = 'YProjection'\n"
    # text += outImage + ".projectionType = areaPercent\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def volumePercent3dMsr(xmlFunctionCall, outImage="volumePercent", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    mask = None
    if len(parameters) > 1:
        mask = parameters[1]

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    if sizeC == "1" and sizeT == "1":
        text += 'resVolumePercent = glbmsr.volumePercent3dMsr(' + image
    else:
        text += 'resVolumePercent = glbmsr.multiSlice_volumePercent3dMsr(' + image

    if mask is not None:
        text += ", " + mask
    text +=  ')\n'

    text += outImage + " = Measure()\n"
    text += outImage + ".value = resVolumePercent\n"
    text += outImage + ".subType = 'VolumePercent'\n"

    text = addToText(text, "outputs = " + outImage, process)

    return text

def counting2dMsr(xmlFunctionCall, outImage="counting2d", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        text += 'resCounting = glbmsr.counting2dMsr(' + image + ')\n'
    else:
        text += 'resCounting = glbmsr.multiSlice_counting2dMsr(' + image + ')\n'

    text += outImage + " = Measure()\n"
    text += outImage + ".value = resCounting\n"
    text += outImage + ".subType = 'Scalar'\n"

    text = addToText(text, "outputs = " + outImage+"\n", process)
    text = addToText(text, "outputs.subType = 'CountingMsr'", process)

    return text

def counting3dMsr(xmlFunctionCall, outImage="counting3d", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    mask = None
    if len(parameters) > 1:
        mask = parameters[1]

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr\n', not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
    text += 'resCounting = glbmsr.counting3dMsr(' + image + ')\n'

    text += outImage + " = Measure()\n"
    text += outImage + ".value = resCounting\n"
    text += outImage + ".subType = 'Scalar'\n"

    text = addToText(text, "outputs = " + outImage+"\n", process)
    text = addToText(text, "outputs.subType = 'CountingMsr'", process)

    return text