import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

from processFunction._ProcessFunction import xmlToParamList, addToText

import UsefullFunctions as fct
import DatabaseFunction as Dfct
import UsefullVariables as vrb


def zoom2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, interpolationMethod, resizeElement = parameters

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeC = Dfct.childText(child, "C")
            colorType = Dfct.childText(child, "ColorType")
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n', not process)
    if resizeElement[0] == 'Factor':
        zoomX = str(resizeElement[1]/100)
        zoomY = str(resizeElement[2]/100)
        text += outImage + ' = gtrans.zoom2dImg('+image+', '+zoomX+', '+zoomY+', '+interpolationMethod+')\n'
    elif resizeElement[0] == 'Size':

        width = str(resizeElement[1])
        height = str(resizeElement[2])

        text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
        if sizeC != "1":
            if colorType == "eCGT_User":
                text += "colorGeometry.initUser(" + image + ".getSizeC())\n"
            else:
                text += "colorGeometry.init(PyIPSDK." + colorType + ")\n"
        else:
            text += "colorGeometry.initGrey()\n"
        text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
        if sizeZ == "1":
            text += "volumeGeometry.init2d()\n"
        else:
            text += "volumeGeometry.init3d(" + image + ".getSizeZ())\n"
        text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
        if sizeT == "1":
            text += "temporalGeometry.initSingle()\n"
        else:
            text += "temporalGeometry.initSequence(" + image + ".getSizeT())\n"

        text += "geometry = PyIPSDK.geometry("+image+".getBufferType(), " +width+", "+height+ ", volumeGeometry, colorGeometry, temporalGeometry)\n"
        text += outImage + ' = PyIPSDK.createImage(geometry)\n'
        text += 'gtrans.zoom2dImg('+image+', '+interpolationMethod+', '+outImage+')\n'
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def zoom3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, interpolationMethod, resizeElement = parameters

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeC = Dfct.childText(child, "C")
            colorType = Dfct.childText(child, "ColorType")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n', not process)
    if resizeElement[0] == 'Factor':
        zoomX = str(resizeElement[1]/100)
        zoomY = str(resizeElement[2]/100)
        zoomZ = str(resizeElement[3]/100)
        text += outImage + ' = gtrans.zoom3dImg('+image+', '+zoomX+', '+zoomY+', '+zoomZ+','+interpolationMethod+')\n'
    elif resizeElement[0] == 'Size':

        width = str(resizeElement[1])
        height = str(resizeElement[2])
        depth = str(resizeElement[3])

        text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
        if sizeC != "1":
            if colorType == "eCGT_User":
                text += "colorGeometry.initUser(" + image + ".getSizeC())\n"
            else:
                text += "colorGeometry.init(PyIPSDK." + colorType + ")\n"
        else:
            text += "colorGeometry.initGrey()\n"
        text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
        text += "volumeGeometry.init3d(" + depth + ")\n"
        text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
        if sizeT == "1":
            text += "temporalGeometry.initSingle()\n"
        else:
            text += "temporalGeometry.initSequence(" + image + ".getSizeT())\n"

        text += "geometry = PyIPSDK.geometry(" + image + ".getBufferType(), " + width + ", " + height + ", volumeGeometry, colorGeometry, temporalGeometry)\n"

        text += outImage + ' = PyIPSDK.createImage(geometry)\n'
        text += 'gtrans.zoom3dImg('+image+', '+interpolationMethod+', '+outImage+')\n'
    else:
        print("ERROR : Arguments do not fit", file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)

    return text

def flipXImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += outImage + ' = gtrans.flipXImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def flipYImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += outImage + ' = gtrans.flipYImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def flipZImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += outImage + ' = gtrans.flipZImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def translation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    image,Tx,Ty = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
    text += "transform = PyIPSDK.createWarpMotionTransform2d(PyIPSDK.eGeometricTransform2dType.eGT2DT_Translation,["+str(Tx)+","+str(Ty)+"])\n"
    text += "gtrans.warp2dImg("+image+", transform, "+outImage+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def translation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    image,Tx,Ty,Tz = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
    text += "transform = PyIPSDK.createWarpMotionTransform3d(PyIPSDK.eGeometricTransform3dType.eGT3DT_Translation,["+str(Tx)+","+str(Ty)+","+str(Tz)+"])\n"
    text += "gtrans.warp3dImg("+image+", transform, "+outImage+")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def rotation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    image,theta,boolValue = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text = addToText(text, "###from numpy import pi\n", not process)
    text += "transform = PyIPSDK.createCenteredRotation(" + str(theta) + "*pi/180," + image + ")\n"
    if boolValue == False:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += "gtrans.warp2dImg(" + image + ", transform, " + outImage + ")\n"
    else:
        text+= "rigid2d = PyIPSDK.Rigid2d(*transform.params)\n"
        text += "minX,minY = 0,0\n"
        text+= "points = [PyIPSDK.Real32Point2d(0,0),PyIPSDK.Real32Point2d("+image+".getSizeX(),0),PyIPSDK.Real32Point2d("+image+".getSizeX(),"+image+".getSizeY()),PyIPSDK.Real32Point2d(0,"+image+".getSizeY())]\n"
        text += "for point in points:\n"
        text += "\tpointRot = PyIPSDK.apply(rigid2d, point)\n"
        text += "\tminX, minY = min(minX, pointRot.getX()), min(minY, pointRot.getY())\n"
        text += "transform.params[1] -= minX\n"
        text += "transform.params[2] -= minY\n"
        text += outImage +" = gtrans.warp2dImg("+image+", transform)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def rotation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    image,thetaX,thetaY,thetaZ,boolValue = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text = addToText(text, "###from numpy import pi\n", not process)
    text += "transform = PyIPSDK.createCenteredRotation(" + str(thetaX) + "*pi/180,"+ str(thetaY) + "*pi/180,"+ str(thetaZ) + "*pi/180," + image + ")\n"
    if boolValue == False:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += "gtrans.warp3dImg(" + image + ", transform, " + outImage + ")\n"
    else:
        text+= "rigid3d = PyIPSDK.Rigid3d(*transform.params)\n"
        text += "minX,minY,minZ = 0,0,0\n"
        text+= "points = [PyIPSDK.Real32Point3d(0,0,0),PyIPSDK.Real32Point3d(0,0,"+image+".getSizeZ()),PyIPSDK.Real32Point3d(0,"+image+".getSizeY(),0),PyIPSDK.Real32Point3d(0,"+image+".getSizeY(),"+image+".getSizeZ()),PyIPSDK.Real32Point3d("+image+".getSizeX(),0,0),PyIPSDK.Real32Point3d("+image+".getSizeX(),"+image+".getSizeY(),0),PyIPSDK.Real32Point3d("+image+".getSizeX(),0,"+image+".getSizeZ()),PyIPSDK.Real32Point3d("+image+".getSizeX(),"+image+".getSizeY(),"+image+".getSizeZ())]\n"
        text += "for point in points:\n"
        text += "\tpointRot = PyIPSDK.apply(rigid3d, point)\n"
        text += "\tminX, minY,minZ = min(minX, pointRot.getX()), min(minY, pointRot.getY()), min(minZ, pointRot.getZ())\n"
        text += "transform.params[3] -= minX\n"
        text += "transform.params[4] -= minY\n"
        text += "transform.params[5] -= minZ\n"
        text += outImage +" = gtrans.warp3dImg("+image+", transform)\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def unrollRingImg(xmlFunctionCall, outImage="outImage", process=True):
    image,centerX,centerY,radius,halfThickness,interpolationMethod, outSizeX = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)
    text += "center = PyIPSDK.createCoords2d(" + str(centerX) + "," + str(centerY) + ")\n"
    if interpolationMethod is None:
        text += outImage + " = gtrans.unrollRingImg(" + image + ", center, " + str(radius) + "," + str(halfThickness) + "," + str(outSizeX) + ")\n"
    else:
        theta0 = "0"
        text += outImage + " = gtrans.unrollRingImg(" + image + ", center, " + str(radius) + "," + str(halfThickness) + "," + str(theta0) + "," + interpolationMethod + "," + str(outSizeX) + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def unrollCylinderImg(xmlFunctionCall, outImage="outImage", process=True):

    image,centerX,centerY,radius, interpolationMethod, halfThickness, integrationType, outSizeX = xmlToParamList(xmlFunctionCall)

    theta0 = "0"

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeC = Dfct.childText(child, "C")
            colorType = Dfct.childText(child, "ColorType")
            sizeT = Dfct.childText(child, "T")
            sizeZ = Dfct.childText(child, "Z")

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n", not process)

    if sizeC != "1" or sizeT != "1":
        text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
        if sizeC != "1":
            if colorType == "eCGT_User":
                text += "colorGeometry.initUser(" + image + ".getSizeC())\n"
            else:
                text += "colorGeometry.init(PyIPSDK." + colorType + ")\n"
        else:
            text += "colorGeometry.initGrey()\n"
        text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
        text += "volumeGeometry.init2d()\n"
        text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
        if sizeT == "1":
            text += "temporalGeometry.initSingle()\n"
        else:
            text += "temporalGeometry.initSequence(" + image + ".getSizeT())\n"
        text += "geometry = PyIPSDK.geometry(" + image + ".getBufferType(), " + str(outSizeX) + ", " + sizeZ + ", volumeGeometry, colorGeometry, temporalGeometry)\n"
        text += outImage + " = PyIPSDK.createImage(geometry)\n"
    else:
        text += outImage +" = PyIPSDK.createImage(" + image + ".getBufferType(), " +  str(outSizeX) + "," + image +".getSizeZ())\n"
    text += "center = PyIPSDK.createCoords2d(" + str(centerX) + "," + str(centerY) + ")\n"
    if halfThickness is None and integrationType is None:
        text += "gtrans.unrollCylinderImg(" + image + ",center," + str(radius) + "," +str(theta0) + "," + interpolationMethod + "," + outImage + ")\n"
    else:
        if halfThickness is None:
            halfThickness = "1"
        if integrationType is None:
            integrationType = "PyIPSDK.eCUIT_Mean"
        text += "intergrationParams = PyIPSDK.createCylinderUnrollingIntegrationParams(" + integrationType + "," + str(halfThickness) + ")\n"
        text += "gtrans.unrollCylinderImg(" + image + ",center," + str(radius) + "," +str(theta0) + "," + interpolationMethod + ",intergrationParams," + outImage + ")\n"
    text = addToText(text, "outputs = " + outImage, process)
    return text

def elasticWarp2dImg(xmlFunctionCall, outImage="outImage", process=True):

    image, imDx, imDy, interpolationMethod = xmlToParamList(xmlFunctionCall)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n', not process)
    text += outImage + ' = gtrans.elasticWarp2dImg('+image+', '+imDx+', '+imDy+', '+interpolationMethod+')\n'
        
    text = addToText(text, "outputs = " + outImage, process)
    return text


def warp2dImg(xmlFunctionCall, outImage="outImage", process=True):
    image, parametersDesc, interpPolicy = xmlToParamList(xmlFunctionCall)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLGeometricTransform as gtrans\n', not process)
    if parametersDesc[0] == 'From parameters':
        tx = parametersDesc[1]
        ty = parametersDesc[2]
        theta = parametersDesc[3]
        scale = parametersDesc[4]
        if scale == 1 and theta == 0:
            text += 'transformation = PyIPSDK.createWarpMotionTransform2d(PyIPSDK.eGT2DT_Translation,['+str(tx)+', '+str(ty)+'])\n'
        elif scale == 1 and theta !=0:
            text = addToText(text, '###import numpy as np\n', not process)
            text += 'transformation = PyIPSDK.createWarpMotionTransform2d(PyIPSDK.eGT2DT_Rigid,['+str(theta)+'*np.pi/180,'+str(tx)+', '+str(ty)+'])\n'
        else:
            text = addToText(text, '###import numpy as np\n', not process)
            text += 'transformation = PyIPSDK.createWarpMotionTransform2d(PyIPSDK.eGT2DT_Similarity,['+str(scale)+','+str(theta)+'*np.pi/180,'+str(tx)+', '+str(ty)+'])\n'

    elif parametersDesc[0] == 'From transformation':
        text+= 'transformation = PyIPSDK.createWarpMotionTransform2d('+parametersDesc[1]+')\n'

    text += outImage + ' = gtrans.warp2dImg(' + image + ',transformation,' + interpPolicy + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text