import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

import DatabaseFunction as Dfct
import UsefullFunctions as fct
import UsefullVariables as vrb
from MatrixCreatorWidget import LabelMatrixCreator
from processFunction._ProcessFunction import xmlToParamList, addToText

##################
#    Filtering   #
##################
def anisotropicDiffusion2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbSteps, sharpness, anisotropy = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.anisotropicDiffusion2dImg(' + image + ', ' + str(nbSteps) + ', ' + str(sharpness) + ', ' + str(anisotropy) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def anisotropicDiffusion3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbSteps, sharpness, anisotropy = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.anisotropicDiffusion3dImg(' + image + ', ' + str(nbSteps) + ', ' + str(sharpness) + ', ' + str(anisotropy) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def bilateral2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSize, spaceSigma, rangeSigma = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if halfKernelSize is None:
        text += outImage + ' = filtering.bilateral2dImg(' + image + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    else:
        text += outImage + ' = filtering.bilateral2dImg(' + image + ', ' + str(halfKernelSize) + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def bilateral3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSize, spaceSigma, rangeSigma = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if halfKernelSize is None:
        text += outImage + ' = filtering.bilateral3dImg(' + image + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    else:
        text += outImage + ' = filtering.bilateral3dImg(' + image + ', ' + str(halfKernelSize) + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def convolution2dImg(xmlFunctionCall, outImage="outImage", process=True):
    # TODO : border policy
    parameters = xmlToParamList(xmlFunctionCall)
    image, kernel, isNormalize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text += 'kernel = ' + kernel
    text += outImage + ' = filtering.convolution2dImg(' + image + ', kernel, ' + str(isNormalize) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    #outImage = util.convertImg(outImage, PyIPSDK.eIBT_UInt8)
    return text


def despeckleFilter2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelX, halfKernelY, factor = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.despeckleFilter2dImg(' + image + ', ' + str(halfKernelX) + ', ' + str(halfKernelY) + ', ' + str(factor) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def frequencyFiltering2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, filterType, cutoffFreq, stdDev, theta, thetaRange = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if (theta is None and thetaRange is not None) or (theta is not None and thetaRange is None):
        raise Exception('ERROR: Theta and Theta range must both be defined, or none of them')
    elif theta is None and thetaRange is None:
        text += outImage + ' = filtering.frequencyFiltering2dImg(' + image + ', ' + str(filterType) + ', ' + str(cutoffFreq) + ', ' + str(stdDev) + ')\n'
    else:
        text += outImage + ' = filtering.frequencyFiltering2dImg(' + image + ', ' + str(filterType) + ', ' + str(cutoffFreq) + ', ' + str(stdDev) + ', ' + str(theta) + ', ' + str(thetaRange) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def frequencyFiltering3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, filterType, cutoffFreq, stdDev, theta, thetaRange, phi, phiRange = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)

    if theta is None and thetaRange is None and phi is None and phiRange is None:
        text += outImage + ' = filtering.frequencyFiltering3dImg(' + image + ', ' + str(filterType) + ', ' + str(cutoffFreq) + ', ' + str(stdDev) + ')\n'
    else:
        nbNone = sum(x is None for x in [theta, thetaRange, phi, phiRange])
        if nbNone != 4:
            raise Exception('ERROR: Theta and Theta range and Phi and Phi range must all be defined, or none of them.')
        else:
            text += outImage + ' = filtering.frequencyFiltering3dImg(' + image + ', ' + str(filterType) + ', ' + str(cutoffFreq) + ', ' + str(stdDev)\
                    + ', ' + str(theta) + ', ' + str(thetaRange) + ', ' + str(phi) + ', ' + str(phiRange) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def gaussianGradient2dImg(xmlFunctionCall, outImage=["outImageX", 'outImageY'], process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    try:
        image, stdDev, stdDevY, gaussianRatio, minHalfKernelSize, outputDomain = parameters
        bPolarOutput = outputDomain == "Polar"
    except:
        image, stdDev, stdDevY, gaussianRatio, minHalfKernelSize = parameters
        bPolarOutput = False

    text = ''
    if bPolarOutput:
        text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    
    cartesianOutGX = outImage[0]
    cartesianOutGY = outImage[1]
    
    if bPolarOutput:
        cartesianOutGX = "gx"
        cartesianOutGY = "gy"
    
    if (stdDevY is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += cartesianOutGX + ', ' + cartesianOutGY + ' = filtering.gaussianGradient2dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += cartesianOutGX + ', ' + cartesianOutGY + ' = filtering.gaussianGradient2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += cartesianOutGX + ', ' + cartesianOutGY + ' = filtering.gaussianGradient2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: Gaussian Ratio and MinHalfKernelSize must both be defined, or none of them')
    
    if bPolarOutput:
        text += 'convertX = util.convertImg(' + cartesianOutGX + ', PyIPSDK.eIBT_Real32)\n'
        text += 'convertY = util.convertImg(' + cartesianOutGY + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage[0] + "," + outImage[1] + " = arithm.cartesianToPolarImg(convertX, convertY)\n"
    
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def gaussianGradient3dImg(xmlFunctionCall, outImage=["outImageX", 'outImageY', 'outImageZ'], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevY, stdDevZ, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (stdDevZ is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianGradient3dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianGradient3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianGradient3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y and Standard Deviation Z) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ']', process)
    return text


def gaussianHessian2dImg(xmlFunctionCall, outImage=("outImageXX", 'outImageXY', 'outImageYY'), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevY, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianHessian2dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianHessian2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.gaussianHessian2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ']', process)
    return text


def gaussianHessian3dImg(xmlFunctionCall, outImage=("outImageXX", 'outImageXY', 'outImageXZ', "outImageYY", 'outImageYZ', 'outImageZZ'), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevY, stdDevZ, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (stdDevZ is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ', ' + outImage[3] + ', ' + outImage[4] + ', ' + outImage[5] + ' = filtering.gaussianHessian3dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ', ' + outImage[3] + ', ' + outImage[4] + ', ' + outImage[5] + ' = filtering.gaussianHessian3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ', ' + outImage[3] + ', ' + outImage[4] + ', ' + outImage[5] + ' = filtering.gaussianHessian3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y and Standard Deviation Z) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ', ' + outImage[3] + ', ' + outImage[4] + ', ' + outImage[5] + ']', process)
    return text


def gaussianSmoothing2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevY, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if stdDevY is None and gaussianRatio is None and minHalfKernelSize is None:
        text += outImage + ' = filtering.gaussianSmoothing2dImg(' + image + ', ' + str(stdDev) + ')\n'
    else:
        if stdDevY is None:
            stdDevY = stdDev
        if gaussianRatio is None and minHalfKernelSize is None:
            text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        else:
            if gaussianRatio is None:
                gaussianRatio = 0.997
            if minHalfKernelSize is None:
                minHalfKernelSize = 2
            text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.gaussianSmoothing2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def gaussianSmoothing3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevY, stdDevZ, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if stdDevY is None and stdDevZ is None and gaussianRatio is None and minHalfKernelSize is None:
        text += outImage + ' = filtering.gaussianSmoothing3dImg(' + image + ', ' + str(stdDev) + ')\n'
    else:
        if stdDevY is None:
            stdDevY = stdDev
        if stdDevZ is None:
            stdDevZ = stdDev
        if gaussianRatio is None and minHalfKernelSize is None:
            text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        else:
            if gaussianRatio is None:
                gaussianRatio = 0.997
            if minHalfKernelSize is None:
                minHalfKernelSize = 2
            text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.gaussianSmoothing3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def highPass2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.highPass2dImg(' + image + ', ' + str(halfKernelSize) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def highPass3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.highPass3dImg(' + image + ', ' + str(halfKernelSize) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def laplacianDoG2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevFactor, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevFactor is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += outImage + ' = filtering.laplacianDoG2dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevFactor is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.laplacianDoG2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    elif (stdDevFactor is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.laplacianDoG2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Factor) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text


def laplacianDoG3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevFactor, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevFactor is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += outImage + ' = filtering.laplacianDoG3dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevFactor is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.laplacianDoG3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    elif (stdDevFactor is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.laplacianDoG3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Factor) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text


def laplacianDoGDeblur2dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevFactor, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevFactor is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += outImage + ' = filtering.laplacianDoGDeblur2dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevFactor is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.laplacianDoGDeblur2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    elif (stdDevFactor is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.laplacianDoGDeblur2dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Factor) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text


def laplacianDoGDeblur3dImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, stdDev, stdDevFactor, gaussianRatio, minHalfKernelSize = parameters
    text = addToText('', '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevFactor is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += outImage + ' = filtering.laplacianDoGDeblur3dImg(' + image + ', ' + str(stdDev) + ')\n'
    elif (stdDevFactor is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.laplacianDoGDeblur3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    elif (stdDevFactor is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.laplacianDoGDeblur3dImg(' + image + ', ' + str(stdDev) + ', ' + str(stdDevFactor) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Factor) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text


def meanSmoothing2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask, halfKernelSizeX, halfKernelSizeY = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if mask is None:
    	text += outImage + '= filtering.meanSmoothing2dImg(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ')\n'
    else:
        text += outImage + '= filtering.meanSmoothing2dMaskImg(' + image + ', ' + mask + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def meanSmoothing3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask, halfKernelSizeX, halfKernelSizeY, halfKernelSizeZ = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if mask is None:
        text += outImage + '= filtering.meanSmoothing3dImg(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ', ' + str(halfKernelSizeZ) + ')\n'
    else:
        text += outImage + '= filtering.meanSmoothing3dMaskImg(' + image + ', ' + mask + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ', ' + str(halfKernelSizeZ) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def median2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSizeX, halfKernelSizeY, allow8bitsCompression = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if allow8bitsCompression:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += 'filtering.median2dImg_allow8bitsCompression(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ', ' + outImage + ')\n'
    else:
        text += outImage + ' = filtering.median2dImg(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def median3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKernelSizeX, halfKernelSizeY, halfKernelSizeZ, allow8bitsCompression = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if allow8bitsCompression:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += 'filtering.median3dImg_allow8bitsCompression(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ', ' + str(halfKernelSizeZ) + ', ' + outImage + ')\n'
    else:
        text += outImage + ' = filtering.median3dImg(' + image + ', ' + str(halfKernelSizeX) + ', ' + str(halfKernelSizeY) + ', ' + str(halfKernelSizeZ) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


# def multiscaleVesselEnhancement2dImg(xmlFunctionCall, outImage="outImage", process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     image, blobnessS, isBrightOnDark, scales = parameters
#     text = ''
#     text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
#     text = addToText(text, '###import PyIPSDK\n', not process)
#     text += 'mveParam = PyIPSDK.createMVEParameter(' + scales + ', ' + str(isBrightOnDark) + ', ' + str(blobnessS) + ', 0.5)\n'
#     text += outImage + ' = filtering.multiscaleVesselEnhancement2dImg(' + image + ', mveParam)\n'
#     text = addToText(text, "outputs = " + outImage, process)
#     return text
#
#
# def multiscaleVesselEnhancement3dImg(xmlFunctionCall, outImage="outImage", process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     image, blobnessS, areaS, isBrightOnDark, scales = parameters
#     text = ''
#     text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
#     text = addToText(text, '###import PyIPSDK\n', not process)
#     text += 'mveParam = PyIPSDK.createMVEParameter(' + scales + ', ' + str(isBrightOnDark) + ', ' + str(blobnessS) + ', ' + str(areaS) + ')\n'
#     text += outImage + ' = filtering.multiscaleVesselEnhancement3dImg(' + image + ', mveParam)\n'
#     text = addToText(text, "outputs = " + outImage, process)
#     return text


def normalizedCrossCorrelation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, subImage = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text += """newSizeX = {subImage}.getSizeX() - (({subImage}.getSizeX() + 1)%2)
newSizeY = {subImage}.getSizeY() - (({subImage}.getSizeY() + 1)%2)
if {subImage}.getSizeX() != newSizeX or {subImage}.getSizeY() != newSizeY:
    {subImage} = util.getROI2dImg({subImage}, 0, 0, newSizeX, newSizeY)

kernel = PyIPSDK.rectangularKernelXY(int((newSizeX-1) / 2), int((newSizeY-1)/2), {subImage}.array.flatten().tolist())
""".format(subImage=subImage)
    text += outImage + ' = filtering.normalizedCrossCorrelation2dImg(' + image + ', kernel)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def normalizedCrossCorrelation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, subImage = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text += """newSizeX = {subImage}.getSizeX() - (({subImage}.getSizeX() + 1)%2)
newSizeY = {subImage}.getSizeY() - (({subImage}.getSizeY() + 1)%2)
newSizeZ = {subImage}.getSizeZ() - (({subImage}.getSizeZ() + 1)%2)
if {subImage}.getSizeX() != newSizeX or {subImage}.getSizeY() != newSizeY or {subImage}.getSizeZ() != newSizeZ:
    {subImage} = util.getROI3dImg({subImage}, 0, 0, 0, newSizeX, newSizeY, newSizeZ)

kernel = PyIPSDK.rectangularKernelXYZ(int((newSizeX-1) / 2), int((newSizeY-1)/2), int((newSizeZ-1)/2), {subImage}.array.flatten().tolist())
""".format(subImage=subImage)
    text += outImage + ' = filtering.normalizedCrossCorrelation3dImg(' + image + ', kernel)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def patchBasedBilateral2dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image, parametersDesc = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        if parametersDesc[0] == 'Simple':
            if parametersDesc[1] is None:
                text += outImage + ', autoParams = filtering.patchBasedBilateral2dImg(' + image + ')\n'
            else:
                text += 'patchBasedBilateralParams = PyIPSDK.createPatchBasedBilateralParams(' + str(parametersDesc[1]) + ')\n'
                text += outImage + ', autoParams = filtering.patchBasedBilateral2dImg(' + image + ', patchBasedBilateralParams)\n'
        elif parametersDesc[0] == 'Range':
            text += 'patchBasedBilateralParams = PyIPSDK.createPatchBasedBilateralParams(' + str(parametersDesc[1]) + ', PyIPSDK.createRange(' + str(parametersDesc[2]) + ', ' + str(parametersDesc[3]) + '))\n'
            text += outImage + ', autoParams = filtering.patchBasedBilateral2dImg(' + image + ', patchBasedBilateralParams)\n'
    else:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        if parametersDesc[0] == 'Simple':
            if parametersDesc[1] is None:
                text += 'autoParams = filtering.multiSlice_patchBasedBilateral2dImg(' + image + ','+outImage+')\n'
            else:
                text += 'autoParams = filtering.multiSlice_patchBasedBilateral2dImg(' + image + ',' + str(parametersDesc[1]) + ',' +outImage+')\n'
        elif parametersDesc[0] == 'Range':
            text += 'autoParams = filtering.multiSlice_patchBasedBilateral2dImg(' + image + ',' + str(parametersDesc[1]) + ',' + str(parametersDesc[2]) + ',' + str(parametersDesc[3]) + ',' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def patchBasedBilateral3dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    image, parametersDesc = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if sizeC == "1" and sizeT == "1":
        if parametersDesc[0] == 'Simple':
            if parametersDesc[1] is None:
                text += outImage + ', autoParams = filtering.patchBasedBilateral3dImg(' + image + ')\n'
            else:
                text += 'patchBasedBilateralParams = PyIPSDK.createPatchBasedBilateralParams(' + str(parametersDesc[1]) + ')\n'
                text += outImage + ', autoParams = filtering.patchBasedBilateral3dImg(' + image + ', patchBasedBilateralParams)\n'
        elif parametersDesc[0] == 'Range':
            text += 'patchBasedBilateralParams = PyIPSDK.createPatchBasedBilateralParams(' + str(parametersDesc[1]) + ', PyIPSDK.createRange(' + str(parametersDesc[2]) + ', ' + str(parametersDesc[3]) + '))\n'
            text += outImage + ', autoParams = filtering.patchBasedBilateral3dImg(' + image + ', patchBasedBilateralParams)\n'
    else:
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        if parametersDesc[0] == 'Simple':
            if parametersDesc[1] is None:
                text += 'autoParams = filtering.multiSlice_patchBasedBilateral3dImg(' + image + ','+outImage+')\n'
            else:
                text += 'autoParams = filtering.multiSlice_patchBasedBilateral3dImg(' + image + ',' + str(parametersDesc[1]) + ',' +outImage+')\n'
        elif parametersDesc[0] == 'Range':
            text += 'autoParams = filtering.multiSlice_patchBasedBilateral3dImg(' + image + ',' + str(parametersDesc[1]) + ',' + str(parametersDesc[2]) + ',' + str(parametersDesc[3]) + ',' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def pearsonColocalization2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.pearsonColocalization2dImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def pearsonColocalization3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text += outImage + ' = filtering.pearsonColocalization3dImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def richardsonLucyDeblur2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbIter, stdDev, stdDevY, gaussianRatio, minHalfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage + ' = filtering.richardsonLucyDeblur2dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.richardsonLucyDeblur2dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.richardsonLucyDeblur2dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text

def richardsonLucyDeblur3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbIter, stdDev, stdDevY, stdDevZ, gaussianRatio, minHalfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (stdDevZ is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage + ' = filtering.richardsonLucyDeblur3dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.richardsonLucyDeblur3dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.richardsonLucyDeblur3dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y and Standard Deviation Z) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text

def separatedBilateral2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, spaceSigma, rangeSigma, halfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if halfKernelSize is None:
        text += outImage + ' = filtering.separatedBilateral2dImg(' + image + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    else:
        text += outImage + ' = filtering.separatedBilateral2dImg(' + image + ', ' + str(halfKernelSize) + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def separatedBilateral3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, spaceSigma, rangeSigma, halfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if halfKernelSize is None:
        text += outImage + ' = filtering.separatedBilateral3dImg(' + image + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    else:
        text += outImage + ' = filtering.separatedBilateral3dImg(' + image + ', ' + str(halfKernelSize) + ', ' + str(spaceSigma) + ', ' + str(rangeSigma) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def sobelGradient2dImg(xmlFunctionCall, outImage=["outImageX", 'outImageY'], process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    try:
        image, kernelType, isNormalize, outputDomain = parameters
        bPolarOutput = outputDomain == "Polar"
    except:
        image, kernelType, isNormalize = parameters
        bPolarOutput = False
    
    text = ''
    if bPolarOutput:
        text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    
    cartesianOutGX = outImage[0]
    cartesianOutGY = outImage[1]
    
    if bPolarOutput:
        cartesianOutGX = "gx"
        cartesianOutGY = "gy"
    
    if kernelType is None:
        text += cartesianOutGX + ', ' + cartesianOutGY + ' = filtering.sobelGradient2dImg(' + image + ')\n'
    else:
        text += cartesianOutGX + ', ' + cartesianOutGY + ' = filtering.sobelGradient2dImg(' + image + ', ' + str(kernelType) + ', ' + str(isNormalize) + ')\n'
    
    if bPolarOutput:
        text += 'convertX = util.convertImg(' + cartesianOutGX + ', PyIPSDK.eIBT_Real32)\n'
        text += 'convertY = util.convertImg(' + cartesianOutGY + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage[0] + "," + outImage[1] + " = arithm.cartesianToPolarImg(convertX, convertY)\n"
    
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def sobelGradient3dImg(xmlFunctionCall, outImage=["outImageX", 'outImageY', 'outImageZ'], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, kernelType, isNormalize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if kernelType is None:
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.sobelGradient3dImg(' + image + ')\n'
    else:
        text += outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ' = filtering.sobelGradient3dImg(' + image + ', ' + str(kernelType) + ', ' + str(isNormalize) + ')\n'
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ']', process)
    return text

def unsharpMask2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, blurWeight, stdDev, stdDevY, gaussianRatio, minHalfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage + ' = filtering.unsharpMask2dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.unsharpMask2dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.unsharpMask2dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text

def unsharpMask3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, blurWeight, stdDev, stdDevY, stdDevZ, gaussianRatio, minHalfKernelSize = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if (stdDevY is None) and (stdDevZ is None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        # only mandatory params
        text += outImage + ' = filtering.unsharpMask3dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ')\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is not None) and (minHalfKernelSize is not None):
        text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        text += outImage + ' = filtering.unsharpMask3dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    elif (stdDevY is not None) and (stdDevZ is not None) and (gaussianRatio is None) and (minHalfKernelSize is None):
        text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        text += outImage + ' = filtering.unsharpMask3dImg(' + image + ', ' + str(blurWeight) + ', ' + str(stdDev) + ', ' + str(stdDevY) + ', ' + str(stdDevZ) + ', gaussianCoverage)\n'
    else:
        raise Exception('ERROR: (Standard Deviation Y and Standard Deviation Z) and/or (Gaussian Ratio and MinHalfKernelSize) must be defined, or none of them')
    text = addToText(text, "outputs = " + outImage, process)
    return text

def zStackFocusMaximumImg(xmlFunctionCall, outImage=("outImage", "depthMap"), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, contrastRay, meanSmoothValue, zoomFactor = parameters

    sizeZ = None

    # numID = fct.getNumId(image)
    # print("numId = ", numID)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if sizeZ == "1":
        text = addToText(text, '###import PyIPSDK\n', not process)

    textImage = image
    if sizeZ == "1":
        text += "image3d = PyIPSDK.reinterpretSequenceToVolume(" + image + ")\n"
        textImage = "image3d"

    if contrastRay is None and meanSmoothValue is None and zoomFactor is None:
        text += outImage[0] + ', ' + outImage[1] + ' = filtering.zStackFocusMaximumWithMapImg(' + textImage + ')\n'
    elif meanSmoothValue is None and zoomFactor is None:
        text += outImage[0] + ', ' + outImage[1] + ' = filtering.zStackFocusMaximumWithMapImg(' + textImage + ', ' + str(contrastRay) + ')\n'
    else:
        if contrastRay is None:
            contrastRay = 10
        if meanSmoothValue is None:
            meanSmoothValue = 1
        if zoomFactor is None:
            zoomFactor = 1
        text += outImage[0] + ', ' + outImage[1] + ' = filtering.zStackFocusMaximumWithMapImg(' + textImage + ', ' + str(contrastRay) + ', ' + str(meanSmoothValue) + ', ' + str(zoomFactor) + ')\n'
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text

def zStackFocusPonderationImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, contrastRay, meanSmoothValue, zoomFactor = parameters

    # numID = fct.getNumId(image)
    #
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # Dfct.saveXmlElement(allElements, "C:/dev/allElement.mho")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
    if sizeZ == "1":
        text = addToText(text, '###import PyIPSDK\n', not process)

    textImage = image
    if sizeZ == "1":
        text += "image3d = PyIPSDK.reinterpretSequenceToVolume(" + image + ")\n"
        textImage = "image3d"

    if contrastRay is None and meanSmoothValue is None and zoomFactor is None:
        text += outImage + ' = filtering.zStackFocusPonderationImg(' + textImage + ')\n'
    elif meanSmoothValue is None and zoomFactor is None:
        text += outImage + ' = filtering.zStackFocusPonderationImg(' + textImage + ', ' + str(contrastRay) + ')\n'
    else:
        if contrastRay is None:
            contrastRay = 10
        if meanSmoothValue is None:
            meanSmoothValue = 1
        if zoomFactor is None:
            zoomFactor = 1
        text += outImage + ' = filtering.zStackFocusPonderationImg(' + textImage + ', ' + str(contrastRay) + ', ' + str(meanSmoothValue) + ', ' + str(zoomFactor) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def fastCrossCorrelation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFiltering as filtering\n", not process)
    text += outImage + ' = filtering.fastCrossCorrelation2dImg(' + parameters[0] + ', ' + parameters[1] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text


def fastCrossCorrelation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFiltering as filtering\n", not process)
    text += outImage + ' = filtering.fastCrossCorrelation3dImg(' + parameters[0] + ', ' + parameters[1] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text


def dicIntegration2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFiltering as filtering\n", not process)
    text += outImage + ' = filtering.dicIntegration2dImg(' + parameters[0] + ', ' + str(parameters[1]) + ', ' + str(parameters[2]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text


def dicPhaseRetrieval2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    
    image, stdDev, mu, delta, defocusDist, lambdaParam, lengthScale, energy = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFiltering as filtering\n", not process)
    if mu is None:
        text += outImage + ' = filtering.dicPhaseRetrieval2dImg(' + image + ', ' + str(stdDev) + ')\n'
    else:
        if lambdaParam is None:
            text += outImage + ' = filtering.dicPhaseRetrieval2dImg(' + image + ', ' + str(stdDev) + ', ' + str(mu) + ', ' + str(delta) + ', ' + str(defocusDist) + ')\n'
        else:
            text += outImage + ' = filtering.dicPhaseRetrieval2dImg(' + image + ', ' + str(stdDev) + ', ' + str(mu) + ', ' + str(delta) + ', ' + str(defocusDist) + ', ' + str(lambdaParam) + ', ' + str(lengthScale) + ', ' + str(energy) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text


def vsnr2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    
    image, nbIter, stdDevX, stdDevY, theta, alpha = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFiltering as filtering\n", not process)
    text += outImage[0] + ', ' + outImage[1] + ' = filtering.vsnr2dImg(' + image + ', ' + str(nbIter) + ', ' + str(stdDevX) + ', ' + str(stdDevY) + ', ' + str(theta) + ', ' + str(alpha) + ')\n'
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)

    return text