import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

from processFunction._ProcessFunction import xmlToParamList, addToText, xmlFunctionCallAdvancedToXmlFunctionCall
import DatabaseFunction as Dfct
import processFunction.Filtering as PfctFiltering


def cannyEdges2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    thresholdMin, thresholdMax, gradientDesc = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)

    cannyThreshold = 'PyIPSDK.createCannyThresholds(' + str(thresholdMin) + ', ' + str(thresholdMax) + ')'
    if gradientDesc[0] == 'Custom':
        text += outImage + ' = fd.cannyEdges2dImg(' + gradientDesc[1] + ', ' + gradientDesc[2] + ', ' + cannyThreshold + ')\n'
    else:
        text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
        xmlParameterAdvancedCopy = xmlFunctionCallAdvancedToXmlFunctionCall(xmlFunctionCall, 2)
        if gradientDesc[0] == 'Sobel':
            text += PfctFiltering.sobelGradient2dImg(xmlParameterAdvancedCopy, outImage=['imgGradX', 'imgGradY'], process=False)
        elif gradientDesc[0] == 'Gaussian':
            text += PfctFiltering.gaussianGradient2dImg(xmlParameterAdvancedCopy, outImage=['imgGradX', 'imgGradY'], process=False)
        text += outImage + ' = fd.cannyEdges2dImg(imgGradX, imgGradY, ' + cannyThreshold + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def cannySurfaces3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    thresholdMin, thresholdMax, gradientDesc = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)

    cannyThreshold = 'PyIPSDK.createCannyThresholds(' + str(thresholdMin) + ', ' + str(thresholdMax) + ')'
    if gradientDesc[0] == 'Custom':
        text += outImage + ' = fd.cannySurfaces3dImg(' + gradientDesc[1] + ', ' + gradientDesc[2] + ', ' + gradientDesc[3] + ', ' + cannyThreshold + ')\n'
    else:
        text = addToText(text, '###import PyIPSDK.IPSDKIPLFiltering as filtering\n', not process)
        xmlParameterAdvancedCopy = xmlFunctionCallAdvancedToXmlFunctionCall(xmlFunctionCall, 2)
        if gradientDesc[0] == 'Sobel':
            text += PfctFiltering.sobelGradient3dImg(xmlParameterAdvancedCopy, outImage=['imgGradX', 'imgGradY', 'imgGradZ'], process=False)
        elif gradientDesc[0] == 'Gaussian':
            text += PfctFiltering.gaussianGradient3dImg(xmlParameterAdvancedCopy, outImage=['imgGradX', 'imgGradY', 'imgGradZ'], process=False)
        text += outImage + ' = fd.cannySurfaces3dImg(imgGradX, imgGradY, imgGradZ, ' + cannyThreshold + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def extractLocalExtrema2d(xmlFunctionCall, outImage="pixels2D", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, distX, distY, extrType, extreThreshold, nbPoint = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    textExtremaConfig = extrType + ', '
    if extreThreshold is not None:
        textExtremaConfig += str(float(extreThreshold)) + ', '
    if nbPoint is not None:
        textExtremaConfig += str(int(nbPoint)) + ', '
    textExtremaConfig = textExtremaConfig[:-2]

    text += 'localExtremaConfig = PyIPSDK.createLocalExtremaConfig(' + textExtremaConfig + ')\n'
    if sizeZ == "1" and sizeC == "1" and sizeT == "1":
        text += outImage + " = fd.extractLocalExtrema2d("+ image +", " + str(distX) + ", " + str(distY) + ", localExtremaConfig)\n"
    else:
        text += outImage + " = fd.multiSlice_extractLocalExtrema2d("+ image +", " + str(distX) + ", " + str(distY) + ", localExtremaConfig)\n"
    text = addToText(text, outImage + '.subType = "LocalExtrema"\n', process)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def extractLocalExtrema3d(xmlFunctionCall, outImage="voxels3D", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, distX, distY, distZ, extrType, extreThreshold, nbPoint = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeC = Dfct.childText(child, "T")
    #         sizeT = Dfct.childText(child, "C")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    textExtremaConfig = extrType + ', '
    if extreThreshold is not None:
        textExtremaConfig += str(float(extreThreshold)) + ', '
    if nbPoint is not None:
        textExtremaConfig += str(int(nbPoint)) + ', '
    textExtremaConfig = textExtremaConfig[:-2]

    text += 'localExtremaConfig = PyIPSDK.createLocalExtremaConfig(' + textExtremaConfig + ')\n'
    if sizeC == "1" and sizeT == "1":
        text += outImage + ' = fd.extractLocalExtrema3d(' + image + ', ' + str(distX) + ', ' + str(distY) + ', ' + str(distZ) + ', localExtremaConfig)\n'
    else:
        text += outImage + ' = fd.multiSlice_extractLocalExtrema3d(' + image + ', ' + str(distX) + ', ' + str(distY) + ', ' + str(distZ) + ', localExtremaConfig)\n'
    text = addToText(text, outImage + '.subType = "LocalExtrema"\n', process)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def harrisCorner2d(xmlFunctionCall, outImage="pixels2D", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, callType = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeZ = Dfct.childText(child, "Z")
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)
    if callType[0] == 'Simple':
        _, gradStdDev, nbPoints, featureDist = callType
        if gradStdDev is None:
            if sizeZ == "1" and sizeC == "1" and sizeT == "1":
                text += outImage  + "=  fd.harrisCorner2d(" + image + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
            else:
                text += outImage  + "=  fd.multiSlice_harrisCorner2d(" + image + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
        else:
            if sizeZ == "1" and sizeC == "1" and sizeT == "1":
                text += outImage  + "=  fd.harrisCorner2d(" + image + "," + str(gradStdDev) + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
            else:
                text += outImage  + "=  fd.multiSlice_harrisCorner2d(" + image + "," + str(gradStdDev) + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
    elif callType[0] == 'Complete':
        _, gradStdDev, gaussianRatio, minHalfKernelSize, cornerDesc, nbPoints, threshold, featureDistX, featureDistY = callType
        if gaussianRatio is not None and minHalfKernelSize is not None:
            text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        elif gaussianRatio is None and minHalfKernelSize is None:
            text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        else:
            raise Exception('ERROR: (Gaussian Ratio and MinHalfKernelSize) must both be defined, or none of them.')
        if cornerDesc[0] == 'Default':
            text += 'cornerDetectionParam = PyIPSDK.createDefaultHarris2dParams()\n'
        elif cornerDesc[0] == 'Harris':
            text += 'cornerDetectionParam = PyIPSDK.createHarrisParams(' + str(cornerDesc[1]) + ')\n'
        elif cornerDesc[0] == 'ShiThomasi':
            text += 'cornerDetectionParam = PyIPSDK.createShiTomasiParams()\n'
        if sizeZ == "1" and sizeC == "1" and sizeT == "1":
            text+= outImage + "= fd.harrisCorner2d(" + image + "," + str(gradStdDev)+ ", gaussianCoverage, cornerDetectionParam, "+ str(nbPoints) + "," + str(threshold) + ","
            str(featureDistX) + "," +str(featureDistY) + ")\n"
        else:
            text+= outImage + "= fd.multiSlice_harrisCorner2d(" + image + "," + str(gradStdDev)+ ", gaussianCoverage, cornerDetectionParam, "+ str(nbPoints) + "," + str(threshold) + ","
            str(featureDistX) + "," +str(featureDistY) + ")\n"
    text = addToText(text, outImage + '.subType = "HarrisCorner"\n', process)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def harrisCorner3d(xmlFunctionCall, outImage="voxels3D", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, callType = parameters

    # numID = fct.getNumId(image)
    # allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    # for child in allElements:
    #     if Dfct.childText(child, "ElementID") == numID:
    #         sizeC = Dfct.childText(child, "C")
    #         sizeT = Dfct.childText(child, "T")

    sizeZ,sizeC,sizeT,bufferType = fct.computesMultisliceSizes(image)


    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)
    if callType[0] == 'Simple':
        _, gradStdDev, nbPoints, featureDist = callType
        if gradStdDev is None:
            if sizeC == "1" and sizeT == "1":
                text += outImage  + "=  fd.harrisCorner3d(" + image + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
            else:
                text += outImage  + "=  fd.multiSlice_harrisCorner3d(" + image + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
        else:
            if sizeC == "1" and sizeT == "1":
                text += outImage  + "=  fd.harrisCorner3d(" + image + "," + str(gradStdDev) + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
            else:
                text += outImage  + "=  fd.multiSlice_harrisCorner3d(" + image + "," + str(gradStdDev) + "," + str(nbPoints)+ "," + str(featureDist) + ")\n"
    elif callType[0] == 'Complete':
        _, gradStdDev, gaussianRatio, minHalfKernelSize, cornerDesc, nbPoints, threshold, featureDistX, featureDistY, featureDistZ = callType
        if gaussianRatio is not None and minHalfKernelSize is not None:
            text += 'gaussianCoverage = PyIPSDK.createGaussianCoverage(' + str(gaussianRatio) + ', ' + str(minHalfKernelSize) + ')\n'
        elif gaussianRatio is None and minHalfKernelSize is None:
            text += 'gaussianCoverage = PyIPSDK.createDefaultGaussianCoverage()\n'
        else:
            raise Exception('ERROR: (Gaussian Ratio and MinHalfKernelSize) must both be defined, or none of them.')
        if cornerDesc[0] == 'Default':
            text += 'cornerDetectionParam = PyIPSDK.createDefaultHarris3dParams()\n'
        elif cornerDesc[0] == 'Harris':
            text += 'cornerDetectionParam = PyIPSDK.createHarrisParams(' + str(cornerDesc[1]) + ')\n'
        elif cornerDesc[0] == 'ShiThosmasi':
            text += 'cornerDetectionParam = PyIPSDK.createShiTomasiParams()\n'
        if sizeC == "1" and sizeT == "1":
            text+= outImage + "= fd.harrisCorner3d(" + image + "," + str(gradStdDev)+ ", gaussianCoverage, cornerDetectionParam, "+ str(nbPoints) + "," + str(threshold) + "," + str(featureDistX) + "," +str(featureDistY) + "," + str(featureDistZ) + ")\n"
        else:
            text+= outImage + "= fd.multiSlice_harrisCorner3d(" + image + "," + str(gradStdDev)+ ", gaussianCoverage, cornerDetectionParam, "+ str(nbPoints) + "," + str(threshold) + "," + str(featureDistX) + "," +str(featureDistY) + "," + str(featureDistZ) + ")\n"
    text = addToText(text, outImage + '.subType = "HarrisCorner"\n', process)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def harrisCorner2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, gradientStdDev = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)

    text += outImage + " = fd.harrisCorner2dImg(" + image + "," + str(gradientStdDev) +")\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text


def harrisCorner3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, gradientStdDev = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text += """{outImage} = fd.harrisCorner2dImg({image}, {gradientStdDev})
""".format(image=image, outImage=outImage, gradientStdDev=gradientStdDev)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def houghCircles2d(xmlFunctionCall, outImage="circles", process=True):

    outImage = "circles"
    parameters = xmlToParamList(xmlFunctionCall)
    image, radMin, radMax, circlesType, nbPoints, thresholdIntensity, ratioTooCloseCircles, nbCircles = parameters

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)

    text += 'circleRadiusRange = PyIPSDK.createHoughCirclesRadiusRange(' + str(radMin) + ', ' + str(radMax) + ')\n'

    if circlesType is None and nbPoints is None and thresholdIntensity is None and ratioTooCloseCircles is None:
        text+= outImage +'= fd.houghCircles2d('+image+', circleRadiusRange)\n'
    else:
        if circlesType is None:
            circlesType = 'PyIPSDK.eCIT_Both'
        if nbPoints is None:
            nbPoints = '128'
        if thresholdIntensity is None:
            thresholdIntensity = '1'
        text += 'thresholdIntensity = PyIPSDK.createAccumIntensityThreshold(' + str(thresholdIntensity) + ',0.3)\n'
        if ratioTooCloseCircles is None:
            ratioTooCloseCircles = '0.3'
        text += 'ratioTooCloseCircles = PyIPSDK.createEnabledRemoveTooCloseCirclesParams(' + str(ratioTooCloseCircles)+')\n'

        text += outImage + '= fd.houghCircles2d(' + image + ', circleRadiusRange,'+circlesType+',' + str(nbPoints) + ', thresholdIntensity,ratioTooCloseCircles)\n'

    text += outImage + '= PyIPSDK.toPyDict('+outImage+')["Coll"]\n'
    if nbCircles is not None:
        text+= outImage +'='+outImage+'[:'+str(nbCircles)+']\n'

    text += "output = Measure()\n"
    text += 'output.value = ' + outImage + '\n'
    text += "output.subType = 'HoughCircles2d'\n"


    text = addToText(text, "outputs = output", process)

    return text

def houghSpheres3d(xmlFunctionCall, outImage="circles", process=True):

    outImage = "circles"
    parameters = xmlToParamList(xmlFunctionCall)
    image, radMin, radMax, circlesType, nbPoints, thresholdIntensity, ratioTooCloseCircles, nbCircles = parameters

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text = addToText(text, '###from UsefullWidgets import Measure\n', not process)

    text += 'circleRadiusRange = PyIPSDK.createHoughCirclesRadiusRange(' + str(radMin) + ', ' + str(radMax) + ')\n'

    if nbPoints is None and thresholdIntensity is None and ratioTooCloseCircles is None and nbCircles is None:
        text+= outImage +'= fd.houghSpheres3d('+image+', circleRadiusRange, '+circlesType +')\n'
    else:
        if nbPoints is None and thresholdIntensity is None and ratioTooCloseCircles is None:
            text += outImage + '= fd.houghSpheres3d(' + image + ', circleRadiusRange, ' + circlesType + ',' + str(nbCircles) +')\n'
        else:
            if circlesType is None:
                circlesType = 'PyIPSDK.eCIT_Both'
            if nbPoints is None:
                nbPoints = '128'
            if thresholdIntensity is None:
                thresholdIntensity = '1'
            text += 'thresholdIntensity = PyIPSDK.createAccumIntensityThreshold(' + str(thresholdIntensity) + ',0.3)\n'
            if ratioTooCloseCircles is None:
                ratioTooCloseCircles = '0.3'
            text += 'ratioTooCloseCircles = PyIPSDK.createEnabledRemoveTooCloseCirclesParams(' + str(ratioTooCloseCircles)+')\n'
            if nbCircles is None:
                text += outImage + '= fd.houghSpheres3d(' + image + ', circleRadiusRange,'+circlesType+',' + str(nbPoints) + ', thresholdIntensity,ratioTooCloseCircles)\n'
            else:
                text += outImage + '= fd.houghSpheres3d(' + image + ', circleRadiusRange,'+circlesType+',' + str(nbCircles) + ',' + str(nbPoints) + ', thresholdIntensity,ratioTooCloseCircles)\n'

    # text += outImage + '= PyIPSDK.toPyDict('+outImage+')["Coll"]\n'
    # if nbCircles is not None:
    #     text+= outImage +'='+outImage+'[:'+str(nbCircles)+']\n'

    text += "output = Measure()\n"
    text += 'output.value = ' + outImage + '\n'
    text += "output.subType = 'HoughSpheres3d'\n"


    text = addToText(text, "outputs = output", process)

    return text

def houghSpheres3dLabelImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    spheres, image = parameters

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)

    text += outImage + ' = fd.houghSpheres3dLabelImg(' + spheres + '.value, ' + image + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text



# def _houghCircles2d(xmlFunctionCall, outImage="circles", process=True):
#
#     outImage = "circles"
#     parameters = xmlToParamList(xmlFunctionCall)
#     image, radMin, radMax, thresholdIntensity, ratioTooCloseCircles, nbCircles = parameters
#     # if nbCircles is None:
#     #     nbCircles = str(100)
#     text = ''
#     text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
#     text = addToText(text, '###from UsefullWidgets import Measure\n', not process)
#     text += 'circleRadiusRange = PyIPSDK.createHoughCirclesRadiusRange(' + str(radMin) + ', ' + str(radMax) + ')\n'
#     text += """{outImage} = fd.houghCircles2d({image}, circleRadiusRange)
# {outImage} = PyIPSDK.toPyDict({outImage})["Coll"]
# """.format(image=image, outImage=outImage)
#     if thresholdIntensity is not None:
#         if nbCircles is not None:
#             text += """outList = []
# i = 0
# while (i< min({nbCircles},len({outImage})) and {outImage}[i]["AccumIntensity"] >= {thresholdIntensity}):
# \toutList.append({outImage}[i])
# \ti += 1
# {outImage} = outList
# """.format(outImage=outImage, thresholdIntensity=thresholdIntensity,nbCircles=nbCircles)
#         else:
#             text += """outList = []
# i = 0
# while (i< len({outImage}) and {outImage}[i]["AccumIntensity"] >= {thresholdIntensity}):
# \toutList.append({outImage}[i])
# \ti += 1
# {outImage} = outList
# """.format(outImage=outImage, thresholdIntensity=thresholdIntensity, nbCircles=nbCircles)
#
#
#     if ratioTooCloseCircles is not None:
#         text += """listToRemove = []
# for i in range(len({outImage})):
# \tif i not in listToRemove:
# \t\tfor j in range(i + 1, len({outImage})):
# \t\t\tif j not in listToRemove:
# \t\t\t\tdist = np.sqrt(({outImage}[i]["X"] - {outImage}[j]["X"]) ** 2 + ({outImage}[i]["Y"] - {outImage}[j]["Y"]) ** 2)
# \t\t\t\tif dist < max({outImage}[i]["Radius"], {outImage}[j]["Radius"]) + ({ratioTooCloseCircles} - 1) * min({outImage}[i]["Radius"], {outImage}[j]["Radius"]):
# \t\t\t\t\t# Distance between centers of c1 and c2 < max(r1, r2) - min(r1, r2) + {ratioTooCloseCircles} * min(r1, r2)
# \t\t\t\t\tlistToRemove.append(j)
# outList = []
# for i in range(len({outImage})):
# \tif i not in listToRemove:
# \t\toutList.append({outImage}[i])
# {outImage} = outList
# """.format(outImage=outImage, ratioTooCloseCircles=ratioTooCloseCircles)
#
#     if nbCircles is not None:
#         text += """if len({outImage}) > {nbCircles}:
# \t{outImage} = {outImage}[:{nbCircles}]
# """.format(outImage=outImage, nbCircles=nbCircles)
#
#     text += "output = Measure()\n"
#     text += 'output.value = ' + outImage + '\n'
#     text += "output.subType = 'HoughCircles'\n"
#
#     # text = addToText(text, "outputs = Measure()\n", process)
#     # text = addToText(text, 'outputs.value = ' + outImage + '\n', process)
#     # text = addToText(text, "outputs.subType = 'HoughCircles'", process)
#
#     text = addToText(text, "outputs = output", process)
#
#     return text
#
#
# def houghCircles2dImg(xmlFunctionCall, outImage="outImage", process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     imageX, imageY, radMin, radMax = parameters
#     text = ''
#     text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
#     text += 'circleRadiusRange = PyIPSDK.createHoughCirclesRadiusRange(' + str(radMin) + ', ' + str(radMax) + ')\n'
#     text += outImage + ' = fd.houghCircles2dImg(' + imageX + ', ' + imageY + ', circleRadiusRange)\n'
#     text = addToText(text, "outputs = " + outImage, process)
#     return text
#
#
# def houghCirclesPhaseCoded2dImg(xmlFunctionCall, outImage=("outRealImage", "outImaginaryImage"), process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     imageX, imageY, radMin, radMax = parameters
#     text = ''
#     text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
#     text += 'circleRadiusRange = PyIPSDK.createHoughCirclesRadiusRange(' + str(radMin) + ', ' + str(radMax) + ')\n'
#     text += outImage[0] + ', ' + outImage[1] + ' = fd.houghCirclesPhaseCoded2dImg(' + imageX + ', ' + imageY + ', circleRadiusRange)\n'
#     text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
#     return text


def houghLines2d(xmlFunctionCall, outImage="lines", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, thetaMin, thetaMax, intensityMin, accThreshold, localMaxSearchWindowStatus = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text += """houghLinesImgParams = PyIPSDK.createHoughLinesImgParams({rhoStep}, PyIPSDK.createEvenlySpacedRange({thetaMin}, {thetaMax}, {thetaBins}), {intensityMin})
""".format(rhoStep=1.0, thetaMin=thetaMin, thetaMax=thetaMax, thetaBins=180, intensityMin=intensityMin)
    text += """houghLinesExtractionParams = PyIPSDK.createHoughLinesExtractionParams(PyIPSDK.eHoughAccumThresholdType.eHATT_MaxRatio, {accThreshold}, {localMaxSearchWindowStatus})
""".format(accThreshold=accThreshold, localMaxSearchWindowStatus=localMaxSearchWindowStatus)
    text += outImage + ', _ = fd.houghLines2d(' + image + ', ' + 'houghLinesImgParams, houghLinesExtractionParams)\n'
    text += outImage + ' = PyIPSDK.toPyDict(' + outImage + ')["Coll"]\n'
    text = addToText(text, "outputs = Measure()\n", process)
    text = addToText(text, 'outputs.value = ' + outImage + '\n', process)
    text = addToText(text, "outputs.subType = 'HoughLines'\n", process)
    return text


def houghLines2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, thetaMin, thetaMax, intensityMin = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLFeatureDetection as fd\n", not process)
    text += """houghLinesImgParams = PyIPSDK.createHoughLinesImgParams({rhoStep}, PyIPSDK.createEvenlySpacedRange({thetaMin}, {thetaMax}, {thetaBins}), {intensityMin})
""".format(rhoStep=1.0, thetaMin=thetaMin, thetaMax=thetaMax, thetaBins=180, intensityMin=intensityMin)
    text += outImage + ' = fd.houghLines2dImg(' + image + ', ' + 'houghLinesImgParams)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text