import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

import UsefullVariables as vrb
import UsefullFunctions as fct
import DatabaseFunction as Dfct

from processFunction._ProcessFunction import xmlToParamList, addToText


def lightnessImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, method = parameters[0],parameters[1]
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLColor as color\n", not process)
    text += outImage + ' = color.lightnessImg(' + image + ',' + method + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def colorConvertImg(xmlFunctionCall, outImage=("outImage1", "outImage2", "outImage3"), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, colorSpace = parameters

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLColor as color\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)
    text += 'convertedImage = color.colorConvertImg(' + image + ', ' + colorSpace + ')\n'

    if sizeT == "1":
        if sizeZ == "1":
            text += outImage[0] + "= PyIPSDK.extractPlan(0, 0, 0, convertedImage)\n"
            text += outImage[1] + "= PyIPSDK.extractPlan(0, 1, 0, convertedImage)\n"
            text += outImage[2] + "= PyIPSDK.extractPlan(0, 2, 0, convertedImage)\n"
        else:
            text += outImage[0] + "= PyIPSDK.extractVolume(0, 0, convertedImage)\n"
            text += outImage[1] + "= PyIPSDK.extractVolume(1, 0, convertedImage)\n"
            text += outImage[2] + "= PyIPSDK.extractVolume(2, 0, convertedImage)\n"
    else:
        if sizeZ == "1":
            text += outImage[0] + "= PyIPSDK.extractTemporal(0, 0, convertedImage)\n"
            text += outImage[1] + "= PyIPSDK.extractTemporal(0, 1, convertedImage)\n"
            text += outImage[2] + "= PyIPSDK.extractTemporal(0, 2, convertedImage)\n"
        else:
            text += outImage[0] + "= PyIPSDK.extractTemporalVolume(0, convertedImage)\n"
            text += outImage[1] + "= PyIPSDK.extractTemporalVolume(1, convertedImage)\n"
            text += outImage[2] + "= PyIPSDK.extractTemporalVolume(2, convertedImage)\n"

    text += outImage[0] + " = util.copyImg("+outImage[0]+")\n"
    text += outImage[1] + " = util.copyImg("+outImage[1]+")\n"
    text += outImage[2] + " = util.copyImg("+outImage[2]+")\n"

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + "]", process)

    return text


def splitChannelsImg(xmlFunctionCall, outImage=("outImage1", "outImage2", "outImage3"), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLColor as color\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)

    if sizeT == "1":
        if sizeZ == "1":
            text += outImage[0] + "= PyIPSDK.extractPlan(0, 0, 0, "+image+")\n"
            text += outImage[1] + "= PyIPSDK.extractPlan(0, 1, 0, "+image+")\n"
            text += outImage[2] + "= PyIPSDK.extractPlan(0, 2, 0, "+image+")\n"
        else:
            text += outImage[0] + "= PyIPSDK.extractVolume(0, 0, "+image+")\n"
            text += outImage[1] + "= PyIPSDK.extractVolume(1, 0, "+image+")\n"
            text += outImage[2] + "= PyIPSDK.extractVolume(2, 0, "+image+")\n"
    else:
        if sizeZ == "1":
            text += outImage[0] + "= PyIPSDK.extractTemporal(0, 0, "+image+")\n"
            text += outImage[1] + "= PyIPSDK.extractTemporal(0, 1, "+image+")\n"
            text += outImage[2] + "= PyIPSDK.extractTemporal(0, 2, "+image+")\n"
        else:
            text += outImage[0] + "= PyIPSDK.extractTemporalVolume(0, "+image+")\n"
            text += outImage[1] + "= PyIPSDK.extractTemporalVolume(1, "+image+")\n"
            text += outImage[2] + "= PyIPSDK.extractTemporalVolume(2, "+image+")\n"

    text += outImage[0] + " = util.copyImg("+outImage[0]+")\n"
    text += outImage[1] + " = util.copyImg("+outImage[1]+")\n"
    text += outImage[2] + " = util.copyImg("+outImage[2]+")\n"

    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + "]", process)

    return text

def mergeChannelsImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image0, image1, image2 = parameters

    numID = fct.getNumId(image0)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)

    text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
    text += "colorGeometry.init(PyIPSDK.eCGT_Rgb)\n"
    text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"
    if sizeZ == "1":
        text += "volumeGeometry.init2d()\n"
    else:
        text += "volumeGeometry.init3d(" + image0 + ".getSizeZ())\n"
    text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
    if sizeT  == "1":
        text += "temporalGeometry.initSingle()\n"
    else:
        text += "temporalGeometry.initSequence(" + image0 + ".getSizeT())\n"

    text += "geometry = PyIPSDK.geometry(" + image0 + ".getBufferType(), " + image0 + ".getSizeX(), "+ image0 + ".getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)\n"
    text += outImage + " = PyIPSDK.createImage(geometry)\n"

    text += "images = ["+image0+","+image1+","+image2+"]\n"
    text += "for c in range(3):\n"
    if sizeT == "1":
        if sizeZ == "1":
            text+= "\tplan = PyIPSDK.extractPlan(0, c, 0, "+outImage+")\n"
            text+= "\tutil.copyImg(images[c], plan)\n"
        else:
            text+= "\tvolume = PyIPSDK.extractVolume(c, 0, "+outImage+")\n"
            text += "\tutil.copyImg(images[c], volume)\n"
    else:
        if sizeZ == "1":
            text+= "\ttemporal = PyIPSDK.extractTemporal(0, c, "+outImage+")\n"
            text+= "\tutil.copyImg(images[c], temporal)\n"
        else:
            text+= "\ttemporalVolume = PyIPSDK.extractTemporalVolume(c, "+outImage+")\n"
            text += "\tutil.copyImg(images[c], temporalVolume)\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def splitByPCAImg(xmlFunctionCall, outImage=("outImage0", "outImage1", "outImage2"), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)
    text += 'imagePCA, eigenValues, eigenVectors, matrixRank = classif.pcaReductionImg(' + image + ')\n'
    if sizeZ == "1":
        text += outImage[0] + ' = util.copyImg(PyIPSDK.extractPlan(0, 0, 0, imagePCA))\n'
        text += outImage[1] + ' = util.copyImg(PyIPSDK.extractPlan(0, 0, 1, imagePCA))\n'
        text += outImage[2] + ' = util.copyImg(PyIPSDK.extractPlan(0, 0, 2, imagePCA))\n'
    else:
        text += outImage[0] + ' = util.copyImg(PyIPSDK.extractVolume(0, 0, imagePCA))\n'
        text += outImage[1] + ' = util.copyImg(PyIPSDK.extractVolume(0, 1, imagePCA))\n'
        text += outImage[2] + ' = util.copyImg(PyIPSDK.extractVolume(0, 2, imagePCA))\n'
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ', ' + outImage[2] + ']', process)
    return text

def appendColorChannelImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1,image2 = parameters[0],parameters[1]

    numID = fct.getNumId(image1)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ""
    text = addToText(text, "###import PyIPSDK\n", not process)

    text += "colorGeometry = PyIPSDK.ColorGeometry()\n"
    text += "colorGeometry.initUser("+image1+".getSizeC()+"+image2+".getSizeC())\n"
    text += "volumeGeometry = PyIPSDK.VolumeGeometry()\n"

    if sizeZ == "1":
        text += "volumeGeometry.init2d()\n"
    else:
        text += "volumeGeometry.init3d("+image1+".getSizeZ())\n"
    text += "temporalGeometry = PyIPSDK.TemporalGeometry()\n"
    if sizeT  == "1":
        text += "temporalGeometry.initSingle()\n"
    else:
        text += "temporalGeometry.initSequence(" + image1 + ".getSizeT())\n"

    text += "geometry = PyIPSDK.geometry("+image1+".getBufferType(),"+image1+".getSizeX(),"+image1+".getSizeY(), volumeGeometry, colorGeometry, temporalGeometry)\n"
    text += outImage + "=PyIPSDK.createImage(geometry)\n"
    text += "util.eraseImg("+outImage+",0)\n"

    text+= "idx=0\n"
    if sizeT == "1":
        if sizeZ == "1":
            text += "for c in range("+image1+".getSizeC()):\n"
            text += "\tplan = PyIPSDK.extractPlan(0, idx, 0, "+outImage+")\n"
            text += "\tnewPlan = PyIPSDK.extractPlan(0, c, 0, "+image1+")\n"
            text += "\tnewPlan = util.convertImg(newPlan,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newPlan,plan)\n"
            text += "\tidx+=1\n"
            text += "for c in range("+image2+".getSizeC()):\n"
            text += "\tplan = PyIPSDK.extractPlan(0, idx, 0, "+outImage+")\n"
            text += "\tnewPlan = PyIPSDK.extractPlan(0, c, 0, "+image2+")\n"
            text += "\tnewPlan = util.convertImg(newPlan,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newPlan,plan)\n"
            text += "\tidx+=1\n"
        else:
            text += "for c in range("+image1+".getSizeC()):\n"
            text += "\tvolume = PyIPSDK.extractVolume(idx, 0, "+outImage+")\n"
            text += "\tnewVolume = PyIPSDK.extractVolume( c, 0, "+image1+")\n"
            text += "\tnewVolume = util.convertImg(newVolume,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newVolume,volume)\n"
            text += "\tidx+=1\n"
            text += "for c in range("+image2+".getSizeC()):\n"
            text += "\tvolume = PyIPSDK.extractVolume(idx, 0, "+outImage+")\n"
            text += "\tnewVolume = PyIPSDK.extractVolume( c, 0, "+image2+")\n"
            text += "\tnewVolume = util.convertImg(newVolume,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newVolume,volume)\n"
            text += "\tidx+=1\n"
    else:
        if sizeZ == "1":
            text += "for c in range("+image1+".getSizeC()):\n"
            text += "\ttemporal = PyIPSDK.extractTemporal(0, idx, "+outImage+")\n"
            text += "\tnewTemporal = PyIPSDK.extractTemporal(0, c, "+image1+")\n"
            text += "\tnewTemporal = util.convertImg(newTemporal,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newTemporal,temporal)\n"
            text += "\tidx+=1\n"
            text += "for c in range("+image2+".getSizeC()):\n"
            text += "\ttemporal = PyIPSDK.extractTemporal(0, idx, "+outImage+")\n"
            text += "\tnewTemporal = PyIPSDK.extractTemporal(0, c, "+image2+")\n"
            text += "\tnewTemporal = util.convertImg(newTemporal,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newTemporal,temporal)\n"
            text += "\tidx+=1\n"
        else:
            text += "for c in range("+image1+".getSizeC()):\n"
            text += "\ttemporalVolume = PyIPSDK.extractTemporalVolume(idx, 0, "+outImage+")\n"
            text += "\tnewTemporalVolume = PyIPSDK.extractTemporalVolume( c, 0, "+image1+")\n"
            text += "\tnewTemporalVolume = util.convertImg(newTemporalVolume,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newTemporalVolume,temporalVolume)\n"
            text += "\tidx+=1\n"
            text += "for c in range("+image2+".getSizeC()):\n"
            text += "\ttemporalVolume = PyIPSDK.extractTemporalVolume(idx, 0, "+outImage+")\n"
            text += "\tnewTemporalVolume = PyIPSDK.extractTemporalVolume( c, 0, "+image2+")\n"
            text += "\tnewTemporalVolume = util.convertImg(newTemporalVolume,"+outImage+".getBufferType())\n"
            text += "\tutil.copyImg(newTemporalVolume,temporalVolume)\n"
            text += "\tidx+=1\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def extractChannel(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,cValue = parameters[0],parameters[1]

    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            sizeZ = Dfct.childText(child, "Z")
            sizeT = Dfct.childText(child, "T")

    text = ""
    text = addToText(text, "###import PyIPSDK\n", not process)
    text += "###import PyIPSDK.IPSDKIPLUtility as util\n"

    text += ""

    if sizeT == "1":
        if sizeZ == "1":
            text += outImage + "=PyIPSDK.extractPlan(0,"+str(cValue)+", 0," + image + ")\n"
        else:
            text += outImage + "=PyIPSDK.extractVolume("+str(cValue)+", 0," + image + ")\n"
    else:
        if sizeZ == "1":
            text += outImage + "=PyIPSDK.extractTemporal(0,"+str(cValue)+"," + image + ")\n"
        else:
            text += outImage + "=PyIPSDK.extractTemporalVolume("+str(cValue)+"," + image + ")\n"
    text += outImage + "=util.copyImg("+outImage+")\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text



