import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

from processFunction._ProcessFunction import xmlToParamList, addToText
from UsefullWidgets import Measure


def kernelKMeansImg(xmlFunctionCall, outImage=("classImage", 'centroids'), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbClusters, nbSamples = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    # text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text += outImage[0] + ', ' + outImage[1] + ' = classif.kernelKMeansImg(' + image + ', ' + str(nbClusters) + ', ' + str(nbSamples) + ')\n'
    # text += outImage[1] + ' = util.convertImg(' + outImage[1] + ', PyIPSDK.eIBT_Label16)\n'
    text = addToText(text, outImage[1] + ".subType = 'KKMeansCentroids'\n", process)
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + ']', process)
    return text


def kernelKMeansAssignImg(xmlFunctionCall, outImage='classImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, centroids = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    text += outImage + ' = classif.kernelKMeansAssignImg(' + image + ', ' + centroids + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

#à reprendre
# def kMeansImg(xmlFunctionCall, outImage=("classImage", 'centroids'), process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     image, nbCluster, nbAttempts, nbMaxIterPerAttempt, centerShiftTol, maskImage = parameters
#     text = ''
#     text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
#     # text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
#     text = addToText(text, "###import PyIPSDK\n", not process)
#
#     if nbAttempts is None and nbMaxIterPerAttempt is None and centerShiftTol is None and maskImage is None:
#         text += outImage[0] + "," + outImage[1] + ",_ " +" = classif.kMeansImg("+image+", "+str(nbCluster)+")\n"
#     else:
#         if nbAttempts is None and nbMaxIterPerAttempt is None and centerShiftTol is None:
#             text += outImage[0] + "," + outImage[1] + ",_ " + " = classif.kMeansImg(" + image + ", " + maskImage + ", " + str(nbCluster) + ")\n"
#         else:
#             if nbAttempts is None:
#                 nbAttempts = 3
#             if nbMaxIterPerAttempt is None:
#                 nbMaxIterPerAttempt = 10
#             if centerShiftTol is None:
#                 centerShiftTol = 0.0001
#             if nbCluster <= 255:
#                 buffer = "PyIPSDK.eIBT_UInt8"
#             elif nbCluster <= 65535:
#                 buffer = "PyIPSDK.eIBT_UInt16"
#             else:
#                 buffer = "PyIPSDK.eIBT_UInt32"
#
#             text += outImage[0] + " = PyIPSDK.createImage(" + image + "," + buffer + ")\n"
#             if maskImage is None:
#                 text += outImage[1] + ",_ = classif.kMeansImg(" + image + ", " + str(nbCluster) + ", " + str(nbAttempts) + "," + str(nbMaxIterPerAttempt) + "," + str(centerShiftTol) + "," + outImage[0] +")\n"
#             else:
#                 text += outImage[1] + ",_ = classif.kMeansImg(" + image + "," + maskImage + ", " + str(nbCluster) + ", " + str(nbAttempts) + "," + str(nbMaxIterPerAttempt) + "," + str(centerShiftTol) + "," + outImage[0] + ")\n"
#     text = addToText(text, outImage[1] + ".subType = 'ClusterCenter'\n", process)
#     text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + "]", process)
#     return text


def kMeansImg(xmlFunctionCall, outImage=("classImage", 'centroids'), process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbCluster, nbAttempts, nbMaxIterPerAttempt, centerShiftTol, maskImage = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLColor as color\n", not process)
    # text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text = addToText(text, "###import PyIPSDK\n", not process)

    if nbAttempts is None:
        nbAttempts = 3
    if nbMaxIterPerAttempt is None:
        nbMaxIterPerAttempt = 10
    if centerShiftTol is None:
        centerShiftTol = 0.0001
    if nbCluster <= 255:
        buffer = "PyIPSDK.eIBT_UInt8"
    elif nbCluster <= 65535:
        buffer = "PyIPSDK.eIBT_UInt16"
    else:
        buffer = "PyIPSDK.eIBT_UInt32"

    text += outImage[0] + " = PyIPSDK.createImage(" + image + "," + buffer + ")\n"
    text += "if "+outImage[0] + ".getSizeC()==3:\n"
    text += "\t"+outImage[0] + "= color.lightnessImg("+outImage[0] + ")\n"
    if maskImage is None:
        text += "_,"+outImage[1]+",_ = classif.kMeansImg(" + image + ", " + str(nbCluster) + ", " + str(nbAttempts) + "," + str(nbMaxIterPerAttempt) + "," + str(centerShiftTol) + "," + outImage[0] +")\n"
    else:
        text += "_,"+outImage[1]+",_ = classif.kMeansImg(" + image + "," + maskImage + ", " + str(nbCluster) + ", " + str(nbAttempts) + "," + str(nbMaxIterPerAttempt) + "," + str(centerShiftTol) + "," + outImage[0] + ")\n"

    text = addToText(text, outImage[1] + ".subType = 'ClusterCenter'\n", process)
    text = addToText(text, "outputs = [" + outImage[0] + ', ' + outImage[1] + "]", process)
    return text


def kMeansAssignImg(xmlFunctionCall, outImage='classImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, maskImage, centroids = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    # text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    if maskImage is None:
        text += outImage + ' = classif.kMeansAssignImg(' + image + ', ' + centroids + ')\n'
    else:
        text += outImage + ' = classif.kMeansAssignImg(' + image + ', ' + maskImage + ', ' + centroids + ')\n'
    # text += outImage + ' = util.convertImg(' + outImage + ', PyIPSDK.eIBT_Label16)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def kMeansComputeCenters(xmlFunctionCall, outImage='centroids', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, classImage, maskImage = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    if maskImage is None:
        text += outImage + ' = classif.kMeansComputeCenters(' + image + ', ' + classImage + ')\n'
    else:
        text += outImage + ' = classif.kMeansComputeCenters(' + image + ', ' + classImage + ', ' + maskImage + ')\n'

    text = addToText(text, outImage + ".subType = 'ClusterCenter'\n", process)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def kMeansPosterizeImg(xmlFunctionCall, outImage='outImage', process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, classImage, centroids = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
    text += outImage + ' = classif.kMeansPosterizeImg(' + image + ', ' + classImage + ', ' + centroids + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

# def kMeansPosterizeImg(xmlFunctionCall, outImage='outImage', process=True):
#     parameters = xmlToParamList(xmlFunctionCall)
#     image, classImage, maskImage, centroids = parameters
#     text = ''
#     text = addToText(text, "###import PyIPSDK.IPSDKIPLClassification as classif\n", not process)
#     if maskImage is None:
#         text += outImage + ' = classif.kMeansPosterizeImg(' + image + ', ' + classImage + ', ' + centroids + ')\n'
#     else:
#         text += outImage + ' = classif.kMeansPosterizeImg(' + image + ', ' + classImage + ', ' + maskImage + ', ' + centroids + ')\n'
#     text = addToText(text, "outputs = " + outImage, process)
#     return text