import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

from processFunction._ProcessFunction import xmlToParamList, addToText
from UsefullWidgets import Measure


def adaptiveThreshold2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, choice, type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if choice[0] == 'Gaussian':
        text += outImage + ' = bin.adaptiveThresholdGaussian2dImg(' + image + ', ' + str(choice[1]) + ')\n'
    elif choice[0] == 'Kernel':
        text += 'kernel = ' + choice[1]
        text += outImage + ' = bin.adaptiveThreshold2dImg(' + image + ', kernel)\n'
    else:
        print('ERROR: Gaussian or Kernel are expected')
    if type == 'Dark':
        text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
        text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def adaptiveThreshold3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, choice, type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if choice[0] == 'Gaussian':
        text += outImage + ' = bin.adaptiveThresholdGaussian3dImg(' + image + ', ' + str(choice[1]) + ')\n'
    elif choice[0] == 'Kernel':
        print('ERROR: not yet implemented', file=sys.stderr)
    else:
        print('ERROR: Gaussian or Kernel are expected', file=sys.stderr)
    if type == 'Dark':
        text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
        text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def adaptiveThresholdMean2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKsize, type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    text += outImage + ' = bin.adaptiveThresholdMean2dImg(' + image + ', ' + str(halfKsize) + ')\n'
    if type == 'Dark':
        text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
        text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def adaptiveThresholdMean3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, halfKsize, type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    text += outImage + ' = bin.adaptiveThresholdMean3dImg(' + image + ', ' + str(halfKsize) + ')\n'
    if type == 'Dark':
        text = addToText(text, "###import PyIPSDK.IPSDKIPLLogical as logic\n", not process)
        text += outImage + ' = logic.logicalNotImg(' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def hysteresisThreshold2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    bounds = parameters[1]
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if bounds[0] == "Light":
        text += outImage + ' = bin.lightHysteresisThreshold2dImg(' + image + ', ' + str(bounds[2]) + ', ' + str(bounds[1]) + ')\n'
    if bounds[0] == "Dark":
        text += outImage + ' = bin.darkHysteresisThreshold2dImg(' + image + ', ' + str(bounds[1]) + ', ' + str(bounds[2]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def hysteresisThreshold3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    bounds = parameters[1]
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if bounds[0] == "Light":
        text += outImage + ' = bin.lightHysteresisThreshold3dImg(' + image + ', ' + str(bounds[2]) + ', ' + str(bounds[1]) + ')\n'
    if bounds[0] == "Dark":
        text += outImage + ' = bin.darkHysteresisThreshold3dImg(' + image + ', ' + str(bounds[1]) + ', ' + str(bounds[2]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def isoDataThresholdImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image,type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if type == 'Light':
        text += outImage + ',isoDataValue = bin.isoDataThresholdImg(' + image + ')\n'
    else:
        text += ' isoDataValue= bin.isoDataThreshold(' + image + ')\n'
        text += outImage + ' = bin.darkThresholdImg(' + image + ',isoDataValue)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def kapurThresholdImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, histogram,type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if type == 'Light':
        if histogram is None:
            text += outImage + ',kapurValue = bin.kapurThresholdImg(' + image + ')\n'
        else:
            text += outImage + ',kapurValue = bin.kapurThresholdImg(' + image + ', ' + histogram + ')\n'
    else:
        if histogram is None:
            text += 'kapurValue = bin.kapurThreshold(' + image + ')\n'
        else:
            text += 'kapurValue = bin.kapurThreshold(' + image + ', ' + histogram + ')\n'
        text += outImage +  ' = bin.darkThresholdImg(' + image + ',kapurValue)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def kittlerThresholdImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, histogram,type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if type == 'Light':
        if histogram is None:
            text += outImage + ',kittlerValue = bin.kittlerThresholdImg(' + image + ')\n'
        else:
            text += outImage + ',kittlerValue = bin.kittlerThresholdImg(' + image + ', ' + histogram + ')\n'
    else:
        if histogram is None:
            text += 'kittlerValue = bin.kittlerThreshold(' + image + ')\n'
        else:
            text += 'kittlerValue = bin.kittlerThreshold(' + image + ', ' + histogram + ')\n'
        text += outImage +  ' = bin.darkThresholdImg(' + image + ',kittlerValue)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def otsuThresholdImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, histogram,type = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if type == 'Light':
        if histogram is None:
            text += outImage + ',otsuValue = bin.otsuThresholdImg(' + image + ')\n'
        else:
            text += outImage + ',otsuValue = bin.otsuThresholdImg(' + image + ', ' + histogram + ')\n'
    else:
        if histogram is None:
            text += 'otsuValue = bin.otsuThreshold(' + image + ')\n'
        else:
            text += 'otsuValue = bin.otsuThreshold(' + image + ', ' + histogram + ')\n'
        text += outImage +  ' = bin.darkThresholdImg(' + image + ',otsuValue)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def thresholdImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    bounds = parameters[1]
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    if bounds[0] is None:
        text += outImage + ' = bin.darkThresholdImg(' + image + ', ' + str(bounds[1]) + ')\n'
    elif bounds[1] is None:
        text += outImage + ' = bin.lightThresholdImg(' + image + ', ' + str(bounds[0]) + ')\n'
    else:
        text += outImage + ' = bin.thresholdImg(' + image + ', ' + str(bounds[0]) + ', ' + str(bounds[1]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def topHat2d(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, structuringElem, topType, threshold = parameters
    threshold = str(threshold)
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    text += structuringElem[0]
    if topType == 'Light':
        text += outImage + ' = bin.lightTopHat2dImg(' + image + ', ' + structuringElem[1] + ', ' + threshold + ')\n'
    elif topType == 'Dark':
        text += outImage + ' = bin.darkTopHat2dImg(' + image + ', ' + structuringElem[1] + ', ' + threshold + ')\n'
    else:
        print('ERROR: Light or Dark are expected', file=sys.stderr)

    text = addToText(text, "outputs = " + outImage, process)
    return text

def topHat3d(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, structuringElem, topType, threshold = parameters
    threshold = str(threshold)
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBinarization as bin\n", not process)
    text += structuringElem[0]
    if topType == 'Light':
        text += outImage + ' = bin.lightTopHat3dImg(' + image + ', ' + structuringElem[1] + ', ' + threshold + ')\n'
    elif topType == 'Dark':
        text += outImage + ' = bin.darkTopHat3dImg(' + image + ', ' + structuringElem[1] + ', ' + threshold + ')\n'
    else:
        print('ERROR: Light or Dark are expected', file=sys.stderr)

    text = addToText(text, "outputs = " + outImage, process)
    return text