import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

import DatabaseFunction as Dfct
import UsefullFunctions as fct
from processFunction._ProcessFunction import xmlToParamList, addToText


def typicalBasicMorphologyFunction(functionName, xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    #image, structuringElementDef, borderPolicy = parameters
    text = ''
    if functionName in ["closing2dImg","closing3dImg","opening2dImg","opening3dImg"]:
        if parameters[2]:
            borderExtension = ",PyIPSDK.eBEP_Enable"
        else:
            borderExtension = ",PyIPSDK.eBEP_Disable"
    else:
        borderExtension = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    text += parameters[1][0]
    text += outImage + ' = morpho.' + functionName + '(' + parameters[0] + ', ' + parameters[1][1] + borderExtension + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def boundary2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, neighboorHood = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if neighboorHood is None:
        text += outImage + ' = morpho.boundary2dImg(' + image + ')\n'
    else:
        text += outImage + ' = morpho.boundary2dImg(' + image + ', ' + str(neighboorHood) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text
def boundary3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, neighboorHood = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if neighboorHood is None:
        text += outImage + ' = morpho.boundary3dImg(' + image + ')\n'
    else:
        text += outImage + ' = morpho.boundary3dImg(' + image + ', ' + str(neighboorHood) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def closing2dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('closing2dImg', xmlFunctionCall, outImage=outImage, process=process)
def closing3dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('closing3dImg', xmlFunctionCall, outImage=outImage, process=process)


def dilate2dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('dilate2dImg', xmlFunctionCall, outImage=outImage, process=process)
def dilate3dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('dilate3dImg', xmlFunctionCall, outImage=outImage, process=process)


def distanceMap2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, outputReal, maxDistance = parameters

    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if outputReal:
        text += outImage + ' = PyIPSDK.createImage(' + image + ', PyIPSDK.eIBT_Real32)\n'
        if maxDistance is None:
            text += outImage + ' = morpho.distanceMap2dImg(' + image + ' , ' + outImage+')\n'
        else:
            text += outImage + ' = morpho.distanceMap2dImg(' + image + ', ' + str(maxDistance) + ' , ' + outImage+')\n'
    else:
        if maxDistance is None:
            text += outImage + ' = morpho.distanceMap2dImg(' + image + ')\n'
        else:
            text += outImage + ' = morpho.distanceMap2dImg(' + image + ', ' + str(maxDistance) + ')\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def distanceMap3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, outputReal, maxDistance = parameters
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if outputReal:
        text += outImage + ' = PyIPSDK.createImage(' + image + ', PyIPSDK.eIBT_Real32)\n'
        if maxDistance is None:
            text += outImage + ' = morpho.distanceMap3dImg(' + image + ' , ' + outImage+')\n'
        else:
            text += outImage + ' = morpho.distanceMap3dImg(' + image + ', ' + str(maxDistance) + ' , ' + outImage+')\n'
    else:
        if maxDistance is None:
            text += outImage + ' = morpho.distanceMap3dImg(' + image + ')\n'
        else:
            text += outImage + ' = morpho.distanceMap3dImg(' + image + ', ' + str(maxDistance) + ')\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def erode2dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('erode2dImg', xmlFunctionCall, outImage=outImage, process=process)
def erode3dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('erode3dImg', xmlFunctionCall, outImage=outImage, process=process)


def morphoGradient2dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('morphoGradient2dImg', xmlFunctionCall, outImage=outImage, process=process)
def morphoGradient3dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('morphoGradient3dImg', xmlFunctionCall, outImage=outImage, process=process)


def opening2dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('opening2dImg', xmlFunctionCall, outImage=outImage, process=process)
def opening3dImg(xmlFunctionCall, outImage="outImage", process=True):
    return typicalBasicMorphologyFunction('opening3dImg', xmlFunctionCall, outImage=outImage, process=process)


def unionLinearClosing2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, radius, nbAngles, borderPolicy = parameters
    if borderPolicy:
        borderExtension = "PyIPSDK.eBEP_Enable"
    else:
        borderExtension = "PyIPSDK.eBEP_Disable"
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if nbAngles is None:
        text += outImage + ' = morpho.unionLinearClosing2dImg(' + image + ', ' + str(radius) + ',' + borderExtension +')\n'
    else:
        text += outImage + ' = morpho.unionLinearClosing2dImg(' + image + ', ' + str(radius) + ', ' + str(nbAngles) + ',' + borderExtension +')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def unionLinearClosing3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, radius, nbAngles,borderPolicy = parameters
    if borderPolicy:
        borderExtension = "PyIPSDK.eBEP_Enable"
    else:
        borderExtension = "PyIPSDK.eBEP_Disable"
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if nbAngles is None:
        text += outImage + ' = morpho.unionLinearClosing3dImg(' + image + ', ' + str(radius) +',' + borderExtension + ')\n'
    else:
        text += outImage + ' = morpho.unionLinearClosing3dImg(' + image + ', ' + str(radius) + ', ' + str(nbAngles) +',' + borderExtension + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def unionLinearOpening2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, radius, nbAngles,borderPolicy = parameters
    if borderPolicy:
        borderExtension = "PyIPSDK.eBEP_Enable"
    else:
        borderExtension = "PyIPSDK.eBEP_Disable"
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if nbAngles is None:
        text += outImage + ' = morpho.unionLinearOpening2dImg(' + image + ', ' + str(radius) +',' + borderExtension + ')\n'
    else:
        text += outImage + ' = morpho.unionLinearOpening2dImg(' + image + ', ' + str(radius) + ', ' + str(nbAngles) +',' + borderExtension + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def unionLinearOpening3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, radius, nbAngles,borderPolicy = parameters
    if borderPolicy:
        borderExtension = "PyIPSDK.eBEP_Enable"
    else:
        borderExtension = "PyIPSDK.eBEP_Disable"
    text = ''
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)
    if nbAngles is None:
        text += outImage + ' = morpho.unionLinearOpening3dImg(' + image + ', ' + str(radius) + ',' + borderExtension +  ')\n'
    else:
        text += outImage + ' = morpho.unionLinearOpening3dImg(' + image + ', ' + str(radius) + ', ' + str(nbAngles) + ',' + borderExtension + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def skeleton2dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, skeletonType = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    if skeletonType is None:
        text += outImage + ' = morpho.skeleton2dImg(' + image + ')\n'
    else:
        text += outImage + ' = morpho.skeleton2dImg(' + image + ',' + skeletonType + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def skeleton3dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, skeletonType = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    if skeletonType is None:
        text += outImage + ' = morpho.skeleton3dImg(' + image + ')\n'
    else:
        text += outImage + ' = morpho.skeleton3dImg(' + image + ',' + skeletonType + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def pruning2dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, nbMaxIter, boolValue = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    if nbMaxIter is None:
        if boolValue == False:
            text += outImage + ' = morpho.pruning2dImg(' + image + ')\n'
        else:
            text += outImage + ' = morpho.pruning2dImg_keepAll(' + image + ')\n'
    else:
        if boolValue == False:
            text += outImage + ' = morpho.pruning2dImg(' + image + ',' + str(nbMaxIter) + ')\n'
        else:
            text += outImage + ' = morpho.pruning2dImg_keepAll(' + image + ',' + str(nbMaxIter) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def pruning3dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    image, nbMaxIter, boolValue = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    if nbMaxIter is None:
        if boolValue == False:
            text += outImage + ' = morpho.pruning3dImg(' + image + ')\n'
        else:
            text += outImage + ' = morpho.pruning3dImg_keepAll(' + image + ')\n'
    else:
        if boolValue == False:
            text += outImage + ' = morpho.pruning3dImg(' + image + ',' + str(nbMaxIter) + ')\n'
        else:
            text += outImage + ' = morpho.pruning3dImg_keepAll(' + image + ',' + str(nbMaxIter) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def addMarkerImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    imageLabel, imageBinary, numLabel = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    text += outImage + ' = morpho.addMarkerImg(' + imageLabel + ',' + imageBinary + ',' + str(numLabel) + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def checkMultiphasedNeighourhood2dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    imageLabel, nbLabels, bIgnoreForeground = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    text += outImage + ' = morpho.checkMultiphasedNeighourhood2dImg(' + imageLabel + ',' + str(nbLabels) + ',' + str(bIgnoreForeground) + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def checkMultiphasedNeighourhood3dImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall, process=process)
    imageLabel, nbLabels, bIgnoreForeground = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLBasicMorphology as morpho\n", not process)

    text += outImage + ' = morpho.checkMultiphasedNeighourhood3dImg(' + imageLabel + ',' + str(nbLabels) + ',' + str(bIgnoreForeground) + ')\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text