import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import UsefullFunctions as fct
from processFunction._ProcessFunction import xmlToParamList, addToText

##################
#   Arithmetic   #
##################

def absImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    text += outImage + ' = arithm.absImg(' + parameters[0] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def addImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    text += outImage + ' = arithm.addImgImg(' + parameters[0] + ', ' + parameters[1] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text


def addScalarImg(xmlFunctionCall, outImage="outImage", process=True):

    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    if fct.isInteger(parameters[1]):
        text += outImage + ' = arithm.addScalarImg(' + parameters[0] + ', ' + str(parameters[1]) + ')\n'
    else:
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
        text += outImage + ' = util.convertImg(' + parameters[0] + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage + ' = arithm.addScalarImg('+outImage+', ' + str(parameters[1]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def subtractScalarImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    if fct.isInteger(parameters[0]):
        text += outImage + ' = arithm.subtractScalarImg(' + str(parameters[0]) + ', ' + parameters[1] + ')\n'
    else:
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
        text += outImage + ' = util.convertImg(' + parameters[1] + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage + ' = arithm.subtractScalarImg(' + str(parameters[0]), ', '+outImage+')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def blendImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    text += outImage + ' = arithm.blendImgImg(' + parameters[0] + ', ' + parameters[1] + ', ' + str(parameters[2]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def boundImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)

    text += 'range = PyIPSDK.createRange(' + str(parameters[1]) + ', ' + str(parameters[2]) + ')\n'
    text += outImage + ' = arithm.boundImg(' + parameters[0] + ', range)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def cartesianToPolarImg(xmlFunctionCall, outImage=["outImage1","outImage2"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
    text += 'convertX = util.convertImg(' + parameters[0] + ', PyIPSDK.eIBT_Real32)\n'
    text += 'convertY = util.convertImg(' + parameters[1] + ', PyIPSDK.eIBT_Real32)\n'
    text += outImage[0] + "," + outImage[1] + " = arithm.cartesianToPolarImg(convertX, convertY)\n"
    text = addToText(text, "outputs = [" + outImage[0] + ", " + outImage[1] + ']', process)
    return text


def polarToCartesianImg(xmlFunctionCall, outImage=["outImageX","outImageY"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageRho, imageTheta = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    text += outImage[0] + "," + outImage[1] + " = arithm.polarToCartesianImg(" + imageRho + ', ' + imageTheta + ")\n"
    text = addToText(text, "outputs = [" + outImage[0] + ", " + outImage[1] + ']', process)
    return text


def formula2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    imageList = parameters[0]
    formula = parameters[1]
    if formula == "":
        raise Exception('Please enter a formula')
    else:
        formula = formula.replace('"', '')
        formula = formula.replace("'", '')
        formula = '"' + formula + '"'
        nbImage = int(imageList[0])
        text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
        if nbImage == 0:
            text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
            sizeX = imageList[1]
            sizeY = imageList[2]
            bufferType = str(imageList[3])
            if imageList[4]:
                text += "image = PyIPSDK.createImageRgb(" + bufferType + ", " + str(sizeX) + ", " + str(sizeY) + ")\n"
            else:
                text += "image = PyIPSDK.createImage(" + bufferType + ", " + str(sizeX) + ", " + str(sizeY) + ")\n"
            text += outImage + ' = arithm.formula2dImg(' + formula + ', InOptImg1=image)\n'
            text += outImage + ' = util.convertImg(' + outImage + ', '+bufferType+')\n'
        elif nbImage == 1:
            text += outImage + ' = arithm.formula2dImg(' + formula + ', InOptImg1=' + imageList[1] + ')\n'
        elif nbImage == 2:
            text += outImage + ' = arithm.formula2dImg(' + formula + ', InOptImg1=' + imageList[1] + ', InOptImg2=' + imageList[2] + ')\n'
        elif nbImage == 3:
            text += outImage + ' = arithm.formula2dImg(' + formula + ', InOptImg1=' + imageList[1] + ', InOptImg2=' + imageList[2] + ', InOptImg3=' + imageList[3] + ')\n'
        text = addToText(text, "outputs = " + outImage, process)
        return text


def formula3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    imageList = parameters[0]
    formula = parameters[1]
    if formula == "":
        raise Exception('Please enter a formula')
    else:
        formula = formula.replace('"', '')
        formula = formula.replace("'", '')
        formula = '"' + formula + '"'
        nbImage = int(imageList[0])
        text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
        if nbImage == 0:
            text = addToText(text, "###import PyIPSDK\n", not process)
            sizeX = imageList[1]
            sizeY = imageList[2]
            sizeZ = imageList[3]
            bufferType = str(imageList[4])
            text += "image = PyIPSDK.createImage(" + bufferType + ", " + str(sizeX) + ", " + str(sizeY) + ", " + str(sizeZ) + ")\n"
            text += outImage + ' = arithm.formula3dImg(' + formula + ', InOptImg3d1=image)\n'
        elif nbImage == 1:
            text += outImage + ' = arithm.formula3dImg(' + formula + ', InOptImg3d1=' + imageList[1] + ')\n'
        elif nbImage == 2:
            text += outImage + ' = arithm.formula3dImg(' + formula + ', InOptImg3d1=' + imageList[1] + ', InOptImg3d2=' + imageList[2] + ')\n'
        elif nbImage == 3:
            text += outImage + ' = arithm.formula3dImg(' + formula + ', InOptImg3d1=' + imageList[1] + ', InOptImg3d2=' + imageList[2] + ', InOptImg3d3=' + imageList[3] + ')\n'
        text = addToText(text, "outputs = " + outImage, process)
    return text


def genericAddImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.genericAddImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def genericDivideImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.genericDivideImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def genericMultiplyImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.genericMultiplyImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def genericSubtractImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.genericSubtractImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def maxImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2, isAbsolute = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    if isAbsolute:
        text += outImage + ' = arithm.maxAbsImgImg(' + image1 + ', ' + image2 + ')\n'
    else:
        text += outImage + ' = arithm.maxImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def minImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.minImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def sqrtImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text = addToText(text, '######import PyIPSDK.IPSDKIPLUtility as util\n', not process)
    text += 'convertImage = util.convertImg(' + image + ', PyIPSDK.eIBT_Real32)\n'
    text += outImage + ' = arithm.sqrtImg(convertImage)\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def divideImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageNum, imageDenom = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.divideImgImg(' + imageNum + ', ' + imageDenom + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def l1Norm(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    choice = parameters[0]

    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    if choice[0] == '2':
        text += outImage + ' = arithm.l1Norm2Img(' + choice[1] + ', ' + choice[2] + ')\n'
    else:
        text += outImage + ' = arithm.l1Norm3Img(' + choice[1] + ', ' + choice[2] + ', ' + choice[3] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def l2Norm(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    choice = parameters[0]

    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    if choice[0] == '2':
        text += outImage + ' = arithm.l2Norm2Img(' + choice[1] + ', ' + choice[2] + ')\n'
    else:
        text += outImage + ' = arithm.l2Norm3Img(' + choice[1] + ', ' + choice[2] + ', ' + choice[3] + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def linearCombineImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2, coef1, coef2 = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.linearCombineImgImg(' + image1 + ', ' + image2 + ', ' + str(coef1) + ', ' + str(coef2) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def multiplyImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2= parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.multiplyImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def subtractImgImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image1, image2 = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.subtractImgImg(' + image1 + ', ' + image2 + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def multiplyAddScalarImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, factor, offset = parameters
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    if fct.isInteger(factor) and fct.isInteger(offset):
        text += outImage + ' = arithm.multiplyAddScalarImg(' + image + ', ' + str(factor) + ', ' + str(offset) + ')\n'
    else:
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
        text += outImage + ' = util.convertImg(' + parameters[0] + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage + ' = arithm.multiplyAddScalarImg(' + image + ', ' + str(factor) + ', ' + str(offset) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def multiplyScalarImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLArithmetic as arithm\n", not process)
    if fct.isInteger(parameters[1]):
        text += outImage + ' = arithm.multiplyScalarImg(' + parameters[0] + ', ' + str(parameters[1]) + ')\n'
    else:
        text = addToText(text, "###import PyIPSDK.IPSDKIPLUtility as util\n", not process)
        text += outImage + ' = util.convertImg(' + parameters[0] + ', PyIPSDK.eIBT_Real32)\n'
        text += outImage + ' = arithm.multiplyScalarImg('+outImage+', ' + str(parameters[1]) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def roundImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, bufferType = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.roundImg(' + image + ', ' + bufferType + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def squareImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image = parameters[0]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text += outImage + ' = arithm.squareImg(' + image + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text