import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation
import PyIPSDK.IPSDKIPLIntensityTransform as itrans
import PyIPSDK

import sys

from processFunction._ProcessFunction import xmlToParamList, addToText

import UsefullFunctions as fct
import DatabaseFunction as Dfct
import UsefullVariables as vrb

##################
# Adv Morphology #
##################
def binaryReconstruction2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageBin, imageBinMark, neighboorHood, optim = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if neighboorHood is None and optim is None:
        text += outImage + ' = advmorpho.binaryReconstruction2dImg(' + imageBin + ', ' + imageBinMark + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + imageBin + ')\n'
        text += 'advmorpho.binaryReconstruction2dImg(' + imageBin + ', ' + imageBinMark + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def binaryReconstruction3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageBin, imageBinMark, neighboorHood, optim = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if neighboorHood is None and optim is None:
        text += outImage + ' = advmorpho.binaryReconstruction3dImg(' + imageBin + ', ' + imageBinMark + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + imageBin + ')\n'
        text += 'advmorpho.binaryReconstruction3dImg(' + imageBin + ', ' + imageBinMark + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def connectedComponent2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorPolicy = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if neighboorPolicy is None:
        text += outImage + ' = advmorpho.connectedComponent2dImg(' + image + ')\n'
    else:
        text += outImage + ' = advmorpho.connectedComponent2dImg(' + image + ', ' + neighboorPolicy + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def connectedComponent3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorPolicy = parameters[0], parameters[1]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if neighboorPolicy is None:
        text += outImage + ' = advmorpho.connectedComponent3dImg(' + image + ')\n'
    else:
        text += outImage + ' = advmorpho.connectedComponent3dImg(' + image + ', ' + neighboorPolicy + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def dilateLocalExtrema2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, dilateFactor, extrema = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extrema == 'Maxima':
        text += outImage + ' = advmorpho.dilateLocalMaxima2dImg(' + image + ', ' + str(dilateFactor) + ')\n'
    elif extrema == 'Minima':
        text += outImage + ' = advmorpho.dilateLocalMinima2dImg(' + image + ', ' + str(dilateFactor) + ')\n'
    else:
        print('ERROR: Should have Maxima or Minima', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def dilateLocalExtrema3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, dilateFactor, extrema = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extrema == 'Maxima':
        text += outImage + ' = advmorpho.dilateLocalMaxima3dImg(' + image + ', ' + str(dilateFactor) + ')\n'
    elif extrema == 'Minima':
        text += outImage + ' = advmorpho.dilateLocalMinima3dImg(' + image + ', ' + str(dilateFactor) + ')\n'
    else:
        print('ERROR: Should have Maxima or Minima', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def fillHole2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorHood, optim = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBinarization as bin\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLLogical as logic\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)

    paramDefined = (neighboorHood is None and optim is None)
    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            bufferType = Dfct.childText(child, "BufferType")

    if bufferType == "eIBT_Binary":
        if paramDefined:
            text += outImage + ' = advmorpho.fillHole2dImg(' + image + ')\n'
        else:
            if neighboorHood is None:
                neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
            if optim is None:
                optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
            text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
            text += 'advmorpho.fillHole2dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'

    else:
        text+= 'mask = bin.lightThresholdImg('+image+', 1.0)\n'
        if paramDefined:
            text += 'maskFill = advmorpho.fillHole2dImg(mask)\n'
        else:
            if neighboorHood is None:
                neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
            if optim is None:
                optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
            text += 'maskFill = PyIPSDK.createImage(mask)\n'
            text += 'advmorpho.fillHole2dImg(mask, ' + neighboorHood + ', ' + optim + ', maskFill)\n'

        text+= 'imgHoles = logic.bitwiseSubImgImg(maskFill,mask)\n'
        text+= outImage+' = arithm.addImgImg('+image+', imgHoles)\n'
        text+= outImage+' = advmorpho.maxPropagation2dImg('+outImage+')\n'
        text+= outImage+' = util.convertImg('+outImage+','+image+'.getBufferType())\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def fillHole3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorHood, optim = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLBinarization as bin\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLLogical as logic\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)

    paramDefined = (neighboorHood is None and optim is None)
    numID = fct.getNumId(image)
    allElements = Dfct.SubElement(vrb.mainWindow.xmlElement, "AllElements")
    for child in allElements:
        if Dfct.childText(child, "ElementID") == numID:
            bufferType = Dfct.childText(child, "BufferType")

    if bufferType == "eIBT_Binary":
        if paramDefined:
            text += outImage + ' = advmorpho.fillHole3dImg(' + image + ')\n'
        else:
            if neighboorHood is None:
                neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
            if optim is None:
                optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
            text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
            text += 'advmorpho.fillHole3dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'

    else:
        text+= 'mask = bin.lightThresholdImg('+image+', 1.0)\n'
        if paramDefined:
            text += 'maskFill = advmorpho.fillHole3dImg(mask)\n'
        else:
            if neighboorHood is None:
                neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
            if optim is None:
                optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
            text += 'maskFill = PyIPSDK.createImage(mask)\n'
            text += 'advmorpho.fillHole3dImg(mask, ' + neighboorHood + ', ' + optim + ', maskFill)\n'

        text+= 'imgHoles = logic.bitwiseSubImgImg(maskFill,mask)\n'
        text+= outImage+' = arithm.addImgImg('+image+', imgHoles)\n'
        text+= outImage+' = advmorpho.maxPropagation3dImg('+outImage+')\n'
        text+= outImage+' = util.convertImg('+outImage+','+image+'.getBufferType())\n'

    text = addToText(text, "outputs = " + outImage, process)
    return text

def genericSeededDistanceMap2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageBin, imageSeed, weightX, weightY, weightXY = parameters[0], parameters[1], str(parameters[2]), str(parameters[3]), str(parameters[4])
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text += 'inDistWeight2d = PyIPSDK.createDistWeight2d(' + weightX + ', ' + weightY + ', ' + weightXY + ')\n'
    text += outImage + ' = advmorpho.genericSeededDistanceMap2dImg(' + imageBin + ', ' + imageSeed + ', inDistWeight2d)\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text


def genericSeededDistanceMap3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    imageBin, imageSeed, weightX, weightY, weightZ = parameters[0], parameters[1], str(parameters[2]), str(parameters[3]), str(parameters[4])
    weightXY, weightXZ, weightYZ, weightXYZ = str(parameters[5]), str(parameters[6]), str(parameters[7]), str(parameters[8])
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    text += 'inDistWeight3d = PyIPSDK.createDistWeight3d(' + weightX + ', ' + weightY + ', ' + weightZ + ', ' + weightXY + ', ' + weightXZ + ', ' + weightYZ + ', ' + weightXYZ + ')\n'
    text += outImage + ' = advmorpho.genericSeededDistanceMap3dImg(' + imageBin + ', ' + imageSeed + ', inDistWeight3d)\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text


def greyReconstruction2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, greyMarkImage, extremum = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extremum == 'Minimum':
        text += outImage + ' = advmorpho.greyMinReconstruction2dImg(' + image + ', ' + greyMarkImage + ')\n'
    elif extremum == 'Maximum':
        text += outImage + ' = advmorpho.greyMaxReconstruction2dImg(' + image + ', ' + greyMarkImage + ')\n'
    else:
        print('ERROR: Should have Minimum or Maximum', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def greyReconstruction3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, greyMarkImage, extremum = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extremum == 'Minimum':
        text += outImage + ' = advmorpho.greyMinReconstruction3dImg(' + image + ', ' + greyMarkImage + ')\n'
    elif extremum == 'Maximum':
        text += outImage + ' = advmorpho.greyMaxReconstruction3dImg(' + image + ', ' + greyMarkImage + ')\n'
    else:
        print('ERROR: Should have Minimum or Maximum', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def keepBigShape2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbrShapes = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text += outImage + ' = advmorpho.keepBigShape2dImg(' + image + ', ' + str(nbrShapes) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def keepBigShape3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, nbrShapes = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text += outImage + ' = advmorpho.keepBigShape3dImg(' + image + ', ' + str(nbrShapes) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def localExtrema2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, extremum = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extremum == 'Minimum':
        text += outImage + ' = advmorpho.localMinima2dImg(' + image + ')\n'
    elif extremum == 'Maximum':
        text += outImage + ' = advmorpho.localMaxima2dImg(' + image + ')\n'
    else:
        print('ERROR: Should have Minimum or Maximum', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text


def localExtrema3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, extremum = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if extremum == 'Minimum':
        text += outImage + ' = advmorpho.localMinima3dImg(' + image + ')\n'
    elif extremum == 'Maximum':
        text += outImage + ' = advmorpho.localMaxima3dImg(' + image + ')\n'
    else:
        print('ERROR: Should have Minimum or Maximum', file=sys.stderr)
    text = addToText(text, "outputs = " + outImage, process)
    return text

def extremaPropagation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, extremum, neighboorHood, optim = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if neighboorHood is None and optim is None:
        if extremum == 'Minimum':
            text += outImage + '=advmorpho.minPropagation2dImg(' + image + ')\n'
        elif extremum == 'Maximum':
            text += outImage + '=advmorpho.maxPropagation2dImg(' + image  + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        if extremum == 'Minimum':
            text += 'advmorpho.minPropagation2dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
        elif extremum == 'Maximum':
            text += 'advmorpho.maxPropagation2dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def extremaPropagation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, extremum, neighboorHood, optim = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)

    if neighboorHood is None and optim is None:
        if extremum == 'Minimum':
            text += outImage + '=advmorpho.minPropagation3dImg(' + image + ')\n'
        elif extremum == 'Maximum':
            text += outImage + '=advmorpho.maxPropagation3dImg(' + image + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        if extremum == 'Minimum':
            text += 'advmorpho.minPropagation3dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
        elif extremum == 'Maximum':
            text += 'advmorpho.maxPropagation3dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def removeBorder2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorHood, optim = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if neighboorHood is None and optim is None:
        text += outImage + ' = advmorpho.removeBorder2dImg(' + image + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += 'advmorpho.removeBorder2dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def removeBorder3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, neighboorHood, optim = parameters[0], parameters[1], parameters[2]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if neighboorHood is None and optim is None:
        text += outImage + ' = advmorpho.removeBorder3dImg(' + image + ')\n'
    else:
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
        if optim is None:
            optim = "PyIPSDK.eProcessingOptimizationPolicy.ePOP_MaximizeSpeed"
        text += outImage + ' = PyIPSDK.createImage(' + image + ')\n'
        text += 'advmorpho.removeBorder3dImg(' + image + ', ' + neighboorHood + ', ' + optim + ', ' + outImage + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def removeSmallShape2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, minSize = parameters[0], parameters[1]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if minSize is None:
        minSize = 0
    text += outImage + ' = advmorpho.removeSmallShape2dImg(' + image + ', ' + str(minSize) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def removeSmallShape3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, minSize = parameters[0], parameters[1]
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if minSize is None:
        minSize = 0
    text += outImage + ' = advmorpho.removeSmallShape3dImg(' + image + ', ' + str(minSize) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def seededDistanceMap2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, seedImage, pixelSizeX, pixelSizeY, neighboorHood, maxDistance = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if pixelSizeX is None and pixelSizeY is None and neighboorHood is None and maxDistance is None:
        text += outImage + ', _ = advmorpho.seededDistanceMap2dImg(' + image + ', ' + seedImage + ')\n'
    else:
        if pixelSizeX is None:
            pixelSizeX = 1
        if pixelSizeY is None:
            pixelSizeY = 1
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood2dType.eN2T_8Connexity"
        if maxDistance is None:
            text += outImage + ', _ = advmorpho.seededDistanceMap2dImg(' + image + ', ' + seedImage + ', ' + str(pixelSizeX) + ', ' + str(pixelSizeY) + ', ' + neighboorHood + ')\n'
        else:
            text += outImage + ', _ = advmorpho.seededDistanceMap2dImg(' + image + ', ' + seedImage + ', ' + str(pixelSizeX) + ', ' + str(pixelSizeY) + ', ' + neighboorHood + ',' + str(maxDistance) + ')\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text

def seededDistanceMap3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, seedImage, pixelSizeX, pixelSizeY, pixelSizeZ, neighboorHood, maxDistance = parameters
    text = ''
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if pixelSizeX is None and pixelSizeY is None and neighboorHood is None and maxDistance is None:
        text += outImage + ', _ = advmorpho.seededDistanceMap3dImg(' + image + ', ' + seedImage + ')\n'
    else:
        if pixelSizeX is None:
            pixelSizeX = 1
        if pixelSizeY is None:
            pixelSizeY = 1
        if pixelSizeZ is None:
            pixelSizeZ = 1
        if neighboorHood is None:
            neighboorHood = "PyIPSDK.eNeighborhood3dType.eN3T_26Connexity"
        if maxDistance is None:
            text += outImage + ', _ = advmorpho.seededDistanceMap3dImg(' + image + ', ' + seedImage + ', ' + str(pixelSizeX) + ', ' + str(pixelSizeY) + ', ' + str(pixelSizeZ) + ', ' + neighboorHood + ')\n'
        else:
            text += outImage + ', _ = advmorpho.seededDistanceMap3dImg(' + image + ', ' + seedImage + ', ' + str(pixelSizeX) + ', ' + str(pixelSizeY) + ', ' + str(pixelSizeZ) + ', ' + neighboorHood + ',' + str(maxDistance) + ')\n'

    text += outImage + ".lut = 'Magma'\n"
    text += outImage + ".background = False\n"

    text = addToText(text, "outputs = " + outImage, process)
    return text


def seededWatershed2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, labelMarkImage, mode, processingMode = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        # text += outImage + ' = advmorpho.seededWatershed2dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ')\n'
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        text += outImage + ' = advmorpho.seededWatershed2dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ', ' + str(processingMode)+ ')\n'

    else:
        text += outImage + ' = advmorpho.seededWatershed2dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ', ' + str(processingMode)+ ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def seededWatershed3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, labelMarkImage, mode, processingMode = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.seededWatershed3dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ')\n'
        text += outImage + ' = advmorpho.seededWatershed3dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ', ' + str(processingMode)+ ')\n'
    else:
        text += outImage + ' = advmorpho.seededWatershed3dImg(' + image + ', ' + labelMarkImage + ', ' + str(mode) + ', ' + str(processingMode)+ ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def watershedBinarySeparation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, dilateFactor, mode, processingMode = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.watershedBinarySeparation2dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+')\n'
        text += outImage + ' = advmorpho.watershedBinarySeparation2dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    else:
        text += outImage + ' = advmorpho.watershedBinarySeparation2dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def watershedBinarySeparation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, dilateFactor, mode, processingMode = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.watershedBinarySeparation3dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+')\n'
        text += outImage + ' = advmorpho.watershedBinarySeparation3dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'

    else:
        text += outImage + ' = advmorpho.watershedBinarySeparation3dImg(' + image + ', ' + str(dilateFactor) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def adaptiveBinaryWatershed2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, ratio, mode, processingMode = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.adaptiveBinaryWatershed2dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+')\n'
        text += outImage + ' = advmorpho.adaptiveBinaryWatershed2dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    else:
        text += outImage + ' = advmorpho.adaptiveBinaryWatershed2dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def adaptiveBinaryWatershed3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, ratio, mode, processingMode = parameters[0], parameters[1], parameters[2], parameters[3]
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.adaptiveBinaryWatershed3dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+')\n'
        text += outImage + ' = advmorpho.adaptiveBinaryWatershed3dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    else:
        text += outImage + ' = advmorpho.adaptiveBinaryWatershed3dImg(' + image + ', ' + str(ratio) + ', ' + str(mode)+', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def watershedGreySeparation2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, considerationMode, dilateFactor, mode, processingMode = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.watershedGreySeparation2dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) + ')\n'
        text += outImage + ' = advmorpho.watershedGreySeparation2dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) +', ' + str(processingMode) + ')\n'
    else:
        text += outImage + ' = advmorpho.watershedGreySeparation2dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) +', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text


def watershedGreySeparation3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, considerationMode, dilateFactor, mode, processingMode = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if processingMode is None:
        processingMode =  "PyIPSDK.eWatershedProcessingMode.eWPM_OptimizeSpeed"
        # text += outImage + ' = advmorpho.watershedGreySeparation3dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) + ')\n'
        text += outImage + ' = advmorpho.watershedGreySeparation3dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) +', ' + str(processingMode) + ')\n'
    else:
        text += outImage + ' = advmorpho.watershedGreySeparation3dImg(' + image + ', ' + considerationMode + ', ' + str(dilateFactor) + ', ' + str(mode) +', ' + str(processingMode) + ')\n'
    text = addToText(text, "outputs = " + outImage, process)
    return text

def ridgeLine2dImg(xmlFunctionCall, outImage=["outImage","outList"], process=True):

    parameters = xmlToParamList(xmlFunctionCall)

    image, mask, axis, nbIter, intensity = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)

    direction = 'PyIPSDK.ePD_Direct'

    if intensity == "Light":
        text += "imageInverted = itrans.invert2dImg("+image+")\n"
        if mask is None:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg(imageInverted, ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg(imageInverted, ' + axis + ', ' + direction + ',' + str(nbIter) + ')\n'
        else:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg(imageInverted, ' + mask + ', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg(imageInverted, ' + mask + ', ' + axis + ', ' + direction + ',' + str(nbIter) + ')\n'

    else:
        if mask is None:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg('+image+', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg('+image+', ' + axis + ', ' + direction + ','+str(nbIter)+')\n'
        else:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + ' = advmorpho.ridgeLine2dImg('+image+', ' + mask + ', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine2dImg('+image+', ' + mask + ', ' + axis + ', ' + direction + ','+str(nbIter)+')\n'

    text += "outputList = Measure()\n"
    text += "outputList.value = " + outImage[1] + "\n"
    text += "outputList.subType = 'ListPixelsPath'\n"
    text = addToText(text, "outputs = [" + outImage[0] + ', outputList]', process)

    return text

def ridgeLine3dImg(xmlFunctionCall, outImage=["outImage","outList"], process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, mask, axis, nbIter, intensity = parameters
    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    text = addToText(text, '###import PyIPSDK.IPSDKIPLIntensityTransform as itrans\n', not process)

    direction = 'PyIPSDK.ePD_Direct'

    if intensity == "Light":
        text += "imageInverted = itrans.invert2dImg("+image+")\n"
        if mask is None:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg(imageInverted, ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg(imageInverted, ' + axis + ', ' + direction + ',' + str(nbIter) + ')\n'
        else:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg(imageInverted, ' + mask + ', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg(imageInverted, ' + mask + ', ' + axis + ', ' + direction + ',' + str(nbIter) + ')\n'

    else:
        if mask is None:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg('+image+', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg('+image+', ' + axis + ', ' + direction + ','+str(nbIter)+')\n'
        else:
            if nbIter is None:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg('+image+', ' + mask + ', ' + axis + ', ' + direction + ')\n'
            else:
                text += outImage[0] + ',' + outImage[1] + '= advmorpho.ridgeLine3dImg('+image+', ' + mask + ', ' + axis + ', ' + direction + ','+str(nbIter)+')\n'

    text += "outputList = Measure()\n"
    text += "outputList.value = " + outImage[1] + "\n"
    text += "outputList.subType = 'ListVoxelsPath'\n"
    text = addToText(text, "outputs = [" + outImage[0] + ', outputList]', process)

    return text

def superPixels2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, param, compactness, nbIter, ratio, separationMode = parameters

    paramValue = param[0]
    if param[1] == 0:
        type = 'PyIPSDK.eSPT_Number'
    else:
        type = 'PyIPSDK.eSPT_Size'

    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if separationMode != "Basins":
        text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    if separationMode == "Label":
        text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)

    if ratio is None and type == 'PyIPSDK.eSPT_Number':
        text += outImage + '= advmorpho.superPixels2dImg('+image+','+ str(paramValue) + ',' + str(compactness) + ',' + str(nbIter) + ')\n'
    else:
        if ratio is None:
            ratio = 0.5
        text += outImage + '= advmorpho.superPixels2dImg(' + image + ',' + str(paramValue) + ',' + str(compactness) + ',' + str(nbIter) + ',' + str(ratio) + ',' + type + ')\n'

    if separationMode == "Label":
        text+= outImage + " = arithm.formula2dImg('if(I1<max(square(I1,1)), 0, I1)', InOptImg1=" + outImage + ")\n"
        text+= outImage+' = util.convertImg('+outImage+',PyIPSDK.eIBT_Label16)\n'
    if separationMode == "Lines":
        text+= outImage + " = arithm.formula2dImg('if (I1<max(square(I1,1)), True, False)', InOptImg1=" + outImage + ")\n"
    text = addToText(text, "outputs = " + outImage, process)

    return text

def superVoxels3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    image, param, compactness, nbIter, ratio, separationMode = parameters

    paramValue = param[0]
    if param[1] == 0:
        type = 'PyIPSDK.eSPT_Number'
    else:
        type = 'PyIPSDK.eSPT_Size'

    text = ""
    text = addToText(text, '###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n', not process)
    if separationMode != "Basins":
        text = addToText(text, '###import PyIPSDK.IPSDKIPLArithmetic as arithm\n', not process)
    if separationMode == "Label":
        text = addToText(text, '###import PyIPSDK.IPSDKIPLUtility as util\n', not process)

    if ratio is None and type == 'PyIPSDK.eSPT_Number':
        text += outImage + '= advmorpho.superVoxels3dImg('+image+','+ str(paramValue) + ',' + str(compactness) + ',' + str(nbIter) + ')\n'
    else:
        if ratio is None:
            ratio = 0.5
        text += outImage + '= advmorpho.superVoxels3dImg(' + image + ',' + str(paramValue) + ',' + str(compactness) + ',' + str(nbIter) + ',' + str(ratio) + ',' + type + ')\n'

    if separationMode == "Label":
        text+= outImage + " = arithm.formula3dImg('if(I1<max(cube(I1,1)), 0, I1)', InOptImg3d1=" + outImage + ")\n"
        text+= outImage+' = util.convertImg('+outImage+',PyIPSDK.eIBT_Label16)\n'
    if separationMode == "Lines":
        text+= outImage + " = arithm.formula3dImg('if (I1<max(cube(I1,1)), True, False)', InOptImg3d1=" + outImage + ")\n"
    text = addToText(text, "outputs = " + outImage, process)

    return text
    


def dilateLabel2dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    
    image, mode = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n", not process)
    
    if mode is None:
        text += outImage + ' = advmorpho.dilateLabel2dImg(' + image + ')\n'
    else:
        text += outImage + ' = advmorpho.dilateLabel2dImg(' + image + ', ' + mode + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text

def dilateLabel3dImg(xmlFunctionCall, outImage="outImage", process=True):
    parameters = xmlToParamList(xmlFunctionCall)
    
    image, mode = parameters

    text = ""
    text = addToText(text, "###import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho\n", not process)
    
    if mode is None:
        text += outImage + ' = advmorpho.dilateLabel3dImg(' + image + ')\n'
    else:
        text += outImage + ' = advmorpho.dilateLabel3dImg(' + image + ', ' + mode + ')\n'
    text = addToText(text, "outputs = " + outImage, process)

    return text