import sys,os
import traceback

import shutil

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans

import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLClassification as classif
import PyIPSDK.IPSDKIPLStats as stats
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLMachineLearning as ml
import PyIPSDK.IPSDKIPLLogical as logic

from PIL import Image, ImageDraw

import UsefullVariables as vrb
import UsefullWidgets as wgt
import UsefullTexts as txt
import UsefullFunctions as fct
import DatabaseFunction as Dfct
import DrawFunctions as DWfct
import UsefullDisplay as display

from GroupMenu import GroupBoxContrast
from WidgetContrast import WidgetContrast
import moduleRandomForest.UsefullMachineLearning as mlFct

import xml.etree.ElementTree as xmlet
import random
random.seed(1)
import webbrowser
# webbrowser.get()

import PyIPSDK.IPSDKUI as ui
import PyIPSDK.IPSDKFunctionsMachineLearning as fctML

# from sklearn.externals import joblib
import joblib

import numpy as np
import time

# from moduleRandomForest.ImageViewer_ import WidgetImage
# from moduleRandomForest.WidgetLabelImage_ import WidgetLabelImage

from WidgetLabelImage import WidgetLabelImage
from ImageViewer import WidgetImage

from moduleRandomForest.FeaturesWidget import FeaturesWidget,ListWidgetFeatures

# from moduleRandomForest.deep import applyNeuralNetwork

import sklearn
from sklearn.ensemble import RandomForestClassifier
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix

class MainWidget(qt.QWidget):

    def __init__(self):
        qt.QWidget.__init__(self)

        self.moduleType = 'Pixel Classification'
        self.graphicElements = None
        self.currentLabel = None
        self.customLutDraw = None
        self.customLutOutput = None

        self.model = None
        self.modelIPSDK = None

        self.posX = None
        self.posY = None

        self.currentMode = "Pen"
        self.liveUpdate = True

        self.groupBoxProcessing = wgt.GroupBoxProcessing()
        self.groupBoxProcessing.buttonStop.setFixedWidth(0)
        self.featuresMessage = False

        self.xmlElement = xmlet.Element('IPSDK')
        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')
        featuresElement = Dfct.SubElement(self.xmlElement, 'Features')

        self.previousImageDraw = None
        self.previousImageDrawLiveUpdate = None
        self.addPreviousimageDrawLiveUpdate = True

        self.featuresWidget = FeaturesWidget(parent=self,xmlElement=featuresElement)

        self.confusionMatrixWidget = display.ConfusionMatrixWidget()
        self.confusionMatrix = None

        self.widgetLabelImage = WidgetLabelImage(xmlElement=allElements,module=self)
        self.widgetImage = WidgetImage(standAlone=True, module=self,parent=self)
        self.imageViewer = self.widgetImage.imageViewer
        self.settingsWidget = SettingsWidget(parent=self)
        self.labelScrollArea = self.settingsWidget.labelSelectionGroupBox.labelScrollArea

        self.graphicElements = GraphicElements(parent=self)

        self.listWidgetFeatures = self.settingsWidget.listWidgetFeatures

        self.groupContrast = GroupBoxContrast(parentWidget=self)
        self.groupContrast.buttonAuto.setToolTip(txt.dictToolTips["MinMaxContrast"])
        self.widgetContrast = WidgetContrast()
        self.widgetContrast.setValues(50, 50)

        self.layout = qt.QGridLayout()
        self.layout.setContentsMargins(5, 15, 5, 5)
        self.layout.setSizeConstraint(1)

        self.layout.addWidget(self.groupContrast,0,1)
        self.layout.addWidget(self.widgetLabelImage,1,0)
        self.layout.addWidget(self.widgetImage,1,1)
        self.layout.addWidget(self.groupBoxProcessing,1,1)
        self.layout.addWidget(self.settingsWidget,0,2,2,1)

        self.groupBoxProcessing.setVisible(False)

        self.setLayout(self.layout)

        self.widgetImage.SignalRefreshPreview.connect(self.evaluateModel)
        self.imageViewer.signalNewImage.connect(self.addLabelsFromUrls)
        self.imageViewer.signalEmitMouse.connect(self.applySignalImageViewer)

        self.widgetLabelImage.signalDoubleClickLabel.connect(self.changeCurrentXmlElement)
        self.widgetLabelImage.signalLabelDeletePosition.connect(self.labelDeleted)

        self.labelScrollArea.SignalDeleteLabel.connect(self.colorLabelDeleted)
        self.labelScrollArea.SignalAddLabel.connect(self.changeLut)
        self.labelScrollArea.SignalColorChanged.connect(self.changeLut)

        self.settingsWidget.buttonViewFeatures.clicked.connect(self.viewFeatures)
        self.settingsWidget.buttonSaveModel.clicked.connect(self.saveModel)
        self.settingsWidget.buttonConfusionMatrix.clicked.connect(self.showConfusionMatrix)
        #self.settingsWidget.buttonLiveUpdate.clicked.connect(self.evaluateModel)

        self.groupContrast.buttonBrigthness.clicked.connect(self.showContrastWindow)
        # self.widgetContrast.signalValueChanged.connect(self.widgetImage.actualizeScene)
        self.settingsWidget.drawGroupBox.buttonBack.clicked.connect(self.getPreviousImageDraw)
        self.settingsWidget.buttonUndoLiveUpdate.clicked.connect(self.getPreviousImageDrawLiveUpdate)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

        self.resize(1200 * vrb.ratio, 900 * vrb.ratio)
        self.setMinimumSize(600 * vrb.ratio, 600 * vrb.ratio)

    def resizeEvent(self, event):

        heightGroupContrast = 50*vrb.ratio

        self.groupContrast.setFixedHeight(heightGroupContrast)
        self.widgetLabelImage.setFixedSize(200*vrb.ratio,self.height() - heightGroupContrast-25*vrb.ratio)
        self.widgetImage.setFixedSize(max(0,self.width()-470*vrb.ratio),self.height()-heightGroupContrast-25*vrb.ratio)
        self.settingsWidget.setFixedSize(250*vrb.ratio,self.height())#-heightGroupContrast-25*vrb.ratio)

    def closeEvent(self, a0: QtGui.QCloseEvent):

        try:
            vrb.mainWindow.currentModuleMachineLearning = None
        except:
            pass

    def showContrastWindow(self):
        self.widgetContrast.window().setWindowModality(Qt.ApplicationModal)
        self.widgetContrast.show()
        self.widgetContrast.widgetSettings.applySliderValues()

    def updateLabelClasses(self):

        labelClassesElement = Dfct.SubElement(self.xmlElement,"LabelClasses")
        numberLabelElement = Dfct.SubElement(labelClassesElement,"NumberLabels")
        nbLabels = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
        numberLabelElement.text = str(nbLabels)
        for numLabel in range(nbLabels):
            labelItem = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
            if labelItem is not None:
                labelWidget = labelItem.widget()
                labelElement = Dfct.SubElement(labelClassesElement,"Label_"+str(numLabel))
                colorElement = Dfct.SubElement(labelElement,"Color")
                colorElement.text = str(labelWidget.color[0]) + "," + str(labelWidget.color[1]) + "," + str(labelWidget.color[2])
                nameElement = Dfct.SubElement(labelElement,"Name")
                nameElement.text = Dfct.convertTextToAscii(labelWidget.editableLabelName.label.text())
                nameElement = Dfct.SubElement(labelElement, "Name").set('ASCII', str(True))
                valueElement = Dfct.SubElement(labelElement,"Value")
                valueElement.text = str(labelWidget.value)

    def saveModel(self):

        modelName = self.settingsWidget.lineEditModelName.text()
        if modelName == "":
            modelName = self.settingsWidget.lineEditModelName.placeholderText()
        filePath = vrb.folderPixelClassification + "/" + modelName
        if os.path.exists(filePath):
            fct.clearDirectory(filePath)
        else:
            os.makedirs(filePath)

        self.updateLabelClasses()

        Dfct.saveXmlElement(self.xmlElement,filePath+"/Settings.mho")

        for i in range(self.widgetLabelImage.layout.count()):
            item = self.widgetLabelImage.layout.itemAt(i)
            if item is not None:
                label = item.widget()

                name = label.labelName.text()
                folderImageName = filePath+"/"+name
                if os.path.exists(folderImageName):
                    fct.clearDirectory(folderImageName)
                else:
                    os.makedirs(folderImageName)

                PyIPSDK.saveTiffImageFile(folderImageName+"/Image.tif",label.image)
                if label.imageDraw is not None:
                    PyIPSDK.saveTiffImageFile(folderImageName + "/ImageDraw.tif", label.imageDraw)

        if self.model is not None:
            joblib.dump(self.model, filePath + "/Model")

        try:
            PyIPSDK.writeToBinaryFile(filePath + "/ModelIPSDK.bin", self.modelIPSDK)
        except:
            traceback.print_exc(file=sys.stderr)

        #PyIPSDK.writeToXmlFile("F:/modelRFPython.xml",self.modelIPSDK)

        try:
            # vrb.mainWindow.actualizeFunctionMachineLearning()
            vrb.mainWindow.updateCurrentFunction()
        except:
            pass
        self.settingsWidget.buttonSaveModel.setEnabled(False)

    def loadClassesElement(self,labelClassesElement,labelMin = 2):

        self.labelScrollArea.clearScrollArea()

        numberLabelElement = Dfct.SubElement(labelClassesElement, "NumberLabels")
        nbLabels = int(numberLabelElement.text)
        for numLabel in range(nbLabels):
            labelElement = Dfct.SubElement(labelClassesElement, "Label_" + str(numLabel))
            colorText = Dfct.childText(labelElement, "Color").split(",")
            color = [int(colorText[0]), int(colorText[1]), int(colorText[2])]
            name = Dfct.childText(labelElement, "Name")
            value = Dfct.childText(labelElement,"Value")

            self.settingsWidget.labelSelectionGroupBox.labelScrollArea.addLabelWithName(color=color, name=name,value = value)

    def loadModel(self,modelName):

        self.settingsWidget.lineEditModelName.setPlaceholderText(modelName)

        folder = vrb.folderPixelClassification + "/" + modelName

        filePath = os.path.join(folder+"/Settings.mho")
        file = xmlet.parse(filePath)
        self.xmlElement = file.getroot()

        try:
            labelClassesElement = Dfct.SubElement(self.xmlElement, "LabelClasses")
            self.loadClassesElement(labelClassesElement)
        except:
            numberLabelElement = Dfct.SubElement(self.xmlElement, "NumberLabels")
            nbLabels = int(numberLabelElement.text)
            for numLabel in range(2,nbLabels):
                self.settingsWidget.labelSelectionGroupBox.labelScrollArea.addLabelWithName()

        featuresElement = Dfct.SubElement(self.xmlElement, 'Features')
        self.featuresWidget.loadXmlElement(featuresElement)

        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')
        self.widgetLabelImage.xmlElement = allElements
        # self.widgetLabelImage = WidgetLabelImage(xmlElement=allElements, module=self)

        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')
        for child in allElements:
            if child.tag == "Image":
                nameImage = Dfct.childText(child,"Name")
                if os.path.exists(folder + "/" + nameImage):

                    image = PyIPSDK.loadTiffImageFile(folder + "/" + nameImage + "/Image.tif")
                    imageDraw = PyIPSDK.loadTiffImageFile(folder + "/" + nameImage + "/ImageDraw.tif")

                    label,name = self.widgetLabelImage.addNewImage(nameImage,image,xmlElement=child)
                    label.imageDraw = imageDraw

                    self.changeCurrentXmlElement(label,evaluate=False)

        try:
            self.model = joblib.load(folder+"/Model")
            # self.modelIPSDK = mlFct.createModelIPSDK(self.xmlElement, self.model, self.currentLabel.image)
            if os.path.exists(folder+"/ModelIPSDK.bin"):
                self.modelIPSDK = PyIPSDK.readRandomForestModel(folder+"/ModelIPSDK.bin")
            else:
                self.modelIPSDK = PyIPSDK.readRandomForestModel(folder +"/ModelIPSDK.xml")

        except:
            traceback.print_exc(file=sys.stderr)
            self.model = None
            self.modelIPSDK = None

        self.evaluateModel()

        self.featuresWidget.actualizeComboBoxLoading()

    def loadModelRef(self,name = ""):

        if name != "":
            self.settingsWidget.lineEditModelName.setPlaceholderText(name)

        try:
            filePath = os.path.join(vrb.folderPixelClassification + "/SettingsRef.mho")
            file = xmlet.parse(filePath)
            self.xmlElement = file.getroot()
        except:
            self.generateSettingsRef()
        featuresElement = Dfct.SubElement(self.xmlElement, 'Features')
        self.featuresWidget.loadXmlElement(featuresElement)

        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')
        self.widgetLabelImage.xmlElement = allElements

        self.featuresWidget.actualizeComboBoxLoading()

    def generateSettingsRef(self):

        self.xmlElement = xmlet.Element('IPSDK')
        allElements = Dfct.SubElement(self.xmlElement, 'AllElements')

        labelClassesElement = Dfct.SubElement(self.xmlElement, "LabelClasses")
        numberLabelsElement = Dfct.SubElement(labelClassesElement, 'NumberLabels')
        numberLabelsElement.text = str(2)

        featuresElement = Dfct.SubElement(self.xmlElement, 'Features')
        allSizesElement = Dfct.SubElement(featuresElement, 'All_Sizes')
        allSizesElement.text = "1,2,3,4,5"
        for nameFunction in ["Gaussian", "Mean", "Laplacian_Difference", "High_Pass", "Variance","Erosion", "Dilation", "Opening", "Closing"]:
            element = Dfct.SubElement(featuresElement, nameFunction)
            element.text = "True,False,False,False,False"
        dimensionElement = Dfct.SubElement(featuresElement, 'Dimension')
        dimensionElement.text = "2D"
        multiResElement = Dfct.SubElement(featuresElement, 'MultiRes')
        multiResElement.text = "1"

    def actualizeNumberOfPixels(self):

        nbLabels = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()

        for numLabel in range(nbLabels):

            labelItem = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
            if labelItem is not None:
                labelWidget = labelItem.widget()

                nbPixels = 0
                for i in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(i)
                    if item is not None:
                        label = item.widget()
                        imageDraw = label.imageDraw.array
                        maskImage = imageDraw == numLabel + 1
                        nbPixels += np.sum(maskImage)
                labelWidget.labelCount.setText(str(nbPixels) + " px")

    def viewFeatures(self):

        if self.settingsWidget.buttonViewFeatures.activate == True:
            self.settingsWidget.buttonViewFeatures.changeActivation()
            self.changeCurrentXmlElement(self.currentLabel)
            self.widgetImage.sliderOpacity.slider.setValue(50)

    def evaluateModel(self):

        start = time.time()

        try:
            self.computeFeatures()
            continueProcess = self.verifImageDraw()
            # continueProcess = True

            if continueProcess:
                self.groupBoxProcessing.setText('Computing and applying Model')
                self.groupBoxProcessing.labelLeft.setFixedWidth(160 * vrb.ratio)
                self.toggleGroupBoxProcessing(True)

                if self.model is None or self.modelIPSDK is None:

                    self.model, dictConversion = self.computeModel()
                    # self.settingsWidget.sortByPercentage()

                    nbLabels = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
                    maxValueLabel = 0
                    for numLabel in range(nbLabels):
                        try:
                            labelItem = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
                            if labelItem is not None:
                                labelWidget = labelItem.widget()
                                maxValueLabel = max(maxValueLabel,int(labelWidget.value)+1)
                        except:
                            maxValueLabel = max(maxValueLabel,numLabel + 1)

                    # self.modelIPSDK = mlFct.createModelIPSDK(self.xmlElement, self.model, self.currentLabel.image,nbLabels = nbLabels,dictConversion = dictConversion)
                    self.modelIPSDK = mlFct.createModelIPSDK(self.xmlElement, self.model, self.currentLabel.image,nbLabels = maxValueLabel,dictConversion = dictConversion)

                    if self.addPreviousimageDrawLiveUpdate:
                        self.updateImageDrawLiveUpdate()

                if self.modelIPSDK is not None and self.model is not None:

                    try:
                        self.listWidgetFeatures.fillListWidget()
                        listFeatures = self.currentLabel.listFeatures

                        if listFeatures[0].getSizeZ() > 1:
                            listImages = []
                            for feature in listFeatures:
                                plan = fct.getImagePlan(feature,self.widgetImage)
                                listImages.append(plan)
                        else:
                            listImages = listFeatures

                        imageSeq = mlFct.createSeqImage(listImages)

                        #PyIPSDK.writeToXmlFile("D:/ModelIPSDK.xml", self.modelIPSDK)
                        # PyIPSDK.saveTiffImageFile("D:/ImageSeq.tif", imageSeq)

                        # output =  ml.pixelClassificationRFImg(imageSeq,self.modelIPSDK)

                        output,imageProbabilities =  ml.pixelClassificationRFWithProbabilitiesImg(imageSeq,self.modelIPSDK)

                        self.updateLabelClasses()
                        fctML.writeSmartSegmentationImage(output,None,self.xmlElement)

                        output = fct.getMultiResolutionImage(output)
                        imageProbabilities = fct.getMultiResolutionImage(imageProbabilities)

                        self.imageViewer.setImageOverlay(output)
                        self.imageViewer.setImageProbabilities(imageProbabilities)

                        #self.imageViewer.getRoiImage()

                    except:
                        traceback.print_exc(file=sys.stderr)
                        self.model = None
                        self.modelIPSDK = None
                        self.imageViewer.setImageOverlay(None)
                        self.imageViewer.setImageProbabilities(None)
                        #self.imageViewer.getRoiImage()

            else:
                self.model = None
                self.modelIPSDK = None
                self.imageViewer.setImageOverlay(None)
                self.imageViewer.setImageProbabilities(None)
                #self.imageViewer.getRoiImage()

        except:
            traceback.print_exc(file=sys.stderr)

        self.actualizeNumberOfPixels()

        self.toggleGroupBoxProcessing(False)
        self.groupBoxProcessing.labelLeft.setFixedWidth(130 * vrb.ratio)
        self.settingsWidget.buttonSaveModel.setEnabled(True)

        # print ('End compute model : '+str(time.time()-start))

    def verifImageDraw(self):

        continueProcess = False
        verif = 0

        nbLabels = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
        for numLabel in range(nbLabels):
            labelItem = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
            if labelItem is not None:
                for i in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(i)
                    if item is not None:
                        label = item.widget()
                        if len(label.listFeatures) > 1:
                            imageDraw = label.imageDraw
                            mask = bin.thresholdImg(imageDraw, numLabel+1, numLabel+1)
                            if imageDraw.getSizeZ() == 1:
                                sumMask = glbmsr.statsMsr2d(mask).sum
                            else:
                                sumMask = glbmsr.statsMsr3d(mask).sum
                            if sumMask >1:
                                verif += 1
                            if verif >= 2:
                                continueProcess = True
                                break

        return continueProcess

    def computeModel(self,realModel=True,confusionMatrix=False):

        try:
            nbLabels = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.count()
            try:
                nbTrees = int(self.settingsWidget.lineEditTreeNumber.text())
            except:
                nbTrees = 50

            featuresArray = []
            labelArray = []

            dictConversion = {}
            currentValue = 0

            dictSum = {}
            dictSum["Total"] = {}
            for numImage in range(self.widgetLabelImage.layout.count()):
                dictSum[numImage] = {}
                item = self.widgetLabelImage.layout.itemAt(numImage)
                if item is not None:
                    label = item.widget()
                    listFeatures = label.listFeatures

                    imageDraw = label.imageDraw.array
                    for numLabel in range(nbLabels):
                        maskImage = imageDraw == numLabel+1
                        sum = np.sum(maskImage)
                        dictSum[numImage][numLabel] = sum
                        if numLabel not in dictSum["Total"]:
                            dictSum["Total"][numLabel] = sum
                        else:
                            dictSum["Total"][numLabel] += sum

            for numImage in range(self.widgetLabelImage.layout.count()):
                item = self.widgetLabelImage.layout.itemAt(numImage)
                if item is not None:
                    label = item.widget()
                    listFeatures = label.listFeatures

                    imageDraw = label.imageDraw.array
                    for numLabel in range(nbLabels):
                        maskImage = imageDraw == numLabel+1

                        if dictSum[numImage][numLabel] != 0:
                            for i in range(len(listFeatures)):
                                if i == 0:
                                    currentFeaturesArray = listFeatures[i].array[maskImage]
                                    currentLabelArray = np.full_like(currentFeaturesArray,numLabel)
                                else:
                                    if len(currentFeaturesArray) != 0:
                                        currentArray = listFeatures[i].array[maskImage]
                                        currentFeaturesArray = np.column_stack((currentFeaturesArray,currentArray))

                            if len(featuresArray) == 0:
                                featuresArray = currentFeaturesArray
                                labelArray = currentLabelArray
                            else:
                                if len(currentFeaturesArray) != 0:
                                    featuresArray = np.concatenate((featuresArray,currentFeaturesArray))
                                    labelArray = np.concatenate((labelArray,currentLabelArray))

                        try:
                            labelItem = self.settingsWidget.labelSelectionGroupBox.labelScrollArea.layout.itemAt(numLabel)
                            if labelItem is not None:
                                labelWidget = labelItem.widget()
                                valueLabel = int(labelWidget.value)
                        except:
                            valueLabel = numLabel

                        if numImage == 0:
                            dictConversion[currentValue] = valueLabel
                            if dictSum["Total"][numLabel] >= 2:
                                currentValue += 1

            if confusionMatrix or self.confusionMatrixWidget.isVisible():

                if self.settingsWidget.lineEditPercentageTest.text() == "":
                    testSize = int(self.settingsWidget.lineEditPercentageTest.placeholderText())/100
                else:
                    testSize = int(self.settingsWidget.lineEditPercentageTest.text())/100

                self.computeConfusionMatrix(featuresArray,labelArray,nbTrees,testSize = testSize)

            if realModel:
                model = RandomForestClassifier(n_estimators=nbTrees,n_jobs=-1)
                model.fit(featuresArray, labelArray)
            else:
                return

        except:
            model = None
            self.imageViewer.setImageOverlay(None)
            self.imageViewer.setImageProbabilities(None)
            self.imageViewer.getRoiImage()
            traceback.print_exc(file=sys.stderr)

        self.settingsWidget.buttonSaveModel.setEnabled(True)

        return model,dictConversion

    def computeConfusionMatrix(self,featuresArray,labelArray,nbTrees,testSize = 0.2):

        self.updateLabelClasses()

        dictConfusionMatrix = {}

        labelClassesElement = Dfct.SubElement(self.xmlElement, "LabelClasses")
        numberLabelElement = Dfct.SubElement(labelClassesElement, "NumberLabels").text
        nbLabels = int(numberLabelElement)
        for numLabel in range(nbLabels):
            dictConfusionMatrix[numLabel] = {}
            labelElement = Dfct.SubElement(labelClassesElement, "Label_" + str(numLabel))
            colorText = Dfct.SubElement(labelElement, "Color").text
            colorTextSplit = colorText.split(",")
            color = [int(x) for x in colorTextSplit]
            dictConfusionMatrix[numLabel]["Color"] = QtGui.QColor(color[0],color[1],color[2])
            dictConfusionMatrix[numLabel]["Name"] = Dfct.childText(labelElement,"Name")

        X_train, X_test, y_train, y_test = train_test_split(featuresArray, labelArray, test_size=testSize,
                                                            random_state=42)

        model = RandomForestClassifier(n_estimators=nbTrees, n_jobs=-1)
        model.fit(X_train, y_train)

        y_pred = model.predict(X_test)

        all_labels = np.arange(nbLabels)

        title = "Confusion matrix ("+str((1-testSize)*100) + "% training / " + str(testSize*100) + "% test)"

        self.confusionMatrix = confusion_matrix(y_test, y_pred, labels=all_labels)
        self.confusionMatrixWidget.loadMatrix(dictConfusionMatrix,self.confusionMatrix,title=title)

    def showConfusionMatrix(self):

        self.computeModel(realModel=False,confusionMatrix=True)
        fct.showWidget(self.confusionMatrixWidget)

    def computeFeatures(self):

        if self.featuresMessage:
            self.groupBoxProcessing.setText('Computing features')
            self.toggleGroupBoxProcessing(True)

        colors = ["Red","Green","Blue"]

        try:
            featuresElement = Dfct.SubElement(self.xmlElement, 'Features')
            allSizes = Dfct.childText(featuresElement, "All_Sizes")
            allSizes = allSizes.split(",")
            for i in range(len(allSizes)):
                allSizes[i] = int(allSizes[i])

            multiRes = Dfct.childText(featuresElement, "MultiRes")
            multiRes = multiRes.split(",")
            for i in range(len(multiRes)):
                multiRes[i] = int(multiRes[i])

            dimension = Dfct.childText(featuresElement,"Dimension")
            if dimension == "3D" and self.currentLabel.image.getSizeZ() == 1:
                dimension = "2D"

            if featuresElement is not None:
                for i in range(self.widgetLabelImage.layout.count()):
                    item = self.widgetLabelImage.layout.itemAt(i)
                    if item is not None:
                        label = item.widget()
                        dictFeatures = {}
                        label.listFeatures = []
                        label.listNamesFeatures = []
                        if dimension != label.dimension:
                            label.dictFeatures = {}
                            label.dimension = dimension

                        if label.image.getSizeC() == 1:
                            label.listNamesFeatures.append("Original image")
                            imageOriginal = util.copyImg(label.image)
                            label.listFeatures.append(imageOriginal)
                        else:
                            sizeC = label.image.getSizeC()
                            for c in range(sizeC):
                                if label.image.getSizeZ() == 1:
                                    plan = PyIPSDK.extractPlan(0, c, 0, label.image)
                                else:
                                    plan = PyIPSDK.extractVolume( c, 0, label.image)
                                newFeature = util.copyImg(plan)
                                if sizeC == 3:
                                    label.listNamesFeatures.append("Original image ("+colors[c]+")")
                                else:
                                    label.listNamesFeatures.append("Original image (channel " + str(c)+")")
                                label.listFeatures.append(newFeature)

                        stop = False
                        for res in multiRes:
                            for child in featuresElement:
                                nameFunction = child.tag.replace("_"," ")
                                if nameFunction in self.featuresWidget.tableFeatures.listFilters or nameFunction in self.featuresWidget.tableFeatures.listMorphology:
                                    featuresBooleans = child.text.split(",")
                                    for j in range(len(featuresBooleans)):
                                        if featuresBooleans[j] == "True":
                                            try:
                                                if stop == False:
                                                    mlFct.addClassicFeatures(nameFunction,allSizes[j],label,dictFeatures,res,dimension)
                                            except:

                                                text = "Can't compute the feature "+nameFunction + " " + str(2*allSizes[j]+1)+"x"+str(2*allSizes[j]+1)
                                                if dimension =="3D":
                                                    text+= "x"+str(2*allSizes[j]+1)
                                                if res != 1:
                                                    text += " with resolution 1/"+str(res)
                                                text += " on your image "+str(label.image.getSizeX())+"x"+str(label.image.getSizeY())
                                                if label.image.getSizeZ() != 1:
                                                    text+="x"+str(label.image.getSizeZ())
                                                text +=".\n Please select smaller structuring elements or change the multi-resolution"

                                                self.messageBox = wgt.MessageBox(text, '', buttons=[qt.QMessageBox.Ok],
                                                                                 windowTitle="Error feature computation",icon=qt.QMessageBox.Warning)
                                                self.messageBox.exec()
                                                print("Error computing features: ",nameFunction,allSizes[j],res,dimension)
                                                stop = True

                        if stop:
                            dictFeatures = {}
                            label.listFeatures = []
                            label.listNamesFeatures = []
                        label.dictFeatures = dictFeatures

        except:
            traceback.print_exc(file=sys.stderr)

        self.listWidgetFeatures.fillListWidget()

        if self.featuresMessage:
            self.toggleGroupBoxProcessing(False)
            self.featuresMessage = False

    def colorLabelDeleted(self,num):

        for i in range(self.widgetLabelImage.layout.count()):
            item = self.widgetLabelImage.layout.itemAt(i)
            if item is not None:
                label = item.widget()
                # label.imageDraw = arithm.formula2dImg("if (I1 ==" + str(num + 1) + ", 0, I1)", InOptImg1=label.imageDraw)
                label.imageDraw = arithm.formula2dImg("if (I1 >= " + str(num + 1) + " , if (I1 ==" + str(num + 1) + ", 0, I1-1), I1)", InOptImg1=label.imageDraw)
                # label.imageDraw = arithm.formula2dImg("if (I1 >= " + str(num) + " , if (I1 ==" + str(num ) + ", 0, I1-1), I1)", InOptImg1=label.imageDraw)
                label.imageDraw = util.convertImg(label.imageDraw, PyIPSDK.eImageBufferType.eIBT_Label16)

        self.labelScrollArea.selectLabelByNum(0)
        self.changeLut()
        self.actualizeImageDraw()
        self.model = None
        self.modelIPSDK = None
        self.evaluateModel()
        # self.computeModel()

    def applySignalImageViewer(self,ddict, imageViewer):

        if self.currentMode in ["Pen","Eraser"]:
            self.drawOnImage(ddict)
        elif self.currentMode == "Polygon":
            self.drawPolygonOnImage(ddict)

    def drawPolygonOnImage(self,ddict):

        self.imageViewer.viewport().setCursor(Qt.ArrowCursor)
        graphicElement = Dfct.SubElement(self.xmlElement, "GraphicElement")
        roiElement = Dfct.SubElement(graphicElement, "Roi")
        currentNum = self.labelScrollArea.getCurrentNum()

        if ddict["Button"] == 1 and ddict["Event"] == "MousePressed":

                DWfct.addPointToPolygon(roiElement, QtCore.QPointF(ddict["Position"][0], ddict["Position"][1]))
                self.imageViewer.getRoiImage(changeRoiImage=False)

        if ddict["Button"] == 1 and ddict["Event"] == "DoubleClick":

            try:
                if self.currentLabel.imageDraw.getSizeZ() == 1:
                    imageDraw = self.currentLabel.imageDraw.array
                else:
                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()
                        imageDraw = self.currentLabel.imageDraw.array[:,:, value]
                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value()
                        imageDraw = self.currentLabel.imageDraw.array[:, value ,:,]
                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value()
                        imageDraw = self.currentLabel.imageDraw.array[value,:, :]

                imagePolygon, polygon = fct.createPolygonImage(roiElement,imageDraw,buffer=PyIPSDK.eIBT_Label16,value=currentNum)
                mask = bin.thresholdImg(imagePolygon,0,0)
                imageDrawIP = np.ascontiguousarray(imageDraw)
                imageDrawIP = PyIPSDK.fromArray(imageDrawIP)
                imageDrawIP = util.convertImg(imageDrawIP,PyIPSDK.eIBT_Label16)
                imagePolygon = logic.maskImgImg(imageDrawIP,imagePolygon,mask)

                imageDraw[:,:] = imagePolygon.array

                self.actualizeImageDraw()

                self.model = None
                self.modelIPSDK = None

                self.updateImageDraw()

                if self.liveUpdate:
                    self.evaluateModel()

            except:
                traceback.print_exc(file=sys.stderr)

            self.clearRoiElement()
            self.imageViewer.getRoiImage(changeRoiImage=False)

    def clearRoiElement(self):

        graphicElement = Dfct.SubElement(self.xmlElement, "GraphicElement")
        roiElement = Dfct.SubElement(graphicElement, "Roi")
        Dfct.clearElement(roiElement)

    def drawOnImage(self,ddict):

        try:

            if self.currentLabel is not None:

                size = int(self.settingsWidget.drawGroupBox.comboBoxSize.currentText())
                size = size-1

                if self.currentMode == "Pen":
                    currentNum = self.labelScrollArea.getCurrentNum()
                    pixmap = QtGui.QPixmap(vrb.folderImages + '/Pencil.png')
                    pixmap = pixmap.scaled(40,40, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
                    self.imageViewer.viewport().setCursor(QtGui.QCursor(pixmap))
                elif self.currentMode == "Eraser":
                    currentNum = 0
                    pixmap = QtGui.QPixmap(vrb.folderImages + '/Eraser_Cursor.png')
                    if size <3:
                        pixmap = pixmap.scaled(30, 30, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
                    if size >= 3 and size < 10:
                        pixmap = pixmap.scaled(50, 50, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
                    if size >= 10:
                        pixmap = pixmap.scaled(70, 70, aspectRatioMode=Qt.KeepAspectRatio, transformMode=Qt.SmoothTransformation)
                    self.imageViewer.viewport().setCursor(QtGui.QCursor(pixmap))

                if (ddict["Event"] == "Move" and self.imageViewer.mousePressed and self.imageViewer.currentButtonPressed == 1) or (ddict["Event"] == "MousePressed" and ddict["Button"] == 1):

                    if self.posX is None or self.posY is None:

                        posX = int(ddict["Position"][0])
                        posY = int(ddict["Position"][1])

                        if self.currentLabel.imageDraw.getSizeZ() == 1:
                            # self.currentLabel.imageDraw.array[posY - sizeMin:posY + sizeMax, posX - sizeMin:posX + sizeMax] = currentNum
                            self.currentLabel.imageDraw.array[posY - size:posY + size+1, posX - size:posX + size+1] = currentNum
                        else:
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()
                                self.currentLabel.imageDraw.array[posY - size:posY + size+1, posX - size:posX + size+1, value] = currentNum
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value()
                                self.currentLabel.imageDraw.array[posY - size:posY + size+1, value, posX - size:posX + size+1] = currentNum
                            if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value()
                                self.currentLabel.imageDraw.array[value, posY - size:posY + size+1, posX - size:posX + size+1] = currentNum

                    else:

                        nbStep = max(round(abs(self.posX - ddict["Position"][0])), round(abs(self.posY - ddict["Position"][1])))
                        nbStep = max(nbStep,1)
                        nbStep *= 5

                        if nbStep > 0:
                            for step in range(nbStep + 1):
                                posX = ddict["Position"][0] + step * (self.posX - ddict["Position"][0]) / nbStep
                                posY = ddict["Position"][1] + step * (self.posY - ddict["Position"][1]) / nbStep

                                posX = int(posX)
                                posY = int(posY)

                                if self.currentLabel.imageDraw.getSizeZ() == 1:
                                    self.currentLabel.imageDraw.array[posY - size:posY + size+1, posX - size:posX + size+1] = currentNum
                                else:
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonX.isChecked():
                                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderX.slider.value()
                                        self.currentLabel.imageDraw.array[posY - size:posY + size+1, posX - size:posX + size+1, value] = currentNum
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonY.isChecked():
                                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderY.slider.value()
                                        self.currentLabel.imageDraw.array[posY - size:posY + size+1, value, posX - size:posX + size+1] = currentNum
                                    if self.widgetImage.imageViewerStandAlone.sliderAxis.radioButtonZ.isChecked():
                                        value = self.widgetImage.imageViewerStandAlone.sliderAxis.sliderZ.slider.value()
                                        self.currentLabel.imageDraw.array[value, posY - size:posY + size+1, posX - size:posX + size+1] = currentNum

                    self.actualizeImageDraw()

                    self.model = None
                    self.modelIPSDK = None

                    self.posX = ddict["Position"][0]
                    self.posY = ddict["Position"][1]


                if ddict["Event"] == "Release":
                    self.posX = None
                    self.posY = None

                    self.updateImageDraw()

                    if self.liveUpdate:
                        self.evaluateModel()

        except:
            pass

    def updateImageDraw(self):

        if len(vrb.smartSegmentationPreviousImages) == 0:
            if self.previousImageDraw is not None:
                firstImageDraw = util.copyImg(self.previousImageDraw)
            else:
                firstImageDraw = util.copyImg(self.currentLabel.imageDraw)
            vrb.smartSegmentationPreviousImages.append(firstImageDraw)
        else:
            if len(vrb.smartSegmentationPreviousImages) == vrb.smartSegmentationNumberPreviousImages:
                vrb.smartSegmentationPreviousImages.remove(vrb.smartSegmentationPreviousImages[0])
            if self.previousImageDraw is not None:
                vrb.smartSegmentationPreviousImages.append(self.previousImageDraw)
        imageCopy = util.copyImg(self.currentLabel.imageDraw)
        self.previousImageDraw = imageCopy

        self.settingsWidget.drawGroupBox.buttonBack.setEnabled(True)

    def getPreviousImageDraw(self):

        try:
            if len(vrb.smartSegmentationPreviousImages) != 0:
                imageDraw = vrb.smartSegmentationPreviousImages[len(vrb.smartSegmentationPreviousImages)-1]

                vrb.smartSegmentationPreviousImages.remove(imageDraw)
                self.currentLabel.imageDraw = imageDraw
                imageCopy = util.copyImg(self.currentLabel.imageDraw)
                self.previousImageDraw = imageCopy

                self.actualizeImageDraw()

                self.model = None
                self.modelIPSDK = None

            self.settingsWidget.drawGroupBox.buttonBack.setEnabled(len(vrb.smartSegmentationPreviousImages) >= 1)
            if self.liveUpdate:
                self.evaluateModel()
        except:
            traceback.print_exc(file=sys.stderr)

    def updateImageDrawLiveUpdate(self):

        if len(vrb.smartSegmentationPreviousImagesLiveUpdate) == 0:
            if self.previousImageDrawLiveUpdate is not None:
                firstImageDrawLiveUpdate = util.copyImg(self.previousImageDrawLiveUpdate)
            else:
                firstImageDrawLiveUpdate = util.copyImg(self.currentLabel.imageDraw)
            vrb.smartSegmentationPreviousImagesLiveUpdate.append(firstImageDrawLiveUpdate)
        else:
            if len(vrb.smartSegmentationPreviousImagesLiveUpdate) == vrb.smartSegmentationNumberPreviousImages:
                vrb.smartSegmentationPreviousImagesLiveUpdate.remove(vrb.smartSegmentationPreviousImagesLiveUpdate[0])
            if self.previousImageDrawLiveUpdate is not None:
                vrb.smartSegmentationPreviousImagesLiveUpdate.append(self.previousImageDrawLiveUpdate)
        imageCopy = util.copyImg(self.currentLabel.imageDraw)
        self.previousImageDrawLiveUpdate = imageCopy

        self.settingsWidget.buttonUndoLiveUpdate.setEnabled(True)

    def getPreviousImageDrawLiveUpdate(self):

        try:

            if len(vrb.smartSegmentationPreviousImagesLiveUpdate) != 0:

                imageDraw = vrb.smartSegmentationPreviousImagesLiveUpdate[len(vrb.smartSegmentationPreviousImagesLiveUpdate)-1]

                vrb.smartSegmentationPreviousImagesLiveUpdate.remove(imageDraw)
                self.currentLabel.imageDraw = imageDraw
                imageCopy = util.copyImg(self.currentLabel.imageDraw)
                self.previousImageDrawLiveUpdate = imageCopy

                self.actualizeImageDraw()

                self.model = None
                self.modelIPSDK = None

            self.settingsWidget.buttonUndoLiveUpdate.setEnabled(len(vrb.smartSegmentationPreviousImagesLiveUpdate) >= 1)

            self.addPreviousimageDrawLiveUpdate = False

            self.evaluateModel()

            self.addPreviousimageDrawLiveUpdate = True

        except:
            self.addPreviousimageDrawLiveUpdate = True
            traceback.print_exc(file=sys.stderr)

    def changeLut(self):

        self.customLutDraw = self.labelScrollArea.getCustomLutDraw()
        self.customLutOverlay = self.labelScrollArea.getCustomLutOverlay()

        self.imageViewer.getRoiImage()

    def actualizeImageDraw(self):

        if self.customLutDraw is None:
            self.customLutDraw = self.labelScrollArea.getCustomLutDraw()
            self.customLutOverlay = self.labelScrollArea.getCustomLutOverlay()

        if self.currentLabel is not None:
            start = time.time()
            self.widgetImage.setImageDraw(self.currentLabel.imageDraw)

        self.actualizeNumberOfPixels()
        self.settingsWidget.buttonSaveModel.setEnabled(True)

    def addLabelsFromUrls(self, urls):

        self.toggleGroupBoxProcessing(True)

        for i in range(len(urls)):
            try:
                url = str(urls[i].toLocalFile())
            except:
                url = urls[i]
            urlSplit = url.split('.')
            extension = urlSplit[len(urlSplit) - 1]
            if extension in vrb.extensionImages:
                try:
                    image,name = self.urlToImage(url)
                    self.addImage(image,name)
                except:
                    traceback.print_exc(file=sys.stderr)

        self.toggleGroupBoxProcessing(False)

    def urlToImage(self, url):

        name = os.path.basename(url)
        self.groupBoxProcessing.setText('Adding image\n' + name)
        self.toggleGroupBoxProcessing(True)
        image = fct.readImage(url, name=name)

        return image,name

    def addImage(self,image,name):

        self.groupBoxProcessing.setText('Adding image\n' + name)
        self.toggleGroupBoxProcessing(True)
        self.featuresMessage = True

        if image.getBufferType() in [PyIPSDK.eImageBufferType.eIBT_Label8,PyIPSDK.eImageBufferType.eIBT_Label16,PyIPSDK.eImageBufferType.eIBT_Label32,PyIPSDK.eImageBufferType.eIBT_Binary]:
            self.messageBox = wgt.MessageBox("You can't add this image\n This module doesn't accept image with type Label or Binary", '', buttons=[qt.QMessageBox.Ok], windowTitle="Error image")
            self.messageBox.exec()
        elif image.isDiskImage():
            self.messageBox = wgt.MessageBox("You can't add this image\n This module doesn't accept disk image, please convert it to memory image", '', buttons=[qt.QMessageBox.Ok], windowTitle="Error image")
            self.messageBox.exec()
        else:
            item = self.widgetLabelImage.layout.itemAt(0)
            if item is None:
                label, name = self.widgetLabelImage.addNewImage(name, image,allowDuplicate=True)
                self.changeCurrentXmlElement(label)
            else:
                imageRef = item.widget().image
                if ((imageRef.getSizeZ() == 1 and image.getSizeZ() == 1) or (imageRef.getSizeZ() > 1 and image.getSizeZ() > 1)) and (imageRef.getSizeC() == image.getSizeC()):
                    label, name = self.widgetLabelImage.addNewImage(name, image,allowDuplicate=True)
                    self.changeCurrentXmlElement(label)
                else:
                    self.messageBox = wgt.MessageBox("You can't add this image\n All images must have the same geometry (2D or 3D and grey or color)", '', buttons=[qt.QMessageBox.Ok], windowTitle="Error image")
                    self.messageBox.exec()

        self.toggleGroupBoxProcessing(False)
        self.settingsWidget.buttonSaveModel.setEnabled(True)

    def changeCurrentXmlElement(self, label, evaluate=True):

        self.clearRoiElement()

        self.currentXmlElement = label.xmlElement
        self.currentLabel = label

        self.settingsWidget.drawGroupBox.buttonBack.setEnabled(False)
        self.previousImageDraw = None
        self.previousImageDrawLiveUpdate = None
        vrb.smartSegmentationPreviousImages = []
        vrb.smartSegmentationPreviousImagesLiveUpdate = []

        if self.currentLabel.imageDraw is None:
            if self.currentLabel.image.getSizeZ() == 1:
                self.currentLabel.imageDraw = PyIPSDK.createImage(PyIPSDK.geometry2d(PyIPSDK.eIBT_Label16, self.currentLabel.image.getSizeX(), self.currentLabel.image.getSizeY()))
            else:
                self.currentLabel.imageDraw = PyIPSDK.createImage(PyIPSDK.geometry3d(PyIPSDK.eIBT_Label16, self.currentLabel.image.getSizeX(), self.currentLabel.image.getSizeY(), self.currentLabel.image.getSizeZ()))
            util.eraseImg(self.currentLabel.imageDraw, 0)

        firstImageDraw = util.copyImg(self.currentLabel.imageDraw)
        vrb.smartSegmentationPreviousImages.append(firstImageDraw)
        firstImageDrawLiveUpdate = util.copyImg(self.currentLabel.imageDraw)
        vrb.smartSegmentationPreviousImagesLiveUpdate.append(firstImageDrawLiveUpdate)

        if label is not None:
            self.setWindowTitle('IPSDK Explorer - ' + str(Dfct.childText(label.xmlElement, "Name")))
        else:
            self.setWindowTitle('IPSDK Explorer')

        # self.currentLabel.setStyleSelected(True)
        self.widgetLabelImage.updateStyleSheet()

        self.imageViewer.setImageOverlay(None)
        self.imageViewer.setImageProbabilities(None)
        self.widgetImage.setImage(self.currentLabel)

        self.groupContrast.loadContrast()

        self.actualizeImageDraw()

        if evaluate:
            self.evaluateModel()

    def labelDeleted(self, position):

        self.model = None
        self.modelIPSDK = None

        self.setWindowTitle('IPSDK Explorer')
        currentPosition = int(Dfct.childText(self.currentXmlElement, "Position"))

        if currentPosition == -1:
            item = self.widgetLabelImage.layout.itemAt(position)
            if item is not None:
                self.changeCurrentXmlElement(item.widget())
            else:
                if position > 0:
                    item = self.widgetLabelImage.layout.itemAt(position - 1)
                    if item is not None:
                        self.changeCurrentXmlElement(item.widget())
                    else:
                        self.resetScene()
                else:
                    self.resetScene()

        self.model = None
        self.modelIPSDK = None
        self.evaluateModel()
        self.settingsWidget.buttonSaveModel.setEnabled(True)

    def toggleGroupBoxProcessing(self,showValue):

        if showValue:
            self.groupBoxProcessing.setVisible(True)
            qt.QApplication.processEvents()
            qt.QApplication.processEvents()
        else:
            self.groupBoxProcessing.setVisible(False)

    def resetScene(self):

        self.currentLabel = None
        self.currentXmlElement = None
        self.imageViewer.scene.clear()
        self.imageViewer.scene.clearSelection()
        self.imageViewer.scene.clearFocus()
        self.widgetImage.setImage(None)
        self.imageViewer.setImageOverlay(None)
        self.imageViewer.setImageProbabilities(None)
        self.image = None
        self.widgetImage.sliderOpacity.setVisible(False)
        self.actualizeNumberOfPixels()

class SettingsWidget(qt.QGroupBox):

    def __init__(self,parent=None):
        qt.QGroupBox.__init__(self)

        self.parent = parent

        self.pushButtonDocumentation = wgt.PushButtonImage(margins=1, filename=vrb.folderImages + '/Interrogation.png')
        self.pushButtonDocumentation.setStyleSheet("background-color : transparent; border :0px")
        self.pushButtonDocumentation.setFixedSize(20 * vrb.ratio, 20 * vrb.ratio)

        self.labelSelectionGroupBox = LabelSelectionGroupBox(parent=self.parent)
        self.drawGroupBox = DrawGroupBox(parent=self.parent)

        self.labelFeatures = qt.QLabel("Features")
        font = QtGui.QFont()
        font.setBold(True)
        font.setPointSize(10)
        self.labelFeatures.setFont(font)
        self.labelFeatures.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelFeatures.setFixedWidth(130*vrb.ratio)
        self.buttonSettings = wgt.PushButtonImage(vrb.folderImages + "/Edit_3.png", margins=0)
        self.buttonSettings.setToolTip("Modify features")
        self.buttonSettings.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.labelTreeNumber = qt.QLabel("Number of trees")
        self.labelTreeNumber.setFont(font)
        self.labelTreeNumber.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelTreeNumber.setFixedWidth(130 * vrb.ratio)
        self.lineEditTreeNumber = wgt.NumberLineEdit()
        self.lineEditTreeNumber.setPlaceholderText("50")
        self.lineEditTreeNumber.setFixedWidth(50 * vrb.ratio)

        self.labelConfusionMatrix = qt.QLabel("Confusion matrix")
        self.labelConfusionMatrix.setFont(font)
        self.labelConfusionMatrix.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelConfusionMatrix.setFixedWidth(130*vrb.ratio)
        self.buttonConfusionMatrix = wgt.PushButtonImage(vrb.folderImages + "/Matrix.png", margins=0)
        self.buttonConfusionMatrix.setToolTip("Compute confusion matrix")
        self.buttonConfusionMatrix.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.labelPercentageTest = qt.QLabel("Percentage test")
        self.labelPercentageTest.setFont(font)
        self.labelPercentageTest.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelPercentageTest.setFixedWidth(130*vrb.ratio)
        self.lineEditPercentageTest = wgt.NumberLineEdit()
        self.lineEditPercentageTest.setPlaceholderText("20")
        self.lineEditPercentageTest.setFixedWidth(50 * vrb.ratio)

        # self.testPercentageSpinbox = wgt.LabeledSpinBox(title = "% Test",minValue=1,maxValue = 99,step = 5,defaultValue=20,margins=7*vrb.ratio)
        # self.testPercentageSpinbox.setFixedSize(80 * vrb.ratio, 54 * vrb.ratio)

        self.labelLiveUpdate = qt.QLabel("Live update")
        self.labelLiveUpdate.setFont(font)
        self.labelLiveUpdate.setAlignment(Qt.AlignCenter)
        # self.labelLiveUpdate.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelLiveUpdate.setFixedWidth(90*vrb.ratio)
        self.labelLiveUpdate.setStyleSheet('QLabel {color: rgb(52, 152, 219);background-color: rgb(70,70,70);}')

        self.buttonLiveUpdate = wgt.PushButtonDoubleImage(vrb.folderImages + "/Pause.png",vrb.folderImages + "/Lecture.png")
        self.buttonLiveUpdate.setToolTip("Stop live update")
        self.buttonLiveUpdate.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.buttonRefresh = wgt.PushButtonImage(vrb.folderImages + "/Refresh_White.png", margins=5)
        self.buttonRefresh.setToolTip("Evaluate model")
        self.buttonRefresh.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.buttonUndoLiveUpdate = wgt.PushButtonImage(vrb.folderImages + "/Back.png", margins=5)
        self.buttonUndoLiveUpdate.setToolTip("Undo")
        self.buttonUndoLiveUpdate.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.emptyLabel1 = qt.QLabel()
        self.emptyLabel1.setFixedHeight(25*vrb.ratio)

        self.groupBoxFeatures = qt.QGroupBox()
        self.layoutFeatures = qt.QGridLayout()
        self.layoutFeatures.addWidget(self.labelFeatures,0,0)
        self.layoutFeatures.addWidget(self.buttonSettings,0,1,Qt.AlignLeft)
        self.layoutFeatures.addWidget(self.labelTreeNumber,1,0)
        self.layoutFeatures.addWidget(self.lineEditTreeNumber,1,1,Qt.AlignLeft)
        self.layoutFeatures.addWidget(self.labelConfusionMatrix,2,0)
        self.layoutFeatures.addWidget(self.buttonConfusionMatrix,2,1,Qt.AlignLeft)
        self.layoutFeatures.addWidget(self.labelPercentageTest,3,0)
        self.layoutFeatures.addWidget(self.lineEditPercentageTest,3,1,Qt.AlignLeft)

        self.groupBoxFeatures.setLayout(self.layoutFeatures)
        self.groupBoxFeatures.setFixedHeight(135*vrb.ratio)
        self.layoutFeatures.setContentsMargins(20, 0, 0, 0)
        self.layoutFeatures.setSizeConstraint(1)

        self.emptyLabel2 = qt.QLabel()
        self.emptyLabel2.setFixedHeight(25*vrb.ratio)

        self.groupBoxLiveUpdate = qt.QGroupBox()
        self.layoutLiveUpdate = qt.QGridLayout()
        self.layoutLiveUpdate.addWidget(self.labelLiveUpdate,0,0)
        self.layoutLiveUpdate.addWidget(self.buttonLiveUpdate,0,1)
        self.layoutLiveUpdate.addWidget(self.buttonRefresh,0,2)
        self.layoutLiveUpdate.addWidget(self.buttonUndoLiveUpdate,0,3)
        self.layoutLiveUpdate.setAlignment(Qt.AlignLeft)
        self.buttonRefresh.setVisible(False)
        self.buttonUndoLiveUpdate.setVisible(False)
        self.groupBoxLiveUpdate.setLayout(self.layoutLiveUpdate)
        self.groupBoxLiveUpdate.setFixedHeight(30*vrb.ratio)
        self.layoutLiveUpdate.setContentsMargins(20, 0, 0, 0)
        self.layoutLiveUpdate.setSizeConstraint(1)

        self.emptyLabel3 = qt.QLabel()
        self.emptyLabel3.setFixedHeight(25 * vrb.ratio)

        self.groupBoxLabelListFeatures = qt.QGroupBox()
        self.groupBoxLabelListFeatures.setFixedHeight(25 * vrb.ratio)
        layoutLabelListFeatures = qt.QGridLayout()
        self.groupBoxLabelListFeatures.setLayout(layoutLabelListFeatures)
        layoutLabelListFeatures.setContentsMargins(0,0,0,0)
        layoutLabelListFeatures.setSizeConstraint(1)
        self.groupBoxLabelListFeatures.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.labelListOfFeatures = qt.QLabel("List of features (sorted by importance)")
        font = QtGui.QFont()
        font.setPointSize(9)
        self.labelListOfFeatures.setFont(font)
        self.labelListOfFeatures.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.labelListOfFeatures.setFixedHeight(25 * vrb.ratio)

        self.buttonViewFeatures = wgt.PushButtonDoubleImage(vrb.folderImages + "/eye_close.png", vrb.folderImages + "/eye_open.png")
        self.buttonViewFeatures.setFixedSize(20*vrb.ratio,20*vrb.ratio)

        layoutLabelListFeatures.addWidget(self.labelListOfFeatures,0,0)
        layoutLabelListFeatures.addWidget(self.buttonViewFeatures,0,1)

        self.groupBoxRemoveFeatures = qt.QGroupBox()
        self.groupBoxRemoveFeatures.setFixedHeight(25 * vrb.ratio)
        layoutRemoveFeatures = qt.QGridLayout()
        self.groupBoxRemoveFeatures.setLayout(layoutRemoveFeatures)
        layoutRemoveFeatures.setContentsMargins(0, 0, 0, 0)
        layoutRemoveFeatures.setSizeConstraint(1)
        self.groupBoxRemoveFeatures.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.labelRemoveFeatures = qt.QLabel("Remove features below")
        font = QtGui.QFont()
        font.setPointSize(9)
        self.labelRemoveFeatures.setFont(font)
        # self.labelRemoveFeatures.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        #‗self.lineEditPercentage = qt.QLineEdit("0")
        self.lineEditPercentage = wgt.NumberLineEdit(constraint="Real")
        self.lineEditPercentage.setText("0")
        self.lineEditPercentage.setPlaceholderText("0")
        self.lineEditPercentage.setFixedWidth(35*vrb.ratio)
        self.labelPercentage = qt.QLabel("%")
        self.labelPercentage.setFont(font)
        # self.labelPercentage.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.buttonRemoveFeatures = wgt.PushButtonImage(vrb.folderImages + "/Trash2.png", margins=5)
        self.buttonRemoveFeatures.setToolTip("Remove Features")
        self.buttonRemoveFeatures.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        layoutRemoveFeatures.addWidget(self.labelRemoveFeatures, 0, 0)
        layoutRemoveFeatures.addWidget(self.lineEditPercentage, 0, 1)
        layoutRemoveFeatures.addWidget(self.labelPercentage, 0, 2)
        layoutRemoveFeatures.addWidget(self.buttonRemoveFeatures, 0, 3)

        self.groupSaveModel = qt.QGroupBox()
        self.groupSaveModel.setFixedHeight(25 * vrb.ratio)
        layoutSaveModel = qt.QGridLayout()
        self.groupSaveModel.setLayout(layoutSaveModel)
        layoutSaveModel.setContentsMargins(0, 0, 0, 0)
        layoutSaveModel.setSizeConstraint(1)
        self.groupSaveModel.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.labelModelName = qt.QLabel("Model name")
        font = QtGui.QFont()
        font.setPointSize(9)
        self.labelModelName.setFont(font)
        self.labelModelName.setStyleSheet('QLabel {color: rgb(52, 152, 219);}')
        self.lineEditModelName = qt.QLineEdit()
        self.lineEditModelName.setFixedWidth(140*vrb.ratio)
        modelName = fct.getModelName(vrb.folderPixelClassification)
        self.lineEditModelName.setPlaceholderText(modelName)
        self.buttonSaveModel = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSaveModel.setToolTip("Save model")
        self.buttonSaveModel.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        layoutSaveModel.addWidget(self.labelModelName, 0, 0)
        layoutSaveModel.addWidget(self.lineEditModelName, 0, 1)
        layoutSaveModel.addWidget(self.buttonSaveModel, 0, 2)

        self.groupBoxListWidgetFeatures = qt.QGroupBox()
        self.groupBoxListWidgetFeatures.setFixedHeight(25 * vrb.ratio)
        layoutListWidgetFeatures = qt.QGridLayout()
        self.groupBoxListWidgetFeatures.setLayout(layoutListWidgetFeatures)
        layoutListWidgetFeatures.setContentsMargins(0, 0, 0, 0)
        layoutListWidgetFeatures.setSizeConstraint(1)
        self.groupBoxListWidgetFeatures.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.listWidgetFeatures = ListWidgetFeatures(parent=self.parent)

        self.labelFeaturesName = wgt.LabelClickable("Name    ▼")
        self.labelFeaturesName.sort = True
        self.labelFeaturesName.setAlignment(Qt.AlignLeft)
        self.labelFeaturesName.setFixedWidth(150*vrb.ratio)

        self.labelFeaturesPercentage = wgt.LabelClickable()
        self.labelFeaturesPercentage.sort = True
        self.labelFeaturesPercentage.setText("Percentage")
        self.labelFeaturesPercentage.setAlignment(Qt.AlignLeft)

        self.currentLabelSort = self.labelFeaturesName

        layoutListWidgetFeatures.addWidget(self.labelFeaturesName,0,0)
        layoutListWidgetFeatures.addWidget(self.labelFeaturesPercentage,0,1)
        layoutListWidgetFeatures.addWidget(self.listWidgetFeatures,1,0,1,2)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.pushButtonDocumentation,0,0, Qt.AlignRight)
        self.layout.addWidget(self.labelSelectionGroupBox,1,0)
        self.layout.addWidget(self.drawGroupBox,2,0)
        self.layout.addWidget(self.emptyLabel1,3,0)
        self.layout.addWidget(self.groupBoxFeatures,4,0)
        self.layout.addWidget(self.emptyLabel2,5,0)
        self.layout.addWidget(self.groupBoxLiveUpdate,6,0)
        self.layout.addWidget(self.emptyLabel3,7,0)
        # self.layout.addWidget(self.labelListOfFeatures,7,0)
        self.layout.addWidget(self.groupBoxLabelListFeatures,8,0)
        # self.layout.addWidget(self.listWidgetFeatures,9,0)
        self.layout.addWidget(self.groupBoxListWidgetFeatures,9,0)
        self.layout.addWidget(self.groupBoxRemoveFeatures,10,0,Qt.AlignTop)
        self.layout.addWidget(self.groupSaveModel,11,0,Qt.AlignBottom)

        self.layout.setContentsMargins(5*vrb.ratio, 5*vrb.ratio, 5*vrb.ratio, 35*vrb.ratio)
        self.layout.setSizeConstraint(1)

        self.setLayout(self.layout)

        self.pushButtonDocumentation.clicked.connect(self.showDocumentation)
        self.buttonSettings.clicked.connect(self.displayFeatures)
        self.buttonLiveUpdate.clicked.connect(self.changeLiveUpdate)
        self.buttonRefresh.clicked.connect(self.parent.evaluateModel)
        self.lineEditTreeNumber.textChanged.connect(self.changeNumberTree)
        self.lineEditTreeNumber.returnPressed.connect(self.parent.evaluateModel)
        self.buttonRemoveFeatures.clicked.connect(self.removeLowFeatures)
        self.labelFeaturesName.clicked.connect(self.sortByName)
        self.labelFeaturesPercentage.clicked.connect(self.sortByPercentage)
        self.lineEditModelName.textChanged.connect(self.allowSaveButton)

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        totalHeight = 0

        totalHeight += 30*vrb.ratio + 25 *vrb.ratio #size button Interrogation + margins

        drawGroupBoxHeight = 40*vrb.ratio
        self.drawGroupBox.setFixedSize(max(0, self.width() - 10 * vrb.ratio), drawGroupBoxHeight)
        totalHeight += drawGroupBoxHeight

        groupBoxFeaturesHeight = 135*vrb.ratio
        self.groupBoxFeatures.setFixedSize(max(0, self.width() - 10 * vrb.ratio), groupBoxFeaturesHeight)
        totalHeight += groupBoxFeaturesHeight

        groupBoxLiveUpdateHeight = 40*vrb.ratio
        self.groupBoxLiveUpdate.setFixedSize(max(0, self.width() - 10 * vrb.ratio), groupBoxLiveUpdateHeight)
        totalHeight += groupBoxLiveUpdateHeight

        groupBoxLabelListFeaturesHeight = 25*vrb.ratio
        self.groupBoxLabelListFeatures.setFixedSize(max(0, self.width() - 10 * vrb.ratio), groupBoxLabelListFeaturesHeight)
        totalHeight += groupBoxLabelListFeaturesHeight

        groupBoxRemoveFeaturesHeight = 25*vrb.ratio
        self.groupBoxRemoveFeatures.setFixedSize(max(0, self.width() - 10 * vrb.ratio), groupBoxRemoveFeaturesHeight)
        totalHeight += groupBoxRemoveFeaturesHeight

        minSizeLabelSelectionGroupBox = 200*vrb.ratio
        minSizegroupBoxLabelListFeatures = 200*vrb.ratio
        sizeEmptyLabel = (self.height() - totalHeight - minSizeLabelSelectionGroupBox - minSizegroupBoxLabelListFeatures)/3
        sizeEmptyLabel = max(0,sizeEmptyLabel)
        sizeEmptyLabel = min(25*vrb.ratio,sizeEmptyLabel)

        self.emptyLabel1.setFixedHeight(sizeEmptyLabel)
        self.emptyLabel2.setFixedHeight(sizeEmptyLabel)
        self.emptyLabel3.setFixedHeight(sizeEmptyLabel)
        totalHeight += 3*sizeEmptyLabel

        totalHeight += 80*vrb.ratio # spacing between widgets

        heightLabelSelectionGroupBox = (self.height()-totalHeight)*3/5
        heightLabelSelectionGroupBox = min(heightLabelSelectionGroupBox,250*vrb.ratio)

        self.labelSelectionGroupBox.setFixedSize(max(0,self.width()-10*vrb.ratio),heightLabelSelectionGroupBox)
        totalHeight += heightLabelSelectionGroupBox

        self.groupBoxListWidgetFeatures.setFixedSize(max(0,self.width()-10*vrb.ratio),self.height()-totalHeight)
        # self.listWidgetFeatures.setFixedSize(max(0,self.width()-10*vrb.ratio),self.height()-totalHeight)

    def allowSaveButton(self):

        try:
            self.buttonSaveModel.setEnabled(True)
            self.labelSelectionGroupBox.updateSaveSettingsButton()
        except:
            pass

    def showDocumentation(self):

        webbrowser.open_new_tab(vrb.folderDocEssential + "/smartsegmentation.html")

        # try:
        #     file = xmlet.parse(vrb.folderInformation + "/MachineLearningDoc.mho")
        #     xmlElement = file.getroot()
        #     pageDoc = Dfct.childText(xmlElement,"SmartSegmentation")
        #     webbrowser.open_new_tab(vrb.folderDocCore + "/" + pageDoc)
        # except:
        #     pass

    def sortByName(self):

        if self.currentLabelSort == self.labelFeaturesName:
            self.labelFeaturesName.sort = not(self.labelFeaturesName.sort)

        self.currentLabelSort = self.labelFeaturesName

        if self.labelFeaturesName.sort:
            self.labelFeaturesName.setText("Name    ▼")
        else:
            self.labelFeaturesName.setText("Name    ▲")
        self.labelFeaturesPercentage.setText("Percentage")
        self.listWidgetFeatures.fillListWidget()

    def sortByPercentage(self):

        if self.currentLabelSort == self.labelFeaturesPercentage:
            self.labelFeaturesPercentage.sort = not (self.labelFeaturesPercentage.sort)

        self.currentLabelSort = self.labelFeaturesPercentage

        if self.labelFeaturesPercentage.sort:
            self.labelFeaturesPercentage.setText("Percentage    ▼")
        else:
            self.labelFeaturesPercentage.setText("Percentage    ▲")
        self.labelFeaturesName.setText("Name")
        self.listWidgetFeatures.fillListWidget()

    def removeLowFeatures(self):

        try:
            try:
                ponderationRef = float(self.lineEditPercentage.text())
            except:
                ponderationRef = 0
            model = self.parent.model
            featuresImportance = model.feature_importances_

            label = self.parent.currentLabel
            tableWidget = self.parent.featuresWidget.tableFeatures

            for size in label.dictFeatures:
                for nameFunction in label.dictFeatures[size]:
                    toRemove = True
                    for res in label.dictFeatures[size][nameFunction]:
                        if label.image.getSizeC() > 1:
                            for color in label.dictFeatures[size][nameFunction][res]:
                                currentFeatures = label.dictFeatures[size][nameFunction][res][color]
                                for i in range(len(label.listFeatures)):
                                    if currentFeatures == label.listFeatures[i]:
                                        ponderation = featuresImportance[i]*100
                                        if ponderation > ponderationRef:
                                            toRemove = False
                        else:
                            currentFeatures = label.dictFeatures[size][nameFunction][res]
                            for i in range(len(label.listFeatures)):
                                if currentFeatures[0] == label.listFeatures[i]:
                                    ponderation = featuresImportance[i] * 100
                                    if ponderation > ponderationRef:
                                        toRemove = False
                    if toRemove:
                        for row in range(tableWidget.rowCount()):
                            if tableWidget.item(row, 0).text() == nameFunction:
                                for col in range(tableWidget.columnCount()):
                                    if tableWidget.item(0, col).text() == str(size):
                                        cell = qt.QTableWidgetItem()
                                        cell.setFlags(cell.flags() & ~Qt.ItemIsSelectable)
                                        cell.setFlags(cell.flags() & ~Qt.ItemIsEditable)
                                        cell.checked = False
                                        tableWidget.setItem(row,col, cell)

            self.parent.featuresWidget.createXmlElement(None,close=False)

        except:
            traceback.print_exc(file=sys.stderr)

    def changeNumberTree(self):

        self.parent.model = None
        self.parent.modelIPSDK = None

    def displayFeatures(self):

        #self.parent.featuresWidget.loadXmlElement()

        fct.showWidget(self.parent.featuresWidget)

    def changeLiveUpdate(self):

        self.buttonLiveUpdate.changeActivation()
        if self.buttonLiveUpdate.activate == False:
            self.parent.evaluateModel()
            self.parent.liveUpdate = True
            self.labelLiveUpdate.setStyleSheet('QLabel {color: rgb(52, 152, 219); background-color: rgb(70,70,70);}')
            self.buttonRefresh.setVisible(False)
            self.buttonUndoLiveUpdate.setVisible(False)
        else:
            self.parent.liveUpdate = False
            self.labelLiveUpdate.setStyleSheet('QLabel {color: rgb(52, 152, 219); background-color: transparent;}')
            self.buttonRefresh.setVisible(True)
            self.buttonUndoLiveUpdate.setVisible(True)

class DrawGroupBox(qt.QGroupBox):

    def __init__(self,parent=None):
        qt.QGroupBox.__init__(self)

        self.parent = parent

        self.buttonPen = wgt.PushButtonDoubleImage(vrb.folderImages + "/Pen.png",vrb.folderImages + "/Pen_Pressed.png")
        self.buttonPen.setToolTip("Draw on the image")
        self.buttonPen.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonPen.mode = "Pen"

        self.buttonEraser = wgt.PushButtonDoubleImage(vrb.folderImages + "/Eraser.png",vrb.folderImages + "/Eraser_Pressed.png")
        self.buttonEraser.setToolTip("Erase on the image")
        self.buttonEraser.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonEraser.mode = "Eraser"

        self.labelSize = qt.QLabel("   Size")
        self.labelSize.setFixedWidth(35*vrb.ratio)
        self.comboBoxSize = qt.QComboBox()
        self.comboBoxSize.addItem("1")
        self.comboBoxSize.addItem("2")
        self.comboBoxSize.addItem("3")
        self.comboBoxSize.addItem("4")
        self.comboBoxSize.addItem("5")
        self.comboBoxSize.addItem("10")
        self.comboBoxSize.addItem("15")
        self.comboBoxSize.addItem("20")
        self.comboBoxSize.addItem("30")
        self.comboBoxSize.setFixedWidth(40*vrb.ratio)

        self.buttonPolygon = wgt.PushButtonDoubleImage(vrb.folderImages + "/Roi.png",vrb.folderImages + "/Roi_Pressed.png",margins1=5*vrb.ratio)
        self.buttonPolygon.setToolTip("Draw a polygon on the image")
        self.buttonPolygon.setFixedSize(25*vrb.ratio,25*vrb.ratio)
        self.buttonPolygon.mode = "Polygon"

        self.buttonBack = wgt.PushButtonImage(vrb.folderImages + "/Back.png")
        self.buttonBack.setFixedSize(25* vrb.ratio,25* vrb.ratio)
        self.buttonBack.setEnabled(False)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonPen, 0, 0)
        self.layout.addWidget(self.buttonPolygon, 0, 1)
        self.layout.addWidget(self.buttonEraser, 0, 2)
        self.layout.addWidget(self.labelSize, 0, 3)
        self.layout.addWidget(self.comboBoxSize, 0, 4, Qt.AlignLeft)
        self.layout.addWidget(self.buttonBack, 0, 5, Qt.AlignRight)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setHorizontalSpacing(5)
        self.layout.setContentsMargins(20, 5, 20, 5)

        self.buttonPen.clicked.connect(self.changeMode)
        self.buttonEraser.clicked.connect(self.changeMode)
        self.buttonPolygon.clicked.connect(self.changeMode)

        self.setMode("Pen")

    def changeMode(self):

        self.parent.clearRoiElement()
        self.parent.imageViewer.getRoiImage(changeRoiImage=False)

        sender = self.sender()
        for button in [self.buttonPen,self.buttonEraser,self.buttonPolygon]:
            button.setActivation(button==sender)
            if button == sender:
                self.parent.currentMode = button.mode

    def setMode(self,mode):

        for button in [self.buttonPen,self.buttonEraser,self.buttonPolygon]:
            button.setActivation(button.mode==mode)
            self.parent.currentMode = mode

class LabelSelectionGroupBox(qt.QGroupBox):

    def __init__(self,parent=None):
        qt.QGroupBox.__init__(self)

        self.parent = parent

        self.groupLabelSelection = wgt.GroupBoxLoadSettings()

        self.labelScrollArea = LabelScrollArea(parent = self.parent)

        self.buttonAdd = wgt.PushButtonImage(vrb.folderImages + "/Add_4.png", margins=0)
        # self.buttonAdd = wgt.PushButtonImage(vrb.folderImages + "/Pen.png", margins=5)
        self.buttonAdd.setToolTip("Add a new label")
        self.buttonAdd.setFixedSize(25*vrb.ratio,25*vrb.ratio)

        self.lineEditSaveSettings = qt.QLineEdit()
        self.lineEditSaveSettings.setPlaceholderText("Save settings")
        self.lineEditSaveSettings.setFixedSize(120*vrb.ratioDimension,25*vrb.ratio)

        self.buttonSaveSettings = wgt.PushButtonImage(vrb.folderImages + "/Save.png", margins=2)
        self.buttonSaveSettings.setToolTip("Save settings")
        self.buttonSaveSettings.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.groupLabelSelection, 0, 0,1,3)
        self.layout.addWidget(self.labelScrollArea, 1, 0,1,3)
        self.layout.addWidget(self.buttonAdd, 2, 0, Qt.AlignLeft)
        self.layout.addWidget(self.lineEditSaveSettings, 2, 1, Qt.AlignRight)
        self.layout.addWidget(self.buttonSaveSettings, 2, 2)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setHorizontalSpacing(5)
        self.layout.setContentsMargins(20, 5, 20, 5)

        self.buttonAdd.clicked.connect(self.labelScrollArea.addLabel)
        self.lineEditSaveSettings.textChanged.connect(self.updateSaveSettingsButton)
        self.buttonSaveSettings.clicked.connect(self.saveSettings)
        self.groupLabelSelection.buttonLoadSettings.clicked.connect(self.loadSettings)
        self.groupLabelSelection.buttonDeleteSettings.clicked.connect(self.deleteSettings)

        self.updateSaveSettingsButton()
        self.updateComboboxSettings()

        # self.setTitle("Label selection")
        # self.setStyleSheet('QGroupBox:title {left: 8px ;padding-left: 10px;padding-right: 10px; padding-top: -12px; color:rgb(6, 115, 186)}  QGroupBox {font: bold; margin-top: 12 px;font-size:12px}')

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        self.labelScrollArea.setFixedSize(self.width()-20*vrb.ratio,self.height()-90*vrb.ratio)

    def updateSaveSettingsButton(self):

        self.buttonSaveSettings.setEnabled(self.lineEditSaveSettings.text()!="")

    def updateComboboxSettings(self):

        self.groupLabelSelection.comboBoxLoadingSettings.clear()
        for fileName in os.listdir(vrb.folderSettingsRF):
            fileSettings = xmlet.parse(vrb.folderSettingsRF + "/" + fileName)
            xmlElement = fileSettings.getroot()
            self.groupLabelSelection.comboBoxLoadingSettings.addItem(fileName[:-4],xmlElement)

    def saveSettings(self):

        self.parent.updateLabelClasses()

        labelClassesElement = Dfct.SubElement(self.parent.xmlElement, "LabelClasses")
        nameSettings = self.lineEditSaveSettings.text()

        found = False
        for fileName in os.listdir(vrb.folderSettingsRF):

            if nameSettings + ".mho" == fileName:
                found = True
                text = 'The settings "'+nameSettings+'" already exists.\nDo you want to replace it ?'
                self.messageBox = wgt.MessageBox(text, '', buttons=[qt.QMessageBox.Yes,qt.QMessageBox.No],windowTitle="Settings already exists", icon=qt.QMessageBox.Warning)
                res = self.messageBox.exec()
                if res == qt.QMessageBox.Yes:
                    Dfct.saveXmlElement(labelClassesElement,vrb.folderSettingsRF + "/" + nameSettings + ".mho")
                    self.buttonSaveSettings.setEnabled(False)

        if found == False:
            Dfct.saveXmlElement(labelClassesElement, vrb.folderSettingsRF + "/" + nameSettings + ".mho")
            self.buttonSaveSettings.setEnabled(False)

        self.updateComboboxSettings()

    def loadSettings(self):

        self.labelScrollArea.clearScrollArea()

        xmlElement = self.groupLabelSelection.comboBoxLoadingSettings.currentData()

        if xmlElement is not None:
            try:
                self.parent.loadClassesElement(xmlElement,labelMin = 0)
            except:
                traceback.print_exc(file=sys.stderr)

        self.parent.actualizeNumberOfPixels()
        self.parent.settingsWidget.buttonSaveModel.setEnabled(True)

        self.lineEditSaveSettings.setText(self.groupLabelSelection.comboBoxLoadingSettings.currentText())

        self.parent.evaluateModel()

    def deleteSettings(self):

        nameSettings = self.groupLabelSelection.comboBoxLoadingSettings.currentText()

        self.messageBox = wgt.MessageBox('Are you sure you want to delete the settings "'+nameSettings+'" ?', '', buttons=[qt.QMessageBox.Yes, qt.QMessageBox.No], windowTitle="Delete settings", icon=qt.QMessageBox.Warning)
        res = self.messageBox.exec()
        if res == qt.QMessageBox.Yes and os.path.exists(vrb.folderSettingsRF + "/" + nameSettings + ".mho"):
            try:
                os.remove(vrb.folderSettingsRF + "/" + nameSettings + ".mho")
            except:
                pass
            self.updateComboboxSettings()


class LabelScrollArea(qt.QScrollArea):

    SignalDeleteLabel = pyqtSignal(int)
    SignalColorChanged = pyqtSignal()
    SignalAddLabel = pyqtSignal()

    def __init__(self,parent=None):
        qt.QScrollArea.__init__(self)

        self.parent = parent

        self.selectedLabel = None

        self.centralWidget = qt.QGroupBox()

        self.layout = qt.QVBoxLayout()
        self.layout.setAlignment(Qt.AlignTop)

        self.centralWidget.setLayout(self.layout)

        self.setWidget(self.centralWidget)

        self.layout.setContentsMargins(0, 0, 0, 0)

        self.setStyleSheet('QScrollArea {border: 1px solid gray; }')

        self.addLabel()
        self.addLabel()

    def resizeEvent(self, a0: QtGui.QResizeEvent):

        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                label = item.widget()
                label.setFixedSize(self.width() - 20*vrb.ratio, 35 * vrb.ratio)

        self.centralWidget = qt.QWidget()
        self.centralWidget.setFixedWidth(self.width()-20*vrb.ratio)
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)

    def addLabel(self):

        self.addLabelWithName()
        self.allowSaveButton()

    def addLabelWithName(self,color=None,name=None,value=None):

        labelNum = self.layout.count()
        label = GroupBoxColor(labelNum + 1, labelNum,color=color,name=name,parent=self.parent,value=value)
        label.setFixedSize(self.width() - 20*vrb.ratio, 35 * vrb.ratio)
        label.SignalSelection.connect(self.selectLabel)
        label.SignalDeleteVariable.connect(self.deleteLabel)
        label.SignalColorChanged.connect(self.emitSignalColorChanged)
        label.editableLabelName.lineEdit.textChanged.connect(self.allowSaveButton)

        self.layout.addWidget(label)

        self.centralWidget = qt.QWidget()
        self.centralWidget.setFixedWidth(self.width() - 20*vrb.ratio)
        self.centralWidget.setLayout(self.layout)
        self.setWidget(self.centralWidget)

        self.verticalScrollBar().setValue(self.verticalScrollBar().maximum())

        self.SignalAddLabel.emit()

        if labelNum == 0:
            self.selectLabel(label)

    def selectLabel(self, label):

        try:
            if self.parent.currentMode == "Eraser":
                self.parent.settingsWidget.drawGroupBox.setMode("Pen")
        except:
            pass

        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                if item.widget() == label:
                    label.selectLabel()
                    self.selectedLabel = label
                    # self.parent.boxPencil.radioButtonDraw.setChecked(True)
                else:
                    item.widget().unselectLabel()

    def selectLabelByNum(self,numLabel):

        try:
            if self.parent.currentMode == "Eraser":
                self.parent.settingsWidget.drawGroupBox.setMode("Pen")
        except:
            pass

        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                if num == numLabel:
                    item.widget().selectLabel()
                    self.selectedLabel = item.widget()
                    # self.parent.boxPencil.radioButtonDraw.setChecked(True)
                else:
                    item.widget().unselectLabel()

    def deleteLabel(self, label):

        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                if item.widget() == label:
                    item.widget().deleteLater()
                    self.layout.removeItem(item)
                    self.SignalDeleteLabel.emit(num)
        self.allowSaveButton()

    def clearScrollArea(self):

        while self.layout.count() != 0:
            item = self.layout.itemAt(0)
            item.widget().deleteLater()
            self.layout.removeItem(item)

    def getCurrentNum(self):

        currentNum = 0
        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                if item.widget() == self.selectedLabel:
                    currentNum = num + 1

        return currentNum

    def getCurrentColor(self):

        color = [255,255,255]
        try:
            for num in range(self.layout.count()):
                item = self.layout.itemAt(num)
                if item is not None:
                    if item.widget() == self.selectedLabel:
                        color = self.selectedLabel.color
        except:
            traceback.print_exc(file=sys.stderr)

        return color

    def getCustomLutDraw(self):

        outputLut = {}
        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                color = item.widget().color
                for c in range(3):
                    if c not in outputLut:
                        outputLut[c] = [0]
                    outputLut[c].append(color[c])

        return outputLut

    def getCustomLutOverlay(self):

        outputLut = {}
        for num in range(self.layout.count()):
            item = self.layout.itemAt(num)
            if item is not None:
                widget = item.widget()
                color = widget.color
                value = widget.value
                for c in range(3):
                    if c not in outputLut:
                        outputLut[c] = []
                    while len(outputLut[c])<value:
                        outputLut[c].append(0)
                    if len(outputLut[c])>value:
                        outputLut[c][value] = color[c]*0.7
                    else:
                        outputLut[c].append(color[c]*0.7)

        return outputLut

    def emitSignalColorChanged(self):

        self.SignalColorChanged.emit()
        self.allowSaveButton()

    def allowSaveButton(self):

        try:
            self.parent.settingsWidget.buttonSaveModel.setEnabled(True)
            self.parent.settingsWidget.labelSelectionGroupBox.updateSaveSettingsButton()
        except:
            pass

class GroupBoxColor(qt.QGroupBox):

    SignalSelection = pyqtSignal(qt.QGroupBox)
    SignalDeleteVariable = pyqtSignal(qt.QGroupBox)
    SignalColorChanged = pyqtSignal()

    def __init__(self, num=1, colorNum=1,color=None,name = None,parent=None,value=None):
        qt.QGroupBox.__init__(self)

        self.parent=parent

        self.setStyleSheet('QGroupBox {border: 0px transparent; }')

        self.contextMenu = qt.QMenu(self)
        self.contextMenu.addAction('Clear current image', self.removeAllElementOneClass)
        self.contextMenu.addAction('Clear all images', self.removeAllElementOneClassAllImages)

        if color is None:
            try:
                self.color = vrb.dictColor[colorNum]
            except:
                self.color = [random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax),random.randint(vrb.randomColorMin, vrb.randomColorMax)]
        else:
            self.color = color

        self.buttonViewLabel = wgt.PushButtonDoubleImage(vrb.folderImages + "/eye_close.png", vrb.folderImages + "/eye_open.png")
        self.buttonViewLabel.setFixedSize(20 * vrb.ratio, 20 * vrb.ratio)
        self.buttonViewLabel.changeActivation()

        if value is None:
            self.value = num-1
        else:
            self.value = int(value)

        self.num = num

        if name is None:
            if num == 1:
                self.editableLabelName = wgt.EditableLabel("Background")
            else:
                self.editableLabelName = wgt.EditableLabel("Class "+str(num-1))
        else:
            self.editableLabelName = wgt.EditableLabel(name)

        font = QtGui.QFont()
        font.setPixelSize(vrb.fontSizeMachineLearning*vrb.ratio)

        self.editableLabelName.label.setFixedSize(65*vrb.ratio,20*vrb.ratio)
        self.editableLabelName.label.setFont(font)
        self.editableLabelName.lineEdit.setFixedSize(65*vrb.ratio,20*vrb.ratio)
        self.editableLabelName.lineEdit.setFont(font)

        self.editableLabelName.label.setContextMenuPolicy(Qt.CustomContextMenu)

        self.labelColor = qt.QLabel()
        self.labelColor.setFixedSize(20*vrb.ratio, 20*vrb.ratio)
        self.changeButtonColor()

        self.labelCount = qt.QLabel('0 px')
        self.labelCount.setFixedSize(40 * vrb.ratio, 20 * vrb.ratio)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(self.buttonViewLabel, 0, 0)
        self.layout.addWidget(self.editableLabelName, 0, 1)
        self.layout.addWidget(self.labelColor, 0, 2 ,Qt.AlignLeft)
        self.layout.addWidget(self.labelCount, 0, 3, Qt.AlignCenter)

        if num > 2:
            self.deleteLabel = wgt.LabelDelete()
            self.deleteLabel.setFixedSize(20* vrb.ratio, 20* vrb.ratio)
            self.deleteLabel.setToolTip(txt.dictToolTips["DeleteLabel"])
            self.layout.addWidget(self.deleteLabel, 0, 3, QtCore.Qt.AlignRight)
            self.deleteLabel.clicked.connect(self.emitSignalDeleteVariable)
        else:
            self.emptyLabel = qt.QLabel()
            self.emptyLabel.setFixedSize(20* vrb.ratio, 20* vrb.ratio)
            self.layout.addWidget(self.emptyLabel, 0, 3, QtCore.Qt.AlignRight)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setHorizontalSpacing(5)
        self.layout.setContentsMargins(5, 0, 5, 0)

        self.editableLabelName.label.customContextMenuRequested.connect(self.showMenu)
        # self.editableLabelName.customContextMenuRequested.connect(self.showMenu)
        # self.labelCount.customContextMenuRequested.connect(self.showMenu)

        self.buttonViewLabel.clicked.connect(self.viewLabel)
        self.labelColor.mouseDoubleClickEvent = self.getColor
        self.editableLabelName.mouseDoubleClickEvent = self.changeName
        self.labelColor.mousePressEvent = self.emitSelection
        self.editableLabelName.mousePressEvent = self.emitSelection

    def showMenu(self,position):

        self.contextMenu.exec(self.contextMenu.parent().mapToGlobal(position))

    def removeAllElementOneClass(self):

        try:
            imageDraw = self.parent.currentLabel.imageDraw
            # mask = bin.thresholdImg(imageDraw,self.value+1,self.value+1)
            mask = bin.thresholdImg(imageDraw,self.num,self.num)
            imageDraw = logic.reverseMaskImg(imageDraw,mask)
            self.parent.currentLabel.imageDraw = imageDraw
            self.parent.actualizeImageDraw()
            self.parent.model = None
            self.parent.modelIPSDK = None
            self.parent.evaluateModel()
        except:
            traceback.print_exc(file=sys.stderr)

    def removeAllElementOneClassAllImages(self):

        try:
            for i in range(self.parent.widgetLabelImage.layout.count()):
                item = self.parent.widgetLabelImage.layout.itemAt(i)
                if item is not None:
                    label = item.widget()

                    imageDraw = label.imageDraw
                    mask = bin.thresholdImg(imageDraw,self.value+1,self.value+1)
                    imageDraw = logic.reverseMaskImg(imageDraw,mask)
                    label.imageDraw = imageDraw

            self.parent.actualizeImageDraw()
            self.parent.model = None
            self.parent.modelIPSDK = None
            self.parent.evaluateModel()
        except:
            traceback.print_exc(file=sys.stderr)

    def viewLabel(self):

        self.buttonViewLabel.changeActivation()
        if self.parent is not None:
            self.parent.widgetImage.actualizeScene()

    def getColor(self, event):

        color = qt.QColorDialog.getColor()

        if color.isValid():
            self.color = [color.red(), color.green(), color.blue()]
            self.changeButtonColor()

    def changeName(self, event):

        self.editableLabelName.switchVisibleWidget()

    def changeButtonColor(self):

        self.labelColor.setStyleSheet('QLabel {background-color: rgb(' + str(self.color[0]) + ',' + str(self.color[1]) + ',' + str(self.color[2]) + ');}')
        self.SignalColorChanged.emit()

    def emitSelection(self, event):

        self.SignalSelection.emit(self)

    def emitSignalDeleteVariable(self):

        self.SignalDeleteVariable.emit(self)

    def unselectLabel(self):

        font = QtGui.QFont()
        font.setPixelSize(vrb.fontSizeMachineLearning*vrb.ratio)
        font.setBold(False)
        self.editableLabelName.label.setFont(font)
        self.labelCount.setFont(font)
        self.editableLabelName.label.setStyleSheet('QLabel {background-color: transparent;}')

    def selectLabel(self):

        font = QtGui.QFont()
        font.setPixelSize(vrb.fontSizeMachineLearning*vrb.ratio)
        font.setBold(True)
        self.editableLabelName.label.setFont(font)
        self.labelCount.setFont(font)
        self.editableLabelName.label.setStyleSheet('QLabel {background-color: rgb(70,70,70);}')

class GraphicElements(QtCore.QObject):
    SignalComputePreview = pyqtSignal()

    def __init__(self, parent=None):
        super(GraphicElements, self).__init__()

        self.parent = parent
        self.imageViewer = parent.imageViewer

        # self.imageViewer.signalEmitMouse.connect(self.imageViewer.getRoiImage)

    def applyGraphicElement(self, imageViewer):

        if self.parent.xmlElement is not None:

            currentColor = self.parent.labelScrollArea.getCurrentColor()

            graphicElement = Dfct.SubElement(self.parent.xmlElement, "GraphicElement")
            roiElement = Dfct.SubElement(graphicElement, "Roi")
            DWfct.addPolygonToScene(imageViewer, roiElement, color=currentColor, showPoints=True, lineSize=2, pointMode="circle", pointSize=6)

if __name__ == '__main__':

    # imgPath = "D:/exemple images/concretePlan.tif"
    # imgPath = "D:/exemple images/blobs_483x348_UInt8.tif"
    # imgPath = "D:/exemple images/sampleKMeansInputImage.tif"
    # imgPath = "D:/exemple images/Concrete.tif"

    # imgPath = "D:/exemple images/matches.tif"
    # imgPath = "D:/exemple images/zFocus.tif"
    # imgPath = "D:/exemple images/test3D.tif"

    # img = PyIPSDK.loadTiffImageFile(imgPath)

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    foo = MainWidget()
    # foo = WidgetImportImageLabel()

    # try:
    #     foo.loadModel("Model 1")
    # except:
    #     pass
    # foo.loadModel("Model 2")
    # foo.loadModel("Model 1")
    # foo.loadModelRef()

    # foo.loadModelRef()

    # foo.setImage(img)

    # foo.resize(1200, 900)

    foo.show()

    app.exec_()
