import sys,os
import traceback

from PyQt5 import QtGui
import PyQt5.QtWidgets as qt
from PyQt5 import QtCore
from PyQt5.QtCore import pyqtSignal, Qt, QCoreApplication

import PyIPSDK
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLStats as stats

import numpy as np

import xml.etree.ElementTree as xmlet
import DatabaseFunction as Dfct

import UsefullWidgets as wgt
import UsefullTexts as txt
import UsefullVariables as vrb
import UsefullFunctions as fct
import moduleRandomForest.UsefullMachineLearning as mlFct

from Sliders import SimpleHorizontalSliderLabel

class FeaturesSuperPixelsWidget(qt.QWidget):

    def __init__(self, parent=None,xmlElement=None):
        qt.QWidget.__init__(self)

        try:
            self.setWindowFlag(Qt.WindowStaysOnTopHint)
        except:
            self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.parent = parent
        self.xmlElement = xmlElement

        font = QtGui.QFont()
        font.setBold(False)
        font.setPixelSize(vrb.fontSizeMachineLearning * vrb.ratio)

        groupBoxGeometry = qt.QGroupBox()
        layoutGeometry = qt.QVBoxLayout()
        layoutGeometry.setContentsMargins(20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio)
        groupBoxGeometry.setLayout(layoutGeometry)
        groupBoxGeometry.setTitle("Geometry")
        groupBoxGeometry.setStyleSheet(f'QGroupBox:title {{left: 20px;padding-left: 10px;padding-right: 10px;padding-top: {-10*vrb.ratio}px; color:rgb(52, 152, 219)}}'
                                                    f'  QGroupBox {{font-size: {vrb.fontSizeMachineLearning*vrb.ratio}px;font: bold;border: 1px solid gray; margin-top: {10*vrb.ratio}px }}')
        self.checkBoxNbPixels = qt.QCheckBox("Number of pixels")
        self.checkBoxSizeX = qt.QCheckBox("Size X")
        self.checkBoxSizeY = qt.QCheckBox("Size Y")
        self.checkBoxSizeZ = qt.QCheckBox("Size Z")
        self.checkBoxSizeZ.setVisible(False)
        layoutGeometry.addWidget(self.checkBoxNbPixels)
        layoutGeometry.addWidget(self.checkBoxSizeX)
        layoutGeometry.addWidget(self.checkBoxSizeY)
        layoutGeometry.addWidget(self.checkBoxSizeZ)

        # sets a font to the children of a widget
        for widget in groupBoxGeometry.findChildren(qt.QWidget):
            widget.setFont(font)

        groupBoxBasicIntensity = qt.QGroupBox()
        layoutBasicIntensity = qt.QVBoxLayout()
        layoutBasicIntensity.setContentsMargins(20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio)
        groupBoxBasicIntensity.setLayout(layoutBasicIntensity)
        groupBoxBasicIntensity.setTitle("Basic Intensity")
        groupBoxBasicIntensity.setStyleSheet(f'QGroupBox:title {{left: 20px;padding-left: 10px;padding-right: 10px;padding-top: {-10*vrb.ratio}px; color:rgb(52, 152, 219)}}'
                                                    f'  QGroupBox {{font-size: {vrb.fontSizeMachineLearning*vrb.ratio}px;font: bold;border: 1px solid gray; margin-top: {10*vrb.ratio} px }}')
        self.checkBoxMinimum = qt.QCheckBox("Minimum")
        self.checkBoxMaximum = qt.QCheckBox("Maximum")
        self.checkBoxMean = qt.QCheckBox("Mean")
        self.checkBoxMedian = qt.QCheckBox("Median")
        layoutBasicIntensity.addWidget(self.checkBoxMinimum)
        layoutBasicIntensity.addWidget(self.checkBoxMaximum)
        layoutBasicIntensity.addWidget(self.checkBoxMean)
        layoutBasicIntensity.addWidget(self.checkBoxMedian)

        # sets a font to the children of a widget
        for widget in groupBoxBasicIntensity.findChildren(qt.QWidget):
            widget.setFont(font)

        groupBoxTexture = qt.QGroupBox()
        layoutTexture = qt.QVBoxLayout()
        layoutTexture.setContentsMargins(20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio, 20 * vrb.ratio)
        groupBoxTexture.setLayout(layoutTexture)
        groupBoxTexture.setTitle("Texture")
        groupBoxTexture.setStyleSheet(f'QGroupBox:title {{left: 20px;padding-left: 10px;padding-right: 10px;padding-top: {-10*vrb.ratio}px; color:rgb(52, 152, 219)}}'
                                                    f'  QGroupBox {{font-size: {vrb.fontSizeMachineLearning*vrb.ratio}px;font: bold;border: 1px solid gray; margin-top: {10*vrb.ratio} px }}')
        self.checkBoxVariance = qt.QCheckBox("Variance")
        self.checkBoxEnergy = qt.QCheckBox("Energy")
        self.checkBoxEntropy = qt.QCheckBox("Entropy")
        self.checkBoxKurtosis = qt.QCheckBox("Kurtosis")
        self.checkBoxSkewness = qt.QCheckBox("Skewness")
        layoutTexture.addWidget(self.checkBoxVariance)
        layoutTexture.addWidget(self.checkBoxEnergy)
        layoutTexture.addWidget(self.checkBoxEntropy)
        layoutTexture.addWidget(self.checkBoxKurtosis)
        layoutTexture.addWidget(self.checkBoxSkewness)

        # sets a font to the children of a widget
        for widget in groupBoxTexture.findChildren(qt.QWidget):
            widget.setFont(font)

        groupBoxHistogram = qt.QGroupBox()
        layoutHistogram = qt.QVBoxLayout()
        layoutHistogram.setContentsMargins(20*vrb.ratio,20*vrb.ratio,20*vrb.ratio,20*vrb.ratio)
        groupBoxHistogram.setLayout(layoutHistogram)
        groupBoxHistogram.setTitle("Histogram")
        groupBoxHistogram.setStyleSheet(f'QGroupBox:title {{left: 20px;padding-left: 10px;padding-right: 10px;padding-top: {-10*vrb.ratio}px; color:rgb(52, 152, 219)}}'
                                                    f'  QGroupBox {{font-size: {vrb.fontSizeMachineLearning*vrb.ratio}px;font: bold;border: 1px solid gray; margin-top: {10*vrb.ratio} px }}')

        self.checkBoxHistogram = qt.QCheckBox("Histogram")
        groupBoxParamHistogram = qt.QGroupBox()
        layoutParamHistogram = qt.QHBoxLayout()
        layoutParamHistogram.setContentsMargins(0,0,0,0)
        groupBoxParamHistogram.setLayout(layoutParamHistogram)
        groupBoxParamHistogram.setStyleSheet('QGroupBox {border: 0px transparent; }')
        self.labelMin = qt.QLabel("Min")
        self.lineEditMin = qt.QLineEdit()
        self.lineEditMin.setAlignment(Qt.AlignRight)
        self.lineEditMin.setPlaceholderText("0")
        self.lineEditMin.setFixedWidth(50*vrb.ratio)
        self.labelMax = qt.QLabel("Max")
        self.lineEditMax = qt.QLineEdit()
        self.lineEditMax.setAlignment(Qt.AlignRight)
        self.lineEditMax.setPlaceholderText("255")
        self.lineEditMax.setFixedWidth(50*vrb.ratio)
        self.labelNbClasses = qt.QLabel("Nb classes")
        self.lineEditNbClasses = qt.QLineEdit()
        self.lineEditNbClasses.setAlignment(Qt.AlignRight)
        self.lineEditNbClasses.setPlaceholderText("50")
        self.lineEditNbClasses.setFixedWidth(50*vrb.ratio)
        layoutParamHistogram.addWidget(self.labelMin)
        layoutParamHistogram.addWidget(self.lineEditMin)
        layoutParamHistogram.addWidget(self.labelMax)
        layoutParamHistogram.addWidget(self.lineEditMax)
        layoutParamHistogram.addWidget(self.labelNbClasses)
        layoutParamHistogram.addWidget(self.lineEditNbClasses)

        layoutHistogram.addWidget(self.checkBoxHistogram)
        layoutHistogram.addWidget(groupBoxParamHistogram)

        # sets a font to the children of a widget
        for widget in groupBoxHistogram.findChildren(qt.QWidget):
            widget.setFont(font)

        self.buttonValidate = wgt.PushButtonImage(vrb.folderImages + "/Validate.png", margins=0)
        self.buttonValidate.setToolTip("Validate")
        self.buttonValidate.setFixedSize(25 * vrb.ratio, 25 * vrb.ratio)

        self.checkBoxNbPixels.setChecked(True)
        self.checkBoxMean.setChecked(True)
        self.checkBoxVariance.setChecked(True)
        self.checkBoxHistogram.setChecked(True)

        self.createXmlElement(None)

        self.layout = qt.QGridLayout()

        self.layout.addWidget(groupBoxGeometry,0,0)
        self.layout.addWidget(groupBoxBasicIntensity,1,0)
        self.layout.addWidget(groupBoxTexture,2,0)
        self.layout.addWidget(groupBoxHistogram,3,0)
        self.layout.addWidget(self.buttonValidate,4,0,Qt.AlignRight)

        self.setLayout(self.layout)

        self.layout.setSizeConstraint(1)
        self.layout.setContentsMargins(10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio, 10*vrb.ratio)

        self.setWindowTitle("Features")

        self.buttonValidate.clicked.connect(self.createXmlElement)

        style = fct.getStyleSheet()
        self.setStyleSheet(style)

    def createXmlElement(self,event,close=True):

        Dfct.SubElement(self.xmlElement,"NbPixels").text = str(self.checkBoxNbPixels.isChecked())
        Dfct.SubElement(self.xmlElement,"SizeX").text = str(self.checkBoxSizeX.isChecked())
        Dfct.SubElement(self.xmlElement,"SizeY").text = str(self.checkBoxSizeY.isChecked())
        Dfct.SubElement(self.xmlElement,"SizeZ").text = str(self.checkBoxSizeZ.isChecked())
        Dfct.SubElement(self.xmlElement,"Minimum").text = str(self.checkBoxMinimum.isChecked())
        Dfct.SubElement(self.xmlElement,"Maximum").text = str(self.checkBoxMaximum.isChecked())
        Dfct.SubElement(self.xmlElement,"Mean").text = str(self.checkBoxMean.isChecked())
        Dfct.SubElement(self.xmlElement,"Median").text = str(self.checkBoxMedian.isChecked())
        Dfct.SubElement(self.xmlElement,"Variance").text = str(self.checkBoxVariance.isChecked())
        Dfct.SubElement(self.xmlElement,"Energy").text = str(self.checkBoxEnergy.isChecked())
        Dfct.SubElement(self.xmlElement,"Entropy").text = str(self.checkBoxEntropy.isChecked())
        Dfct.SubElement(self.xmlElement,"Kurtosis").text = str(self.checkBoxKurtosis.isChecked())
        Dfct.SubElement(self.xmlElement,"Skewness").text = str(self.checkBoxSkewness.isChecked())
        Dfct.SubElement(self.xmlElement,"Histogram").text = str(self.checkBoxHistogram.isChecked())
        if self.lineEditMin.text() != "":
            Dfct.SubElement(self.xmlElement,"HistogramMin").text = str(self.lineEditMin.text())
        else:
            Dfct.SubElement(self.xmlElement,"HistogramMin").text = str(self.lineEditMin.placeholderText())
        if self.lineEditMax.text() != "":
            Dfct.SubElement(self.xmlElement,"HistogramMax").text = str(self.lineEditMax.text())
        else:
            Dfct.SubElement(self.xmlElement,"HistogramMax").text = str(self.lineEditMax.placeholderText())
        if self.lineEditNbClasses.text() != "":
            Dfct.SubElement(self.xmlElement,"HistogramNbClasses").text = str(self.lineEditNbClasses.text())
        else:
            Dfct.SubElement(self.xmlElement,"HistogramNbClasses").text = str(self.lineEditNbClasses.placeholderText())

        try:
            self.parent.computeAllFeatures()
        except:
            traceback.print_exc(file=sys.stderr)

        if close:
            self.close()

    def loadXmlElement(self):

        self.checkBoxNbPixels.setChecked(Dfct.childText(self.xmlElement,"NbPixels")=="True")
        self.checkBoxSizeX.setChecked(Dfct.childText(self.xmlElement,"SizeX")=="True")
        self.checkBoxSizeY.setChecked(Dfct.childText(self.xmlElement,"SizeY")=="True")
        self.checkBoxSizeZ.setChecked(Dfct.childText(self.xmlElement,"SizeZ")=="True")
        self.checkBoxMinimum.setChecked(Dfct.childText(self.xmlElement,"Minimum")=="True")
        self.checkBoxMaximum.setChecked(Dfct.childText(self.xmlElement,"Maximum")=="True")
        self.checkBoxMean.setChecked(Dfct.childText(self.xmlElement,"Mean")=="True")
        self.checkBoxMedian.setChecked(Dfct.childText(self.xmlElement,"Median")=="True")
        self.checkBoxVariance.setChecked(Dfct.childText(self.xmlElement,"Variance")=="True")
        self.checkBoxEnergy.setChecked(Dfct.childText(self.xmlElement,"Energy")=="True")
        self.checkBoxEntropy.setChecked(Dfct.childText(self.xmlElement,"Entropy")=="True")
        self.checkBoxKurtosis.setChecked(Dfct.childText(self.xmlElement,"Kurtosis")=="True")
        self.checkBoxSkewness.setChecked(Dfct.childText(self.xmlElement,"Skewness")=="True")
        self.checkBoxHistogram.setChecked(Dfct.childText(self.xmlElement,"Histogram")=="True")
        if Dfct.childText(self.xmlElement,"HistogramMin") is not None:
            self.lineEditMin.setText(Dfct.childText(self.xmlElement,"HistogramMin"))
        else:
            self.lineEditMin.setText("")
        if Dfct.childText(self.xmlElement,"HistogramMax") is not None:
            self.lineEditMax.setText(Dfct.childText(self.xmlElement,"HistogramMax"))
        else:
            self.lineEditMax.setText("")
        if Dfct.childText(self.xmlElement,"HistogramNbClasses") is not None:
            self.lineEditNbClasses.setText(Dfct.childText(self.xmlElement,"HistogramNbClasses"))
        else:
            self.lineEditNbClasses.setText("")

if __name__ == '__main__':

    app = QCoreApplication.instance()
    if app is None:
        app = qt.QApplication([])

    sys._excepthook = sys.excepthook


    def exception_hook(exctype, value, traceback):
        print(exctype, value, traceback)
        sys._excepthook(exctype, value, traceback)
        sys.exit(1)

    sys.excepthook = exception_hook

    #xmlElement = xmlet.Element('FeaturesSuperPixels')

    foo = FeaturesSuperPixelsWidget()

    foo.loadXmlElement()

    # foo.setImage(img)

    #foo.resize(1200, 900)

    foo.show()

    app.exec_()