import sys
import os
import glob
import shutil
import re
import datetime

# -------------------------------------------------------------------------------------------------------------------- #
def generateFakeDict():
    ddict = {}

    ddict["AllModules"] = {}
    ddict["AllModules"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37738.html"
    ddict["AllModules"]["content"] = {}

    ddict["AllModules"]["content"]["AdvMorpho"] = {}
    ddict["AllModules"]["content"]["AdvMorpho"]["title"] = "Advanced Morphology"
    ddict["AllModules"]["content"]["AdvMorpho"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37782.html"
    ddict["AllModules"]["content"]["AdvMorpho"]["content"] = {}
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["AdaptiveWatershed2dImg"] = {}
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["AdaptiveWatershed2dImg"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37741.html"
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["AdaptiveWatershed2dImg"]["title"] = "Adaptive Watershed Binary Separation 2d"
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["BinaryReconstruction2dImg"] = {}
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["BinaryReconstruction2dImg"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllModules"]["content"]["AdvMorpho"]["content"]["BinaryReconstruction2dImg"]["title"] = "Binary Reconstruction 2d"

    ddict["AllModules"]["content"]["Arith"] = {}
    ddict["AllModules"]["content"]["Arith"]["title"] = "Arithmetic"
    ddict["AllModules"]["content"]["Arith"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37782.html"
    ddict["AllModules"]["content"]["Arith"]["content"] = {}
    ddict["AllModules"]["content"]["Arith"]["content"]["AbsImg"] = {}
    ddict["AllModules"]["content"]["Arith"]["content"]["AbsImg"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37783.html"
    ddict["AllModules"]["content"]["Arith"]["content"]["AbsImg"]["title"] = "Absolute value"
    ddict["AllModules"]["content"]["Arith"]["content"]["AddImgImg"] = {}
    ddict["AllModules"]["content"]["Arith"]["content"]["AddImgImg"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37784.html"
    ddict["AllModules"]["content"]["Arith"]["content"]["AddImgImg"]["title"] = "Addition"



    ddict["AllMeasures"] = {}
    ddict["AllMeasures"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37738.html"
    ddict["AllMeasures"]["content"] = {}

    ddict["AllMeasures"]["content"]["Geometry"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["title"] = "Geometric measures"
    ddict["AllMeasures"]["content"]["Geometry"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37782.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["title"] = "Basic geometry measures"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37741.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["Area2d"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["Area2d"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["Area2d"]["title"] = "Area 2D"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["NbPixels2d"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["NbPixels2d"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["Basic"]["content"]["NbPixels2d"]["title"] = "Number of 2d pixels"

    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["title"] = "FormFactor"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37741.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"]["title"] = "Angularity"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"]["content"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"]["content"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["Angularity"]["content"]["title"] = "Degree of angularity 2d"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["AspectRatio"] = {}
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["AspectRatio"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Geometry"]["content"]["FormFactor"]["content"]["AspectRatio"]["title"] = "AspectRatio"


    ddict["AllMeasures"]["content"]["Intensity"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["title"] = "Intensity-based measures"
    ddict["AllMeasures"]["content"]["Intensity"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37782.html"
    ddict["AllMeasures"]["content"]["Intensity"]["content"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["title"] = "Statistics measures"
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37741.html"
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Energy"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Energy"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Energy"]["title"] = "Energy"
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Sum"] = {}
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Sum"]["doc"] = "D:/dev/IPSDK_dev/Output/doc/public/IPSDKIPL/html/a37743.html"
    ddict["AllMeasures"]["content"]["Intensity"]["content"]["Statistics"]["content"]["Sum"]["title"] = "Sum"

    return ddict

# -------------------------------------------------------------------------------------------------------------------- #
def copyFile(filePath, outPath):
    """
    Copies a file after checking that the file exists
    """
    if os.path.exists(filePath):
        filename = os.path.basename(filePath)
        if os.path.exists(outPath+"/"+filename):
            print("The file " + filename + " already exists in " + outPath)
        else:
            shutil.copy2(filePath, outPath)
    else:
        print("The file " + filePath + " does not exist")

# -------------------------------------------------------------------------------------------------------------------- #
def copyFiles(extension, inPath, outPath):
    """
    Copies all the with the given extension the destination directory
    """
    files = glob.iglob(os.path.join(inPath, "*." + extension))
    for file in files:
        if os.path.isfile(file):
            # Add the prefix IPSDKCore in the name if it comes from IPSDKCore
            if "IPSDKCore" in inPath:
                filename = os.path.basename(file)
                outFileName = "IPSDKCore_" + filename
                outFilePath = outPath+"/"+outFileName
            else:
                outFileName = os.path.basename(file)
                outFilePath = outPath+"/"+outFileName

            if os.path.exists(outFilePath):
                print("The file " + outFileName + " already exists in " + outPath)
            else:
                shutil.copy2(file, outPath)
                os.rename(outPath + "/" + os.path.basename(file), outFilePath)

# -------------------------------------------------------------------------------------------------------------------- #
def copyFiles_old(extension, inPath, outPath):
    """
    Copies all the with the given extension the destination directory
    """
    files = glob.iglob(os.path.join(inPath, "*." + extension))
    for file in files:
        if os.path.isfile(file):
            rx = r"a[0-9]*.png"
            bMatch = re.search(rx, file)
            if not bMatch:
                filename = os.path.basename(file)
                if os.path.exists(outPath+"/"+filename):
                    print("The file " + filename + " already exists in " + outPath)
                else:
                    shutil.copy2(file, outPath)

# -------------------------------------------------------------------------------------------------------------------- #
def generateHTMLHeader(rootDocDir, title):
    """
    Generates the begining of the HTML page, including <body> that will be closed with generateHTMLFooter
    """

    str = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n'+\
    '<html xmlns="http://www.w3.org/1999/xhtml">\n'+\
    '<head>\n'+\
    '<meta http-equiv="Content-Type" content="text/xhtml;charset=UTF-8"/>\n'+\
    '<meta http-equiv="X-UA-Compatible" content="IE=9"/>\n'+\
    '<meta name="viewport" content="width=device-width, initial-scale=1"/>\n'+\
    '<title>'+title+'</title>\n'+\
    '<link href="tabs.css" rel="stylesheet" type="text/css"/>\n'+\
    '<link href="doxygen.css" rel="stylesheet" type="text/css" />\n'+\
    '<link href="IPSDK_doxygen.css" rel="stylesheet" type="text/css"/>\n'+\
    '</head>\n'+\
    '<body>\n'+\
    '<div id="titlearea">\n'+\
    '   <table cellspacing="0" cellpadding="0">\n'+\
    '       <tbody>\n'+\
    '           <tr style="height: 56px;">\n'+\
    '               <td id="projectlogo"><a href="index.html"><img alt="Logo" src="IPSDKToolkit.png"/></a></td>\n'+\
    '               <td id="projectalign" style="padding-left: 0.5em;">\n'

    # Find the line where the IPSDK version is specified
    inDocFile = rootDocDir+"/IPSDKCore/html/index.html"
    with open(inDocFile, "r") as file:
        curLine = ""
        bIPSDKVersionFound = False
        while not bIPSDKVersionFound and not curLine is None:
            curLine = file.readline()
            if '<span id="projectnumber">' in curLine:
                idx = curLine.find("</span>")
                ipsdkVersion = curLine[idx-7:idx].replace("_", ".")

                str += \
                '                   <div id="projectname">IPSDK&#160;<span id="projectnumber">'+ipsdkVersion+'</span></div>\n'
                bIPSDKVersionFound = True

    str += \
    '                   <div id="projectbrief">IPSDK : Image Processing Software Development Kit</div>\n'+\
    '               </td>\n'+\
    '               <td>\n'+\
    '                   <div id="projectCompanyWebSite">\n'+\
    '                       <div><a href="https://www.reactivip.com"><img class="centeredImage" src="web-link.png" /></a></div>\n'+\
    '                       <div><a href="https://www.reactivip.com">Reactiv\'IP home page</a></div>\n'+\
    '                   </div>\n'+\
    '               </td>\n'+\
    '           </tr>\n'+\
    '       </tbody>\n'+\
    '   </table>\n'+\
    '</div>\n'


    return str

# -------------------------------------------------------------------------------------------------------------------- #
def generateHTMLFooter():
    """
    Generates the begining of the HTML page
    """
    footerStr = '</div><!--content-->\n</body>\n</html>'

    year = datetime.date.today().year
    footerStr += '<!-- start footer part -->\n'+\
                 '<hr class="footer"/><div><address class="footer"><small>\n'+\
                 '<span class="footerText">'+\
                 '<a href="https://www.reactivip.com"><img class="footerLogo" src="CompanyLogo.png" alt="Reactiv\'IP" width="40" height="40"/></a>\n'+\
                 'IPSDK by &#160;<a href="https://www.reactivip.com">Reactiv\'IP</a><br/>\n'+\
                 'Copyright '+ str(year) +'</span>\n'+\
                 '</small></address></div>\n'

    return footerStr

# -------------------------------------------------------------------------------------------------------------------- #
def writeHTML(htmlPath, str):
    """
    Write the HTML contained in the input string str in a file located at htmlPath
    """
    with open(htmlPath, "w") as file:
        file.write(str)

# -------------------------------------------------------------------------------------------------------------------- #
def lineContainsPattern(inLine, pattern):
    """
    Returns true if the pattern is contained in the input line or if the line is empty
    """
    return pattern in inLine or inLine == ""

# -------------------------------------------------------------------------------------------------------------------- #
def findPages(rootDir, patterns):
    """
    Returns the path of the file containing the input pattern or "" if on file in rootDir contains the pattern
    """

    nbPatternFound = 0
    result = dict()
    for keyPattern in patterns:
        result[keyPattern] = ""

    files = glob.iglob(os.path.join(rootDir, "a[0-9]*.html"))
    for filePath in files:
        with open(filePath, "r") as file:
            bContinue = True
            while bContinue:
                curLine = file.readline()
                if curLine == "":
                    bContinue = False
                else:
                    for pattern in patterns:
                        if result[pattern] == "" and lineContainsPattern(curLine, pattern):
                            nbPatternFound+=1
                            result[pattern] = file.name
                            if nbPatternFound == len(patterns):
                                return result
    return result

# -------------------------------------------------------------------------------------------------------------------- #
def removeHeaderContent(inPath):
    # Find the first "More...
    cutHTML = ""
    with open(inPath, "r") as file:

        # Skip everything before "More..."
        bFound = False
        while not bFound:
            curLine = file.readline()
            if lineContainsPattern(curLine, "More"):
                bFound = True

        # Skip everything before the first "</h1>"
        bFound = False
        while not bFound:
            curLine = file.readline()
            if lineContainsPattern(curLine, "<h1>"):
                bFound = True

        # Keep everything before the first "</div><!-- contents -->"
        cutHTML += curLine
        bFound = False
        while not bFound:
            curLine = file.readline()
            if lineContainsPattern(curLine, "</div><!-- contents -->"):
                bFound = True
            else:
                cutHTML += curLine

    return cutHTML

# -------------------------------------------------------------------------------------------------------------------- #
def removeRelativeLinks(strContent):
    """
    Returns the input content string without relative links, pointing to the initial doxygen documentation
    """
    simplifiedContent = ""
    remainingContent = strContent

    bContinue = True
    while bContinue:
        # Find the first link tag
        idxStart = remainingContent.find('<a')

        bLinkFound = idxStart >= 0
        if bLinkFound:
            # Is a link to the documentation?
            tagContent = remainingContent[idxStart:]
            idxCloseStart = tagContent.find('>')
            tagContent = tagContent[:idxCloseStart+1]

            # Add the content before the tag
            simplifiedContent += remainingContent[:idxStart]
            remainingContent = remainingContent[idxStart:]
            bExternalLink = tagContent.find("href") >= 0 and tagContent.find("http") >= 0
            if bExternalLink:
                # External link : keep the entire tag
                simplifiedContent += remainingContent[:idxCloseStart+1]
                remainingContent = remainingContent[idxCloseStart+1:]

                # Find the tag </a> and add the text between <a></a>
                idxEnd = remainingContent.find('</a>')
                simplifiedContent += remainingContent[:idxEnd+4]
                remainingContent = remainingContent[idxEnd+4:]
            else:
                # Process the internal link
                # Skip the tag arguments
                remainingContent = remainingContent[idxCloseStart+1:]

                # Find the tag </a> and add the text between <a></a>
                idxEnd = remainingContent.find('</a>')
                simplifiedContent += remainingContent[:idxEnd]
                remainingContent = remainingContent[idxEnd+4:]


            bContinue = len(remainingContent) > 0

        else:
            # End condition
            simplifiedContent += remainingContent
            bContinue = False

    return simplifiedContent

# -------------------------------------------------------------------------------------------------------------------- #
def removeGroupHeaders(strContent):
    """
    Returns the input content string without the definitions generated by doxygen at the bottom of the page
    """
    return strContent.split('<h2 class="groupheader">')[0]