import sys
import PyIPSDK.IPSDKIPLBasicMorphology as morpho
import PyIPSDK.IPSDKIPLAdvancedMorphology as advmorpho
import PyIPSDK.IPSDKIPLColor as color
import PyIPSDK.IPSDKIPLUtility as util
import PyIPSDK.IPSDKIPLFiltering as filtering
import PyIPSDK.IPSDKIPLBinarization as bin
import PyIPSDK.IPSDKIPLArithmetic as arithm
import PyIPSDK.IPSDKIPLLogical as logic
import PyIPSDK.IPSDKIPLGlobalMeasure as glbmsr
import PyIPSDK.IPSDKIPLGeometricTransform as gtrans
import PyIPSDK.IPSDKIPLShapeAnalysis as shapeanalysis
import PyIPSDK.IPSDKIPLShapeSegmentation as shapesegmentation

import PyIPSDK
import UsefullVariables as vrb
import DatabaseFunction as Dfct
import xml.etree.ElementTree as xmlet

from ConversionIPSDK import dictConversion
from WidgetTypes import InputType

from processFunction._ProcessFunction import xmlToParamList, addToText

def xmlToInfosetIntensity(xmlAllMeasures, infoSetName, dimension='2D',calibration=None):

    text = ''
    if dimension == '2D':
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d()\n'
    else:
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d()\n'


    measures = []

    for child in xmlAllMeasures:
        if child.tag == 'Intensity':
            for measureNode in Dfct.childIterator(child, 'Measure'):
                if measureNode.get('CheckState') == '2':
                    paramInfoSet = []
                    fillParamInfoSet(measureNode, paramInfoSet)
                    text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                    measures.append(paramInfoSetToString(paramInfoSet))

    return text

def xmlToInfoset(xmlAllMeasures, infoSetName, dimension='2D',calibration = None,process=False,addBarycenter = True):
    text = ''
    if dimension == '2D':
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d()\n'
    else:
        if calibration is not None:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d('+calibration+')\n'
        else:
            text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d()\n'

    measures = []

    for child in xmlAllMeasures:
        try:
            if child.tag == 'Custom':
                # Custom measures
                for child2 in child:
                    if child2.tag == 'Arithmetic':
                        prefix = "Custom_A_"
                        function = 'shapeanalysis.createArithmeticFormulaMsrParams'
                    elif child2.tag == 'Logic':
                        prefix = "Custom_L_"
                        function = 'shapeanalysis.createLogicFormulaMsrParams'
                    for measureNode in Dfct.childIterator(child2, 'Measure'):
                        if measureNode.get('CheckState') == '2':
                            name = prefix + Dfct.childText(measureNode, 'UserName').replace(" ","")
                            #name = prefix + Dfct.childText(measureNode, 'UserName')
                            objElement = Dfct.SubElement(measureNode, "Object")
                            paramInfoSetCustom = ['"' + name + '"', '"' + Dfct.childText(objElement, 'Name') + '"']
                            shortNames = []
                            for child2 in objElement:
                                # Add the variable to the infoSet
                                if child2.tag == "Variables":
                                    for var in child2:
                                        shortName = Dfct.childText(var, 'ShortName')
                                        shortNames.append(shortName)
                                        realName = name + "_" + shortName
                                        paramInfoSet = ['"' + realName + '"']
                                        fillParamInfoSet(Dfct.SubElement(var, 'Measure'), paramInfoSet)
                                        text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                                        measures.append(paramInfoSetToString(paramInfoSet))
                            shortFormula = Dfct.childText(objElement, "Formula")
                            completeFormula = shortToCompleteFormula(shortFormula, shortNames, name)
                            paramInfoSetCustom.append(function + '("' + completeFormula + '")')
                            text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSetCustom) + ')\n'
            else:
                # Classic measures
                for measureNode in Dfct.childIterator(child, 'Measure'):
                    if measureNode.get('CheckState') == '2':
                        paramInfoSet = []
                        fillParamInfoSet(measureNode, paramInfoSet)
                        text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                        measures.append(paramInfoSetToString(paramInfoSet))
        except:
            pass

    if addBarycenter:

        text += '\n'
        text += '#Used in Explorer\n'
        text += 'PyIPSDK.createMeasureInfo('+infoSetName+', "Ref_Barycenter_X", "BarycenterXMsr")\n'
        text += 'PyIPSDK.createMeasureInfo('+infoSetName+', "Ref_Barycenter_Y", "BarycenterYMsr")\n'
        if dimension == "3D":
            text += 'PyIPSDK.createMeasureInfo('+infoSetName+', "Ref_Barycenter_Z", "BarycenterZMsr")\n'
        text += '\n'

        # if '"BarycenterXMsr"' not in measures:
        #     text = addToText(text, 'PyIPSDK.createMeasureInfo(' + infoSetName + ',"BarycenterXMsr")\n', process)
        # if '"BarycenterYMsr"' not in measures:
        #     text = addToText(text, 'PyIPSDK.createMeasureInfo(' + infoSetName + ',"BarycenterYMsr")\n', process)
        # if '"BarycenterZMsr"' not in measures and dimension == "3D":
        #     text = addToText(text, 'PyIPSDK.createMeasureInfo(' + infoSetName + ',"BarycenterZMsr")\n', process)

    return text

def xmlToSpecificParam(xmlAllMeasures, infoSetName,dimension, paranName):
    text = ''
    if dimension == '2D':
        text += infoSetName + ' = PyIPSDK.createMeasureInfoSet2d()\n'
    else:
        text += infoSetName + ' = PyIPSDK.createMeasureInfoSet3d()\n'
    for child in xmlAllMeasures:
        if child.tag == 'Custom':
            # Custom measures
            for child2 in child:
                if child2.tag == 'Logic':
                    prefix = "Custom_L_"
                    function = 'shapeanalysis.createLogicFormulaMsrParams'
                    for measureNode in Dfct.childIterator(child2, 'Measure'):
                        if Dfct.childText(measureNode, 'UserName') == paranName:
                            name = prefix + Dfct.childText(measureNode, 'UserName')
                            objElement = Dfct.SubElement(measureNode, "Object")
                            paramInfoSetCustom = ['"' + name + '"', '"' + Dfct.childText(objElement, 'Name') + '"']
                            shortNames = []
                            for child2 in objElement:
                                # Add the variable to the infoSet
                                if child2.tag == "Variables":
                                    for var in child2:
                                        shortName = Dfct.childText(var, 'ShortName')
                                        shortNames.append(shortName)
                                        realName = name + "_" + shortName
                                        paramInfoSet = ['"' + realName + '"']
                                        fillParamInfoSet(Dfct.SubElement(var, 'Measure'), paramInfoSet)
                                        text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSet) + ')\n'
                            shortFormula = Dfct.childText(objElement, "Formula")
                            completeFormula = shortToCompleteFormula(shortFormula, shortNames, name)
                            paramInfoSetCustom.append(function + '("' + completeFormula + '")')
                            text += 'PyIPSDK.createMeasureInfo(' + infoSetName + ', ' + paramInfoSetToString(paramInfoSetCustom) + ')\n'

    return text

def paramInfoSetToString(paramInfoSet):
    text = ''
    for info in paramInfoSet:
        text += info + ', '
    return text[:-2]

def fillParamInfoSet(measureNode, paramInfoSet):

    objElement = Dfct.SubElement(measureNode, "Object")
    paramInfoSet.append('"' + Dfct.childText(objElement, 'Name') + '"')
    for child2 in objElement:
        if child2.tag == "Parameters":
            valueText = ""
            fonction = None
            for param in child2:
                fonction = Dfct.childText(param, 'Name')
                type = InputType.stringToType(Dfct.childText(param, 'Type'))
                value = InputType.typeToClass(type).xmlToValue(param)
                if value is None:
                    Dfct.SubElement(param, 'Value').text = str(Dfct.childText(param, 'Default'))
                    value = InputType.typeToClass(type).xmlToValue(param)
                valueText+=str(value)+","
            valueText = valueText[:-1]
            if fonction in ['HistogramMostPopulatedGLMsrParams','HistogramPopulationMaxMsrParams']:
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] in ['"None"',None,""] or valueTextSplit[2] in ['"None"',None,""]:
                    valueText = valueTextSplit[0]
            if fonction == "HistogramQuantileMsrParams":
                valueTextSplit = valueText.split(",")
                if valueTextSplit[1] in ['"None"',None,""] or valueTextSplit[2] in ['"None"',None,""]:
                    valueText = valueTextSplit[0] + "," + valueTextSplit[3]
            paramIPSDK = dictConversion[fonction]['IPSDK'] + '(' + valueText + ')'
            paramInfoSet.append(paramIPSDK)


maskSplit = [' ', '/', '+', '-', '*', '(', ')', '&', '|', '>', '<', '[', ']', '=', '%',',']
def shortToCompleteFormula(shortFormula, shortNames, prefix):
    shortFormula = shortFormula.replace(' ', '')
    completeFormula = ''

    i = 0
    while i < len(shortFormula):
        if shortFormula[i] in maskSplit:
            completeFormula += shortFormula[i]
            var = ''
            while i+1 < len(shortFormula) and shortFormula[i+1] not in maskSplit:
                var += shortFormula[i+1]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var
            i += 1
        elif i == 0:
            var = ''
            while i < len(shortFormula) and shortFormula[i] not in maskSplit:
                var += shortFormula[i]
                i += 1
            if var in shortNames:
                var = prefix + '_' + var
            completeFormula += var

    return completeFormula